/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.boot.model.process.spi;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.evosuite.shaded.org.hibernate.boot.MetadataSources;
import org.evosuite.shaded.org.hibernate.boot.internal.ClassLoaderAccessImpl;
import org.evosuite.shaded.org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.evosuite.shaded.org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.evosuite.shaded.org.hibernate.boot.jaxb.internal.MappingBinder;
import org.evosuite.shaded.org.hibernate.boot.model.TypeContributions;
import org.evosuite.shaded.org.hibernate.boot.model.TypeContributor;
import org.evosuite.shaded.org.hibernate.boot.model.process.internal.ManagedResourcesImpl;
import org.evosuite.shaded.org.hibernate.boot.model.process.internal.ScanningCoordinator;
import org.evosuite.shaded.org.hibernate.boot.model.process.spi.ManagedResources;
import org.evosuite.shaded.org.hibernate.boot.model.source.internal.annotations.AnnotationMetadataSourceProcessorImpl;
import org.evosuite.shaded.org.hibernate.boot.model.source.internal.hbm.EntityHierarchyBuilder;
import org.evosuite.shaded.org.hibernate.boot.model.source.internal.hbm.EntityHierarchySourceImpl;
import org.evosuite.shaded.org.hibernate.boot.model.source.internal.hbm.HbmMetadataSourceProcessorImpl;
import org.evosuite.shaded.org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.evosuite.shaded.org.hibernate.boot.model.source.internal.hbm.ModelBinder;
import org.evosuite.shaded.org.hibernate.boot.model.source.spi.MetadataSourceProcessor;
import org.evosuite.shaded.org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.evosuite.shaded.org.hibernate.boot.spi.AdditionalJaxbMappingProducer;
import org.evosuite.shaded.org.hibernate.boot.spi.BasicTypeRegistration;
import org.evosuite.shaded.org.hibernate.boot.spi.MetadataBuildingContext;
import org.evosuite.shaded.org.hibernate.boot.spi.MetadataBuildingOptions;
import org.evosuite.shaded.org.hibernate.boot.spi.MetadataContributor;
import org.evosuite.shaded.org.hibernate.boot.spi.MetadataImplementor;
import org.evosuite.shaded.org.hibernate.cfg.AttributeConverterDefinition;
import org.evosuite.shaded.org.hibernate.cfg.MetadataSourceType;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.JdbcServices;
import org.evosuite.shaded.org.hibernate.type.BasicType;
import org.evosuite.shaded.org.hibernate.type.BasicTypeRegistry;
import org.evosuite.shaded.org.hibernate.type.TypeFactory;
import org.evosuite.shaded.org.hibernate.type.TypeResolver;
import org.evosuite.shaded.org.hibernate.usertype.CompositeUserType;
import org.evosuite.shaded.org.hibernate.usertype.UserType;
import org.evosuite.shaded.org.jboss.jandex.IndexView;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class MetadataBuildingProcess {
    private static final Logger log = Logger.getLogger(MetadataBuildingProcess.class);

    public static MetadataImplementor build(MetadataSources sources, MetadataBuildingOptions options) {
        return MetadataBuildingProcess.complete(MetadataBuildingProcess.prepare(sources, options), options);
    }

    public static ManagedResources prepare(MetadataSources sources, MetadataBuildingOptions options) {
        ManagedResourcesImpl managedResources = ManagedResourcesImpl.baseline(sources, options);
        ScanningCoordinator.INSTANCE.coordinateScan(managedResources, options, sources.getXmlMappingBinderAccess());
        return managedResources;
    }

    public static MetadataImplementor complete(final ManagedResources managedResources, final MetadataBuildingOptions options) {
        BasicTypeRegistry basicTypeRegistry = MetadataBuildingProcess.handleTypes(options);
        InFlightMetadataCollectorImpl metadataCollector = new InFlightMetadataCollectorImpl(options, new TypeResolver(basicTypeRegistry, new TypeFactory()));
        for (AttributeConverterDefinition attributeConverterDefinition : managedResources.getAttributeConverterDefinitions()) {
            metadataCollector.addAttributeConverter(attributeConverterDefinition);
        }
        ClassLoaderService classLoaderService = options.getServiceRegistry().getService(ClassLoaderService.class);
        ClassLoaderAccessImpl classLoaderAccess = new ClassLoaderAccessImpl(options.getTempClassLoader(), classLoaderService);
        final MetadataBuildingContextRootImpl rootMetadataBuildingContext = new MetadataBuildingContextRootImpl(options, classLoaderAccess, metadataCollector);
        final IndexView jandexView = options.getJandexView();
        MetadataSourceProcessor processor = new MetadataSourceProcessor(){
            private final HbmMetadataSourceProcessorImpl hbmProcessor;
            private final AnnotationMetadataSourceProcessorImpl annotationProcessor;
            {
                this.hbmProcessor = new HbmMetadataSourceProcessorImpl(managedResources, (MetadataBuildingContext)rootMetadataBuildingContext);
                this.annotationProcessor = new AnnotationMetadataSourceProcessorImpl(managedResources, rootMetadataBuildingContext, jandexView);
            }

            @Override
            public void prepare() {
                this.hbmProcessor.prepare();
                this.annotationProcessor.prepare();
            }

            @Override
            public void processTypeDefinitions() {
                this.hbmProcessor.processTypeDefinitions();
                this.annotationProcessor.processTypeDefinitions();
            }

            @Override
            public void processQueryRenames() {
                this.hbmProcessor.processQueryRenames();
                this.annotationProcessor.processQueryRenames();
            }

            @Override
            public void processNamedQueries() {
                this.hbmProcessor.processNamedQueries();
                this.annotationProcessor.processNamedQueries();
            }

            @Override
            public void processAuxiliaryDatabaseObjectDefinitions() {
                this.hbmProcessor.processAuxiliaryDatabaseObjectDefinitions();
                this.annotationProcessor.processAuxiliaryDatabaseObjectDefinitions();
            }

            @Override
            public void processIdentifierGenerators() {
                this.hbmProcessor.processIdentifierGenerators();
                this.annotationProcessor.processIdentifierGenerators();
            }

            @Override
            public void processFilterDefinitions() {
                this.hbmProcessor.processFilterDefinitions();
                this.annotationProcessor.processFilterDefinitions();
            }

            @Override
            public void processFetchProfiles() {
                this.hbmProcessor.processFetchProfiles();
                this.annotationProcessor.processFetchProfiles();
            }

            @Override
            public void prepareForEntityHierarchyProcessing() {
                for (MetadataSourceType metadataSourceType : options.getSourceProcessOrdering()) {
                    if (metadataSourceType == MetadataSourceType.HBM) {
                        this.hbmProcessor.prepareForEntityHierarchyProcessing();
                    }
                    if (metadataSourceType != MetadataSourceType.CLASS) continue;
                    this.annotationProcessor.prepareForEntityHierarchyProcessing();
                }
            }

            @Override
            public void processEntityHierarchies(Set<String> processedEntityNames) {
                for (MetadataSourceType metadataSourceType : options.getSourceProcessOrdering()) {
                    if (metadataSourceType == MetadataSourceType.HBM) {
                        this.hbmProcessor.processEntityHierarchies(processedEntityNames);
                    }
                    if (metadataSourceType != MetadataSourceType.CLASS) continue;
                    this.annotationProcessor.processEntityHierarchies(processedEntityNames);
                }
            }

            @Override
            public void postProcessEntityHierarchies() {
                for (MetadataSourceType metadataSourceType : options.getSourceProcessOrdering()) {
                    if (metadataSourceType == MetadataSourceType.HBM) {
                        this.hbmProcessor.postProcessEntityHierarchies();
                    }
                    if (metadataSourceType != MetadataSourceType.CLASS) continue;
                    this.annotationProcessor.postProcessEntityHierarchies();
                }
            }

            @Override
            public void processResultSetMappings() {
                this.hbmProcessor.processResultSetMappings();
                this.annotationProcessor.processResultSetMappings();
            }

            @Override
            public void finishUp() {
                this.hbmProcessor.finishUp();
                this.annotationProcessor.finishUp();
            }
        };
        processor.prepare();
        processor.processTypeDefinitions();
        processor.processQueryRenames();
        processor.processAuxiliaryDatabaseObjectDefinitions();
        processor.processIdentifierGenerators();
        processor.processFilterDefinitions();
        processor.processFetchProfiles();
        HashSet<String> processedEntityNames = new HashSet<String>();
        processor.prepareForEntityHierarchyProcessing();
        processor.processEntityHierarchies(processedEntityNames);
        processor.postProcessEntityHierarchies();
        processor.processResultSetMappings();
        processor.processNamedQueries();
        processor.finishUp();
        for (MetadataContributor contributor : classLoaderService.loadJavaServices(MetadataContributor.class)) {
            log.tracef("Calling MetadataContributor : %s", (Object)contributor);
            contributor.contribute(metadataCollector, jandexView);
        }
        metadataCollector.processSecondPasses(rootMetadataBuildingContext);
        Collection<AdditionalJaxbMappingProducer> producers = classLoaderService.loadJavaServices(AdditionalJaxbMappingProducer.class);
        if (producers != null) {
            EntityHierarchyBuilder hierarchyBuilder = new EntityHierarchyBuilder();
            MappingBinder mappingBinder = new MappingBinder(classLoaderService, false);
            for (AdditionalJaxbMappingProducer producer : producers) {
                log.tracef("Calling AdditionalJaxbMappingProducer : %s", (Object)producer);
                Collection<MappingDocument> additionalMappings = producer.produceAdditionalMappings(metadataCollector, jandexView, mappingBinder, rootMetadataBuildingContext);
                for (MappingDocument mappingDocument : additionalMappings) {
                    hierarchyBuilder.indexMappingDocument(mappingDocument);
                }
            }
            ModelBinder binder = ModelBinder.prepare(rootMetadataBuildingContext);
            for (EntityHierarchySourceImpl entityHierarchySource : hierarchyBuilder.buildHierarchies()) {
                binder.bindEntityHierarchy(entityHierarchySource);
            }
        }
        return metadataCollector.buildMetadataInstance(rootMetadataBuildingContext);
    }

    private static BasicTypeRegistry handleTypes(MetadataBuildingOptions options) {
        ClassLoaderService classLoaderService = options.getServiceRegistry().getService(ClassLoaderService.class);
        final BasicTypeRegistry basicTypeRegistry = new BasicTypeRegistry();
        TypeContributions typeContributions = new TypeContributions(){

            @Override
            public void contributeType(BasicType type) {
                basicTypeRegistry.register(type);
            }

            @Override
            public void contributeType(BasicType type, String ... keys) {
                basicTypeRegistry.register(type, keys);
            }

            @Override
            public void contributeType(UserType type, String[] keys) {
                basicTypeRegistry.register(type, keys);
            }

            @Override
            public void contributeType(CompositeUserType type, String[] keys) {
                basicTypeRegistry.register(type, keys);
            }
        };
        Dialect dialect = options.getServiceRegistry().getService(JdbcServices.class).getDialect();
        dialect.contributeTypes(typeContributions, options.getServiceRegistry());
        for (TypeContributor contributor : classLoaderService.loadJavaServices(TypeContributor.class)) {
            contributor.contribute(typeContributions, options.getServiceRegistry());
        }
        for (BasicTypeRegistration basicTypeRegistration : options.getBasicTypeRegistrations()) {
            basicTypeRegistry.register(basicTypeRegistration.getBasicType(), basicTypeRegistration.getRegistrationKeys());
        }
        return basicTypeRegistry;
    }
}

