/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.boot.model.process.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.shaded.org.hibernate.boot.MetadataSources;
import org.evosuite.shaded.org.hibernate.boot.jaxb.spi.Binding;
import org.evosuite.shaded.org.hibernate.boot.model.process.spi.ManagedResources;
import org.evosuite.shaded.org.hibernate.boot.spi.MetadataBuildingOptions;
import org.evosuite.shaded.org.hibernate.cfg.AttributeConverterDefinition;

public class ManagedResourcesImpl
implements ManagedResources {
    private Map<Class, AttributeConverterDefinition> attributeConverterDefinitionMap = new HashMap<Class, AttributeConverterDefinition>();
    private Set<Class> annotatedClassReferences = new LinkedHashSet<Class>();
    private Set<String> annotatedClassNames = new LinkedHashSet<String>();
    private Set<String> annotatedPackageNames = new LinkedHashSet<String>();
    private List<Binding> mappingFileBindings = new ArrayList<Binding>();

    public static ManagedResourcesImpl baseline(MetadataSources sources, MetadataBuildingOptions metadataBuildingOptions) {
        ManagedResourcesImpl impl = new ManagedResourcesImpl();
        for (AttributeConverterDefinition attributeConverterDefinition : metadataBuildingOptions.getAttributeConverters()) {
            impl.addAttributeConverterDefinition(attributeConverterDefinition);
        }
        impl.annotatedClassReferences.addAll(sources.getAnnotatedClasses());
        impl.annotatedClassNames.addAll(sources.getAnnotatedClassNames());
        impl.annotatedPackageNames.addAll(sources.getAnnotatedPackages());
        impl.mappingFileBindings.addAll(sources.getXmlBindings());
        return impl;
    }

    private ManagedResourcesImpl() {
    }

    @Override
    public Collection<AttributeConverterDefinition> getAttributeConverterDefinitions() {
        return Collections.unmodifiableCollection(this.attributeConverterDefinitionMap.values());
    }

    @Override
    public Collection<Class> getAnnotatedClassReferences() {
        return Collections.unmodifiableSet(this.annotatedClassReferences);
    }

    @Override
    public Collection<String> getAnnotatedClassNames() {
        return Collections.unmodifiableSet(this.annotatedClassNames);
    }

    @Override
    public Collection<String> getAnnotatedPackageNames() {
        return Collections.unmodifiableSet(this.annotatedPackageNames);
    }

    @Override
    public Collection<Binding> getXmlMappingBindings() {
        return Collections.unmodifiableList(this.mappingFileBindings);
    }

    void addAttributeConverterDefinition(AttributeConverterDefinition attributeConverterDefinition) {
        this.attributeConverterDefinitionMap.put(attributeConverterDefinition.getAttributeConverter().getClass(), attributeConverterDefinition);
    }

    void addAnnotatedClassReference(Class annotatedClassReference) {
        this.annotatedClassReferences.add(annotatedClassReference);
    }

    void addAnnotatedClassName(String annotatedClassName) {
        this.annotatedClassNames.add(annotatedClassName);
    }

    void addAnnotatedPackageName(String annotatedPackageName) {
        this.annotatedPackageNames.add(annotatedPackageName);
    }

    void addXmlBinding(Binding binding) {
        this.mappingFileBindings.add(binding);
    }
}

