/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.net.bytebuddy.implementation.bytecode.constant;

import org.evosuite.shaded.net.bytebuddy.implementation.Implementation;
import org.evosuite.shaded.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.evosuite.shaded.net.bytebuddy.implementation.bytecode.StackSize;
import org.evosuite.shaded.net.bytebuddy.jar.asm.MethodVisitor;

public enum FloatConstant implements StackManipulation
{
    ZERO(11),
    ONE(12),
    TWO(13);

    private static final StackManipulation.Size SIZE;
    private final int opcode;

    private FloatConstant(int opcode) {
        this.opcode = opcode;
    }

    public static StackManipulation forValue(float value) {
        if (value == 0.0f) {
            return ZERO;
        }
        if (value == 1.0f) {
            return ONE;
        }
        if (value == 2.0f) {
            return TWO;
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    static {
        SIZE = StackSize.SINGLE.toIncreasingSize();
    }

    protected static class ConstantPool
    implements StackManipulation {
        private final float value;

        protected ConstantPool(float value) {
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitLdcInsn(Float.valueOf(this.value));
            return SIZE;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstantPool)) {
                return false;
            }
            ConstantPool other = (ConstantPool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Float.compare(this.value, other.value) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConstantPool;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.value);
            return result;
        }
    }
}

