/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.util;

import java.util.LinkedList;

public class JOptionPaneInputs {
    private static JOptionPaneInputs instance = null;
    private final LinkedList<String> stringInputs = new LinkedList();
    private boolean hasStringDialogs = false;
    private boolean hasYesCancelDialogs = false;
    private boolean hasYesNoCancelDialogs = false;
    private boolean hasYesNoDialogs = false;
    private boolean hasOptionDialogs = false;
    private final LinkedList<Integer> yesNoCancelSelections = new LinkedList();
    private final LinkedList<Integer> yesNoSelections = new LinkedList();
    private final LinkedList<Integer> optionSelections = new LinkedList();
    private final LinkedList<Integer> okCancelSelections = new LinkedList();

    private JOptionPaneInputs() {
    }

    public static synchronized JOptionPaneInputs getInstance() {
        if (instance == null) {
            instance = new JOptionPaneInputs();
        }
        return instance;
    }

    public static synchronized void resetSingleton() {
        instance = null;
    }

    public void initForTestCase() {
        this.stringInputs.clear();
        this.yesNoCancelSelections.clear();
        this.yesNoSelections.clear();
        this.okCancelSelections.clear();
        this.optionSelections.clear();
    }

    public static void enqueueInputString(String data) {
        JOptionPaneInputs.getInstance().enqueueInputString0(data);
    }

    public static void enqueueYesNoCancelSelection(int selection) {
        JOptionPaneInputs.getInstance().enqueueYesNoCancelSelection0(selection);
    }

    public static void enqueueYesNoSelection(int selection) {
        JOptionPaneInputs.getInstance().enqueueYesNoSelection0(selection);
    }

    public static void enqueueOptionSelection(int selection) {
        JOptionPaneInputs.getInstance().enqueueOptionSelection0(selection);
    }

    private void enqueueOptionSelection0(int selection) {
        this.optionSelections.add(selection);
    }

    public static void enqueueOkCancelSelection(int selection) {
        JOptionPaneInputs.getInstance().enqueueOkCancelSelection0(selection);
    }

    private void enqueueOkCancelSelection0(int selection) {
        this.okCancelSelections.add(selection);
    }

    private void enqueueYesNoSelection0(int selection) {
        this.yesNoSelections.add(selection);
    }

    private void enqueueYesNoCancelSelection0(int selection) {
        this.yesNoCancelSelections.add(selection);
    }

    public String dequeueStringInput() {
        if (this.stringInputs.isEmpty()) {
            throw new IllegalStateException("dequeueString() should not be invoked if no string is contained!");
        }
        return this.stringInputs.poll();
    }

    private void enqueueInputString0(String str) {
        this.stringInputs.add(str);
    }

    public void addDialog(GUIAction dialogType) {
        switch (dialogType) {
            case STRING_INPUT: {
                this.hasStringDialogs = true;
                break;
            }
            case OK_CANCEL_SELECTION: {
                this.hasYesCancelDialogs = true;
                break;
            }
            case YES_NO_CANCEL_SELECTION: {
                this.hasYesNoCancelDialogs = true;
                break;
            }
            case YES_NO_SELECTION: {
                this.hasYesNoDialogs = true;
                break;
            }
            case OPTION_SELECTION: {
                this.hasOptionDialogs = true;
                break;
            }
            default: {
                throw new IllegalStateException("dialogType " + (Object)((Object)dialogType) + " was not implemented");
            }
        }
    }

    public boolean hasDialog(GUIAction dialogType) {
        switch (dialogType) {
            case STRING_INPUT: {
                return this.hasStringDialogs;
            }
            case OK_CANCEL_SELECTION: {
                return this.hasYesCancelDialogs;
            }
            case YES_NO_CANCEL_SELECTION: {
                return this.hasYesNoCancelDialogs;
            }
            case YES_NO_SELECTION: {
                return this.hasYesNoDialogs;
            }
            case OPTION_SELECTION: {
                return this.hasOptionDialogs;
            }
        }
        throw new IllegalStateException("dialogType " + (Object)((Object)dialogType) + " was not implemented");
    }

    public boolean hasAnyDialog() {
        return this.hasStringDialogs || this.hasYesCancelDialogs || this.hasYesNoCancelDialogs || this.hasYesNoDialogs || this.hasOptionDialogs;
    }

    public boolean containsStringInput() {
        return !this.stringInputs.isEmpty();
    }

    public boolean containsYesNoCancelSelection() {
        return !this.yesNoCancelSelections.isEmpty();
    }

    public int dequeueYesNoCancelSelection() {
        if (this.yesNoCancelSelections.isEmpty()) {
            throw new IllegalStateException("The input queue for" + (Object)((Object)GUIAction.YES_NO_CANCEL_SELECTION) + " selections is empty");
        }
        return this.yesNoCancelSelections.poll();
    }

    public boolean containsYesNoSelection() {
        return !this.yesNoSelections.isEmpty();
    }

    public int dequeueYesNoSelection() {
        if (this.yesNoSelections.isEmpty()) {
            throw new IllegalStateException("The input queue for " + (Object)((Object)GUIAction.YES_NO_SELECTION) + " selections is empty");
        }
        return this.yesNoSelections.poll();
    }

    public boolean containsOkCancelSelection() {
        return !this.okCancelSelections.isEmpty();
    }

    public int dequeueOkCancelSelection() {
        if (this.okCancelSelections.isEmpty()) {
            throw new IllegalStateException("The input queue for " + (Object)((Object)GUIAction.OK_CANCEL_SELECTION) + " selections is empty");
        }
        return this.okCancelSelections.poll();
    }

    public int dequeueOptionSelection() {
        if (this.optionSelections.isEmpty()) {
            throw new IllegalStateException("The input queue for " + (Object)((Object)GUIAction.OPTION_SELECTION) + " selections is empty");
        }
        return this.optionSelections.poll();
    }

    public boolean containsOptionSelection() {
        return !this.optionSelections.isEmpty();
    }

    public static enum GUIAction {
        STRING_INPUT,
        YES_NO_SELECTION,
        YES_NO_CANCEL_SELECTION,
        OK_CANCEL_SELECTION,
        OPTION_SELECTION;

    }
}

