/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.evosuite.runtime.mock.java.io.MockIOException;

public class ByteDataInputStream
extends InputStream {
    private final byte[] data;
    private final AtomicInteger pos;
    private volatile boolean closed;

    public ByteDataInputStream(byte[] data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("Null input");
        }
        this.data = data;
        this.pos = new AtomicInteger(0);
        this.closed = false;
    }

    public ByteDataInputStream(String text) throws NullPointerException {
        this(text.getBytes());
    }

    @Override
    public int read() throws IOException {
        this.throwExceptionIfClosed();
        int available = this.available();
        if (available <= 0) {
            return -1;
        }
        int index = this.pos.getAndIncrement();
        return this.data[index];
    }

    @Override
    public int available() throws IOException {
        this.throwExceptionIfClosed();
        int dif = this.data.length - this.pos.get();
        return dif;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void throwExceptionIfClosed() throws IOException {
        if (this.closed) {
            throw new MockIOException();
        }
    }
}

