/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.javax.swing.filechooser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.javax.swing.filechooser.MockGenericFileSystemView;
import org.evosuite.runtime.mock.javax.swing.filechooser.MockUnixFileSystemView;
import org.evosuite.runtime.mock.javax.swing.filechooser.MockWindowsFileSystemView;
import org.evosuite.runtime.vfs.FSObject;
import org.evosuite.runtime.vfs.VFolder;
import org.evosuite.runtime.vfs.VirtualFileSystem;

public abstract class MockFileSystemView
extends FileSystemView
implements OverrideMock {
    static FileSystemView windowsFileSystemView = null;
    static FileSystemView unixFileSystemView = null;
    static FileSystemView genericFileSystemView = null;
    private boolean useSystemExtensionHiding = UIManager.getDefaults().getBoolean("FileChooser.useSystemExtensionHiding");

    public static FileSystemView getFileSystemView() {
        if (File.separatorChar == '\\') {
            if (windowsFileSystemView == null) {
                windowsFileSystemView = new MockWindowsFileSystemView();
            }
            return windowsFileSystemView;
        }
        if (File.separatorChar == '/') {
            if (unixFileSystemView == null) {
                unixFileSystemView = new MockUnixFileSystemView();
            }
            return unixFileSystemView;
        }
        if (genericFileSystemView == null) {
            genericFileSystemView = new MockGenericFileSystemView();
        }
        return genericFileSystemView;
    }

    public MockFileSystemView() {
        final WeakReference<MockFileSystemView> weakReference = new WeakReference<MockFileSystemView>(this);
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MockFileSystemView fileSystemView = (MockFileSystemView)weakReference.get();
                if (fileSystemView == null) {
                    UIManager.removePropertyChangeListener(this);
                } else if (evt.getPropertyName().equals("lookAndFeel")) {
                    fileSystemView.useSystemExtensionHiding = UIManager.getDefaults().getBoolean("FileChooser.useSystemExtensionHiding");
                }
            }
        });
    }

    @Override
    public boolean isRoot(File f) {
        return super.isRoot(f);
    }

    @Override
    public Boolean isTraversable(File f) {
        return super.isTraversable(f);
    }

    @Override
    public String getSystemDisplayName(File f) {
        if (f == null) {
            return null;
        }
        String name = f.getName();
        if (name == null || name.length() == 0) {
            name = f.getPath();
        }
        return name;
    }

    @Override
    public String getSystemTypeDescription(File f) {
        return super.getSystemTypeDescription(f);
    }

    @Override
    public Icon getSystemIcon(File f) {
        if (f == null) {
            return null;
        }
        return UIManager.getIcon(f.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
    }

    @Override
    public boolean isParent(File folder, File file) {
        if (folder == null || file == null) {
            return false;
        }
        return folder.equals(file.getParentFile());
    }

    @Override
    public File getChild(File parent, String fileName) {
        return this.createFileObject(parent, fileName);
    }

    @Override
    public boolean isFileSystem(File f) {
        return true;
    }

    @Override
    public boolean isHiddenFile(File f) {
        return super.isHiddenFile(f);
    }

    @Override
    public boolean isFileSystemRoot(File dir) {
        FSObject fso = VirtualFileSystem.getInstance().findFSObject(dir.getAbsolutePath());
        if (fso == null || !(fso instanceof VFolder)) {
            return false;
        }
        VFolder folder = (VFolder)fso;
        return folder.isRoot();
    }

    @Override
    public boolean isDrive(File dir) {
        return super.isDrive(dir);
    }

    @Override
    public boolean isFloppyDrive(File dir) {
        return super.isFloppyDrive(dir);
    }

    @Override
    public boolean isComputerNode(File dir) {
        return false;
    }

    @Override
    public File[] getRoots() {
        File[] roots = MockFile.listRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (!this.isFileSystemRoot(roots[i])) continue;
            roots[i] = this.createFileSystemRoot(roots[i]);
        }
        return roots;
    }

    @Override
    public File getHomeDirectory() {
        return super.getHomeDirectory();
    }

    @Override
    public File getDefaultDirectory() {
        File f = this.getHomeDirectory();
        if (this.isFileSystemRoot(f)) {
            f = this.createFileSystemRoot(f);
        }
        return f;
    }

    @Override
    public File createFileObject(File dir, String filename) {
        if (dir == null) {
            return new MockFile(filename);
        }
        return new MockFile(dir, filename);
    }

    @Override
    public File createFileObject(String path) {
        File f = new MockFile(path);
        if (this.isFileSystemRoot(f)) {
            f = this.createFileSystemRoot(f);
        }
        return f;
    }

    @Override
    public File[] getFiles(File dir, boolean useFileHiding) {
        ArrayList<File> files = new ArrayList<File>();
        if (dir == null) {
            return new File[0];
        }
        File[] names = dir.listFiles();
        if (names == null) {
            return new File[0];
        }
        for (File f : names) {
            if (Thread.currentThread().isInterrupted()) break;
            if (this.isFileSystemRoot(f)) {
                f = this.createFileSystemRoot(f);
            }
            if (useFileHiding && this.isHiddenFile(f)) continue;
            files.add(f);
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public File getParentDirectory(File dir) {
        if (dir == null || !dir.exists()) {
            return null;
        }
        return dir.getParentFile();
    }

    @Override
    protected File createFileSystemRoot(File f) {
        if (f instanceof MockFileSystemRoot) {
            return f;
        }
        return new MockFileSystemRoot(f);
    }

    static class MockFileSystemRoot
    extends MockFile {
        private static final long serialVersionUID = -7059909648025194367L;

        public MockFileSystemRoot(File f) {
            super(f, "");
        }

        public MockFileSystemRoot(String s) {
            super(s);
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public String getName() {
            return this.getPath();
        }
    }
}

