/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.javax.naming;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.evosuite.runtime.annotation.EvoSuiteClassExclude;
import org.evosuite.runtime.annotation.EvoSuiteInclude;
import org.evosuite.runtime.javaee.TestDataJavaEE;
import org.evosuite.runtime.testdata.EvoName;

@EvoSuiteClassExclude
public class EvoNamingContext
implements Context {
    private static final EvoNamingContext singleton = new EvoNamingContext();
    private final Map<String, Binding> bindings = new ConcurrentHashMap<String, Binding>();

    @EvoSuiteInclude
    public static EvoNamingContext getInstance() {
        return singleton;
    }

    public void reset() {
        this.bindings.clear();
    }

    @EvoSuiteInclude
    public static void add(EvoName name, Object obj) {
        try {
            EvoNamingContext.getInstance().bind(name.getName(), obj);
        }
        catch (NamingException e) {
            throw new RuntimeException("Invaliding binding: " + e.toString());
        }
    }

    private String getClassName(String name) {
        String[] tokens = name.split("/");
        String cn = tokens[tokens.length - 1];
        return cn;
    }

    private void checkNaming(String name, Object obj) throws NamingException {
        Class<?> klass;
        if (obj == null) {
            return;
        }
        String cn = this.getClassName(name);
        if (!cn.contains("!")) {
            return;
        }
        String[] tokens = cn.split("!");
        if (tokens.length != 2) {
            throw new NamingException("Invalid <name>!<type>: " + name);
        }
        String type = tokens[1];
        try {
            ClassLoader loader = obj.getClass().getClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            klass = loader.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new NamingException("Cannot load type " + type + ": " + e.toString());
        }
        if (!klass.isAssignableFrom(obj.getClass())) {
            throw new NamingException("Invaliding binding of class " + obj.getClass().getName() + " for name " + name);
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name == null) {
            throw new NamingException("Null name");
        }
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (name == null) {
            throw new NamingException("Null name");
        }
        TestDataJavaEE.getInstance().accessLookUpContextName(name);
        Binding b = this.bindings.get(name);
        if (b == null) {
            return null;
        }
        return b.getObject();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (name == null) {
            throw new NamingException("Null name");
        }
        this.bind(name.toString(), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        if (name == null) {
            throw new NamingException("Null name");
        }
        if (this.bindings.containsKey(name)) {
            throw new NameAlreadyBoundException("Already bounded object for: " + name);
        }
        this.checkNaming(name, obj);
        Binding b = new Binding(name, obj);
        this.bindings.put(name, b);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (name == null) {
            throw new NamingException("Null name");
        }
        this.rebind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        if (name == null) {
            throw new NamingException("Null name");
        }
        this.checkNaming(name, obj);
        Binding b = new Binding(name, obj);
        this.bindings.put(name, b);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name == null) {
            throw new NamingException("Null name");
        }
        this.unbind(name.toString());
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.bindings.remove(name);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        if (oldName == null || newName == null) {
            throw new NamingException("Null name");
        }
        this.rename(oldName.toString(), newName.toString());
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        if (oldName == null || newName == null) {
            throw new NamingException("Null name");
        }
        if (this.bindings.containsKey(newName)) {
            throw new NameAlreadyBoundException("Already bounded object for: " + newName);
        }
        if (!this.bindings.containsKey(oldName)) {
            throw new NamingException("No " + oldName + " is bounded");
        }
        Binding r = this.bindings.remove(oldName);
        Binding n = new Binding(newName, r.getObject());
        this.bindings.put(newName, n);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return null;
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return null;
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return null;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return null;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return null;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return null;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return null;
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return null;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return null;
    }
}

