/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Inet4Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inet4AddressUtil {
    private static final Logger logger = LoggerFactory.getLogger(Inet4AddressUtil.class);
    public static final int INADDRSZ = 4;
    private static Constructor<Inet4Address> constructorStringByteArray;
    private static Constructor<Inet4Address> constructorStringInt;

    public static Inet4Address createNewInstance() {
        try {
            return (Inet4Address)Inet4Address.class.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("Failed to create instance: " + e.getMessage());
            return null;
        }
    }

    public static Inet4Address createNewInstance(String hostName, byte[] addr) {
        try {
            return constructorStringByteArray.newInstance(hostName, addr);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            logger.error("Failed to create instance: " + e.getMessage());
            return null;
        }
    }

    public static Inet4Address createNewInstance(String hostName, int address) {
        try {
            return constructorStringInt.newInstance(hostName, address);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            logger.error("Failed to create instance: " + e.getMessage());
            return null;
        }
    }

    static {
        try {
            constructorStringByteArray = Inet4Address.class.getDeclaredConstructor(String.class, byte[].class);
            constructorStringByteArray.setAccessible(true);
            constructorStringInt = Inet4Address.class.getDeclaredConstructor(String.class, Integer.TYPE);
            constructorStringInt.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.error("Failed to initialize due to reflection problems: " + e.getMessage());
        }
    }
}

