/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.evosuite.runtime.LeakingResource;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.io.EvoFileChannel;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockIOException;
import org.evosuite.runtime.mock.java.io.NativeMockedIO;
import org.evosuite.runtime.vfs.FSObject;
import org.evosuite.runtime.vfs.VFile;
import org.evosuite.runtime.vfs.VirtualFileSystem;

public class MockFileOutputStream
extends FileOutputStream
implements LeakingResource,
OverrideMock {
    private final String path;
    private FileChannel channel;
    private volatile boolean closed = false;
    private final AtomicInteger position = new AtomicInteger(0);

    public MockFileOutputStream(String name) throws FileNotFoundException {
        this(name != null ? (!MockFramework.isEnabled() ? new File(name) : new MockFile(name)) : null, false);
    }

    public MockFileOutputStream(String name, boolean append) throws FileNotFoundException {
        this(name != null ? (!MockFramework.isEnabled() ? new File(name) : new MockFile(name)) : null, append);
    }

    public MockFileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public MockFileOutputStream(File file, boolean append) throws FileNotFoundException {
        super(!MockFramework.isEnabled() ? file : VirtualFileSystem.getInstance().getRealTmpFile(), append);
        if (!MockFramework.isEnabled()) {
            this.path = null;
            return;
        }
        VirtualFileSystem.getInstance().addLeakingResource(this);
        this.path = file != null ? file.getAbsolutePath() : null;
        FSObject target = VirtualFileSystem.getInstance().findFSObject(this.path);
        if (target == null) {
            boolean created = VirtualFileSystem.getInstance().createFile(this.path);
            if (!created) {
                throw new FileNotFoundException();
            }
            target = VirtualFileSystem.getInstance().findFSObject(this.path);
        }
        if (target == null || target.isDeleted() || target.isFolder() || !target.isWritePermission()) {
            throw new FileNotFoundException();
        }
        if (!append) {
            ((VFile)target).eraseData();
        }
    }

    public MockFileOutputStream(FileDescriptor fdObj) {
        super(fdObj);
        this.path = "";
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        this.throwExceptionIfClosed();
        NativeMockedIO.writeBytes(this.path, this.position, b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.write(b);
            return;
        }
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.write(b);
            return;
        }
        this.writeBytes(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.write(b, off, len);
            return;
        }
        this.writeBytes(b, off, len);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (!MockFramework.isEnabled()) {
            return;
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.channel != null) {
            this.channel.close();
        }
        VirtualFileSystem.getInstance().throwSimuledIOExceptionIfNeeded(this.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel getChannel() {
        if (!MockFramework.isEnabled()) {
            return super.getChannel();
        }
        MockFileOutputStream mockFileOutputStream = this;
        synchronized (mockFileOutputStream) {
            if (this.channel == null) {
                this.channel = new EvoFileChannel(this.position, this.path, false, true);
            }
            return this.channel;
        }
    }

    private void throwExceptionIfClosed() throws IOException {
        if (this.closed) {
            throw new MockIOException();
        }
    }

    @Override
    public void release() throws Exception {
        if (!MockFramework.isEnabled()) {
            return;
        }
        super.close();
    }
}

