/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.mock.EvoSuiteMock;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.StaticReplacementMock;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockFileInputStream;
import org.evosuite.runtime.mock.java.io.MockFileOutputStream;
import org.evosuite.runtime.mock.java.io.MockFileReader;
import org.evosuite.runtime.mock.java.io.MockFileWriter;
import org.evosuite.runtime.mock.java.io.MockIOException;
import org.evosuite.runtime.mock.java.io.MockPrintStream;
import org.evosuite.runtime.mock.java.io.MockPrintWriter;
import org.evosuite.runtime.mock.java.io.MockRandomAccessFile;
import org.evosuite.runtime.mock.java.lang.MockArithmeticException;
import org.evosuite.runtime.mock.java.lang.MockArrayIndexOutOfBoundsException;
import org.evosuite.runtime.mock.java.lang.MockError;
import org.evosuite.runtime.mock.java.lang.MockException;
import org.evosuite.runtime.mock.java.lang.MockIllegalAccessException;
import org.evosuite.runtime.mock.java.lang.MockIllegalArgumentException;
import org.evosuite.runtime.mock.java.lang.MockIllegalStateException;
import org.evosuite.runtime.mock.java.lang.MockNullPointerException;
import org.evosuite.runtime.mock.java.lang.MockRuntime;
import org.evosuite.runtime.mock.java.lang.MockRuntimeException;
import org.evosuite.runtime.mock.java.lang.MockThread;
import org.evosuite.runtime.mock.java.lang.MockThrowable;
import org.evosuite.runtime.mock.java.net.MockDatagramSocket;
import org.evosuite.runtime.mock.java.net.MockInetAddress;
import org.evosuite.runtime.mock.java.net.MockInetSocketAddress;
import org.evosuite.runtime.mock.java.net.MockNetworkInterface;
import org.evosuite.runtime.mock.java.net.MockServerSocket;
import org.evosuite.runtime.mock.java.net.MockSocket;
import org.evosuite.runtime.mock.java.net.MockSocketImpl;
import org.evosuite.runtime.mock.java.net.MockURI;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.mock.java.net.MockURLStreamHandler;
import org.evosuite.runtime.mock.java.security.MockSecureRandom;
import org.evosuite.runtime.mock.java.text.MockDateFormat;
import org.evosuite.runtime.mock.java.text.MockSimpleDateFormat;
import org.evosuite.runtime.mock.java.time.MockClock;
import org.evosuite.runtime.mock.java.time.MockInstant;
import org.evosuite.runtime.mock.java.time.MockLocalDate;
import org.evosuite.runtime.mock.java.time.MockLocalDateTime;
import org.evosuite.runtime.mock.java.time.MockLocalTime;
import org.evosuite.runtime.mock.java.time.MockMonthDay;
import org.evosuite.runtime.mock.java.time.MockOffsetDateTime;
import org.evosuite.runtime.mock.java.time.MockOffsetTime;
import org.evosuite.runtime.mock.java.time.MockYear;
import org.evosuite.runtime.mock.java.time.MockYearMonth;
import org.evosuite.runtime.mock.java.time.MockZonedDateTime;
import org.evosuite.runtime.mock.java.time.chrono.MockHijrahChronology;
import org.evosuite.runtime.mock.java.time.chrono.MockHijrahDate;
import org.evosuite.runtime.mock.java.time.chrono.MockIsoChronology;
import org.evosuite.runtime.mock.java.time.chrono.MockJapaneseChronology;
import org.evosuite.runtime.mock.java.time.chrono.MockJapaneseDate;
import org.evosuite.runtime.mock.java.time.chrono.MockMinguoChronology;
import org.evosuite.runtime.mock.java.time.chrono.MockMinguoDate;
import org.evosuite.runtime.mock.java.time.chrono.MockThaiBuddhistChronology;
import org.evosuite.runtime.mock.java.time.chrono.MockThaiBuddhistDate;
import org.evosuite.runtime.mock.java.util.MockCalendar;
import org.evosuite.runtime.mock.java.util.MockDate;
import org.evosuite.runtime.mock.java.util.MockGregorianCalendar;
import org.evosuite.runtime.mock.java.util.MockRandom;
import org.evosuite.runtime.mock.java.util.MockTimer;
import org.evosuite.runtime.mock.java.util.MockUUID;
import org.evosuite.runtime.mock.java.util.logging.MockFileHandler;
import org.evosuite.runtime.mock.java.util.logging.MockLogRecord;
import org.evosuite.runtime.mock.java.util.prefs.MockPreferences;
import org.evosuite.runtime.mock.javax.naming.MockInitialContext;
import org.evosuite.runtime.mock.javax.persistence.MockPersistence;
import org.evosuite.runtime.mock.javax.swing.MockDefaultListSelectionModel;
import org.evosuite.runtime.mock.javax.swing.MockJFileChooser;
import org.evosuite.runtime.mock.javax.swing.MockJOptionPane;
import org.evosuite.runtime.mock.javax.swing.MockSpinnerDateModel;
import org.evosuite.runtime.mock.javax.swing.filechooser.MockFileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockList {
    private static final Logger logger = LoggerFactory.getLogger(MockList.class);

    public static List<Class<? extends EvoSuiteMock>> getList() {
        ArrayList<Class<? extends EvoSuiteMock>> list = new ArrayList<Class<? extends EvoSuiteMock>>();
        if (RuntimeSettings.useVFS) {
            list.add(MockFile.class);
            list.add(MockFileInputStream.class);
            list.add(MockFileOutputStream.class);
            list.add(MockRandomAccessFile.class);
            list.add(MockFileReader.class);
            list.add(MockFileWriter.class);
            list.add(MockPrintStream.class);
            list.add(MockPrintWriter.class);
            list.add(MockFileHandler.class);
            list.add(MockJFileChooser.class);
            list.add(MockFileSystemView.class);
        }
        if (RuntimeSettings.mockJVMNonDeterminism) {
            list.add(MockRuntime.class);
            list.add(MockLogRecord.class);
            list.add(MockDefaultListSelectionModel.class);
            list.add(MockDate.class);
            list.add(MockRandom.class);
            list.add(MockGregorianCalendar.class);
            list.add(MockCalendar.class);
            list.add(MockDateFormat.class);
            list.add(MockSimpleDateFormat.class);
            list.add(MockSpinnerDateModel.class);
            list.add(MockSecureRandom.class);
            list.add(MockUUID.class);
            list.add(MockClock.class);
            list.add(MockInstant.class);
            list.add(MockLocalDate.class);
            list.add(MockLocalDateTime.class);
            list.add(MockLocalTime.class);
            list.add(MockMonthDay.class);
            list.add(MockOffsetDateTime.class);
            list.add(MockOffsetTime.class);
            list.add(MockYear.class);
            list.add(MockYearMonth.class);
            list.add(MockZonedDateTime.class);
            list.add(MockHijrahChronology.class);
            list.add(MockHijrahDate.class);
            list.add(MockIsoChronology.class);
            list.add(MockJapaneseChronology.class);
            list.add(MockJapaneseDate.class);
            list.add(MockMinguoDate.class);
            list.add(MockMinguoChronology.class);
            list.add(MockThaiBuddhistChronology.class);
            list.add(MockThaiBuddhistDate.class);
            list.add(MockPreferences.class);
            list.add(MockTimer.class);
            list.add(MockThread.class);
            list.add(MockIOException.class);
            list.add(MockArithmeticException.class);
            list.add(MockArrayIndexOutOfBoundsException.class);
            list.add(MockError.class);
            list.add(MockException.class);
            list.add(MockIllegalAccessException.class);
            list.add(MockIllegalArgumentException.class);
            list.add(MockIllegalStateException.class);
            list.add(MockNullPointerException.class);
            list.add(MockRuntimeException.class);
            list.add(MockThrowable.class);
        }
        if (RuntimeSettings.useVNET) {
            list.add(MockDatagramSocket.class);
            list.add(MockInetAddress.class);
            list.add(MockInetSocketAddress.class);
            list.add(MockNetworkInterface.class);
            list.add(MockServerSocket.class);
            list.add(MockSocket.class);
            list.add(MockSocketImpl.class);
            list.add(MockURL.class);
            list.add(MockURLStreamHandler.class);
            list.add(MockURI.class);
        }
        if (RuntimeSettings.useJEE) {
            list.add(MockInitialContext.class);
            list.add(MockPersistence.class);
        }
        if (RuntimeSettings.mockGUI) {
            list.add(MockJOptionPane.class);
        }
        return list;
    }

    public static boolean shouldBeMocked(String originalClass) throws IllegalArgumentException {
        return MockList.getMockClass(originalClass) != null;
    }

    public static boolean isAMockClass(String mockClass) {
        if (mockClass == null) {
            return false;
        }
        for (Class<? extends EvoSuiteMock> mock : MockList.getList()) {
            if (!mock.getCanonicalName().equals(mockClass)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getMockClass(String originalClass) throws IllegalArgumentException {
        if (originalClass == null || originalClass.isEmpty()) {
            throw new IllegalArgumentException("Empty className");
        }
        for (Class<? extends EvoSuiteMock> mock : MockList.getList()) {
            String name;
            block8: {
                name = null;
                if (OverrideMock.class.isAssignableFrom(mock)) {
                    Class<? extends EvoSuiteMock> target = mock.getSuperclass();
                    if (target == null) {
                        logger.error("Override mock " + mock.getCanonicalName() + " does not have a superclass");
                        continue;
                    }
                    name = target.getCanonicalName();
                } else {
                    if (StaticReplacementMock.class.isAssignableFrom(mock)) {
                        try {
                            StaticReplacementMock m = (StaticReplacementMock)mock.newInstance();
                            name = m.getMockedClassName();
                            break block8;
                        }
                        catch (Exception e) {
                            logger.error("Failed to create instance of mock " + mock.getCanonicalName());
                            continue;
                        }
                    }
                    logger.error("Cannot handle " + mock);
                    continue;
                }
            }
            if (!originalClass.equals(name)) continue;
            return mock;
        }
        return null;
    }
}

