/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.javax.servlet.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.evosuite.runtime.annotation.Constraints;
import org.evosuite.runtime.annotation.EvoSuiteAssertionOnly;
import org.evosuite.runtime.annotation.EvoSuiteClassExclude;
import org.evosuite.runtime.annotation.EvoSuiteInclude;
import org.evosuite.runtime.javaee.TestDataJavaEE;
import org.evosuite.runtime.javaee.javax.servlet.EvoAsyncContext;
import org.evosuite.runtime.javaee.javax.servlet.EvoServletState;
import org.evosuite.runtime.javaee.javax.servlet.http.EvoPart;
import org.evosuite.runtime.javaee.javax.servlet.http.HttpMethod;
import org.evosuite.runtime.vnet.VirtualNetwork;
import org.evosuite.shaded.javax.servlet.AsyncContext;
import org.evosuite.shaded.javax.servlet.DispatcherType;
import org.evosuite.shaded.javax.servlet.RequestDispatcher;
import org.evosuite.shaded.javax.servlet.Servlet;
import org.evosuite.shaded.javax.servlet.ServletContext;
import org.evosuite.shaded.javax.servlet.ServletException;
import org.evosuite.shaded.javax.servlet.ServletInputStream;
import org.evosuite.shaded.javax.servlet.ServletRequest;
import org.evosuite.shaded.javax.servlet.ServletResponse;
import org.evosuite.shaded.javax.servlet.annotation.WebServlet;
import org.evosuite.shaded.javax.servlet.http.Cookie;
import org.evosuite.shaded.javax.servlet.http.HttpServletRequest;
import org.evosuite.shaded.javax.servlet.http.HttpServletResponse;
import org.evosuite.shaded.javax.servlet.http.HttpSession;
import org.evosuite.shaded.javax.servlet.http.HttpUpgradeHandler;
import org.evosuite.shaded.javax.servlet.http.Part;

@EvoSuiteClassExclude
public class EvoHttpServletRequest
implements HttpServletRequest {
    public static final String TEXT_XML_CONTENT_FORMAT = "text/xml";
    public static final String TEXT_HTML_CONTENT_FORMAT = "text/html";
    public static final String MULTIPART_FORM_CONTENT_FORMAT = "multipart/form-data";
    private String contextPath = "/EvoSuiteContext";
    private String servletPath = "/EvoSuiteServlet";
    private Integer requestedSessionId = null;
    private HttpMethod method;
    private String contentType;
    private String protocol;
    private String localAddr;
    private String localName;
    private int localPort;
    private String remoteAddr;
    private String remoteHost;
    private int remotePort;
    private Map<String, String[]> parameters;
    private AsyncContext asyncContext;
    private Map<String, EvoPart> parts;
    private String principalName;

    public EvoHttpServletRequest() {
        this.asGET();
        this.contentType = null;
        this.protocol = "HTTP/1.1";
        this.localName = "MockedJavaEEServer";
        this.localAddr = VirtualNetwork.getInstance().dnsResolve(this.localName);
        this.localPort = 80;
        this.remoteHost = "MockedRemoteEvoSuiteRequestClient";
        this.remoteAddr = VirtualNetwork.getInstance().dnsResolve(this.remoteHost);
        this.remotePort = 61386;
        this.parameters = new LinkedHashMap<String, String[]>();
        this.asyncContext = null;
        this.parts = new LinkedHashMap<String, EvoPart>();
    }

    @Override
    public AsyncContext getAsyncContext() throws IllegalStateException {
        if (this.asyncContext == null) {
            throw new IllegalStateException("Async context not initialized");
        }
        return this.asyncContext;
    }

    @Override
    @EvoSuiteAssertionOnly
    public boolean isAsyncStarted() {
        return this.asyncContext != null;
    }

    @Override
    @EvoSuiteAssertionOnly
    public boolean isAsyncSupported() {
        Servlet sut = EvoServletState.getServlet();
        WebServlet annotation = sut.getClass().getAnnotation(WebServlet.class);
        if (annotation == null) {
            return false;
        }
        return annotation.asyncSupported();
    }

    @Override
    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.isAsyncSupported() || EvoServletState.getResponse().isCommitted()) {
            throw new IllegalStateException("Cannot start async");
        }
        if (this.asyncContext == null) {
            this.asyncContext = new EvoAsyncContext();
        }
        return this.asyncContext;
    }

    @Override
    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) throws IllegalStateException {
        return null;
    }

    @Override
    public Object getAttribute(String arg0) {
        return null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return null;
    }

    @Override
    public String getCharacterEncoding() {
        return null;
    }

    @Override
    public int getContentLength() {
        return 0;
    }

    @Override
    public long getContentLengthLong() {
        return 0L;
    }

    @Override
    public String getContentType() {
        TestDataJavaEE.getInstance().accessContentType();
        return this.contentType;
    }

    @Override
    public DispatcherType getDispatcherType() {
        return null;
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public String getLocalAddr() {
        return this.localAddr;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    @Override
    public Locale getLocale() {
        return null;
    }

    @Override
    public Enumeration<Locale> getLocales() {
        return null;
    }

    @Override
    public String getParameter(String arg0) {
        String[] params;
        if (arg0 != null) {
            TestDataJavaEE.getInstance().accessedHttpRequestParameter(arg0);
        }
        if ((params = this.getParameterValues(arg0)) != null) {
            return params[0];
        }
        return null;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, String[]>(){
            {
                this.putAll(EvoHttpServletRequest.this.parameters);
            }

            @Override
            public Set<String> keySet() {
                final Set set = super.keySet();
                return Collections.unmodifiableSet(new LinkedHashSet<String>(){
                    {
                        this.addAll(set);
                    }

                    @Override
                    public boolean contains(Object k) {
                        if (!(k instanceof String)) {
                            return false;
                        }
                        String val = (String)k;
                        if (val != null && !val.trim().isEmpty()) {
                            TestDataJavaEE.getInstance().accessedHttpRequestParameter(val);
                        }
                        return super.contains(val);
                    }
                });
            }

            @Override
            public boolean containsKey(Object k) {
                if (!(k instanceof String)) {
                    return false;
                }
                String key = (String)k;
                if (key != null && !key.trim().isEmpty()) {
                    TestDataJavaEE.getInstance().accessedHttpRequestParameter(key);
                }
                return super.containsKey(key);
            }
        });
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    @Override
    public String[] getParameterValues(String arg0) {
        return this.parameters.get(arg0);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public BufferedReader getReader() throws IOException {
        return null;
    }

    @Override
    public String getRealPath(String arg0) {
        return null;
    }

    @Override
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String arg0) {
        return null;
    }

    @Override
    public String getScheme() {
        return null;
    }

    @Override
    public String getServerName() {
        return null;
    }

    @Override
    public int getServerPort() {
        return 0;
    }

    @Override
    public ServletContext getServletContext() {
        return null;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public void removeAttribute(String arg0) {
    }

    @Override
    public void setAttribute(String arg0, Object arg1) {
    }

    @Override
    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
    }

    @Override
    public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
        return false;
    }

    @Override
    public String changeSessionId() throws IllegalStateException {
        if (this.requestedSessionId == null) {
            throw new IllegalStateException("No current session id");
        }
        Integer n = this.requestedSessionId;
        Integer n2 = this.requestedSessionId = Integer.valueOf(this.requestedSessionId + 1);
        return this.requestedSessionId.toString();
    }

    @Override
    public String getAuthType() {
        return null;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public Cookie[] getCookies() {
        return null;
    }

    @Override
    public long getDateHeader(String arg0) {
        return 0L;
    }

    @Override
    public String getHeader(String arg0) {
        return null;
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return null;
    }

    @Override
    public Enumeration<String> getHeaders(String arg0) {
        return null;
    }

    @Override
    public int getIntHeader(String arg0) {
        return 0;
    }

    @Override
    public String getMethod() {
        return this.method.toString();
    }

    @Override
    public Part getPart(String arg0) throws IOException, ServletException {
        if (!MULTIPART_FORM_CONTENT_FORMAT.equals(this.contentType)) {
            throw new ServletException("Cannot access parts if request is not of type multipart/form-data");
        }
        TestDataJavaEE.getInstance().accessPart(arg0);
        return this.parts.get(arg0);
    }

    @Override
    public Collection<Part> getParts() throws IOException, ServletException {
        if (!MULTIPART_FORM_CONTENT_FORMAT.equals(this.contentType)) {
            throw new ServletException("Cannot access parts if request is not of type multipart/form-data");
        }
        TestDataJavaEE.getInstance().accessPart(null);
        return new ArrayList<Part>(){
            {
                this.addAll(EvoHttpServletRequest.this.parts.values());
            }
        };
    }

    @Override
    public String getPathInfo() {
        return null;
    }

    @Override
    public String getPathTranslated() {
        return null;
    }

    @Override
    public String getQueryString() {
        return null;
    }

    @Override
    public String getRemoteUser() {
        return null;
    }

    @Override
    public String getRequestURI() {
        return this.getContextPath() + this.getServletPath();
    }

    @Override
    public StringBuffer getRequestURL() {
        return null;
    }

    @Override
    public String getRequestedSessionId() {
        return this.requestedSessionId == null ? null : this.requestedSessionId.toString();
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public HttpSession getSession() {
        return null;
    }

    @Override
    public HttpSession getSession(boolean arg0) {
        return null;
    }

    @Override
    public Principal getUserPrincipal() {
        if (this.principalName == null || this.principalName.trim().isEmpty()) {
            return null;
        }
        return new Principal(){

            @Override
            public String getName() {
                return EvoHttpServletRequest.this.principalName;
            }
        };
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return false;
    }

    @Override
    public boolean isUserInRole(String arg0) {
        return false;
    }

    @Override
    public void login(String arg0, String arg1) throws ServletException {
    }

    @Override
    public void logout() throws ServletException {
    }

    @Override
    public <T extends HttpUpgradeHandler> T upgrade(Class<T> arg0) throws IOException, ServletException {
        return null;
    }

    public String toString() {
        return EvoHttpServletRequest.class.getSimpleName() + " [ " + this.getMethod() + " " + this.getRequestURI() + " ]";
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asGET", "asPUT", "as"})
    public void asPOST() {
        this.setHttpMethod(HttpMethod.POST);
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asPOST", "asPUT", "as"})
    public void asGET() {
        this.setHttpMethod(HttpMethod.GET);
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asGET", "asPOST", "as"})
    public void asPUT() {
        this.setHttpMethod(HttpMethod.PUT);
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asGET", "asPOST", "asPUT"}, noNullInputs=true)
    public void as(HttpMethod m) {
        this.setHttpMethod(m);
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asMultipartFormData", "asTextHtml"}, dependOnProperties={"javaee.servlet.http.contentType"})
    public void asTextXml() {
        this.setContentType(TEXT_XML_CONTENT_FORMAT);
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asTextXml", "asMultipartFormData"}, dependOnProperties={"javaee.servlet.http.contentType"})
    public void asTextHtml() {
        this.setContentType(TEXT_HTML_CONTENT_FORMAT);
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asTextXml", "asTextHtml"}, dependOnProperties={"javaee.servlet.http.contentType"}, after="asPOST")
    public void asMultipartFormData() {
        this.setContentType(MULTIPART_FORM_CONTENT_FORMAT);
    }

    @EvoSuiteInclude
    @Constraints(dependOnProperties={"javaee.servlet.http.param"}, after="asMultipartFormData")
    public void addParam(String key, String value) throws IllegalArgumentException {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Null input");
        }
        String[] params = this.parameters.get(key);
        if (params == null) {
            params = new String[]{value};
        } else {
            params = Arrays.copyOf(params, params.length + 1);
            params[params.length - 1] = value;
        }
        this.parameters.put(key, params);
    }

    @EvoSuiteInclude
    @Constraints(dependOnProperties={"javaee.servlet.http.part"})
    public void addPart(EvoPart p) {
        this.parts.put(p.getName(), p);
    }

    @EvoSuiteInclude
    @Constraints(dependOnProperties={"javaee.servlet.http.principal"})
    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    private void setHttpMethod(HttpMethod m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException("Null input");
        }
        this.method = m;
    }

    private void setContentType(String type) {
        this.contentType = type;
    }
}

