/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.PackageInfo;
import org.evosuite.runtime.instrumentation.RuntimeInstrumentation;
import org.evosuite.shaded.org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerForTests
implements ClassFileTransformer {
    protected static final Logger logger = LoggerFactory.getLogger(TransformerForTests.class);
    private volatile boolean active = false;
    private RuntimeInstrumentation instrumenter = new RuntimeInstrumentation();
    private Set<String> instrumentedClasses = new LinkedHashSet<String>();

    public void setRetransformingMode(boolean on) {
        this.instrumenter.setRetransformingMode(on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        String classWithDots = className.replace('/', '.');
        if (!this.active || !RuntimeInstrumentation.checkIfCanInstrument(classWithDots) || classWithDots.startsWith(PackageInfo.getEvoSuitePackage())) {
            return classfileBuffer;
        }
        ClassReader reader = new ClassReader(classfileBuffer);
        Set<String> set = this.instrumentedClasses;
        synchronized (set) {
            this.instrumentedClasses.add(classWithDots);
        }
        logger.debug("Going to instrument: " + classWithDots);
        if (this.instrumenter.isAlreadyInstrumented(new ClassReader(classfileBuffer))) {
            logger.debug("Skipping transformation of {} as it is already instrumented", (Object)classWithDots);
            return classfileBuffer;
        }
        return this.instrumenter.transformBytes(loader, className, reader, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClassAlreadyTransformed(String className) {
        Set<String> set = this.instrumentedClasses;
        synchronized (set) {
            return this.instrumentedClasses.contains(className);
        }
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }
}

