/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.util.Locale;
import javax.swing.JComponent;
import org.evosuite.runtime.LoopCounter;
import org.evosuite.runtime.Random;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.System;
import org.evosuite.runtime.javaee.TestDataJavaEE;
import org.evosuite.runtime.javaee.db.DBManager;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.java.lang.MockThread;
import org.evosuite.runtime.mock.java.util.MockLocale;
import org.evosuite.runtime.mock.java.util.MockTimeZone;
import org.evosuite.runtime.mock.java.util.prefs.MockPreferences;
import org.evosuite.runtime.mock.javax.naming.EvoNamingContext;
import org.evosuite.runtime.thread.ThreadCounter;
import org.evosuite.runtime.vfs.VirtualFileSystem;
import org.evosuite.runtime.vnet.VirtualNetwork;

public class Runtime {
    private static final Runtime singleton = new Runtime();

    protected Runtime() {
    }

    public static synchronized Runtime getInstance() {
        return singleton;
    }

    public static synchronized void resetSingleton() {
        singleton.resetRuntime();
    }

    public void resetRuntime() {
        MockFramework.enable();
        if (RuntimeSettings.mockJVMNonDeterminism) {
            Random.reset();
            System.resetRuntime();
            MockThread.reset();
            ThreadCounter.getInstance().resetSingleton();
            MockTimeZone.reset();
            MockLocale.reset();
            MockPreferences.resetPreferences();
            JComponent.setDefaultLocale(Locale.getDefault());
        }
        if (RuntimeSettings.useVFS) {
            VirtualFileSystem.getInstance().resetSingleton();
            VirtualFileSystem.getInstance().init();
        }
        if (RuntimeSettings.useVNET) {
            VirtualNetwork.getInstance().reset();
            VirtualNetwork.getInstance().init();
        }
        if (RuntimeSettings.useJEE) {
            TestDataJavaEE.getInstance().reset();
            EvoNamingContext.getInstance().reset();
            if (DBManager.getInstance().isWasAccessed()) {
                boolean wasLoopCheckOn = LoopCounter.getInstance().isActivated();
                LoopCounter.getInstance().setActive(false);
                DBManager.getInstance().initDB();
                LoopCounter.getInstance().setActive(wasLoopCheckOn);
            }
        }
        LoopCounter.getInstance().reset();
    }
}

