/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.ActionSource2;
import javax.faces.component.MethodBindingMethodExpressionAdapter;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public class UIViewAction
extends UIComponentBase
implements ActionSource2 {
    public static final String COMPONENT_TYPE = "javax.faces.ViewAction";
    public static final String COMPONENT_FAMILY = "javax.faces.ViewAction";
    private static final String UIVIEWACTION_BROADCAST = "javax.faces.ViewAction.broadcast";
    private static final String UIVIEWACTION_EVENT_COUNT = "javax.faces.ViewAction.eventCount";

    public UIViewAction() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "javax.faces.ViewAction";
    }

    private void incrementEventCount(FacesContext context) {
        Map<Object, Object> attrs = context.getAttributes();
        Integer count = (Integer)attrs.get(UIVIEWACTION_EVENT_COUNT);
        if (null == count) {
            attrs.put(UIVIEWACTION_EVENT_COUNT, 1);
        } else {
            attrs.put(UIVIEWACTION_EVENT_COUNT, count + 1);
        }
    }

    private boolean decrementEventCountAndReturnTrueIfZero(FacesContext context) {
        boolean result = true;
        Map<Object, Object> attrs = context.getAttributes();
        Integer count = (Integer)attrs.get(UIVIEWACTION_EVENT_COUNT);
        if (null != count) {
            if ((count = Integer.valueOf(count - 1)) < 1) {
                attrs.remove(UIVIEWACTION_EVENT_COUNT);
                result = true;
            } else {
                attrs.put(UIVIEWACTION_EVENT_COUNT, count);
                result = false;
            }
        }
        return result;
    }

    @Deprecated
    public MethodBinding getAction() {
        MethodBindingMethodExpressionAdapter result = null;
        MethodExpression me = this.getActionExpression();
        if (null != me) {
            result = new MethodBindingMethodExpressionAdapter(me);
        }
        return result;
    }

    @Deprecated
    public void setAction(MethodBinding action) {
    }

    @Deprecated
    public MethodBinding getActionListener() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Deprecated
    public void setActionListener(MethodBinding actionListener) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean isImmediate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.immediate), false);
    }

    public void setImmediate(boolean immediate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.immediate), immediate);
    }

    public String getPhase() {
        PhaseId myPhaseId = this.getPhaseId();
        String result = null;
        if (null != myPhaseId) {
            result = myPhaseId.getName();
        }
        return result;
    }

    public void setPhase(String phase) {
        PhaseId myPhaseId = PhaseId.phaseIdValueOf(phase);
        if (PhaseId.ANY_PHASE.equals(myPhaseId) || PhaseId.RESTORE_VIEW.equals(myPhaseId) || PhaseId.RENDER_RESPONSE.equals(myPhaseId)) {
            throw new FacesException("View actions cannot be executed in specified phase: [" + myPhaseId.toString() + "]");
        }
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.phase), myPhaseId);
    }

    private void setIsProcessingUIViewActionBroadcast(FacesContext context, boolean value) {
        Map<Object, Object> attrs = context.getAttributes();
        if (value) {
            attrs.put(UIVIEWACTION_BROADCAST, Boolean.TRUE);
        } else {
            attrs.remove(UIVIEWACTION_BROADCAST);
        }
    }

    public static boolean isProcessingBroadcast(FacesContext context) {
        boolean result = context.getAttributes().containsKey(UIVIEWACTION_BROADCAST);
        return result;
    }

    private PhaseId getPhaseId() {
        PhaseId myPhaseId = (PhaseId)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.phase));
        return myPhaseId;
    }

    public void addActionListener(ActionListener listener) {
    }

    public ActionListener[] getActionListeners() {
        return new ActionListener[0];
    }

    public void removeActionListener(ActionListener listener) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public MethodExpression getActionExpression() {
        return (MethodExpression)this.getStateHelper().get((Serializable)((Object)PropertyKeys.actionExpression));
    }

    public void setActionExpression(MethodExpression actionExpression) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.actionExpression), actionExpression);
    }

    public boolean isOnPostback() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onPostback), false);
    }

    public void setOnPostback(boolean onPostback) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onPostback), onPostback);
    }

    public boolean isRendered() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.renderedAttr), true);
    }

    public void setRendered(boolean condition) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.renderedAttr), condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        ActionListener listener;
        super.broadcast(event);
        FacesContext context = this.getFacesContext();
        if (!(event instanceof ActionEvent)) {
            throw new IllegalArgumentException();
        }
        if (!context.getResponseComplete() && context.getViewRoot() == this.getViewRootOf(event) && (listener = context.getApplication().getActionListener()) != null) {
            boolean hasMoreViewActionEvents = false;
            UIViewRoot viewRootBefore = context.getViewRoot();
            assert (null != viewRootBefore);
            InstrumentedFacesContext instrumentedContext = null;
            try {
                instrumentedContext = new InstrumentedFacesContext(context);
                this.setIsProcessingUIViewActionBroadcast(context, true);
                instrumentedContext.disableRenderResponseControl().set();
                listener.processAction((ActionEvent)event);
                hasMoreViewActionEvents = !this.decrementEventCountAndReturnTrueIfZero(context);
            }
            finally {
                this.setIsProcessingUIViewActionBroadcast(context, false);
                if (null != instrumentedContext) {
                    instrumentedContext.restore();
                }
            }
            if (!context.getResponseComplete()) {
                UIViewRoot viewRootAfter = context.getViewRoot();
                assert (null != viewRootAfter);
                String viewIdBefore = viewRootBefore.getViewId();
                String viewIdAfter = viewRootAfter.getViewId();
                assert (null != viewIdBefore && null != viewIdAfter);
                boolean viewIdsSame = viewIdBefore.equals(viewIdAfter);
                if (viewIdsSame && !hasMoreViewActionEvents) {
                    context.renderResponse();
                }
            }
        }
    }

    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (context.isPostback() && !this.isOnPostback() || !this.isRendered()) {
            return;
        }
        ActionEvent e = new ActionEvent(this);
        PhaseId phaseId = this.getPhaseId();
        if (phaseId != null) {
            e.setPhaseId(phaseId);
        } else if (this.isImmediate()) {
            e.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else {
            e.setPhaseId(PhaseId.INVOKE_APPLICATION);
        }
        this.incrementEventCount(context);
        this.queueEvent(e);
    }

    private UIViewRoot getViewRootOf(FacesEvent e) {
        UIComponent c = e.getComponent();
        do {
            if (!(c instanceof UIViewRoot)) continue;
            return (UIViewRoot)c;
        } while ((c = c.getParent()) != null);
        return null;
    }

    private class InstrumentedFacesContext
    extends FacesContextWrapper {
        private final FacesContext wrapped;
        private boolean viewRootCleared = false;
        private boolean renderedResponseControlDisabled = false;
        private Boolean postback = null;

        public InstrumentedFacesContext(FacesContext wrapped) {
            this.wrapped = wrapped;
        }

        public FacesContext getWrapped() {
            return this.wrapped;
        }

        public UIViewRoot getViewRoot() {
            if (this.viewRootCleared) {
                return null;
            }
            return this.wrapped.getViewRoot();
        }

        public void setViewRoot(UIViewRoot viewRoot) {
            this.viewRootCleared = false;
            this.wrapped.setViewRoot(viewRoot);
        }

        public boolean isPostback() {
            return this.postback == null ? this.wrapped.isPostback() : this.postback.booleanValue();
        }

        public void renderResponse() {
            if (!this.renderedResponseControlDisabled) {
                this.wrapped.renderResponse();
            }
        }

        public InstrumentedFacesContext pushViewIntoRequestMap() {
            this.getExternalContext().getRequestMap().put("org.evosuite.shaded.javax.servlet.include.servlet_path", this.wrapped.getViewRoot().getViewId());
            return this;
        }

        public InstrumentedFacesContext clearPostback() {
            this.postback = false;
            return this;
        }

        public InstrumentedFacesContext clearViewRoot() {
            this.viewRootCleared = true;
            return this;
        }

        public InstrumentedFacesContext disableRenderResponseControl() {
            this.renderedResponseControlDisabled = true;
            return this;
        }

        public void set() {
            InstrumentedFacesContext.setCurrentInstance(this);
        }

        public void restore() {
            InstrumentedFacesContext.setCurrentInstance(this.wrapped);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyKeys {
        onPostback,
        actionExpression,
        immediate,
        phase,
        renderedAttr("if");

        private String name;

        private PropertyKeys() {
        }

        private PropertyKeys(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name != null ? this.name : super.toString();
        }
    }
}

