/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.SizeTPointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Opaque;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.presets.opencv_core;

@Namespace(value="cv::ocl")
@NoOffset
@Properties(inherit={opencv_core.class})
public class Device
extends Pointer {
    public static final int TYPE_DEFAULT = 1;
    public static final int TYPE_CPU = 2;
    public static final int TYPE_GPU = 4;
    public static final int TYPE_ACCELERATOR = 8;
    public static final int TYPE_DGPU = 65540;
    public static final int TYPE_IGPU = 131076;
    public static final int TYPE_ALL = -1;
    public static final int FP_DENORM = 1;
    public static final int FP_INF_NAN = 2;
    public static final int FP_ROUND_TO_NEAREST = 4;
    public static final int FP_ROUND_TO_ZERO = 8;
    public static final int FP_ROUND_TO_INF = 16;
    public static final int FP_FMA = 32;
    public static final int FP_SOFT_FLOAT = 64;
    public static final int FP_CORRECTLY_ROUNDED_DIVIDE_SQRT = 128;
    public static final int EXEC_KERNEL = 1;
    public static final int EXEC_NATIVE_KERNEL = 2;
    public static final int NO_CACHE = 0;
    public static final int READ_ONLY_CACHE = 1;
    public static final int READ_WRITE_CACHE = 2;
    public static final int NO_LOCAL_MEM = 0;
    public static final int LOCAL_IS_LOCAL = 1;
    public static final int LOCAL_IS_GLOBAL = 2;
    public static final int UNKNOWN_VENDOR = 0;
    public static final int VENDOR_AMD = 1;
    public static final int VENDOR_INTEL = 2;
    public static final int VENDOR_NVIDIA = 3;

    public Device(long size) {
        super((Pointer)null);
        this.allocateArray(size);
    }

    private native void allocateArray(long var1);

    public Device position(long position) {
        return (Device)super.position(position);
    }

    public Device getPointer(long i) {
        return new Device((Pointer)this).position(this.position + i);
    }

    public Device() {
        super((Pointer)null);
        this.allocate();
    }

    private native void allocate();

    public Device(Pointer d) {
        super((Pointer)null);
        this.allocate(d);
    }

    private native void allocate(Pointer var1);

    public Device(@Const @ByRef Device d) {
        super((Pointer)null);
        this.allocate(d);
    }

    private native void allocate(@Const @ByRef Device var1);

    @ByRef
    @Name(value={"operator ="})
    public native Device put(@Const @ByRef Device var1);

    public native void set(Pointer var1);

    @opencv_core.Str
    public native BytePointer name();

    @opencv_core.Str
    public native BytePointer extensions();

    @Cast(value={"bool"})
    public native boolean isExtensionSupported(@opencv_core.Str BytePointer var1);

    @Cast(value={"bool"})
    public native boolean isExtensionSupported(@opencv_core.Str String var1);

    @opencv_core.Str
    public native BytePointer version();

    @opencv_core.Str
    public native BytePointer vendorName();

    @opencv_core.Str
    public native BytePointer OpenCL_C_Version();

    @opencv_core.Str
    public native BytePointer OpenCLVersion();

    public native int deviceVersionMajor();

    public native int deviceVersionMinor();

    @opencv_core.Str
    public native BytePointer driverVersion();

    public native Pointer ptr();

    public native int type();

    public native int addressBits();

    @Cast(value={"bool"})
    public native boolean available();

    @Cast(value={"bool"})
    public native boolean compilerAvailable();

    @Cast(value={"bool"})
    public native boolean linkerAvailable();

    public native int doubleFPConfig();

    public native int singleFPConfig();

    public native int halfFPConfig();

    @Cast(value={"bool"})
    public native boolean endianLittle();

    @Cast(value={"bool"})
    public native boolean errorCorrectionSupport();

    public native int executionCapabilities();

    @Cast(value={"size_t"})
    public native long globalMemCacheSize();

    public native int globalMemCacheType();

    public native int globalMemCacheLineSize();

    @Cast(value={"size_t"})
    public native long globalMemSize();

    @Cast(value={"size_t"})
    public native long localMemSize();

    public native int localMemType();

    @Cast(value={"bool"})
    public native boolean hostUnifiedMemory();

    @Cast(value={"bool"})
    public native boolean imageSupport();

    @Cast(value={"bool"})
    public native boolean imageFromBufferSupport();

    @Cast(value={"uint"})
    public native int imagePitchAlignment();

    @Cast(value={"uint"})
    public native int imageBaseAddressAlignment();

    @Cast(value={"bool"})
    public native boolean intelSubgroupsSupport();

    @Cast(value={"size_t"})
    public native long image2DMaxWidth();

    @Cast(value={"size_t"})
    public native long image2DMaxHeight();

    @Cast(value={"size_t"})
    public native long image3DMaxWidth();

    @Cast(value={"size_t"})
    public native long image3DMaxHeight();

    @Cast(value={"size_t"})
    public native long image3DMaxDepth();

    @Cast(value={"size_t"})
    public native long imageMaxBufferSize();

    @Cast(value={"size_t"})
    public native long imageMaxArraySize();

    public native int vendorID();

    @Cast(value={"bool"})
    public native boolean isAMD();

    @Cast(value={"bool"})
    public native boolean isIntel();

    @Cast(value={"bool"})
    public native boolean isNVidia();

    public native int maxClockFrequency();

    public native int maxComputeUnits();

    public native int maxConstantArgs();

    @Cast(value={"size_t"})
    public native long maxConstantBufferSize();

    @Cast(value={"size_t"})
    public native long maxMemAllocSize();

    @Cast(value={"size_t"})
    public native long maxParameterSize();

    public native int maxReadImageArgs();

    public native int maxWriteImageArgs();

    public native int maxSamplers();

    @Cast(value={"size_t"})
    public native long maxWorkGroupSize();

    public native int maxWorkItemDims();

    public native void maxWorkItemSizes(@Cast(value={"size_t*"}) SizeTPointer var1);

    public native int memBaseAddrAlign();

    public native int nativeVectorWidthChar();

    public native int nativeVectorWidthShort();

    public native int nativeVectorWidthInt();

    public native int nativeVectorWidthLong();

    public native int nativeVectorWidthFloat();

    public native int nativeVectorWidthDouble();

    public native int nativeVectorWidthHalf();

    public native int preferredVectorWidthChar();

    public native int preferredVectorWidthShort();

    public native int preferredVectorWidthInt();

    public native int preferredVectorWidthLong();

    public native int preferredVectorWidthFloat();

    public native int preferredVectorWidthDouble();

    public native int preferredVectorWidthHalf();

    @Cast(value={"size_t"})
    public native long printfBufferSize();

    @Cast(value={"size_t"})
    public native long profilingTimerResolution();

    @Const
    @ByRef
    public static native Device getDefault();

    @ByVal
    public static native Device fromHandle(Pointer var0);

    public native Impl getImpl();

    @Cast(value={"bool"})
    public native boolean empty();

    static {
        Loader.load();
    }

    @Opaque
    public static class Impl
    extends Pointer {
        public Impl() {
            super((Pointer)null);
        }

        public Impl(Pointer p) {
            super(p);
        }
    }
}

