/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.BaseWSDLFactory;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.ReaderFeatures;
import org.apache.woden.internal.WSDLContext;
import org.apache.woden.internal.resolver.SimpleURIResolver;
import org.apache.woden.internal.schema.SchemaConstants;
import org.apache.woden.internal.util.PropertyUtils;
import org.apache.woden.internal.util.StringUtils;
import org.apache.woden.internal.wsdl20.Constants;
import org.apache.woden.resolver.URIResolver;
import org.apache.woden.schema.Schema;
import org.apache.woden.types.NCName;
import org.apache.woden.types.QNameTokenUnion;
import org.apache.woden.wsdl20.enumeration.Direction;
import org.apache.woden.wsdl20.enumeration.MessageLabel;
import org.apache.woden.wsdl20.extensions.ExtensionDeserializer;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;
import org.apache.woden.wsdl20.xml.BindingElement;
import org.apache.woden.wsdl20.xml.BindingFaultElement;
import org.apache.woden.wsdl20.xml.BindingFaultReferenceElement;
import org.apache.woden.wsdl20.xml.BindingMessageReferenceElement;
import org.apache.woden.wsdl20.xml.BindingOperationElement;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.DocumentableElement;
import org.apache.woden.wsdl20.xml.DocumentationElement;
import org.apache.woden.wsdl20.xml.EndpointElement;
import org.apache.woden.wsdl20.xml.ImportElement;
import org.apache.woden.wsdl20.xml.IncludeElement;
import org.apache.woden.wsdl20.xml.InterfaceElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceOperationElement;
import org.apache.woden.wsdl20.xml.ServiceElement;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.woden.wsdl20.xml.WSDLElement;

public abstract class BaseWSDLReader
implements WSDLReader {
    private final String DEFAULT_RESOLVER_PROPERTY = "org.apache.woden.resolver.default";
    private String fFactoryImplName = null;
    protected WSDLContext fWsdlContext;
    protected final ReaderFeatures features;

    protected BaseWSDLReader(WSDLContext wsdlContext) throws WSDLException {
        SimpleURIResolver resolver;
        this.fFactoryImplName = wsdlContext.wsdlFactory.getClass().getName();
        this.features = new ReaderFeatures();
        String defaultURIResolver = PropertyUtils.findProperty("org.apache.woden.resolver.default");
        if (defaultURIResolver == null) {
            resolver = new SimpleURIResolver();
        } else {
            try {
                Class<?> resolverClass = Class.forName(defaultURIResolver);
                resolver = (URIResolver)resolverClass.newInstance();
            }
            catch (Exception e) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem instantiating a URIResolver implementation using classname '" + defaultURIResolver + "' ", (Throwable)e);
            }
        }
        this.fWsdlContext = new WSDLContext(wsdlContext.wsdlFactory, wsdlContext.errorReporter, wsdlContext.extensionRegistry, resolver);
    }

    public ErrorReporter getErrorReporter() {
        return this.fWsdlContext.errorReporter;
    }

    protected WSDLFactory getFactory() throws WSDLException {
        return this.fWsdlContext.wsdlFactory;
    }

    public void setFactoryImplName(String factoryImplName) {
        this.fFactoryImplName = factoryImplName;
    }

    public String getFactoryImplName() {
        return this.fFactoryImplName;
    }

    public void setExtensionRegistry(ExtensionRegistry extReg) {
        if (extReg == null) {
            String msg = this.fWsdlContext.errorReporter.getFormattedMessage("WSDL014", null);
            throw new NullPointerException(msg);
        }
        this.fWsdlContext = new WSDLContext(this.fWsdlContext.wsdlFactory, this.fWsdlContext.errorReporter, extReg, this.fWsdlContext.uriResolver);
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.fWsdlContext.extensionRegistry;
    }

    public void setFeature(String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL005", null));
        }
        try {
            this.features.setValue(name, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL006", new Object[]{name}));
        }
    }

    public boolean getFeature(String name) {
        if (name == null) {
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL005", null));
        }
        try {
            return this.features.getValue(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL006", new Object[]{name}));
        }
    }

    public void setProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL007", null));
        }
        if (!name.equals("xyz")) {
            Object[] args = new Object[]{name};
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL008", args));
        }
    }

    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL007", null));
        }
        if (name.equals("xyz")) {
            return null;
        }
        throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL008", new Object[]{name}));
    }

    protected DescriptionElement parseDescription(String documentBaseURI, XMLElement descEl, Map wsdlModules) throws WSDLException {
        if (Constants.Q_ELEM_DEFINITIONS.equals(descEl.getQName())) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL514", new Object[]{Constants.Q_ELEM_DEFINITIONS, descEl.getQName()}, (short)3);
        }
        if (!Constants.Q_ELEM_DESCRIPTION.equals(descEl.getQName())) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL501", new Object[]{Constants.Q_ELEM_DESCRIPTION, descEl.getQName()}, (short)3);
        }
        DescriptionElement desc = ((BaseWSDLFactory)this.getFactory()).newDescriptionElement(this.fWsdlContext);
        if (wsdlModules == null) {
            wsdlModules = new HashMap<String, DescriptionElement>();
        }
        desc.setDocumentBaseURI(this.getURI(documentBaseURI));
        String targetNamespace = descEl.getAttributeValue("targetNamespace");
        if (targetNamespace != null) {
            desc.setTargetNamespace(this.getURI(targetNamespace));
        }
        this.parseNamespaceDeclarations(descEl, (WSDLElement)desc);
        this.parseExtensionAttributes(descEl, DescriptionElement.class, (WSDLElement)desc, desc);
        XMLElement[] children = descEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)desc);
                continue;
            }
            if (Constants.Q_ELEM_IMPORT.equals(tempElQN)) {
                if (documentBaseURI != null && !wsdlModules.containsKey(documentBaseURI)) {
                    wsdlModules.put(documentBaseURI, desc);
                }
                this.parseImport(tempEl, desc, wsdlModules);
                continue;
            }
            if (Constants.Q_ELEM_INCLUDE.equals(tempElQN)) {
                if (documentBaseURI != null && !wsdlModules.containsKey(documentBaseURI)) {
                    wsdlModules.put(documentBaseURI, desc);
                }
                this.parseInclude(tempEl, desc, wsdlModules);
                continue;
            }
            if (Constants.Q_ELEM_TYPES.equals(tempElQN)) {
                this.parseTypes(tempEl, desc);
                continue;
            }
            if (Constants.Q_ELEM_INTERFACE.equals(tempElQN)) {
                this.parseInterface(tempEl, desc);
                continue;
            }
            if (Constants.Q_ELEM_BINDING.equals(tempElQN)) {
                this.parseBinding(tempEl, desc);
                continue;
            }
            if (Constants.Q_ELEM_SERVICE.equals(tempElQN)) {
                this.parseService(tempEl, desc);
                continue;
            }
            desc.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$DescriptionElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.DescriptionElement") : class$org$apache$woden$wsdl20$xml$DescriptionElement, (WSDLElement)desc, tempEl, desc));
        }
        this.parseSchemaForXMLSchema(desc);
        return desc;
    }

    protected DocumentationElement parseDocumentation(XMLElement docEl, DescriptionElement desc, DocumentableElement parent) throws WSDLException {
        DocumentationElement documentation = parent.addDocumentationElement();
        documentation.setContent(docEl);
        this.parseExtensionAttributes(docEl, DocumentationElement.class, (WSDLElement)documentation, desc);
        XMLElement[] children = docEl.getChildElements();
        XMLElement tempEl = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            documentation.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$DocumentationElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.DocumentationElement") : class$org$apache$woden$wsdl20$xml$DocumentationElement, (WSDLElement)documentation, tempEl, desc));
        }
        return documentation;
    }

    private ImportElement parseImport(XMLElement importEl, DescriptionElement desc, Map wsdlModules) throws WSDLException {
        ImportElement imp = desc.addImportElement();
        String namespaceURI = importEl.getAttributeValue("namespace");
        String locationURI = importEl.getAttributeValue("location");
        this.parseExtensionAttributes(importEl, ImportElement.class, (WSDLElement)imp, desc);
        if (namespaceURI != null) {
            imp.setNamespace(this.getURI(namespaceURI));
        }
        if (locationURI != null) {
            URI resolvedLocationURI = this.resolveURI(this.getURI(locationURI));
            imp.setLocation(resolvedLocationURI);
            DescriptionElement importedDesc = this.getWSDLFromLocation(resolvedLocationURI.toString(), desc, wsdlModules);
            imp.setDescriptionElement(importedDesc);
        }
        return imp;
    }

    private IncludeElement parseInclude(XMLElement includeEl, DescriptionElement desc, Map wsdlModules) throws WSDLException {
        IncludeElement include = desc.addIncludeElement();
        String locationURI = includeEl.getAttributeValue("location");
        this.parseExtensionAttributes(includeEl, IncludeElement.class, (WSDLElement)include, desc);
        if (locationURI != null) {
            URI resolvedLocationURI = this.resolveURI(this.getURI(locationURI));
            include.setLocation(resolvedLocationURI);
            DescriptionElement includedDesc = this.getWSDLFromLocation(resolvedLocationURI.toString(), desc, wsdlModules);
            include.setDescriptionElement(includedDesc);
        }
        return include;
    }

    private TypesElement parseTypes(XMLElement typesEl, DescriptionElement desc) throws WSDLException {
        TypesElement types = desc.addTypesElement();
        types.setTypeSystem("http://www.w3.org/2001/XMLSchema");
        this.parseExtensionAttributes(typesEl, TypesElement.class, (WSDLElement)types, desc);
        XMLElement[] children = typesEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)types);
                continue;
            }
            if (SchemaConstants.Q_ELEM_SCHEMA_IMPORT.equals(tempElQN)) {
                types.addSchema(this.parseSchemaImport(tempEl, desc));
                continue;
            }
            if (SchemaConstants.Q_ELEM_SCHEMA.equals(tempElQN)) {
                types.addSchema(this.parseSchemaInline(tempEl, desc));
                continue;
            }
            types.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$TypesElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.TypesElement") : class$org$apache$woden$wsdl20$xml$TypesElement, (WSDLElement)types, tempEl, desc));
        }
        return types;
    }

    protected abstract Schema parseSchemaImport(XMLElement var1, DescriptionElement var2) throws WSDLException;

    protected abstract Schema parseSchemaInline(XMLElement var1, DescriptionElement var2) throws WSDLException;

    private InterfaceElement parseInterface(XMLElement interfaceEl, DescriptionElement desc) throws WSDLException {
        String extendsAtt;
        String styleDefault;
        InterfaceElement intface = desc.addInterfaceElement();
        String name = interfaceEl.getAttributeValue("name");
        if (name != null) {
            intface.setName(new NCName(name));
        }
        if ((styleDefault = interfaceEl.getAttributeValue("styleDefault")) != null) {
            List stringList = StringUtils.parseNMTokens(styleDefault);
            String uriString = null;
            Iterator it = stringList.iterator();
            while (it.hasNext()) {
                uriString = (String)it.next();
                intface.addStyleDefaultURI(this.getURI(uriString));
            }
        }
        if ((extendsAtt = interfaceEl.getAttributeValue("extends")) != null) {
            List stringList = StringUtils.parseNMTokens(extendsAtt);
            String qnString = null;
            Iterator it = stringList.iterator();
            while (it.hasNext()) {
                qnString = (String)it.next();
                intface.addExtendedInterfaceName(interfaceEl.getQName(qnString));
            }
        }
        this.parseExtensionAttributes(interfaceEl, InterfaceElement.class, (WSDLElement)intface, desc);
        XMLElement[] children = interfaceEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)intface);
                continue;
            }
            if (Constants.Q_ELEM_FAULT.equals(tempElQN)) {
                this.parseInterfaceFault(tempEl, desc, intface);
                continue;
            }
            if (Constants.Q_ELEM_OPERATION.equals(tempElQN)) {
                this.parseInterfaceOperation(tempEl, desc, intface);
                continue;
            }
            intface.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceElement") : class$org$apache$woden$wsdl20$xml$InterfaceElement, (WSDLElement)intface, tempEl, desc));
        }
        return intface;
    }

    private InterfaceFaultElement parseInterfaceFault(XMLElement faultEl, DescriptionElement desc, InterfaceElement parent) throws WSDLException {
        String element;
        InterfaceFaultElement fault = parent.addInterfaceFaultElement();
        String name = faultEl.getAttributeValue("name");
        if (name != null) {
            fault.setName(new NCName(name));
        }
        if ((element = faultEl.getAttributeValue("element")) != null) {
            if (element.equals("#any")) {
                fault.setElement(QNameTokenUnion.ANY);
            } else if (element.equals("#none")) {
                fault.setElement(QNameTokenUnion.NONE);
            } else if (element.equals("#other")) {
                fault.setElement(QNameTokenUnion.OTHER);
            } else {
                try {
                    QName qname = faultEl.getQName(element);
                    fault.setElement(new QNameTokenUnion(qname));
                }
                catch (WSDLException e) {
                    this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{element, faultEl.getQName()}, (short)2);
                }
            }
        }
        this.parseExtensionAttributes(faultEl, InterfaceFaultElement.class, (WSDLElement)fault, desc);
        XMLElement[] children = faultEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)fault);
                continue;
            }
            fault.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceFaultElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceFaultElement") : class$org$apache$woden$wsdl20$xml$InterfaceFaultElement, (WSDLElement)fault, tempEl, desc));
        }
        return fault;
    }

    private InterfaceOperationElement parseInterfaceOperation(XMLElement operEl, DescriptionElement desc, InterfaceElement parent) throws WSDLException {
        String pat;
        String style;
        InterfaceOperationElement oper = parent.addInterfaceOperationElement();
        String name = operEl.getAttributeValue("name");
        if (name != null) {
            oper.setName(new NCName(name));
        }
        if ((style = operEl.getAttributeValue("style")) != null) {
            List stringList = StringUtils.parseNMTokens(style);
            String uriString = null;
            Iterator it = stringList.iterator();
            while (it.hasNext()) {
                uriString = (String)it.next();
                oper.addStyleURI(this.getURI(uriString));
            }
        }
        if ((pat = operEl.getAttributeValue("pattern")) != null) {
            oper.setPattern(this.getURI(pat));
        }
        this.parseExtensionAttributes(operEl, InterfaceOperationElement.class, (WSDLElement)oper, desc);
        XMLElement[] children = operEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)oper);
                continue;
            }
            if (Constants.Q_ELEM_INPUT.equals(tempElQN)) {
                this.parseInterfaceMessageReference(tempEl, desc, oper);
                continue;
            }
            if (Constants.Q_ELEM_OUTPUT.equals(tempElQN)) {
                this.parseInterfaceMessageReference(tempEl, desc, oper);
                continue;
            }
            if (Constants.Q_ELEM_INFAULT.equals(tempElQN)) {
                this.parseInterfaceFaultReference(tempEl, desc, oper);
                continue;
            }
            if (Constants.Q_ELEM_OUTFAULT.equals(tempElQN)) {
                this.parseInterfaceFaultReference(tempEl, desc, oper);
                continue;
            }
            oper.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceOperationElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceOperationElement") : class$org$apache$woden$wsdl20$xml$InterfaceOperationElement, (WSDLElement)oper, tempEl, desc));
        }
        return oper;
    }

    private InterfaceFaultReferenceElement parseInterfaceFaultReference(XMLElement faultRefEl, DescriptionElement desc, InterfaceOperationElement parent) throws WSDLException {
        String msgLabel;
        InterfaceFaultReferenceElement faultRef = parent.addInterfaceFaultReferenceElement();
        if ("infault".equals(faultRefEl.getLocalName())) {
            faultRef.setDirection(Direction.IN);
        } else if ("outfault".equals(faultRefEl.getLocalName())) {
            faultRef.setDirection(Direction.OUT);
        }
        String ref = faultRefEl.getAttributeValue("ref");
        if (ref != null) {
            try {
                QName qname = faultRefEl.getQName(ref);
                faultRef.setRef(qname);
            }
            catch (WSDLException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{ref, faultRefEl.getQName()}, (short)2);
            }
        }
        if ((msgLabel = faultRefEl.getAttributeValue("messageLabel")) != null) {
            faultRef.setMessageLabel(new NCName(msgLabel));
        } else {
            InterfaceOperationElement iop = (InterfaceOperationElement)faultRef.getParentElement();
            URI mep = iop.getPattern();
            if (Constants.MEP_URI_IN_OUT.equals(mep)) {
                if ("outfault".equals(faultRefEl.getLocalName())) {
                    faultRef.setMessageLabel(MessageLabel.OUT);
                } else {
                    faultRef.setMessageLabel(MessageLabel.IN);
                }
            } else if (Constants.MEP_URI_ROBUST_IN_ONLY.equals(mep)) {
                if ("outfault".equals(faultRefEl.getLocalName())) {
                    faultRef.setMessageLabel(MessageLabel.IN);
                } else {
                    faultRef.setMessageLabel(MessageLabel.OUT);
                }
            } else if (Constants.MEP_URI_IN_ONLY.equals(mep)) {
                // empty if block
            }
        }
        this.parseExtensionAttributes(faultRefEl, InterfaceFaultReferenceElement.class, (WSDLElement)faultRef, desc);
        XMLElement[] children = faultRefEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)faultRef);
                continue;
            }
            faultRef.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceFaultReferenceElement") : class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement, (WSDLElement)faultRef, tempEl, desc));
        }
        return faultRef;
    }

    private InterfaceMessageReferenceElement parseInterfaceMessageReference(XMLElement msgRefEl, DescriptionElement desc, InterfaceOperationElement parent) throws WSDLException {
        InterfaceMessageReferenceElement message = parent.addInterfaceMessageReferenceElement();
        if ("input".equals(msgRefEl.getLocalName())) {
            message.setDirection(Direction.IN);
        } else if ("output".equals(msgRefEl.getLocalName())) {
            message.setDirection(Direction.OUT);
        }
        String msgLabel = msgRefEl.getAttributeValue("messageLabel");
        if (msgLabel != null) {
            message.setMessageLabel(new NCName(msgLabel));
        } else if (message.getDirection().equals(Direction.IN)) {
            message.setMessageLabel(MessageLabel.IN);
        } else {
            message.setMessageLabel(MessageLabel.OUT);
        }
        String element = msgRefEl.getAttributeValue("element");
        if (element != null) {
            if (element.equals("#any")) {
                message.setElement(QNameTokenUnion.ANY);
            } else if (element.equals("#none")) {
                message.setElement(QNameTokenUnion.NONE);
            } else if (element.equals("#other")) {
                message.setElement(QNameTokenUnion.OTHER);
            } else {
                try {
                    QNameTokenUnion qname = new QNameTokenUnion(msgRefEl.getQName(element));
                    message.setElement(qname);
                }
                catch (WSDLException e) {
                    this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{element, msgRefEl.getQName()}, (short)2);
                }
            }
        }
        this.parseExtensionAttributes(msgRefEl, InterfaceMessageReferenceElement.class, (WSDLElement)message, desc);
        XMLElement[] children = msgRefEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)message);
                continue;
            }
            message.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement") : class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement, (WSDLElement)message, tempEl, desc));
        }
        return message;
    }

    private BindingElement parseBinding(XMLElement bindEl, DescriptionElement desc) throws WSDLException {
        String type;
        BindingElement binding = desc.addBindingElement();
        String name = bindEl.getAttributeValue("name");
        if (name != null) {
            binding.setName(new NCName(name));
        }
        QName intfaceQN = null;
        String intface = bindEl.getAttributeValue("interface");
        if (intface != null) {
            try {
                intfaceQN = bindEl.getQName(intface);
                binding.setInterfaceName(intfaceQN);
            }
            catch (WSDLException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{intface, bindEl.getQName()}, (short)2);
            }
        }
        if ((type = bindEl.getAttributeValue("type")) != null) {
            binding.setType(this.getURI(type));
        }
        this.parseExtensionAttributes(bindEl, BindingElement.class, (WSDLElement)binding, desc);
        XMLElement[] children = bindEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)binding);
                continue;
            }
            if (Constants.Q_ELEM_FAULT.equals(tempElQN)) {
                this.parseBindingFault(tempEl, desc, binding);
                continue;
            }
            if (Constants.Q_ELEM_OPERATION.equals(tempElQN)) {
                this.parseBindingOperation(tempEl, desc, binding);
                continue;
            }
            binding.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingElement") : class$org$apache$woden$wsdl20$xml$BindingElement, (WSDLElement)binding, tempEl, desc));
        }
        return binding;
    }

    private BindingFaultElement parseBindingFault(XMLElement bindFaultEl, DescriptionElement desc, BindingElement parent) throws WSDLException {
        BindingFaultElement fault = parent.addBindingFaultElement();
        QName intFltQN = null;
        String ref = bindFaultEl.getAttributeValue("ref");
        if (ref != null) {
            try {
                intFltQN = bindFaultEl.getQName(ref);
                fault.setRef(intFltQN);
            }
            catch (WSDLException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{ref, bindFaultEl.getQName()}, (short)2);
            }
        }
        this.parseExtensionAttributes(bindFaultEl, BindingFaultElement.class, (WSDLElement)fault, desc);
        XMLElement[] children = bindFaultEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)fault);
                continue;
            }
            fault.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingFaultElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingFaultElement") : class$org$apache$woden$wsdl20$xml$BindingFaultElement, (WSDLElement)fault, tempEl, desc));
        }
        return fault;
    }

    private BindingOperationElement parseBindingOperation(XMLElement bindOpEl, DescriptionElement desc, BindingElement parent) throws WSDLException {
        BindingOperationElement oper = parent.addBindingOperationElement();
        QName refQN = null;
        String ref = bindOpEl.getAttributeValue("ref");
        if (ref != null) {
            try {
                refQN = bindOpEl.getQName(ref);
                oper.setRef(refQN);
            }
            catch (WSDLException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{ref, bindOpEl.getQName()}, (short)2);
            }
        }
        this.parseExtensionAttributes(bindOpEl, BindingOperationElement.class, (WSDLElement)oper, desc);
        XMLElement[] children = bindOpEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)oper);
                continue;
            }
            if (Constants.Q_ELEM_INPUT.equals(tempElQN)) {
                this.parseBindingMessageReference(tempEl, desc, oper);
                continue;
            }
            if (Constants.Q_ELEM_OUTPUT.equals(tempElQN)) {
                this.parseBindingMessageReference(tempEl, desc, oper);
                continue;
            }
            if (Constants.Q_ELEM_INFAULT.equals(tempElQN)) {
                this.parseBindingFaultReference(tempEl, desc, oper);
                continue;
            }
            if (Constants.Q_ELEM_OUTFAULT.equals(tempElQN)) {
                this.parseBindingFaultReference(tempEl, desc, oper);
                continue;
            }
            oper.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingOperationElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingOperationElement") : class$org$apache$woden$wsdl20$xml$BindingOperationElement, (WSDLElement)oper, tempEl, desc));
        }
        return oper;
    }

    private BindingFaultReferenceElement parseBindingFaultReference(XMLElement faultRefEl, DescriptionElement desc, BindingOperationElement parent) throws WSDLException {
        String msgLabel;
        BindingFaultReferenceElement faultRef = parent.addBindingFaultReferenceElement();
        QName refQN = null;
        String ref = faultRefEl.getAttributeValue("ref");
        if (ref != null) {
            try {
                refQN = faultRefEl.getQName(ref);
                faultRef.setRef(refQN);
            }
            catch (WSDLException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{ref, faultRefEl.getQName()}, (short)2);
            }
        }
        if ((msgLabel = faultRefEl.getAttributeValue("messageLabel")) != null) {
            faultRef.setMessageLabel(new NCName(msgLabel));
        } else {
            URI mep;
            BindingOperationElement bop = (BindingOperationElement)faultRef.getParentElement();
            InterfaceOperationElement iop = bop.getInterfaceOperationElement();
            URI uRI = mep = iop != null ? iop.getPattern() : null;
            if (Constants.MEP_URI_IN_OUT.equals(mep)) {
                if ("outfault".equals(faultRefEl.getLocalName())) {
                    faultRef.setMessageLabel(MessageLabel.OUT);
                } else {
                    faultRef.setMessageLabel(MessageLabel.IN);
                }
            } else if (Constants.MEP_URI_ROBUST_IN_ONLY.equals(mep)) {
                if ("outfault".equals(faultRefEl.getLocalName())) {
                    faultRef.setMessageLabel(MessageLabel.IN);
                } else {
                    faultRef.setMessageLabel(MessageLabel.OUT);
                }
            } else if (Constants.MEP_URI_IN_ONLY.equals(mep)) {
                // empty if block
            }
        }
        this.parseExtensionAttributes(faultRefEl, BindingFaultReferenceElement.class, (WSDLElement)faultRef, desc);
        XMLElement[] children = faultRefEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)faultRef);
                continue;
            }
            faultRef.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingFaultReferenceElement") : class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement, (WSDLElement)faultRef, tempEl, desc));
        }
        return faultRef;
    }

    private BindingMessageReferenceElement parseBindingMessageReference(XMLElement msgRefEl, DescriptionElement desc, BindingOperationElement parent) throws WSDLException {
        BindingMessageReferenceElement message = parent.addBindingMessageReferenceElement();
        if ("input".equals(msgRefEl.getLocalName())) {
            message.setDirection(Direction.IN);
        } else if ("output".equals(msgRefEl.getLocalName())) {
            message.setDirection(Direction.OUT);
        }
        String msgLabel = msgRefEl.getAttributeValue("messageLabel");
        if (msgLabel != null) {
            message.setMessageLabel(new NCName(msgLabel));
        } else if (message.getDirection().equals(Direction.IN)) {
            message.setMessageLabel(MessageLabel.IN);
        } else {
            message.setMessageLabel(MessageLabel.OUT);
        }
        this.parseExtensionAttributes(msgRefEl, BindingMessageReferenceElement.class, (WSDLElement)message, desc);
        XMLElement[] children = msgRefEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)message);
                continue;
            }
            message.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingMessageReferenceElement") : class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement, (WSDLElement)message, tempEl, desc));
        }
        return message;
    }

    private ServiceElement parseService(XMLElement serviceEl, DescriptionElement desc) throws WSDLException {
        ServiceElement service = desc.addServiceElement();
        String name = serviceEl.getAttributeValue("name");
        if (name != null) {
            service.setName(new NCName(name));
        }
        QName intfaceQN = null;
        String intface = serviceEl.getAttributeValue("interface");
        if (intface != null) {
            try {
                intfaceQN = serviceEl.getQName(intface);
                service.setInterfaceName(intfaceQN);
            }
            catch (WSDLException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{intface, serviceEl.getQName()}, (short)2);
            }
        }
        this.parseExtensionAttributes(serviceEl, ServiceElement.class, (WSDLElement)service, desc);
        XMLElement[] children = serviceEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)service);
                continue;
            }
            if (Constants.Q_ELEM_ENDPOINT.equals(tempElQN)) {
                this.parseEndpoint(tempEl, desc, service);
                continue;
            }
            service.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$ServiceElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.ServiceElement") : class$org$apache$woden$wsdl20$xml$ServiceElement, (WSDLElement)service, tempEl, desc));
        }
        return service;
    }

    private EndpointElement parseEndpoint(XMLElement endpointEl, DescriptionElement desc, ServiceElement parent) throws WSDLException {
        String address;
        EndpointElement endpoint = parent.addEndpointElement();
        String name = endpointEl.getAttributeValue("name");
        if (name != null) {
            endpoint.setName(new NCName(name));
        }
        QName bindingQN = null;
        String binding = endpointEl.getAttributeValue("binding");
        if (binding != null) {
            try {
                bindingQN = endpointEl.getQName(binding);
                endpoint.setBindingName(bindingQN);
            }
            catch (WSDLException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{binding, endpointEl.getQName()}, (short)2);
            }
        }
        if ((address = endpointEl.getAttributeValue("address")) != null) {
            endpoint.setAddress(this.getURI(address));
        }
        this.parseExtensionAttributes(endpointEl, EndpointElement.class, (WSDLElement)endpoint, desc);
        XMLElement[] children = endpointEl.getChildElements();
        XMLElement tempEl = null;
        QName tempElQN = null;
        for (int i = 0; i < children.length; ++i) {
            tempEl = children[i];
            tempElQN = tempEl.getQName();
            if (Constants.Q_ELEM_DOCUMENTATION.equals(tempElQN)) {
                this.parseDocumentation(tempEl, desc, (DocumentableElement)endpoint);
                continue;
            }
            endpoint.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$EndpointElement == null ? BaseWSDLReader.class$("org.apache.woden.wsdl20.xml.EndpointElement") : class$org$apache$woden$wsdl20$xml$EndpointElement, (WSDLElement)endpoint, tempEl, desc));
        }
        return endpoint;
    }

    protected ExtensionElement parseExtensionElement(Class parentType, WSDLElement parent, XMLElement el, DescriptionElement desc) throws WSDLException {
        QName elementType = el.getQName();
        URI namespaceURI = el.getNamespaceURI();
        try {
            if (Constants.NS_URI_WSDL20.equals(namespaceURI)) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL520", new Object[]{elementType, parentType.getName()}, (short)2);
                return null;
            }
            ExtensionRegistry extReg = this.fWsdlContext.extensionRegistry;
            ExtensionDeserializer extDS = extReg.queryDeserializer(parentType, elementType);
            return extDS.unmarshall(parentType, (Object)parent, elementType, el, desc, extReg);
        }
        catch (WSDLException e) {
            if (e.getLocation() == null) {
                // empty if block
            }
            throw e;
        }
    }

    protected abstract void parseExtensionAttributes(XMLElement var1, Class var2, WSDLElement var3, DescriptionElement var4) throws WSDLException;

    protected abstract void parseNamespaceDeclarations(XMLElement var1, WSDLElement var2) throws WSDLException;

    protected void parseSchemaForXMLSchema(DescriptionElement desc) throws WSDLException {
    }

    protected abstract XMLElement createXMLElement(Object var1) throws IllegalArgumentException;

    protected URI getURI(String anyURI) throws WSDLException {
        URI uri = null;
        if (anyURI != null) {
            try {
                uri = new URI(anyURI);
            }
            catch (URISyntaxException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL506", new Object[]{anyURI}, (short)2, (Exception)e);
            }
        }
        return uri;
    }

    protected abstract DescriptionElement getWSDLFromLocation(String var1, DescriptionElement var2, Map var3) throws WSDLException;

    public void setURIResolver(URIResolver resolver) {
        if (resolver == null) {
            String msg = this.fWsdlContext.errorReporter.getFormattedMessage("WSDL026", new Object[]{"resolver"});
            throw new NullPointerException(msg);
        }
        this.fWsdlContext = new WSDLContext(this.fWsdlContext.wsdlFactory, this.fWsdlContext.errorReporter, this.fWsdlContext.extensionRegistry, resolver);
    }

    protected URI resolveURI(URI uri) throws WSDLException {
        if (uri != null) {
            URI resolvedUri = null;
            try {
                resolvedUri = this.getURIResolver().resolveURI(uri);
            }
            catch (IOException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL524", new Object[]{uri}, (short)2, (Exception)e);
            }
            if (resolvedUri != null) {
                uri = resolvedUri;
            }
        }
        return uri;
    }

    protected String resolveURI(String uri) {
        String resolvedUri;
        try {
            resolvedUri = this.getURIResolver().resolveURI(new URI(uri)).toString();
        }
        catch (Exception e) {
            resolvedUri = uri;
        }
        return resolvedUri;
    }

    public URIResolver getURIResolver() {
        return this.fWsdlContext.uriResolver;
    }
}

