/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.distsql.exception.rule;

import java.util.Collection;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleDefinitionViolationException;
import org.apache.shardingsphere.infra.util.exception.external.sql.sqlstate.SQLState;
import org.apache.shardingsphere.infra.util.exception.external.sql.sqlstate.XOpenSQLState;

public final class MissingRequiredAlgorithmException
extends RuleDefinitionViolationException {
    private static final long serialVersionUID = -1952698375135777585L;

    public MissingRequiredAlgorithmException() {
        super((SQLState)XOpenSQLState.CHECK_OPTION_VIOLATION, 151, "Algorithm does not exist.", new Object[0]);
    }

    public MissingRequiredAlgorithmException(String type, String databaseName) {
        super((SQLState)XOpenSQLState.CHECK_OPTION_VIOLATION, 151, String.format("%s algorithm does not exist in database `%s`.", type, databaseName), new Object[0]);
    }

    public MissingRequiredAlgorithmException(String type, Collection<String> algorithmNames) {
        super((SQLState)XOpenSQLState.CHECK_OPTION_VIOLATION, 151, String.format("%s algorithms `%s` do not exist.", type, algorithmNames), new Object[0]);
    }

    public MissingRequiredAlgorithmException(String type, String databaseName, Collection<String> algorithmNames) {
        super((SQLState)XOpenSQLState.CHECK_OPTION_VIOLATION, 151, String.format("%s algorithms `%s` do not exist in database `%s`.", type, algorithmNames, databaseName), new Object[0]);
    }
}

