/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import kafka.api.OffsetRequest$;
import kafka.common.Config;
import kafka.common.InvalidConfigException;
import kafka.consumer.ConsumerConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsumerConfig$
implements Config {
    public static ConsumerConfig$ MODULE$;
    private final int RefreshMetadataBackoffMs;
    private final int SocketTimeout;
    private final int SocketBufferSize;
    private final int FetchSize;
    private final int MaxFetchSize;
    private final int NumConsumerFetchers;
    private final int DefaultFetcherBackoffMs;
    private final boolean AutoCommit;
    private final int AutoCommitInterval;
    private final int MaxQueuedChunks;
    private final int MaxRebalanceRetries;
    private final String AutoOffsetReset;
    private final int ConsumerTimeoutMs;
    private final int MinFetchBytes;
    private final int MaxFetchBytes;
    private final int MaxFetchWaitMs;
    private final String MirrorTopicsWhitelist;
    private final String MirrorTopicsBlacklist;
    private final int MirrorConsumerNumThreads;
    private final int OffsetsChannelBackoffMs;
    private final int OffsetsChannelSocketTimeoutMs;
    private final int OffsetsCommitMaxRetries;
    private final String OffsetsStorage;
    private final String MirrorTopicsWhitelistProp;
    private final String MirrorTopicsBlacklistProp;
    private final boolean ExcludeInternalTopics;
    private final String DefaultPartitionAssignmentStrategy;
    private final String MirrorConsumerNumThreadsProp;
    private final String DefaultClientId;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ConsumerConfig$();
    }

    @Override
    public void validateChars(String prop, String value) {
        Config.validateChars$(this, prop, value);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConsumerConfig$ consumerConfig$ = this;
        synchronized (consumerConfig$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public int RefreshMetadataBackoffMs() {
        return this.RefreshMetadataBackoffMs;
    }

    public int SocketTimeout() {
        return this.SocketTimeout;
    }

    public int SocketBufferSize() {
        return this.SocketBufferSize;
    }

    public int FetchSize() {
        return this.FetchSize;
    }

    public int MaxFetchSize() {
        return this.MaxFetchSize;
    }

    public int NumConsumerFetchers() {
        return this.NumConsumerFetchers;
    }

    public int DefaultFetcherBackoffMs() {
        return this.DefaultFetcherBackoffMs;
    }

    public boolean AutoCommit() {
        return this.AutoCommit;
    }

    public int AutoCommitInterval() {
        return this.AutoCommitInterval;
    }

    public int MaxQueuedChunks() {
        return this.MaxQueuedChunks;
    }

    public int MaxRebalanceRetries() {
        return this.MaxRebalanceRetries;
    }

    public String AutoOffsetReset() {
        return this.AutoOffsetReset;
    }

    public int ConsumerTimeoutMs() {
        return this.ConsumerTimeoutMs;
    }

    public int MinFetchBytes() {
        return this.MinFetchBytes;
    }

    public int MaxFetchBytes() {
        return this.MaxFetchBytes;
    }

    public int MaxFetchWaitMs() {
        return this.MaxFetchWaitMs;
    }

    public String MirrorTopicsWhitelist() {
        return this.MirrorTopicsWhitelist;
    }

    public String MirrorTopicsBlacklist() {
        return this.MirrorTopicsBlacklist;
    }

    public int MirrorConsumerNumThreads() {
        return this.MirrorConsumerNumThreads;
    }

    public int OffsetsChannelBackoffMs() {
        return this.OffsetsChannelBackoffMs;
    }

    public int OffsetsChannelSocketTimeoutMs() {
        return this.OffsetsChannelSocketTimeoutMs;
    }

    public int OffsetsCommitMaxRetries() {
        return this.OffsetsCommitMaxRetries;
    }

    public String OffsetsStorage() {
        return this.OffsetsStorage;
    }

    public String MirrorTopicsWhitelistProp() {
        return this.MirrorTopicsWhitelistProp;
    }

    public String MirrorTopicsBlacklistProp() {
        return this.MirrorTopicsBlacklistProp;
    }

    public boolean ExcludeInternalTopics() {
        return this.ExcludeInternalTopics;
    }

    public String DefaultPartitionAssignmentStrategy() {
        return this.DefaultPartitionAssignmentStrategy;
    }

    public String MirrorConsumerNumThreadsProp() {
        return this.MirrorConsumerNumThreadsProp;
    }

    public String DefaultClientId() {
        return this.DefaultClientId;
    }

    public void validate(ConsumerConfig config) {
        this.validateClientId(config.clientId());
        this.validateGroupId(config.groupId());
        this.validateAutoOffsetReset(config.autoOffsetReset());
        this.validateOffsetsStorage(config.offsetsStorage());
        this.validatePartitionAssignmentStrategy(config.partitionAssignmentStrategy());
    }

    public void validateClientId(String clientId) {
        this.validateChars("client.id", clientId);
    }

    public void validateGroupId(String groupId) {
        this.validateChars("group.id", groupId);
    }

    public void validateAutoOffsetReset(String autoOffsetReset) {
        String string = autoOffsetReset;
        String string2 = OffsetRequest$.MODULE$.SmallestTimeString();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = OffsetRequest$.MODULE$.LargestTimeString();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new InvalidConfigException("Wrong value " + autoOffsetReset + " of auto.offset.reset in ConsumerConfig; " + "Valid values are " + OffsetRequest$.MODULE$.SmallestTimeString() + " and " + OffsetRequest$.MODULE$.LargestTimeString());
            }
        }
    }

    public void validateOffsetsStorage(String storage) {
        String string = storage;
        if ("zookeeper".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("kafka".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new InvalidConfigException("Wrong value " + storage + " of offsets.storage in consumer config; " + "Valid values are 'zookeeper' and 'kafka'");
        }
    }

    public void validatePartitionAssignmentStrategy(String strategy) {
        String string = strategy;
        if ("range".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("roundrobin".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new InvalidConfigException("Wrong value " + strategy + " of partition.assignment.strategy in consumer config; " + "Valid values are 'range' and 'roundrobin'");
        }
    }

    private ConsumerConfig$() {
        MODULE$ = this;
        Logging.$init$(this);
        Config.$init$(this);
        this.RefreshMetadataBackoffMs = 200;
        this.SocketTimeout = 30000;
        this.SocketBufferSize = 65536;
        this.FetchSize = 0x100000;
        this.MaxFetchSize = 10 * this.FetchSize();
        this.NumConsumerFetchers = 1;
        this.DefaultFetcherBackoffMs = 1000;
        this.AutoCommit = true;
        this.AutoCommitInterval = 60000;
        this.MaxQueuedChunks = 2;
        this.MaxRebalanceRetries = 4;
        this.AutoOffsetReset = OffsetRequest$.MODULE$.LargestTimeString();
        this.ConsumerTimeoutMs = -1;
        this.MinFetchBytes = 1;
        this.MaxFetchBytes = 0x3200000;
        this.MaxFetchWaitMs = 100;
        this.MirrorTopicsWhitelist = "";
        this.MirrorTopicsBlacklist = "";
        this.MirrorConsumerNumThreads = 1;
        this.OffsetsChannelBackoffMs = 1000;
        this.OffsetsChannelSocketTimeoutMs = 10000;
        this.OffsetsCommitMaxRetries = 5;
        this.OffsetsStorage = "zookeeper";
        this.MirrorTopicsWhitelistProp = "mirror.topics.whitelist";
        this.MirrorTopicsBlacklistProp = "mirror.topics.blacklist";
        this.ExcludeInternalTopics = true;
        this.DefaultPartitionAssignmentStrategy = "range";
        this.MirrorConsumerNumThreadsProp = "mirror.consumer.numthreads";
        this.DefaultClientId = "";
    }
}

