/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ConfigCommand$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r\u001ds!B\u0001\u0003\u0011\u00039\u0011!D\"p]\u001aLwmQ8n[\u0006tGM\u0003\u0002\u0004\t\u0005)\u0011\rZ7j]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003\u001b\r{gNZ5h\u0007>lW.\u00198e'\rIAB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011AB2p[6|g.\u0003\u0002\u0018)\t11i\u001c8gS\u001eDQ!G\u0005\u0005\u0002i\ta\u0001P5oSRtD#A\u0004\t\u000fqI!\u0019!C\u0001;\u00051B)\u001a4bk2$8k\u0019:b[&#XM]1uS>t7/F\u0001\u001f!\tiq$\u0003\u0002!\u001d\t\u0019\u0011J\u001c;\t\r\tJ\u0001\u0015!\u0003\u001f\u0003]!UMZ1vYR\u001c6M]1n\u0013R,'/\u0019;j_:\u001c\b\u0005C\u0003%\u0013\u0011\u0005Q%\u0001\u0003nC&tGC\u0001\u0014*!\tiq%\u0003\u0002)\u001d\t!QK\\5u\u0011\u0015Q3\u00051\u0001,\u0003\u0011\t'oZ:\u0011\u00075ac&\u0003\u0002.\u001d\t)\u0011I\u001d:bsB\u0011qF\u000e\b\u0003aQ\u0002\"!\r\b\u000e\u0003IR!a\r\u0004\u0002\rq\u0012xn\u001c;?\u0013\t)d\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b\u000f\u0011\u0019Q\u0014\u0002\"\u0001\u0003w\u0005Y\u0011\r\u001c;fe\u000e{gNZ5h)\u00151C\bRA<\u0011\u0015i\u0014\b1\u0001?\u0003\u001dQ8.\u0016;jYN\u0004\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005\r\u0003%a\u0002.l+RLGn\u001d\u0005\u0006\u000bf\u0002\rAR\u0001\u0005_B$8\u000f\u0005\u0002H\u00116\t\u0011B\u0002\u0003J\u0013\u0001Q%\u0001F\"p]\u001aLwmQ8n[\u0006tGm\u00149uS>t7o\u0005\u0002I\u0019!A!\u0006\u0013B\u0001B\u0003%1\u0006C\u0003\u001a\u0011\u0012\u0005Q\n\u0006\u0002G\u001d\")!\u0006\u0014a\u0001W!9\u0001\u000b\u0013b\u0001\n\u0003\t\u0016A\u00029beN,'/F\u0001S!\t\u0019f+D\u0001U\u0015\u0005)\u0016A\u00036paR\u001c\u0018.\u001c9mK&\u0011q\u000b\u0016\u0002\r\u001fB$\u0018n\u001c8QCJ\u001cXM\u001d\u0005\u00073\"\u0003\u000b\u0011\u0002*\u0002\u000fA\f'o]3sA!91\f\u0013b\u0001\n\u0003a\u0016\u0001\u0004>l\u0007>tg.Z2u\u001fB$X#A/\u0011\u0007Msf&\u0003\u0002`)\nY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000eDa!\u0019%!\u0002\u0013i\u0016!\u0004>l\u0007>tg.Z2u\u001fB$\b\u0005C\u0004d\u0011\n\u0007I\u0011\u00013\u0002\u0011\u0005dG/\u001a:PaR,\u0012!\u001a\t\u0003'\u001aL!a\u001a+\u0003#=\u0003H/[8o'B,7MQ;jY\u0012,'\u000f\u0003\u0004j\u0011\u0002\u0006I!Z\u0001\nC2$XM](qi\u0002Bqa\u001b%C\u0002\u0013\u0005A-A\u0006eKN\u001c'/\u001b2f\u001fB$\bBB7IA\u0003%Q-\u0001\u0007eKN\u001c'/\u001b2f\u001fB$\b\u0005C\u0004p\u0011\n\u0007I\u0011\u0001/\u0002\u0015\u0015tG/\u001b;z)f\u0004X\r\u0003\u0004r\u0011\u0002\u0006I!X\u0001\fK:$\u0018\u000e^=UsB,\u0007\u0005C\u0004t\u0011\n\u0007I\u0011\u0001/\u0002\u0015\u0015tG/\u001b;z\u001d\u0006lW\r\u0003\u0004v\u0011\u0002\u0006I!X\u0001\fK:$\u0018\u000e^=OC6,\u0007\u0005C\u0004x\u0011\n\u0007I\u0011\u00013\u0002\u001b\u0015tG/\u001b;z\t\u00164\u0017-\u001e7u\u0011\u0019I\b\n)A\u0005K\u0006qQM\u001c;jif$UMZ1vYR\u0004\u0003bB>I\u0005\u0004%\t\u0001`\u0001\u0003]2,\u0012! \t\u0004}\u0006\u001dQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0006\u0005!!.\u0019<b\u0013\t9t\u0010C\u0004\u0002\f!\u0003\u000b\u0011B?\u0002\u00079d\u0007\u0005\u0003\u0005\u0002\u0010!\u0013\r\u0011\"\u0001]\u0003%\tG\rZ\"p]\u001aLw\rC\u0004\u0002\u0014!\u0003\u000b\u0011B/\u0002\u0015\u0005$GmQ8oM&<\u0007\u0005\u0003\u0005\u0002\u0018!\u0013\r\u0011\"\u0001]\u00031!W\r\\3uK\u000e{gNZ5h\u0011\u001d\tY\u0002\u0013Q\u0001\nu\u000bQ\u0002Z3mKR,7i\u001c8gS\u001e\u0004\u0003\u0002CA\u0010\u0011\n\u0007I\u0011\u00013\u0002\u000f!,G\u000e](qi\"9\u00111\u0005%!\u0002\u0013)\u0017\u0001\u00035fYB|\u0005\u000f\u001e\u0011\t\u0011\u0005\u001d\u0002J1A\u0005\u0002\u0011\f\u0001BZ8sG\u0016|\u0005\u000f\u001e\u0005\b\u0003WA\u0005\u0015!\u0003f\u0003%1wN]2f\u001fB$\b\u0005C\u0005\u00020!\u0013\r\u0011\"\u0001\u00022\u00059q\u000e\u001d;j_:\u001cXCAA\u001a!\r\u0019\u0016QG\u0005\u0004\u0003o!&!C(qi&|gnU3u\u0011!\tY\u0004\u0013Q\u0001\n\u0005M\u0012\u0001C8qi&|gn\u001d\u0011\t\u0013\u0005}\u0002J1A\u0005\u0002\u0005\u0005\u0013aB1mY>\u0003Ho]\u000b\u0003\u0003\u0007\u0002b!!\u0012\u0002L\u0005=SBAA$\u0015\r\tIED\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA'\u0003\u000f\u00121aU3ua\u0011\t\t&a\u0017\u0011\u000bM\u000b\u0019&a\u0016\n\u0007\u0005UCK\u0001\u0006PaRLwN\\*qK\u000e\u0004B!!\u0017\u0002\\1\u0001A\u0001DA/\u0003?\n\t\u0011!A\u0003\u0002\u0005\r$aA0%c!A\u0011\u0011\r%!\u0002\u0013\t\u0019%\u0001\u0005bY2|\u0005\u000f^:!#\u0011\t)'a\u001b\u0011\u00075\t9'C\u0002\u0002j9\u0011qAT8uQ&tw\rE\u0002\u000e\u0003[J1!a\u001c\u000f\u0005\r\te.\u001f\u0005\b\u0003gBE\u0011AA;\u0003%\u0019\u0007.Z2l\u0003J<7\u000fF\u0001'\u0011!\t\u0015\b%AA\u0002\u0005e\u0004c\u0001\u0005\u0002|%\u0019\u0011Q\u0010\u0002\u0003\u001d\u0005#W.\u001b8Vi&d\u0017\u000e^5fg\"9\u0011\u0011Q\u0005\u0005\n\u0005\r\u0015A\u00079sKB\u0013xnY3tgN\u001b'/Y7De\u0016$WM\u001c;jC2\u001cHc\u0001\u0014\u0002\u0006\"A\u0011qQA@\u0001\u0004\tI)\u0001\td_:4\u0017nZ:U_\n+\u0017\t\u001a3fIB!\u00111RAI\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006\r\u0011\u0001B;uS2LA!a%\u0002\u000e\nQ\u0001K]8qKJ$\u0018.Z:\t\u000f\u0005]\u0015\u0002\"\u0003\u0002\u001a\u0006qA-Z:de&\u0014WmQ8oM&<G#\u0002\u0014\u0002\u001c\u0006u\u0005BB\u001f\u0002\u0016\u0002\u0007a\b\u0003\u0004F\u0003+\u0003\rA\u0012\u0005\t\u0003CKA\u0011\u0001\u0002\u0002$\u0006)\u0002/\u0019:tK\u000e{gNZ5hgR{')Z!eI\u0016$G\u0003BAE\u0003KCa!RAP\u0001\u00041\u0005\u0002CAU\u0013\u0011\u0005!!a+\u0002/A\f'o]3D_:4\u0017nZ:U_\n+G)\u001a7fi\u0016$G\u0003BAW\u0003g\u0003R!!\u0012\u00020:JA!!-\u0002H\t\u00191+Z9\t\r\u0015\u000b9\u000b1\u0001G\r\u0019\t9,\u0003!\u0002:\n1QI\u001c;jif\u001cr!!.\r\u0003w\u000b\t\rE\u0002\u000e\u0003{K1!a0\u000f\u0005\u001d\u0001&o\u001c3vGR\u00042!DAb\u0013\r\t)M\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u000b_\u0006U&Q3A\u0005\u0002\u0005%W#\u0001\u0018\t\u0013E\f)L!E!\u0002\u0013q\u0003bCAh\u0003k\u0013)\u001a!C\u0001\u0003#\fQb]1oSRL'0\u001a3OC6,WCAAj!\u0011i\u0011Q\u001b\u0018\n\u0007\u0005]gB\u0001\u0004PaRLwN\u001c\u0005\f\u00037\f)L!E!\u0002\u0013\t\u0019.\u0001\btC:LG/\u001b>fI:\u000bW.\u001a\u0011\t\u000fe\t)\f\"\u0001\u0002`R1\u0011\u0011]Ar\u0003K\u00042aRA[\u0011\u0019y\u0017Q\u001ca\u0001]!A\u0011qZAo\u0001\u0004\t\u0019\u000eC\u0005\u0002j\u0006U&\u0019!C\u0001y\u0006QQM\u001c;jif\u0004\u0016\r\u001e5\t\u0011\u00055\u0018Q\u0017Q\u0001\nu\f1\"\u001a8uSRL\b+\u0019;iA!A\u0011\u0011_A[\t\u0003\n\u00190\u0001\u0005u_N#(/\u001b8h)\u0005q\u0003BCA|\u0003k\u000b\t\u0011\"\u0001\u0002z\u0006!1m\u001c9z)\u0019\t\t/a?\u0002~\"Aq.!>\u0011\u0002\u0003\u0007a\u0006\u0003\u0006\u0002P\u0006U\b\u0013!a\u0001\u0003'D!B!\u0001\u00026F\u0005I\u0011\u0001B\u0002\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\u0002+\u00079\u00129a\u000b\u0002\u0003\nA!!1\u0002B\u000b\u001b\t\u0011iA\u0003\u0003\u0003\u0010\tE\u0011!C;oG\",7m[3e\u0015\r\u0011\u0019BD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\f\u0005\u001b\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011Y\"!.\u0012\u0002\u0013\u0005!QD\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yB\u000b\u0003\u0002T\n\u001d\u0001\"\u0003B\u0012\u0003k\u000b\t\u0011\"\u0011}\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\"I!qEA[\u0003\u0003%\t!H\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\u000b\u0005W\t),!A\u0005\u0002\t5\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003W\u0012y\u0003C\u0005\u00032\t%\u0012\u0011!a\u0001=\u0005\u0019\u0001\u0010J\u0019\t\u0015\tU\u0012QWA\u0001\n\u0003\u00129$A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\u0004\u0005\u0004\u0002F\tm\u00121N\u0005\u0005\u0005{\t9E\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\u0011\t%!.\u0002\u0002\u0013\u0005!1I\u0001\tG\u0006tW)];bYR!!Q\tB&!\ri!qI\u0005\u0004\u0005\u0013r!a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0005c\u0011y$!AA\u0002\u0005-\u0004B\u0003B(\u0003k\u000b\t\u0011\"\u0011\u0003R\u0005A\u0001.Y:i\u0007>$W\rF\u0001\u001f\u0011)\u0011)&!.\u0002\u0002\u0013\u0005#qK\u0001\u0007KF,\u0018\r\\:\u0015\t\t\u0015#\u0011\f\u0005\u000b\u0005c\u0011\u0019&!AA\u0002\u0005-t!\u0003B/\u0013\u0005\u0005\t\u0012\u0001B0\u0003\u0019)e\u000e^5usB\u0019qI!\u0019\u0007\u0013\u0005]\u0016\"!A\t\u0002\t\r4C\u0002B1\u0005K\n\t\rE\u0005\u0003h\t5d&a5\u0002b6\u0011!\u0011\u000e\u0006\u0004\u0005Wr\u0011a\u0002:v]RLW.Z\u0005\u0005\u0005_\u0012IGA\tBEN$(/Y2u\rVt7\r^5p]JBq!\u0007B1\t\u0003\u0011\u0019\b\u0006\u0002\u0003`!Q\u0011\u0011\u001fB1\u0003\u0003%)Ea\u001e\u0015\u0003uD!Ba\u001f\u0003b\u0005\u0005I\u0011\u0011B?\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\t\tOa \u0003\u0002\"1qN!\u001fA\u00029B\u0001\"a4\u0003z\u0001\u0007\u00111\u001b\u0005\u000b\u0005\u000b\u0013\t'!A\u0005\u0002\n\u001d\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0013\u0013\t\nE\u0003\u000e\u0003+\u0014Y\t\u0005\u0004\u000e\u0005\u001bs\u00131[\u0005\u0004\u0005\u001fs!A\u0002+va2,'\u0007\u0003\u0006\u0003\u0014\n\r\u0015\u0011!a\u0001\u0003C\f1\u0001\u001f\u00131\u0011)\u00119J!\u0019\u0002\u0002\u0013%!\u0011T\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u001cB\u0019aP!(\n\u0007\t}uP\u0001\u0004PE*,7\r\u001e\u0004\u0007\u0005GK\u0001I!*\u0003\u0019\r{gNZ5h\u000b:$\u0018\u000e^=\u0014\u000f\t\u0005F\"a/\u0002B\"Y!\u0011\u0016BQ\u0005+\u0007I\u0011\u0001BV\u0003\u0011\u0011xn\u001c;\u0016\u0005\u0005\u0005\bb\u0003BX\u0005C\u0013\t\u0012)A\u0005\u0003C\fQA]8pi\u0002B1Ba-\u0003\"\nU\r\u0011\"\u0001\u00036\u0006)1\r[5mIV\u0011!q\u0017\t\u0006\u001b\u0005U\u0017\u0011\u001d\u0005\f\u0005w\u0013\tK!E!\u0002\u0013\u00119,\u0001\u0004dQ&dG\r\t\u0005\b3\t\u0005F\u0011\u0001B`)\u0019\u0011\tMa1\u0003FB\u0019qI!)\t\u0011\t%&Q\u0018a\u0001\u0003CD\u0001Ba-\u0003>\u0002\u0007!q\u0017\u0005\n\u0005\u0013\u0014\tK1A\u0005\u0002q\f\u0011CZ;mYN\u000bg.\u001b;ju\u0016$g*Y7f\u0011!\u0011iM!)!\u0002\u0013i\u0018A\u00054vY2\u001c\u0016M\\5uSj,GMT1nK\u0002B\u0001B!5\u0003\"\u0012\u0005!1[\u0001\u000fO\u0016$\u0018\t\u001c7F]RLG/[3t)\u0011\u0011)Na6\u0011\r\u0005\u0015\u0013q\u0016Ba\u0011\u0019i$q\u001aa\u0001}!A\u0011\u0011\u001fBQ\t\u0003\n\u0019\u0010\u0003\u0006\u0002x\n\u0005\u0016\u0011!C\u0001\u0005;$bA!1\u0003`\n\u0005\bB\u0003BU\u00057\u0004\n\u00111\u0001\u0002b\"Q!1\u0017Bn!\u0003\u0005\rAa.\t\u0015\t\u0005!\u0011UI\u0001\n\u0003\u0011)/\u0006\u0002\u0003h*\"\u0011\u0011\u001dB\u0004\u0011)\u0011YB!)\u0012\u0002\u0013\u0005!1^\u000b\u0003\u0005[TCAa.\u0003\b!I!1\u0005BQ\u0003\u0003%\t\u0005 \u0005\n\u0005O\u0011\t+!A\u0005\u0002uA!Ba\u000b\u0003\"\u0006\u0005I\u0011\u0001B{)\u0011\tYGa>\t\u0013\tE\"1_A\u0001\u0002\u0004q\u0002B\u0003B\u001b\u0005C\u000b\t\u0011\"\u0011\u00038!Q!\u0011\tBQ\u0003\u0003%\tA!@\u0015\t\t\u0015#q \u0005\u000b\u0005c\u0011Y0!AA\u0002\u0005-\u0004B\u0003B(\u0005C\u000b\t\u0011\"\u0011\u0003R!Q!Q\u000bBQ\u0003\u0003%\te!\u0002\u0015\t\t\u00153q\u0001\u0005\u000b\u0005c\u0019\u0019!!AA\u0002\u0005-t!CB\u0006\u0013\u0005\u0005\t\u0012AB\u0007\u00031\u0019uN\u001c4jO\u0016sG/\u001b;z!\r95q\u0002\u0004\n\u0005GK\u0011\u0011!E\u0001\u0007#\u0019baa\u0004\u0004\u0014\u0005\u0005\u0007C\u0003B4\u0005[\n\tOa.\u0003B\"9\u0011da\u0004\u0005\u0002\r]ACAB\u0007\u0011)\t\tpa\u0004\u0002\u0002\u0013\u0015#q\u000f\u0005\u000b\u0005w\u001ay!!A\u0005\u0002\u000euAC\u0002Ba\u0007?\u0019\t\u0003\u0003\u0005\u0003*\u000em\u0001\u0019AAq\u0011!\u0011\u0019la\u0007A\u0002\t]\u0006B\u0003BC\u0007\u001f\t\t\u0011\"!\u0004&Q!1qEB\u0016!\u0015i\u0011Q[B\u0015!\u001di!QRAq\u0005oC!Ba%\u0004$\u0005\u0005\t\u0019\u0001Ba\u0011)\u00119ja\u0004\u0002\u0002\u0013%!\u0011\u0014\u0005\t\u0007cIA\u0011\u0001\u0002\u00044\u0005Y\u0001/\u0019:tK\u0016sG/\u001b;z)\u0011\u0011\tm!\u000e\t\r\u0015\u001by\u00031\u0001G\u0011\u001d\u0019I$\u0003C\u0005\u0007w\t\u0001\u0003]1sg\u0016\fVo\u001c;b\u000b:$\u0018\u000e^=\u0015\t\t\u00057Q\b\u0005\u0007\u000b\u000e]\u0002\u0019\u0001$\t\u0015\r\u0005\u0013\"%A\u0005\u0002\t\u0019\u0019%A\u000bbYR,'oQ8oM&<G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r\u0015#\u0006BA=\u0005\u000f\u0001")
public final class ConfigCommand {
    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.fatal(function0, function02);
    }

    public static Object fatal(Function0<Throwable> function0) {
        return ConfigCommand$.MODULE$.fatal(function0);
    }

    public static void fatal(Function0<String> function0) {
        ConfigCommand$.MODULE$.fatal(function0);
    }

    public static void swallowError(Function0<BoxedUnit> function0) {
        ConfigCommand$.MODULE$.swallowError(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.error(function0, function02);
    }

    public static Object error(Function0<Throwable> function0) {
        return ConfigCommand$.MODULE$.error(function0);
    }

    public static void error(Function0<String> function0) {
        ConfigCommand$.MODULE$.error(function0);
    }

    public static void swallow(Function0<BoxedUnit> function0) {
        ConfigCommand$.MODULE$.swallow(function0);
    }

    public static void swallowWarn(Function0<BoxedUnit> function0) {
        ConfigCommand$.MODULE$.swallowWarn(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.warn(function0, function02);
    }

    public static Object warn(Function0<Throwable> function0) {
        return ConfigCommand$.MODULE$.warn(function0);
    }

    public static void warn(Function0<String> function0) {
        ConfigCommand$.MODULE$.warn(function0);
    }

    public static void swallowInfo(Function0<BoxedUnit> function0) {
        ConfigCommand$.MODULE$.swallowInfo(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.info(function0, function02);
    }

    public static Object info(Function0<Throwable> function0) {
        return ConfigCommand$.MODULE$.info(function0);
    }

    public static void info(Function0<String> function0) {
        ConfigCommand$.MODULE$.info(function0);
    }

    public static void swallowDebug(Function0<BoxedUnit> function0) {
        ConfigCommand$.MODULE$.swallowDebug(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.debug(function0, function02);
    }

    public static Object debug(Function0<Throwable> function0) {
        return ConfigCommand$.MODULE$.debug(function0);
    }

    public static void debug(Function0<String> function0) {
        ConfigCommand$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return ConfigCommand$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return ConfigCommand$.MODULE$.isDebugEnabled();
    }

    public static void swallowTrace(Function0<BoxedUnit> function0) {
        ConfigCommand$.MODULE$.swallowTrace(function0);
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.trace(function0, function02);
    }

    public static Object trace(Function0<Throwable> function0) {
        return ConfigCommand$.MODULE$.trace(function0);
    }

    public static void trace(Function0<String> function0) {
        ConfigCommand$.MODULE$.trace(function0);
    }

    public static String msgWithLogIdent(String string) {
        return ConfigCommand$.MODULE$.msgWithLogIdent(string);
    }

    public static void validateChars(String string, String string2) {
        ConfigCommand$.MODULE$.validateChars(string, string2);
    }

    public static Logger logger() {
        return ConfigCommand$.MODULE$.logger();
    }

    public static String loggerName() {
        return ConfigCommand$.MODULE$.loggerName();
    }

    public static void main(String[] stringArray) {
        ConfigCommand$.MODULE$.main(stringArray);
    }

    public static int DefaultScramIterations() {
        return ConfigCommand$.MODULE$.DefaultScramIterations();
    }

    public static String logIdent() {
        return ConfigCommand$.MODULE$.logIdent();
    }

    public static class ConfigCommandOptions {
        private final OptionParser parser = new OptionParser(false);
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final OptionSpecBuilder alterOpt = this.parser().accepts("alter", "Alter the configuration for the entity.");
        private final OptionSpecBuilder describeOpt = this.parser().accepts("describe", "List configs for the given entity.");
        private final ArgumentAcceptingOptionSpec<String> entityType = this.parser().accepts("entity-type", "Type of entity (topics/clients/users/brokers)").withRequiredArg().ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> entityName = this.parser().accepts("entity-name", "Name of entity (topic name/client id/user principal name/broker id)").withRequiredArg().ofType(String.class);
        private final OptionSpecBuilder entityDefault = this.parser().accepts("entity-default", "Default entity name for clients/users (applies to corresponding entity type in command line)");
        private final String nl = System.getProperty("line.separator");
        private final ArgumentAcceptingOptionSpec<String> addConfig = this.parser().accepts("add-config", "Key Value pairs of configs to add. Square brackets can be used to group values which contain commas: 'k1=v1,k2=[v1,v2,v2],k3=v3'. The following is a list of valid configurations: For entity_type '" + ConfigType$.MODULE$.Topic() + "': " + ((TraversableOnce)LogConfig$.MODULE$.configNames().map((Function1 & Serializable & scala.Serializable)x$7 -> "\t" + x$7, Seq$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl()) + "For entity_type '" + ConfigType$.MODULE$.Broker() + "': " + ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(DynamicConfig$Broker$.MODULE$.names()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> "\t" + x$8, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl()) + "For entity_type '" + ConfigType$.MODULE$.User() + "': " + ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(DynamicConfig$User$.MODULE$.names()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> "\t" + x$9, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl()) + "For entity_type '" + ConfigType$.MODULE$.Client() + "': " + ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(DynamicConfig$Client$.MODULE$.names()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> "\t" + x$10, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl()) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Entity types '", "' and '", "' may be specified together to update config for clients of a specific user."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()}))).withRequiredArg().ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> deleteConfig = this.parser().accepts("delete-config", "config keys to remove 'k1,k2'").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',');
        private final OptionSpecBuilder helpOpt = this.parser().accepts("help", "Print usage information.");
        private final OptionSpecBuilder forceOpt = this.parser().accepts("force", "Suppress console prompts");
        private final OptionSet options;
        private final Set<OptionSpec<?>> allOpts;

        public OptionParser parser() {
            return this.parser;
        }

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public OptionSpecBuilder alterOpt() {
            return this.alterOpt;
        }

        public OptionSpecBuilder describeOpt() {
            return this.describeOpt;
        }

        public ArgumentAcceptingOptionSpec<String> entityType() {
            return this.entityType;
        }

        public ArgumentAcceptingOptionSpec<String> entityName() {
            return this.entityName;
        }

        public OptionSpecBuilder entityDefault() {
            return this.entityDefault;
        }

        public String nl() {
            return this.nl;
        }

        public ArgumentAcceptingOptionSpec<String> addConfig() {
            return this.addConfig;
        }

        public ArgumentAcceptingOptionSpec<String> deleteConfig() {
            return this.deleteConfig;
        }

        public OptionSpecBuilder helpOpt() {
            return this.helpOpt;
        }

        public OptionSpecBuilder forceOpt() {
            return this.forceOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public Set<OptionSpec<?>> allOpts() {
            return this.allOpts;
        }

        public void checkArgs() {
            int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{this.alterOpt(), this.describeOpt()}))).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommandOptions.$anonfun$checkArgs$1(this, x$1)));
            if (actions != 1) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), "Command must include exactly one action: --describe, --alter");
            }
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.zkConnectOpt(), this.entityType()}));
            CommandLineUtils$.MODULE$.checkInvalidArgs(this.parser(), this.options(), (OptionSpec<?>)this.alterOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.describeOpt()}))));
            CommandLineUtils$.MODULE$.checkInvalidArgs(this.parser(), this.options(), (OptionSpec<?>)this.describeOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.alterOpt(), this.addConfig(), this.deleteConfig()}))));
            Buffer entityTypeVals = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.options().valuesOf(this.entityType())).asScala();
            if (this.options().has((OptionSpec)this.alterOpt())) {
                if (entityTypeVals.contains((Object)ConfigType$.MODULE$.User()) || entityTypeVals.contains((Object)ConfigType$.MODULE$.Client())) {
                    if (!this.options().has(this.entityName()) && !this.options().has((OptionSpec)this.entityDefault())) {
                        throw new IllegalArgumentException("--entity-name or --entity-default must be specified with --alter of users/clients");
                    }
                } else if (!this.options().has(this.entityName())) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name must be specified with --alter of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityTypeVals})));
                }
                boolean isAddConfigPresent = this.options().has(this.addConfig());
                boolean isDeleteConfigPresent = this.options().has(this.deleteConfig());
                if (!isAddConfigPresent && !isDeleteConfigPresent) {
                    throw new IllegalArgumentException("At least one of --add-config or --delete-config must be specified with --alter");
                }
            }
            entityTypeVals.foreach((Function1 & Serializable & scala.Serializable)entityTypeVal -> {
                ConfigCommandOptions.$anonfun$checkArgs$2(entityTypeVal);
                return BoxedUnit.UNIT;
            });
            if (entityTypeVals.isEmpty()) {
                throw new IllegalArgumentException("At least one --entity-type must be specified");
            }
            if (entityTypeVals.size() > 1 && !entityTypeVals.toSet().equals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()})))) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only '", "' and '", "' entity types may be specified together"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()})));
            }
        }

        public static final /* synthetic */ boolean $anonfun$checkArgs$1(ConfigCommandOptions $this, OptionSpec x$1) {
            return $this.options().has(x$1);
        }

        public static final /* synthetic */ void $anonfun$checkArgs$2(String entityTypeVal) {
            if (!ConfigType$.MODULE$.all().contains((Object)entityTypeVal)) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid entity-type ", ", --entity-type must be one of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityTypeVal, ConfigType$.MODULE$.all()})));
            }
        }

        public ConfigCommandOptions(String[] args) {
            this.options = this.parser().parse(args);
            this.allOpts = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.alterOpt(), this.describeOpt(), this.entityType(), this.entityName(), this.addConfig(), this.deleteConfig(), this.helpOpt()}));
        }
    }

    public static class ConfigEntity
    implements Product,
    scala.Serializable {
        private final Entity root;
        private final Option<Entity> child;
        private final String fullSanitizedName;

        public Entity root() {
            return this.root;
        }

        public Option<Entity> child() {
            return this.child;
        }

        public String fullSanitizedName() {
            return this.fullSanitizedName;
        }

        public Seq<ConfigEntity> getAllEntities(ZkUtils zkUtils) {
            Option option;
            Option option2;
            Seq seq;
            Option option3;
            Tuple2 tuple2 = new Tuple2(this.root().sanitizedName(), this.child());
            if (tuple2 != null && None$.MODULE$.equals(option3 = (Option)tuple2._1())) {
                Seq seq2;
                Seq rootEntities = (Seq)zkUtils.getAllEntitiesWithConfig(this.root().entityType()).map((Function1 & Serializable & scala.Serializable)name -> new ConfigEntity(new Entity(this.root().entityType(), (Option<String>)new Some(name)), this.child()), Seq$.MODULE$.canBuildFrom());
                Option<Entity> option4 = this.child();
                if (option4 instanceof Some) {
                    Some some = (Some)option4;
                    Entity s = (Entity)some.value();
                    seq2 = (Seq)rootEntities.flatMap((Function1 & Serializable & scala.Serializable)rootEntity -> new ConfigEntity(rootEntity.root(), (Option<Entity>)new Some((Object)new Entity(s.entityType(), (Option<String>)None$.MODULE$))).getAllEntities(zkUtils), Seq$.MODULE$.canBuildFrom());
                } else if (None$.MODULE$.equals(option4)) {
                    seq2 = rootEntities;
                } else {
                    throw new MatchError(option4);
                }
                seq = seq2;
            } else if (tuple2 != null && (option2 = (Option)tuple2._2()) instanceof Some) {
                Seq seq3;
                Some some = (Some)option2;
                Entity childEntity = (Entity)some.value();
                Option<String> option5 = childEntity.sanitizedName();
                if (option5 instanceof Some) {
                    seq3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntity[]{this}));
                } else if (None$.MODULE$.equals(option5)) {
                    seq3 = (Seq)zkUtils.getAllEntitiesWithConfig(this.root().entityPath() + "/" + childEntity.entityType()).map((Function1 & Serializable & scala.Serializable)name -> new ConfigEntity(this.root(), (Option<Entity>)new Some((Object)new Entity(childEntity.entityType(), (Option<String>)new Some(name)))), Seq$.MODULE$.canBuildFrom());
                } else {
                    throw new MatchError(option5);
                }
                seq = seq3;
            } else if (tuple2 != null && None$.MODULE$.equals(option = (Option)tuple2._2())) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntity[]{this}));
            } else {
                throw new MatchError((Object)tuple2);
            }
            return seq;
        }

        public String toString() {
            return this.root().toString() + this.child().map((Function1 & Serializable & scala.Serializable)s -> ", " + s.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        }

        public ConfigEntity copy(Entity root, Option<Entity> child) {
            return new ConfigEntity(root, child);
        }

        public Entity copy$default$1() {
            return this.root();
        }

        public Option<Entity> copy$default$2() {
            return this.child();
        }

        public String productPrefix() {
            return "ConfigEntity";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Option<Entity> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.root();
                    break;
                }
                case 1: {
                    option = this.child();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConfigEntity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConfigEntity)) return false;
            boolean bl = true;
            if (!bl) return false;
            ConfigEntity configEntity = (ConfigEntity)x$1;
            Entity entity = this.root();
            Entity entity2 = configEntity.root();
            if (entity == null) {
                if (entity2 != null) {
                    return false;
                }
            } else if (!((Object)entity).equals(entity2)) return false;
            Option<Entity> option = this.child();
            Option<Entity> option2 = configEntity.child();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!configEntity.canEqual(this)) return false;
            return true;
        }

        public ConfigEntity(Entity root, Option<Entity> child) {
            this.root = root;
            this.child = child;
            Product.$init$((Product)this);
            this.fullSanitizedName = (String)root.sanitizedName().getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + child.map((Function1 & Serializable & scala.Serializable)s -> "/" + s.entityPath()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        }
    }

    public static class Entity
    implements Product,
    scala.Serializable {
        private final String entityType;
        private final Option<String> sanitizedName;
        private final String entityPath;

        public String entityType() {
            return this.entityType;
        }

        public Option<String> sanitizedName() {
            return this.sanitizedName;
        }

        public String entityPath() {
            return this.entityPath;
        }

        /*
         * Unable to fully structure code
         */
        public String toString() {
            block9: {
                block10: {
                    block8: {
                        var4_1 = this.entityType();
                        v0 = ConfigType$.MODULE$.User();
                        var5_2 = var4_1;
                        if (!(v0 != null ? v0.equals(var5_2) == false : var5_2 != null)) {
                            var2_3 = "user-principal";
                        } else {
                            v1 = ConfigType$.MODULE$.Client();
                            var6_4 = var4_1;
                            if (!(v1 != null ? v1.equals(var6_4) == false : var6_4 != null)) {
                                var2_3 = "client-id";
                            } else {
                                v2 = ConfigType$.MODULE$.Topic();
                                var7_5 = var4_1;
                                var2_3 = !(v2 != null ? v2.equals(var7_5) == false : var7_5 != null) ? "topic" : var4_1;
                            }
                        }
                        typeName = var2_3;
                        var8_7 = false;
                        var9_8 = null;
                        var10_9 = this.sanitizedName();
                        if (!(var10_9 instanceof Some)) break block8;
                        var8_7 = true;
                        var9_8 = (Some)var10_9;
                        var11_10 = (String)var9_8.value();
                        v3 = ConfigEntityName$.MODULE$.Default();
                        var12_11 = var11_10;
                        if (v3 != null ? v3.equals(var12_11) == false : var12_11 != null) break block8;
                        var1_12 = "default " + typeName;
                        break block9;
                    }
                    if (!var8_7) break block10;
                    n = (String)var9_8.value();
                    v4 = this.entityType();
                    var15_14 = ConfigType$.MODULE$.User();
                    if (!(v4 == null ? var15_14 != null : v4.equals(var15_14) == false)) ** GOTO lbl-1000
                    v5 = this.entityType();
                    var16_15 = ConfigType$.MODULE$.Client();
                    if (!(v5 != null ? v5.equals(var16_15) == false : var16_15 != null)) lbl-1000:
                    // 2 sources

                    {
                        v6 = Sanitizer.desanitize((String)n);
                    } else {
                        v6 = n;
                    }
                    desanitized = v6;
                    var1_12 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName, desanitized}));
                    break block9;
                }
                if (None$.MODULE$.equals(var10_9)) {
                    var1_12 = this.entityType();
                } else {
                    throw new MatchError(var10_9);
                }
            }
            return var1_12;
        }

        public Entity copy(String entityType, Option<String> sanitizedName) {
            return new Entity(entityType, sanitizedName);
        }

        public String copy$default$1() {
            return this.entityType();
        }

        public Option<String> copy$default$2() {
            return this.sanitizedName();
        }

        public String productPrefix() {
            return "Entity";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Option<String> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.entityType();
                    break;
                }
                case 1: {
                    option = this.sanitizedName();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Entity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Entity)) return false;
            boolean bl = true;
            if (!bl) return false;
            Entity entity = (Entity)x$1;
            String string = this.entityType();
            String string2 = entity.entityType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.sanitizedName();
            Option<String> option2 = entity.sanitizedName();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!entity.canEqual(this)) return false;
            return true;
        }

        public Entity(String entityType, Option<String> sanitizedName) {
            String string;
            this.entityType = entityType;
            this.sanitizedName = sanitizedName;
            Product.$init$((Product)this);
            Option<String> option = sanitizedName;
            if (option instanceof Some) {
                Some some = (Some)option;
                String n = (String)some.value();
                string = entityType + "/" + n;
            } else if (None$.MODULE$.equals(option)) {
                string = entityType;
            } else {
                throw new MatchError(option);
            }
            this.entityPath = string;
        }
    }
}

