/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionStateInfo;
import kafka.server.AdminManager;
import kafka.server.CreateTopicMetadata;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u000f\t\u0019B)\u001a7bs\u0016$7I]3bi\u0016$v\u000e]5dg*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IA\u0004\u000b\u0002\u000f\u0011,G.Y=NgB\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t!Aj\u001c8h\u0013\ti!\u0002\u0003\u0005\u0017\u0001\t\u0005\t\u0015!\u0003\u0018\u00039\u0019'/Z1uK6+G/\u00193bi\u0006\u00042\u0001G\u000e\u001e\u001b\u0005I\"B\u0001\u000e\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00039e\u00111aU3r!\tIa$\u0003\u0002 \u0005\t\u00192I]3bi\u0016$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\u0007bI6Lg.T1oC\u001e,'\u000f\u0005\u0002\nG%\u0011AE\u0001\u0002\r\u0003\u0012l\u0017N\\'b]\u0006<WM\u001d\u0005\tM\u0001\u0011\t\u0011)A\u0005O\u0005\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\u0005\u001f!RS)\u0003\u0002*!\tIa)\u001e8di&|g.\r\t\u00051-j\u0003(\u0003\u0002-3\t\u0019Q*\u00199\u0011\u00059*dBA\u00184!\t\u0001\u0004#D\u00012\u0015\t\u0011d!\u0001\u0004=e>|GOP\u0005\u0003iA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011A\u0007\u0005\t\u0003s\rk\u0011A\u000f\u0006\u0003wq\n\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003{y\naaY8n[>t'BA\u0003@\u0015\t\u0001\u0015)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011S$\u0001C!qS\u0016\u0013(o\u001c:\u0011\u0005=1\u0015BA$\u0011\u0005\u0011)f.\u001b;\t\u000b%\u0003A\u0011\u0001&\u0002\rqJg.\u001b;?)\u0015YE*\u0014(P!\tI\u0001\u0001C\u0003\u000e\u0011\u0002\u0007a\u0002C\u0003\u0017\u0011\u0002\u0007q\u0003C\u0003\"\u0011\u0002\u0007!\u0005C\u0003'\u0011\u0002\u0007q\u0005C\u0003R\u0001\u0011\u0005#+A\u0006uef\u001cu.\u001c9mKR,G#A*\u0011\u0005=!\u0016BA+\u0011\u0005\u001d\u0011un\u001c7fC:DQa\u0016\u0001\u0005Ba\u000b!b\u001c8D_6\u0004H.\u001a;f)\u0005)\u0005\"\u0002.\u0001\t\u0003B\u0016\u0001D8o\u000bb\u0004\u0018N]1uS>t\u0007\"\u0002/\u0001\t\u0013i\u0016AE7jgNLgn\u001a'fC\u0012,'oQ8v]R$2AX1d!\tyq,\u0003\u0002a!\t\u0019\u0011J\u001c;\t\u000b\t\\\u0006\u0019A\u0017\u0002\u000bQ|\u0007/[2\t\u000b\u0011\\\u0006\u0019A3\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0002\u0019MzK!aZ\r\u0003\u0007M+G\u000fC\u0003j\u0001\u0011%!.A\bjg6K7o]5oO2+\u0017\rZ3s)\r\u00196\u000e\u001c\u0005\u0006E\"\u0004\r!\f\u0005\u0006[\"\u0004\rAX\u0001\na\u0006\u0014H/\u001b;j_:\u0004")
public class DelayedCreateTopics
extends DelayedOperation {
    private final Seq<CreateTopicMetadata> createMetadata;
    private final AdminManager adminManager;
    private final Function1<Map<String, ApiError>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        boolean bl;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to complete operation for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.createMetadata})));
        int leaderlessPartitionCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.createMetadata.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedCreateTopics.$anonfun$tryComplete$2(x$1)))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)DelayedCreateTopics.$anonfun$tryComplete$3(this, BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
        if (leaderlessPartitionCount == 0) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "All partitions have a leader, completing the delayed operation");
            bl = this.forceComplete();
        } else {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " partitions do not have a leader, not completing the delayed operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderlessPartitionCount)})));
            bl = false;
        }
        return bl;
    }

    @Override
    public void onComplete() {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completing operation for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.createMetadata})));
        scala.collection.immutable.Map results = ((TraversableOnce)this.createMetadata.map((Function1 & Serializable & scala.Serializable)metadata -> metadata.error().isSuccess() && this.missingLeaderCount(metadata.topic(), (Set<Object>)metadata.replicaAssignments().keySet()) > 0 ? new Tuple2((Object)metadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)metadata.topic(), (Object)metadata.error()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.responseCallback.apply((Object)results);
    }

    @Override
    public void onExpiration() {
    }

    private int missingLeaderCount(String topic, Set<Object> partitions) {
        return BoxesRunTime.unboxToInt((Object)partitions.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$2, x1$2);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int counter = sp2._1$mcI$sp();
            int partition = sp2._2$mcI$sp();
            int n = this.isMissingLeader(topic, partition) ? counter + 1 : counter;
            return n;
        }));
    }

    private boolean isMissingLeader(String topic, int partition) {
        Option<PartitionStateInfo> partitionInfo = this.adminManager.metadataCache().getPartitionInfo(topic, partition);
        return partitionInfo.isEmpty() || ((PartitionStateInfo)partitionInfo.get()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == LeaderAndIsr$.MODULE$.NoLeader();
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$2(CreateTopicMetadata x$1) {
        return x$1.error().isSuccess();
    }

    public static final /* synthetic */ int $anonfun$tryComplete$3(DelayedCreateTopics $this, int x0$1, CreateTopicMetadata x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int topicCounter = tuple2._1$mcI$sp();
        CreateTopicMetadata metadata = (CreateTopicMetadata)tuple2._2();
        int n = topicCounter + $this.missingLeaderCount(metadata.topic(), (Set<Object>)metadata.replicaAssignments().keySet());
        return n;
    }

    public DelayedCreateTopics(long delayMs, Seq<CreateTopicMetadata> createMetadata, AdminManager adminManager, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        this.createMetadata = createMetadata;
        this.adminManager = adminManager;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

