/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientSensors;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaEntity;
import kafka.server.QuotaId;
import kafka.server.QuotaId$;
import kafka.server.QuotaType;
import kafka.server.QuotaTypes$;
import kafka.server.SensorAccess;
import kafka.server.ThrottledResponse;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichLong$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u001de\u0001B\u0001\u0003\u0001\u001d\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\nY\taaY8oM&<W#A\f\u0011\u0005aIR\"\u0001\u0002\n\u0005i\u0011!\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\"AA\u0004\u0001B\u0001B\u0003%q#A\u0004d_:4\u0017n\u001a\u0011\t\u0011y\u0001!Q1A\u0005\n}\tq!\\3ue&\u001c7/F\u0001!!\t\t#&D\u0001#\u0015\tq2E\u0003\u0002%K\u000511m\\7n_:T!!\u0002\u0014\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0005\u0003W\t\u0012q!T3ue&\u001c7\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003!\u0003!iW\r\u001e:jGN\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0002\u0019\u0002\u0013E,x\u000e^1UsB,W#A\u0019\u0011\u0005a\u0011\u0014BA\u001a\u0003\u0005%\tVo\u001c;b)f\u0004X\r\u0003\u00056\u0001\t\u0005\t\u0015!\u00032\u0003)\tXo\u001c;b)f\u0004X\r\t\u0005\to\u0001\u0011)\u0019!C\u0005q\u0005!A/[7f+\u0005I\u0004C\u0001\u001e=\u001b\u0005Y$BA\t$\u0013\ti4H\u0001\u0003US6,\u0007\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u000bQLW.\u001a\u0011\t\u000b\u0005\u0003A\u0011\u0001\"\u0002\rqJg.\u001b;?)\u0015\u0019E)\u0012$H!\tA\u0002\u0001C\u0003\u0016\u0001\u0002\u0007q\u0003C\u0003\u001f\u0001\u0002\u0007\u0001\u0005C\u00030\u0001\u0002\u0007\u0011\u0007C\u00038\u0001\u0002\u0007\u0011\bC\u0004J\u0001\t\u0007I\u0011\u0002&\u0002\u001f=4XM\u001d:jI\u0012,g.U;pi\u0006,\u0012a\u0013\t\u0005\u0019N+\u0006,D\u0001N\u0015\tqu*\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001U)\u0002\tU$\u0018\u000e\u001c\u0006\u0002%\u0006!!.\u0019<b\u0013\t!VJA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"\u0001\u0007,\n\u0005]\u0013!aB)v_R\f\u0017\n\u001a\t\u0003CeK!A\u0017\u0012\u0003\u000bE+x\u000e^1\t\rq\u0003\u0001\u0015!\u0003L\u0003Ayg/\u001a:sS\u0012$WM\\)v_R\f\u0007\u0005C\u0004_\u0001\t\u0007I\u0011B0\u00023M$\u0018\r^5d\u0007>tg-[4DY&,g\u000e^%e#V|G/Y\u000b\u00021\"1\u0011\r\u0001Q\u0001\na\u000b!d\u001d;bi&\u001c7i\u001c8gS\u001e\u001cE.[3oi&#\u0017+^8uC\u0002Bqa\u0019\u0001A\u0002\u0013%A-A\trk>$\u0018\rV=qKN,e.\u00192mK\u0012,\u0012!\u001a\t\u0003\u0013\u0019L!a\u001a\u0006\u0003\u0007%sG\u000fC\u0004j\u0001\u0001\u0007I\u0011\u00026\u0002+E,x\u000e^1UsB,7/\u00128bE2,Gm\u0018\u0013fcR\u00111N\u001c\t\u0003\u00131L!!\u001c\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b_\"\f\t\u00111\u0001f\u0003\rAH%\r\u0005\u0007c\u0002\u0001\u000b\u0015B3\u0002%E,x\u000e^1UsB,7/\u00128bE2,G\r\t\u0005\bg\u0002\u0011\r\u0011\"\u0003u\u0003\u0011awnY6\u0016\u0003U\u0004\"A^=\u000e\u0003]T!\u0001_'\u0002\u000b1|7m[:\n\u0005i<(A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\t\rq\u0004\u0001\u0015!\u0003v\u0003\u0015awnY6!\u0011\u001dq\bA1A\u0005\n}\f!\u0002Z3mCf\fV/Z;f+\t\t\t\u0001E\u0003M\u0003\u0007\t9!C\u0002\u0002\u00065\u0013!\u0002R3mCf\fV/Z;f!\rA\u0012\u0011B\u0005\u0004\u0003\u0017\u0011!!\u0005+ie>$H\u000f\\3e%\u0016\u001c\bo\u001c8tK\"A\u0011q\u0002\u0001!\u0002\u0013\t\t!A\u0006eK2\f\u00170U;fk\u0016\u0004\u0003\"CA\n\u0001\t\u0007I\u0011BA\u000b\u00039\u0019XM\\:pe\u0006\u001b7-Z:t_J,\"!a\u0006\u0011\u0007a\tI\"C\u0002\u0002\u001c\t\u0011AbU3og>\u0014\u0018iY2fgND\u0001\"a\b\u0001A\u0003%\u0011qC\u0001\u0010g\u0016t7o\u001c:BG\u000e,7o]8sA!I\u00111\u0005\u0001C\u0002\u0013\u0005\u0011QE\u0001\u0017i\"\u0014x\u000e\u001e;mK\u0012\u0014V-];fgR\u0014V-\u00199feV\u0011\u0011q\u0005\t\u0005\u0003S\tY#D\u0001\u0001\r\u0019\ti\u0003\u0001\u0001\u00020\t1B\u000b\u001b:piRdW\r\u001a*fcV,7\u000f\u001e*fCB,'o\u0005\u0003\u0002,\u0005E\u0002cA\b\u00024%\u0019\u0011Q\u0007\t\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\u000b}\u0006-\"\u0011!Q\u0001\n\u0005\u0005\u0001bB!\u0002,\u0011\u0005\u00111\b\u000b\u0005\u0003O\ti\u0004C\u0004\u007f\u0003s\u0001\r!!\u0001\t\u0011\u0005\u0005\u00131\u0006C!\u0003\u0007\na\u0001Z8X_J\\G#A6\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003O\tq\u0003\u001e5s_R$H.\u001a3SKF,Xm\u001d;SK\u0006\u0004XM\u001d\u0011\t\u0013\u0005-\u0003A1A\u0005\n\u00055\u0013\u0001\u00053fY\u0006L\u0018+^3vKN+gn]8s+\t\ty\u0005E\u0002\"\u0003#J1!a\u0015#\u0005\u0019\u0019VM\\:pe\"A\u0011q\u000b\u0001!\u0002\u0013\ty%A\teK2\f\u00170U;fk\u0016\u001cVM\\:pe\u0002Bq!a\u0017\u0001\t\u0013\t\u0019%A\u0003ti\u0006\u0014H\u000fC\u0004\u0002`\u0001!\t!!\u0019\u0002-I,7m\u001c:e\u0003:$W*Y=cKRC'o\u001c;uY\u0016$\u0012\"ZA2\u0003{\n\t)a#\t\u0011\u0005\u0015\u0014Q\fa\u0001\u0003O\nQb]1oSRL'0\u001a3Vg\u0016\u0014\b\u0003BA5\u0003orA!a\u001b\u0002tA\u0019\u0011Q\u000e\u0006\u000e\u0005\u0005=$bAA9\r\u00051AH]8pizJ1!!\u001e\u000b\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011PA>\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u000f\u0006\t\u0011\u0005}\u0014Q\fa\u0001\u0003O\n\u0001b\u00197jK:$\u0018\n\u001a\u0005\t\u0003\u0007\u000bi\u00061\u0001\u0002\u0006\u0006)a/\u00197vKB\u0019\u0011\"a\"\n\u0007\u0005%%B\u0001\u0004E_V\u0014G.\u001a\u0005\t\u0003\u001b\u000bi\u00061\u0001\u0002\u0010\u0006A1-\u00197mE\u0006\u001c7\u000eE\u0003\n\u0003#+7.C\u0002\u0002\u0014*\u0011\u0011BR;oGRLwN\\\u0019\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\u0006\t#/Z2pe\u0012\fe\u000e\u001a+ie>$H\u000f\\3P]F+x\u000e^1WS>d\u0017\r^5p]R9Q-a'\u0002&\u0006\u001d\u0006\u0002CAO\u0003+\u0003\r!a(\u0002\u001b\rd\u0017.\u001a8u'\u0016t7o\u001c:t!\rA\u0012\u0011U\u0005\u0004\u0003G\u0013!!D\"mS\u0016tGoU3og>\u00148\u000f\u0003\u0005\u0002\u0004\u0006U\u0005\u0019AAC\u0011!\ti)!&A\u0002\u0005=\u0005bBAV\u0001\u0011\u0005\u0011QV\u0001\u0011e\u0016\u001cwN\u001d3O_RC'o\u001c;uY\u0016$Ra[AX\u0003cC\u0001\"!(\u0002*\u0002\u0007\u0011q\u0014\u0005\t\u0003\u0007\u000bI\u000b1\u0001\u0002\u0006\"9\u0011Q\u0017\u0001\u0005\n\u0005]\u0016aC9v_R\fWI\u001c;jif$b!!/\u0002@\u0006\u0005\u0007c\u0001\r\u0002<&\u0019\u0011Q\u0018\u0002\u0003\u0017E+x\u000e^1F]RLG/\u001f\u0005\t\u0003K\n\u0019\f1\u0001\u0002h!A\u0011qPAZ\u0001\u0004\t9\u0007C\u0004\u0002F\u0002!I!a2\u0002EE,x\u000e^1F]RLG/_,ji\"lU\u000f\u001c;ja2,\u0017+^8uC2+g/\u001a7t)\u0019\tI,!3\u0002L\"A\u0011QMAb\u0001\u0004\t9\u0007\u0003\u0005\u0002\u0000\u0005\r\u0007\u0019AA4\u0011\u001d\ty\r\u0001C\u0001\u0003#\fQ!];pi\u0006$R\u0001WAj\u0003/D\u0001\"!6\u0002N\u0002\u0007\u0011qM\u0001\u0005kN,'\u000f\u0003\u0005\u0002\u0000\u00055\u0007\u0019AA4\u0011\u001d\tY\u000e\u0001C\t\u0003;\fA\u0002\u001e5s_R$H.\u001a+j[\u0016$b!a8\u0002f\u0006=\bcA\u0005\u0002b&\u0019\u00111\u001d\u0006\u0003\t1{gn\u001a\u0005\t\u0003O\fI\u000e1\u0001\u0002j\u0006a1\r\\5f]RlU\r\u001e:jGB\u0019\u0011%a;\n\u0007\u00055(EA\u0006LC\u001a\\\u0017-T3ue&\u001c\u0007bB\u000b\u0002Z\u0002\u0007\u0011\u0011\u001f\t\u0004C\u0005M\u0018bAA{E\taQ*\u001a;sS\u000e\u001cuN\u001c4jO\"9\u0011\u0011 \u0001\u0005\n\u0005m\u0018\u0001E7fCN,(/\u00192mK\u0006\u001b(+\u0019;f)\u0019\tiP!\u0003\u0003\u0016A!\u0011q B\u0003\u001b\t\u0011\tAC\u0002\u0003\u0004\t\nQa\u001d;biNLAAa\u0002\u0003\u0002\t!!+\u0019;f\u0011!\u0011Y!a>A\u0002\t5\u0011\u0001\u00028b[\u0016\u0004BAa\u0004\u0003\u00125\t1%C\u0002\u0003\u0014\r\u0012!\"T3ue&\u001cg*Y7f\u0011!\u00119\"a>A\u0002\te\u0011AC7fCN,(/\u00192mKB\u0019\u0011Ea\u0007\n\u0007\tu!E\u0001\u0006NK\u0006\u001cXO]1cY\u0016DqA!\t\u0001\t\u0003\u0011\u0019#A\fhKR|%o\u0011:fCR,\u0017+^8uCN+gn]8sgR1\u0011q\u0014B\u0013\u0005OA\u0001\"!\u001a\u0003 \u0001\u0007\u0011q\r\u0005\t\u0003\u007f\u0012y\u00021\u0001\u0002h!9!1\u0006\u0001\u0005\n\t5\u0012AD7fCN,(/\u00192mKN#\u0018\r^\u000b\u0003\u0005_\u00012!\tB\u0019\u0013\r\u0011\u0019D\t\u0002\u000f\u001b\u0016\f7/\u001e:bE2,7\u000b^1u\u0011\u001d\u00119\u0004\u0001C\u0005\u0005s\t\u0011dZ3u)\"\u0014x\u000e\u001e;mKRKW.Z*f]N|'OT1nKR!\u0011q\rB\u001e\u0011\u001d\u0011iD!\u000eA\u0002U\u000bq!];pi\u0006LE\rC\u0004\u0003B\u0001!IAa\u0011\u0002%\u001d,G/U;pi\u0006\u001cVM\\:pe:\u000bW.\u001a\u000b\u0005\u0003O\u0012)\u0005C\u0004\u0003>\t}\u0002\u0019A+\t\u000f\t%\u0003\u0001\"\u0005\u0003L\u0005!r-\u001a;Rk>$\u0018-T3ue&\u001c7i\u001c8gS\u001e$B!!=\u0003N!9\u0011q\u001aB$\u0001\u0004A\u0006b\u0002B)\u0001\u0011E!1K\u0001\rGJ,\u0017\r^3TK:\u001cxN\u001d\u000b\u0007\u0003\u001f\u0012)F!\u0017\t\u0011\t]#q\na\u0001\u0003O\n!b]3og>\u0014h*Y7f\u0011!\u0011YFa\u0014A\u0002\t5\u0011AC7fiJL7MT1nK\"9!q\f\u0001\u0005\u0002\t\u0005\u0014aC;qI\u0006$X-U;pi\u0006$ra\u001bB2\u0005W\u0012i\u0007\u0003\u0005\u0002f\tu\u0003\u0019\u0001B3!\u0015I!qMA4\u0013\r\u0011IG\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005}$Q\fa\u0001\u0005KB\u0001\"a4\u0003^\u0001\u0007!q\u000e\t\u0005\u0013\t\u001d\u0004\fC\u0004\u0003t\u0001!\tB!\u001e\u0002)\rd\u0017.\u001a8u%\u0006$X-T3ue&\u001cg*Y7f)\u0019\u0011iAa\u001e\u0003z!A\u0011Q\rB9\u0001\u0004\t9\u0007\u0003\u0005\u0002\u0000\tE\u0004\u0019AA4\u0011\u001d\u0011i\b\u0001C\u0005\u0005\u007f\n!\u0003\u001e5s_R$H.Z'fiJL7MT1nKR!!Q\u0002BA\u0011!\t)La\u001fA\u0002\u0005e\u0006b\u0002BC\u0001\u0011\u0005\u00111I\u0001\tg\",H\u000fZ8x]\u0002")
public class ClientQuotaManager
implements Logging {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType kafka$server$ClientQuotaManager$$quotaType;
    private final Time time;
    private final ConcurrentHashMap<QuotaId, Quota> overriddenQuota;
    private final Quota staticConfigClientIdQuota;
    private int quotaTypesEnabled;
    private final ReentrantReadWriteLock lock;
    private final DelayQueue<ThrottledResponse> delayQueue;
    private final SensorAccess sensorAccessor;
    private final ThrottledRequestReaper throttledRequestReaper;
    private final Sensor kafka$server$ClientQuotaManager$$delayQueueSensor;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ClientQuotaManager clientQuotaManager = this;
        synchronized (clientQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public QuotaType kafka$server$ClientQuotaManager$$quotaType() {
        return this.kafka$server$ClientQuotaManager$$quotaType;
    }

    private Time time() {
        return this.time;
    }

    private ConcurrentHashMap<QuotaId, Quota> overriddenQuota() {
        return this.overriddenQuota;
    }

    private Quota staticConfigClientIdQuota() {
        return this.staticConfigClientIdQuota;
    }

    private int quotaTypesEnabled() {
        return this.quotaTypesEnabled;
    }

    private void quotaTypesEnabled_$eq(int x$1) {
        this.quotaTypesEnabled = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private DelayQueue<ThrottledResponse> delayQueue() {
        return this.delayQueue;
    }

    private SensorAccess sensorAccessor() {
        return this.sensorAccessor;
    }

    public ThrottledRequestReaper throttledRequestReaper() {
        return this.throttledRequestReaper;
    }

    public Sensor kafka$server$ClientQuotaManager$$delayQueueSensor() {
        return this.kafka$server$ClientQuotaManager$$delayQueueSensor;
    }

    private void start() {
        this.throttledRequestReaper().start();
    }

    public int recordAndMaybeThrottle(String sanitizedUser, String clientId, double value, Function1<Object, BoxedUnit> callback) {
        ClientSensors clientSensors = this.getOrCreateQuotaSensors(sanitizedUser, clientId);
        return this.recordAndThrottleOnQuotaViolation(clientSensors, value, callback);
    }

    public int recordAndThrottleOnQuotaViolation(ClientSensors clientSensors, double value, Function1<Object, BoxedUnit> callback) {
        int throttleTimeMs = 0;
        try {
            clientSensors.quotaSensor().record(value);
            callback.apply$mcVI$sp(0);
        }
        catch (QuotaViolationException quotaViolationException) {
            QuotaEntity clientQuotaEntity = clientSensors.quotaEntity();
            KafkaMetric clientMetric = (KafkaMetric)this.metrics().metrics().get(this.clientRateMetricName(clientQuotaEntity.sanitizedUser(), clientQuotaEntity.clientId()));
            throttleTimeMs = (int)RichLong$.MODULE$.round$extension(Predef$.MODULE$.longWrapper(this.throttleTime(clientMetric, this.getQuotaMetricConfig(clientQuotaEntity.quota()))));
            clientSensors.throttleTimeSensor().record((double)throttleTimeMs);
            this.delayQueue().add(new ThrottledResponse(this.time(), throttleTimeMs, callback));
            this.kafka$server$ClientQuotaManager$$delayQueueSensor().record();
            this.logger().debug((Object)new StringOps(Predef$.MODULE$.augmentString("Quota violated for sensor (%s). Delay time: (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientSensors.quotaSensor().name(), BoxesRunTime.boxToInteger((int)throttleTimeMs)})));
        }
        return throttleTimeMs;
    }

    public void recordNoThrottle(ClientSensors clientSensors, double value) {
        clientSensors.quotaSensor().record(value, this.time().milliseconds(), false);
    }

    private QuotaEntity quotaEntity(String sanitizedUser, String clientId) {
        QuotaEntity quotaEntity;
        int n = this.quotaTypesEnabled();
        boolean bl = QuotaTypes$.MODULE$.NoQuotas() == n ? true : QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == n;
        if (bl) {
            QuotaId quotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultClientIdQuotaId())) == null) {
                quota = this.staticConfigClientIdQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, "", clientId, quota);
        } else if (QuotaTypes$.MODULE$.UserQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$);
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, "", quota);
        } else if (QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default())))) == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId)))) == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserClientIdQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, clientId, quota);
        } else {
            quotaEntity = this.quotaEntityWithMultipleQuotaLevels(sanitizedUser, clientId);
        }
        return quotaEntity;
    }

    private QuotaEntity quotaEntityWithMultipleQuotaLevels(String sanitizedUser, String clientId) {
        QuotaId userClientQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId));
        QuotaId userQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$);
        QuotaId clientQuotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
        QuotaId quotaId = userClientQuotaId;
        QuotaId quotaConfigId = userClientQuotaId;
        Quota quota = this.overriddenQuota().get(quotaConfigId);
        if (quota == null) {
            quotaId = userClientQuotaId;
            quotaConfigId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
            quota = this.overriddenQuota().get(quotaConfigId);
            if (quota == null) {
                quotaConfigId = quotaId = userQuotaId;
                quota = this.overriddenQuota().get(quotaConfigId);
                if (quota == null) {
                    quotaId = userClientQuotaId;
                    quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId));
                    quota = this.overriddenQuota().get(quotaConfigId);
                    if (quota == null) {
                        quotaId = userClientQuotaId;
                        quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                        quota = this.overriddenQuota().get(quotaConfigId);
                        if (quota == null) {
                            quotaId = userQuotaId;
                            quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
                            quota = this.overriddenQuota().get(quotaConfigId);
                            if (quota == null) {
                                quotaId = clientQuotaId;
                                quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
                                quota = this.overriddenQuota().get(quotaConfigId);
                                if (quota == null) {
                                    quotaId = clientQuotaId;
                                    quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                                    quota = this.overriddenQuota().get(quotaConfigId);
                                    if (quota == null) {
                                        quotaId = clientQuotaId;
                                        quotaConfigId = null;
                                        quota = this.staticConfigClientIdQuota();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        QuotaId quotaId2 = quotaId;
        QuotaId quotaId3 = clientQuotaId;
        String quotaUser = !(quotaId2 != null ? !((Object)quotaId2).equals(quotaId3) : quotaId3 != null) ? "" : sanitizedUser;
        QuotaId quotaId4 = quotaId;
        QuotaId quotaId5 = userQuotaId;
        String quotaClientId = !(quotaId4 != null ? !((Object)quotaId4).equals(quotaId5) : quotaId5 != null) ? "" : clientId;
        return new QuotaEntity(quotaId, quotaUser, quotaClientId, quota);
    }

    public Quota quota(String user, String clientId) {
        return this.quotaEntity(QuotaId$.MODULE$.sanitize(user), clientId).quota();
    }

    public long throttleTime(KafkaMetric clientMetric, MetricConfig config) {
        Rate rateMetric = this.measurableAsRate(clientMetric.metricName(), clientMetric.measurable());
        Quota quota = config.quota();
        double difference = clientMetric.value() - quota.bound();
        double throttleTimeMs = difference / quota.bound() * (double)rateMetric.windowSize(config, this.time().milliseconds());
        return RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(throttleTimeMs));
    }

    private Rate measurableAsRate(MetricName name, Measurable measurable) {
        Rate rate;
        Measurable measurable2 = measurable;
        if (!(measurable2 instanceof Rate)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metric ", " is not a Rate metric, value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, measurable})));
        }
        Rate rate2 = rate = (Rate)measurable2;
        return rate2;
    }

    public ClientSensors getOrCreateQuotaSensors(String sanitizedUser, String clientId) {
        QuotaEntity clientQuotaEntity = this.quotaEntity(sanitizedUser, clientId);
        return new ClientSensors(clientQuotaEntity, this.sensorAccessor().getOrCreate(this.getQuotaSensorName(clientQuotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.metrics(), (Function0<MetricName>)(Function0 & Serializable & scala.Serializable)() -> this.clientRateMetricName(clientQuotaEntity.sanitizedUser(), clientQuotaEntity.clientId()), (Function0<MetricConfig>)(Function0 & Serializable & scala.Serializable)() -> this.getQuotaMetricConfig(clientQuotaEntity.quota()), (Function0<MeasurableStat>)(Function0 & Serializable & scala.Serializable)() -> this.measurableStat()), this.sensorAccessor().getOrCreate(this.getThrottleTimeSensorName(clientQuotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.metrics(), (Function0<MetricName>)(Function0 & Serializable & scala.Serializable)() -> this.throttleMetricName(clientQuotaEntity), (Function0<MetricConfig>)(Function0 & Serializable & scala.Serializable)() -> null, (Function0<MeasurableStat>)(Function0 & Serializable & scala.Serializable)() -> new Avg()));
    }

    private MeasurableStat measurableStat() {
        return new Rate();
    }

    private String getThrottleTimeSensorName(QuotaId quotaId) {
        return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$quotaType()), "ThrottleTime-") + quotaId.sanitizedUser().getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + ':' + quotaId.clientId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    private String getQuotaSensorName(QuotaId quotaId) {
        return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$quotaType()), "-") + quotaId.sanitizedUser().getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + ':' + quotaId.clientId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    public Sensor createSensor(String sensorName, MetricName metricName) {
        return this.sensorAccessor().getOrCreate(sensorName, ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.metrics(), (Function0<MetricName>)(Function0 & Serializable & scala.Serializable)() -> metricName, (Function0<MetricConfig>)(Function0 & Serializable & scala.Serializable)() -> null, (Function0<MeasurableStat>)(Function0 & Serializable & scala.Serializable)() -> this.measurableStat());
    }

    /*
     * Unable to fully structure code
     */
    public void updateQuota(Option<String> sanitizedUser, Option<String> clientId, Option<Quota> quota) {
        this.lock().writeLock().lock();
        try {
            block28: {
                block23: {
                    block25: {
                        block27: {
                            block26: {
                                block24: {
                                    quotaId = new QuotaId(sanitizedUser, clientId);
                                    var12_5 = false;
                                    var13_6 = null;
                                    var14_7 = sanitizedUser;
                                    if (!(var14_7 instanceof Some)) ** GOTO lbl-1000
                                    var12_5 = true;
                                    var13_6 = (Some)var14_7;
                                    var15_8 = (String)var13_6.value();
                                    v0 = ConfigEntityName$.MODULE$.Default();
                                    var16_9 = var15_8;
                                    if (!(v0 != null ? v0.equals(var16_9) == false : var16_9 != null)) {
                                        var9_10 = "default user ";
                                    } else if (var12_5) {
                                        user = (String)var13_6.value();
                                        var9_10 = "user " + user + " ";
                                    } else if (None$.MODULE$.equals(var14_7)) {
                                        var9_10 = "";
                                    } else {
                                        throw new MatchError(var14_7);
                                    }
                                    userInfo = var9_10;
                                    var19_13 = false;
                                    var20_14 = null;
                                    var21_15 = clientId;
                                    if (!(var21_15 instanceof Some)) ** GOTO lbl-1000
                                    var19_13 = true;
                                    var20_14 = (Some)var21_15;
                                    var22_16 = (String)var20_14.value();
                                    v1 = ConfigEntityName$.MODULE$.Default();
                                    var23_17 = var22_16;
                                    if (!(v1 != null ? v1.equals(var23_17) == false : var23_17 != null)) {
                                        var8_18 = "default client-id";
                                    } else if (var19_13) {
                                        id = (String)var20_14.value();
                                        var8_18 = "client-id " + id;
                                    } else if (None$.MODULE$.equals(var21_15)) {
                                        var8_18 = "";
                                    } else {
                                        throw new MatchError(var21_15);
                                    }
                                    clientIdInfo = var8_18;
                                    var25_21 = quota;
                                    if (!(var25_21 instanceof Some)) break block23;
                                    var26_22 = (Some)var25_21;
                                    newQuota = (Quota)var26_22.value();
                                    this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changing ", " quota for ", "", " to ", ".bound}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$quotaType(), userInfo, clientIdInfo, newQuota})));
                                    this.overriddenQuota().put(quotaId, newQuota);
                                    var28_24 = new Tuple2(sanitizedUser, clientId);
                                    if (var28_24 == null) break block24;
                                    var29_25 = (Option)var28_24._1();
                                    var30_26 = (Option)var28_24._2();
                                    if (!(var29_25 instanceof Some) || !(var30_26 instanceof Some)) break block24;
                                    this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserClientIdQuotaEnabled());
                                    var7_27 = BoxedUnit.UNIT;
                                    break block25;
                                }
                                if (var28_24 == null) break block26;
                                var31_31 = (Option)var28_24._1();
                                var32_32 = (Option)var28_24._2();
                                if (!(var31_31 instanceof Some) || !None$.MODULE$.equals(var32_32)) break block26;
                                this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserQuotaEnabled());
                                var7_28 = BoxedUnit.UNIT;
                                break block25;
                            }
                            if (var28_24 == null) break block27;
                            var33_33 = (Option)var28_24._1();
                            var34_34 = (Option)var28_24._2();
                            if (!None$.MODULE$.equals(var33_33) || !(var34_34 instanceof Some)) break block27;
                            this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.ClientIdQuotaEnabled());
                            var7_29 = BoxedUnit.UNIT;
                            break block25;
                        }
                        if (var28_24 == null) ** GOTO lbl-1000
                        var35_35 = (Option)var28_24._1();
                        var36_36 = (Option)var28_24._2();
                        if (None$.MODULE$.equals(var35_35) && None$.MODULE$.equals(var36_36)) {
                            var7_30 = BoxedUnit.UNIT;
                        } else lbl-1000:
                        // 2 sources

                        {
                            throw new MatchError((Object)var28_24);
                        }
                    }
                    var6_37 = BoxedUnit.UNIT;
                    break block28;
                }
                if (None$.MODULE$.equals(var25_21)) {
                    this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " quota for ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$quotaType(), userInfo, clientIdInfo})));
                    var6_37 = this.overriddenQuota().remove(quotaId);
                } else {
                    throw new MatchError(var25_21);
                }
            }
            quotaMetricName = this.clientRateMetricName((String)sanitizedUser.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$updateQuota$1(), ()Ljava/lang/String;)()), (String)clientId.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$updateQuota$2(), ()Ljava/lang/String;)()));
            allMetrics = this.metrics().metrics();
            var40_40 = this.quotaTypesEnabled();
            var5_41 = QuotaTypes$.MODULE$.NoQuotas() == var40_40 ? true : (QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == var40_40 ? true : (QuotaTypes$.MODULE$.UserQuotaEnabled() == var40_40 ? true : QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == var40_40));
            var4_42 = var5_41 != false ? sanitizedUser.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$updateQuota$3$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()).isDefined() == false && clientId.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$updateQuota$4$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()).isDefined() == false : false;
            singleUpdate = var4_42;
            if (singleUpdate) {
                metric = (KafkaMetric)allMetrics.get(quotaMetricName);
                if (metric != null) {
                    metricConfigEntity = this.quotaEntity((String)sanitizedUser.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$updateQuota$5(), ()Ljava/lang/String;)()), (String)clientId.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$updateQuota$6(), ()Ljava/lang/String;)()));
                    newQuota = metricConfigEntity.quota();
                    this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for ", "", " already exists. Changing quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userInfo, clientIdInfo, BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                    metric.config(this.getQuotaMetricConfig(newQuota));
                }
            } else {
                ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(allMetrics).asScala()).filterKeys((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$updateQuota$7$adapted(org.apache.kafka.common.MetricName org.apache.kafka.common.MetricName ), (Lorg/apache/kafka/common/MetricName;)Ljava/lang/Object;)((MetricName)quotaMetricName)).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$updateQuota$8$adapted(kafka.server.ClientQuotaManager scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ClientQuotaManager)this));
            }
        }
        finally {
            this.lock().writeLock().unlock();
        }
    }

    public MetricName clientRateMetricName(String sanitizedUser, String clientId) {
        return this.metrics().metricName("byte-rate", this.kafka$server$ClientQuotaManager$$quotaType().toString(), "Tracking byte-rate per user/client-id", new String[]{"user", sanitizedUser, "client-id", clientId});
    }

    private MetricName throttleMetricName(QuotaEntity quotaEntity) {
        return this.metrics().metricName("throttle-time", this.kafka$server$ClientQuotaManager$$quotaType().toString(), "Tracking average throttle-time per user/client-id", new String[]{"user", quotaEntity.sanitizedUser(), "client-id", quotaEntity.clientId()});
    }

    public void shutdown() {
        this.throttledRequestReaper().shutdown();
    }

    public static final /* synthetic */ String $anonfun$updateQuota$1() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$updateQuota$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$updateQuota$3(String x$1) {
        String string = x$1;
        String string2 = ConfigEntityName$.MODULE$.Default();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateQuota$4(String x$2) {
        String string = x$2;
        String string2 = ConfigEntityName$.MODULE$.Default();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$updateQuota$5() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$updateQuota$6() {
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$updateQuota$7(MetricName quotaMetricName$1, MetricName n) {
        String string = n.name();
        String string2 = quotaMetricName$1.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = n.group();
        String string4 = quotaMetricName$1.group();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public static final /* synthetic */ void $anonfun$updateQuota$8(ClientQuotaManager $this, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            MetricName metricName = (MetricName)tuple2._1();
            KafkaMetric metric = (KafkaMetric)tuple2._2();
            String userTag = metricName.tags().containsKey("user") ? (String)metricName.tags().get("user") : "";
            String clientIdTag = metricName.tags().containsKey("client-id") ? (String)metricName.tags().get("client-id") : "";
            QuotaEntity metricConfigEntity = $this.quotaEntity(userTag, clientIdTag);
            Quota quota = metricConfigEntity.quota();
            Quota quota2 = metric.config().quota();
            if (quota == null ? quota2 != null : !quota.equals(quota2)) {
                Quota newQuota = metricConfigEntity.quota();
                $this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for quota-id ", " already exists. Setting quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricConfigEntity.quotaId(), BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                metric.config($this.getQuotaMetricConfig(newQuota));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public ClientQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, QuotaType quotaType, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.kafka$server$ClientQuotaManager$$quotaType = quotaType;
        this.time = time;
        Logging.$init$(this);
        this.overriddenQuota = new ConcurrentHashMap();
        this.staticConfigClientIdQuota = Quota.upperBound((double)config.quotaBytesPerSecondDefault());
        this.quotaTypesEnabled = config.quotaBytesPerSecondDefault() == Long.MAX_VALUE ? QuotaTypes$.MODULE$.NoQuotas() : QuotaTypes$.MODULE$.ClientIdQuotaEnabled();
        this.lock = new ReentrantReadWriteLock();
        this.delayQueue = new DelayQueue();
        this.sensorAccessor = new SensorAccess();
        this.throttledRequestReaper = new ThrottledRequestReaper(this, this.delayQueue());
        this.kafka$server$ClientQuotaManager$$delayQueueSensor = metrics.sensor(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)quotaType), "-delayQueue"));
        this.kafka$server$ClientQuotaManager$$delayQueueSensor().add(metrics.metricName("queue-size", quotaType.toString(), "Tracks the size of the delay queue"), (MeasurableStat)new Total());
        this.start();
    }

    public static final /* synthetic */ Object $anonfun$updateQuota$3$adapted(String x$1) {
        return BoxesRunTime.boxToBoolean((boolean)ClientQuotaManager.$anonfun$updateQuota$3(x$1));
    }

    public static final /* synthetic */ Object $anonfun$updateQuota$4$adapted(String x$2) {
        return BoxesRunTime.boxToBoolean((boolean)ClientQuotaManager.$anonfun$updateQuota$4(x$2));
    }

    public static final /* synthetic */ Object $anonfun$updateQuota$7$adapted(MetricName quotaMetricName$1, MetricName n) {
        return BoxesRunTime.boxToBoolean((boolean)ClientQuotaManager.$anonfun$updateQuota$7(quotaMetricName$1, n));
    }

    public static final /* synthetic */ Object $anonfun$updateQuota$8$adapted(ClientQuotaManager $this, Tuple2 x0$1) {
        ClientQuotaManager.$anonfun$updateQuota$8($this, x0$1);
        return BoxedUnit.UNIT;
    }

    public class ThrottledRequestReaper
    extends ShutdownableThread {
        private final DelayQueue<ThrottledResponse> delayQueue;
        public final /* synthetic */ ClientQuotaManager $outer;

        @Override
        public void doWork() {
            block0: {
                ThrottledResponse response = (ThrottledResponse)this.delayQueue.poll(1L, TimeUnit.SECONDS);
                if (response == null) break block0;
                this.kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer().kafka$server$ClientQuotaManager$$delayQueueSensor().record(-1.0);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Response throttled for: " + response.throttleTimeMs() + " ms");
                response.execute();
            }
        }

        public /* synthetic */ ClientQuotaManager kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer() {
            return this.$outer;
        }

        public ThrottledRequestReaper(ClientQuotaManager $outer, DelayQueue<ThrottledResponse> delayQueue) {
            this.delayQueue = delayQueue;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(new StringOps(Predef$.MODULE$.augmentString("ThrottledRequestReaper-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$outer.kafka$server$ClientQuotaManager$$quotaType()})), false);
        }
    }
}

