/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.common.InvalidOffsetException;
import kafka.log.AbstractIndex;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.CoreUtils$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0005\u0013)a!#D\u0001\u0003\u0013\tY!AA\u0007BEN$(/Y2u\u0013:$W\r\u001f\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0005\u0019>tw\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\u0004\u0013:$\b\u0002\u0003\f\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\t\u0019LG.\u001a\t\u00031ui\u0011!\u0007\u0006\u00035m\t!![8\u000b\u0003q\tAA[1wC&\u0011a$\u0007\u0002\u0005\r&dW\rC\u0005!\u0001\t\u0005\t\u0015!\u0003\rC\u0005Q!-Y:f\u001f\u001a47/\u001a;\n\u0005\u0001R\u0001\"C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n%\u00031i\u0017\r_%oI\u0016D8+\u001b>f\u0013\t\u0019#\u0002C\u0005'\u0001\t\u0005\t\u0015!\u0003(U\u0005AqO]5uC\ndW\r\u0005\u0002\u000eQ%\u0011\u0011F\u0004\u0002\b\u0005>|G.Z1o\u0013\t1#\u0002C\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0006]=\u0002\u0014G\r\t\u0003\u0013\u0001AQAF\u0016A\u0002]AQ\u0001I\u0016A\u00021AqaI\u0016\u0011\u0002\u0003\u0007!\u0003C\u0004'WA\u0005\t\u0019A\u0014\t\u000bQ\u0002A\u0011I\u001b\u0002\u0013\u0015tGO]=TSj,W#\u0001\n\t\r]\u0002\u0001\u0015)\u0003\r\u0003-yF.Y:u\u001f\u001a47/\u001a;\t\u000be\u0002A\u0011\u0002\u001e\u0002\u00131\f7\u000f^#oiJLX#A\u001e\u0011\u0005%a\u0014BA\u001f\u0003\u00059yeMZ:fiB{7/\u001b;j_:DQa\u0010\u0001\u0005\u0002\u0001\u000b!\u0002\\1ti>3gm]3u+\u0005a\u0001\"\u0002\"\u0001\t\u0003\u0019\u0015A\u00027p_.,\b\u000f\u0006\u0002<\t\")Q)\u0011a\u0001\u0019\u0005aA/\u0019:hKR|eMZ:fi\")q\t\u0001C\u0001\u0011\u0006)b-\u001a;dQV\u0003\b/\u001a:C_VtGm\u00144gg\u0016$HcA%M\u001dB\u0019QBS\u001e\n\u0005-s!AB(qi&|g\u000eC\u0003N\r\u0002\u00071(A\u0006gKR\u001c\u0007n\u00144gg\u0016$\b\"B(G\u0001\u0004\u0011\u0012!\u00034fi\u000eD7+\u001b>f\u0011\u0015\t\u0006\u0001\"\u0003S\u00039\u0011X\r\\1uSZ,wJ\u001a4tKR$2AE*\\\u0011\u0015!\u0006\u000b1\u0001V\u0003\u0019\u0011WO\u001a4feB\u0011a+W\u0007\u0002/*\u0011\u0001lG\u0001\u0004]&|\u0017B\u0001.X\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u00069B\u0003\rAE\u0001\u0002]\")a\f\u0001C\u0005?\u0006A\u0001\u000f[=tS\u000e\fG\u000eF\u0002\u0013A\u0006DQ\u0001V/A\u0002UCQ\u0001X/A\u0002IAQa\u0019\u0001\u0005B\u0011\f!\u0002]1sg\u0016,e\u000e\u001e:z)\r)\u0007.\u001b\t\u0003\u0013\u0019L!a\u001a\u0002\u0003\u0015%sG-\u001a=F]R\u0014\u0018\u0010C\u0003UE\u0002\u0007Q\u000bC\u0003]E\u0002\u0007!\u0003C\u0003l\u0001\u0011\u0005A.A\u0003f]R\u0014\u0018\u0010\u0006\u0002<[\")AL\u001ba\u0001%!)q\u000e\u0001C\u0001a\u00061\u0011\r\u001d9f]\u0012$2!\u001d;w!\ti!/\u0003\u0002t\u001d\t!QK\\5u\u0011\u0015)h\u000e1\u0001\r\u0003\u0019ygMZ:fi\")qO\u001ca\u0001%\u0005A\u0001o\\:ji&|g\u000eC\u0003z\u0001\u0011\u0005#0\u0001\u0005ueVt7-\u0019;f)\u0005\t\b\"\u0002?\u0001\t\u0003j\u0018A\u0003;sk:\u001c\u0017\r^3U_R\u0011\u0011O \u0005\u0006kn\u0004\r\u0001\u0004\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0003E!(/\u001e8dCR,Gk\\#oiJLWm\u001d\u000b\u0004c\u0006\u0015\u0001BBA\u0004\u007f\u0002\u0007!#A\u0004f]R\u0014\u0018.Z:\t\r\u0005-\u0001\u0001\"\u0011{\u0003-\u0019\u0018M\\5us\u000eCWmY6\t\u0019\u0005=\u0001\u0001%A\u0002\u0002\u0003%I!\u000e\u0013\u0002%M,\b/\u001a:%[\u0006D\u0018J\u001c3fqNK'0\u001a\u0005\r\u0003'\u0001\u0001\u0013aA\u0001\u0002\u0013%\u0001)I\u0001\u0011gV\u0004XM\u001d\u0013cCN,wJ\u001a4tKR<\u0011\"a\u0006\u0003\u0003\u0003E\t!!\u0007\u0002\u0017=3gm]3u\u0013:$W\r\u001f\t\u0004\u0013\u0005ma\u0001C\u0001\u0003\u0003\u0003E\t!!\b\u0014\t\u0005m\u0011q\u0004\t\u0004\u001b\u0005\u0005\u0012bAA\u0012\u001d\t1\u0011I\\=SK\u001aDq\u0001LA\u000e\t\u0003\t9\u0003\u0006\u0002\u0002\u001a!Q\u00111FA\u000e#\u0003%\t!!\f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tyCK\u0002\u0013\u0003cY#!a\r\u0011\t\u0005U\u0012qH\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003{q\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011IA\u001c\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003\u000b\nY\"%A\u0005\u0002\u0005\u001d\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002J)\u001aq%!\r")
public class OffsetIndex
extends AbstractIndex<Object, Object> {
    private final File file;
    private long _lastOffset;

    public static boolean $lessinit$greater$default$4() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    private /* synthetic */ int super$maxIndexSize() {
        return super.maxIndexSize();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 8;
    }

    private OffsetPosition lastEntry() {
        return (OffsetPosition)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            OffsetPosition offsetPosition;
            int n = this._entries();
            switch (n) {
                case 0: {
                    offsetPosition = new OffsetPosition(this.super$baseOffset(), 0);
                    break;
                }
                default: {
                    offsetPosition = (OffsetPosition)this.parseEntry(this.mmap(), n - 1);
                    break;
                }
            }
            return offsetPosition;
        });
    }

    public long lastOffset() {
        return this._lastOffset;
    }

    public OffsetPosition lookup(long targetOffset) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetOffset, IndexSearchType$.MODULE$.KEY());
            return slot == -1 ? new OffsetPosition(this.super$baseOffset(), 0) : (OffsetPosition)this.parseEntry(idx, slot);
        });
    }

    public Option<OffsetPosition> fetchUpperBoundOffset(OffsetPosition fetchOffset, int fetchSize) {
        return (Option)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.smallestUpperBoundSlotFor(idx, fetchOffset.position() + fetchSize, IndexSearchType$.MODULE$.VALUE());
            return slot == -1 ? None$.MODULE$ : new Some((Object)((OffsetPosition)this.parseEntry(idx, slot)));
        });
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize());
    }

    private int physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 4);
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new OffsetPosition(super.baseOffset() + (long)this.relativeOffset(buffer, n), this.physical(buffer, n));
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from an index of size %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this._entries())})));
            }
            ByteBuffer idx = this.mmap().duplicate();
            return new OffsetPosition(this.relativeOffset(idx, n), this.physical(idx, n));
        });
    }

    public void append(long offset, int position) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(!this.isFull(), (Function0 & Serializable & scala.Serializable)() -> "Attempt to append to a full index (size = " + this._entries() + ").");
            if (this._entries() != 0 && offset <= $this._lastOffset) {
                throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to position %d no larger than the last offset appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)this.entries()), BoxesRunTime.boxToLong((long)$this._lastOffset), $this.file.getAbsolutePath()})));
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)position), $this.file.getName()})));
            this.mmap().putInt((int)(offset - this.super$baseOffset()));
            this.mmap().putInt(position);
            this._entries_$eq(this._entries() + 1);
            $this._lastOffset = offset;
            Predef$.MODULE$.require(this._entries() * this.entrySize() == this.mmap().position(), (Function0 & Serializable & scala.Serializable)() -> this.entries() + " entries but file position in index is " + this.mmap().position() + ".");
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, offset, IndexSearchType$.MODULE$.KEY());
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.super$baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    private void truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this._entries_$eq(entries);
            this.mmap().position(this._entries() * this.entrySize());
            $this._lastOffset = this.lastEntry().offset();
        });
    }

    @Override
    public void sanityCheck() {
        Predef$.MODULE$.require(this._entries() == 0 || this._lastOffset > super.baseOffset(), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt index found, index file (", ") has non-zero size but the last offset "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.file.getAbsolutePath()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is no larger than the base offset ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)$this._lastOffset), BoxesRunTime.boxToLong((long)this.super$baseOffset())})));
        long len = this.file.length();
        Predef$.MODULE$.require(len % (long)this.entrySize() == 0L, (Function0 & Serializable & scala.Serializable)() -> "Index file " + $this.file.getAbsolutePath() + " is corrupt, found " + len + " bytes which is not positive or not a multiple of 8.");
    }

    public OffsetIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        this.file = file;
        super(file, baseOffset, maxIndexSize, writable);
        this._lastOffset = this.lastEntry().offset();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Loaded index file %s with maxEntries = %d, maxIndexSize = %d, entries = %d, lastOffset = %d, file position = %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.file.getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.maxEntries()), BoxesRunTime.boxToInteger((int)this.super$maxIndexSize()), BoxesRunTime.boxToInteger((int)this._entries()), BoxesRunTime.boxToLong((long)$this._lastOffset), BoxesRunTime.boxToInteger((int)this.mmap().position())})));
    }
}

