/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.common.InterBrokerSendThread;
import kafka.common.InterBrokerSendThread$;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.DelayedTxnMarker;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnIdAndMarkerEntry;
import kafka.coordinator.transaction.TxnLogAppend;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\tUs!B\u0001\u0003\u0011\u0003I\u0011a\b+sC:\u001c\u0018m\u0019;j_:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe*\u00111\u0001B\u0001\fiJ\fgn]1di&|gN\u0003\u0002\u0006\r\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00059\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0015-i\u0011A\u0001\u0004\u0006\u0019\tA\t!\u0004\u0002 )J\fgn]1di&|g.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u00148CA\u0006\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Qc\u0003C\u0001-\u00051A(\u001b8jiz\"\u0012!\u0003\u0005\u00061-!\t!G\u0001\u0006CB\u0004H.\u001f\u000b\u000e5\t}\"\u0011\tB'\u0005\u001f\u0012\tFa\u0015\u0011\u0005)Yb\u0001\u0002\u0007\u0003\u0001q\u0019BaG\u000f$SA\u0011a$I\u0007\u0002?)\u0011\u0001EB\u0001\u0007G>lWn\u001c8\n\u0005\tz\"!F%oi\u0016\u0014(I]8lKJ\u001cVM\u001c3UQJ,\u0017\r\u001a\t\u0003I\u001dj\u0011!\n\u0006\u0003M\u0019\tQ!\u001e;jYNL!\u0001K\u0013\u0003\u000f1{wmZ5oOB\u0011!&L\u0007\u0002W)\u0011AFB\u0001\b[\u0016$(/[2t\u0013\tq3FA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001\u0002M\u000e\u0003\u0002\u0003\u0006I!M\u0001\u0007G>tg-[4\u0011\u0005I*T\"A\u001a\u000b\u0005Q2\u0011AB:feZ,'/\u0003\u00027g\tY1*\u00194lC\u000e{gNZ5h\u0011!A4D!A!\u0002\u0013I\u0014!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u00023u%\u00111h\r\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\t\u0011uZ\"\u0011!Q\u0001\ny\nQB\\3uo>\u00148n\u00117jK:$\bCA H\u001b\u0005\u0001%BA!C\u0003\u001d\u0019G.[3oiNT!aB\"\u000b\u0005\u0011+\u0015AB1qC\u000eDWMC\u0001G\u0003\ry'oZ\u0005\u0003\u0011\u0002\u0013QBT3uo>\u00148n\u00117jK:$\b\u0002\u0003&\u001c\u0005\u0003\u0005\u000b\u0011B&\u0002\u001fQDhn\u0015;bi\u0016l\u0015M\\1hKJ\u0004\"A\u0003'\n\u00055\u0013!a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0011!y5D!A!\u0002\u0013\u0001\u0016A\u0005;y]6\u000b'o[3s!V\u0014x-\u0019;pef\u00042AM)T\u0013\t\u00116GA\rEK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]B+(oZ1u_JL\bC\u0001\u0006U\u0013\t)&A\u0001\tEK2\f\u00170\u001a3Uq:l\u0015M]6fe\"Aqk\u0007B\u0001B\u0003%\u0001,\u0001\u0003uS6,\u0007CA-]\u001b\u0005Q&B\u0001\u0014\\\u0015\t\u0001#)\u0003\u0002^5\n!A+[7f\u0011\u0015)2\u0004\"\u0001`)\u001dQ\u0002-\u00192dI\u0016DQ\u0001\r0A\u0002EBQ\u0001\u000f0A\u0002eBQ!\u00100A\u0002yBQA\u00130A\u0002-CQa\u00140A\u0002ACQa\u00160A\u0002aCqaZ\u000eC\u0002\u0013%\u0001.A\fj]R,'O\u0011:pW\u0016\u0014H*[:uK:,'OT1nKV\t\u0011\u000e\u0005\u0002k[6\t1N\u0003\u0002m7\u00069a.\u001a;x_J\\\u0017B\u00018l\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011\u0019\u00018\u0004)A\u0005S\u0006A\u0012N\u001c;fe\n\u0013xn[3s\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0011\t\u000fI\\\"\u0019!C\u0005g\u0006)R.\u0019:lKJ\u001c\u0018+^3vKB+'O\u0011:pW\u0016\u0014X#\u0001;\u0011\tUTHp`\u0007\u0002m*\u0011q\u000f_\u0001\u000bG>t7-\u001e:sK:$(BA=\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003wZ\u00141!T1q!\tyQ0\u0003\u0002\u007f!\t\u0019\u0011J\u001c;\u0011\u0007)\t\t!C\u0002\u0002\u0004\t\u0011a\u0002\u0016=o\u001b\u0006\u00148.\u001a:Rk\u0016,X\rC\u0004\u0002\bm\u0001\u000b\u0011\u0002;\u0002-5\f'o[3sgF+X-^3QKJ\u0014%o\\6fe\u0002B\u0011\"a\u0003\u001c\u0005\u0004%I!!\u0004\u000295\f'o[3sgF+X-^3G_J,fn\u001b8po:\u0014%o\\6feV\tq\u0010C\u0004\u0002\u0012m\u0001\u000b\u0011B@\u0002;5\f'o[3sgF+X-^3G_J,fn\u001b8po:\u0014%o\\6fe\u0002B\u0011\"!\u0006\u001c\u0005\u0004%I!a\u0006\u0002-QDh\u000eT8h\u0003B\u0004XM\u001c3SKR\u0014\u00180U;fk\u0016,\"!!\u0007\u0011\r\u0005m\u0011qEA\u0016\u001b\t\tiBC\u0002x\u0003?QA!!\t\u0002$\u0005!Q\u000f^5m\u0015\t\t)#\u0001\u0003kCZ\f\u0017\u0002BA\u0015\u0003;\u00111\u0003T5oW\u0016$'\t\\8dW&tw-U;fk\u0016\u00042ACA\u0017\u0013\r\tyC\u0001\u0002\r)btGj\\4BaB,g\u000e\u001a\u0005\t\u0003gY\u0002\u0015!\u0003\u0002\u001a\u00059B\u000f\u001f8M_\u001e\f\u0005\u000f]3oIJ+GO]=Rk\u0016,X\r\t\u0005\b\u0003oYB\u0011IA\u001d\u0003A9WM\\3sCR,'+Z9vKN$8\u000f\u0006\u0002\u0002<A1\u0011QHA'\u0003'rA!a\u0010\u0002J9!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002F!\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0007\u0005-\u0003#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0013\u0011\u000b\u0002\t\u0013R,'/\u00192mK*\u0019\u00111\n\t\u0011\u0007y\t)&C\u0002\u0002X}\u00111DU3rk\u0016\u001cH/\u00118e\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\bbBA.7\u0011\u0005\u0013QL\u0001\tg\",H\u000fZ8x]R\u0011\u0011q\f\t\u0004\u001f\u0005\u0005\u0014bAA2!\t!QK\\5u\u0011!\t9g\u0007C\u0001\u0005\u0005%\u0014AD9vKV,gi\u001c:Ce>\\WM\u001d\u000b\u0005\u0003W\n\t\b\u0005\u0003\u0010\u0003[z\u0018bAA8!\t1q\n\u001d;j_:Dq!a\u001d\u0002f\u0001\u0007A0\u0001\u0005ce>\\WM]%e\u0011!\t9h\u0007C\u0001\u0005\u00055\u0011!F9vKV,gi\u001c:V].twn\u001e8Ce>\\WM\u001d\u0005\t\u0003wZB\u0011\u0001\u0002\u0002~\u0005\u0019\u0012\r\u001a3NCJ\\WM]:G_J\u0014%o\\6feRA\u0011qLA@\u0003\u0017\u000by\t\u0003\u0005\u0002\u0002\u0006e\u0004\u0019AAB\u0003\u0019\u0011'o\\6feB!\u0011QQAD\u001b\u0005Y\u0016bAAE7\n!aj\u001c3f\u0011\u001d\ti)!\u001fA\u0002q\f\u0011\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8o\u0011!\t\t*!\u001fA\u0002\u0005M\u0015A\u0004;y]&#\u0017I\u001c3NCJ\\WM\u001d\t\u0004\u0015\u0005U\u0015bAAL\u0005\t\u0019B\u000b\u001f8JI\u0006sG-T1sW\u0016\u0014XI\u001c;ss\"9\u00111T\u000e\u0005\u0002\u0005u\u0013a\u0004:fiJLHj\\4BaB,g\u000eZ:\t\u0011\u0005}5\u0004\"\u0001\u0003\u0003s\tQ\u0004\u001a:bS:\fV/Z;fIR\u0013\u0018M\\:bGRLwN\\'be.,'o\u001d\u0005\b\u0003G[B\u0011AAS\u0003M\tG\r\u001a+y]6\u000b'o[3sgR{7+\u001a8e)1\ty&a*\u0002<\u0006}\u0016qZAm\u0011!\tI+!)A\u0002\u0005-\u0016a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\u0011\t\u00055\u0016Q\u0017\b\u0005\u0003_\u000b\t\fE\u0002\u0002BAI1!a-\u0011\u0003\u0019\u0001&/\u001a3fM&!\u0011qWA]\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0017\t\t\u000f\u0005u\u0016\u0011\u0015a\u0001y\u0006\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0005\t\u0003\u0003\f\t\u000b1\u0001\u0002D\u0006IA\u000f\u001f8SKN,H\u000e\u001e\t\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*\u0019\u0011\u0011Z.\u0002\u0011I,\u0017/^3tiNLA!!4\u0002H\n\tBK]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\t\u0011\u0005E\u0017\u0011\u0015a\u0001\u0003'\f1\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCB\u0019!\"!6\n\u0007\u0005]'AA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\u0003\u0005\u0002\\\u0006\u0005\u0006\u0019AAo\u0003-qWm^'fi\u0006$\u0017\r^1\u0011\u0007)\ty.C\u0002\u0002b\n\u0011!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\"9\u0011Q]\u000e\u0005\n\u0005\u001d\u0018A\u0004;ss\u0006\u0003\b/\u001a8e)>dun\u001a\u000b\u0005\u0003?\nI\u000f\u0003\u0005\u0002l\u0006\r\b\u0019AA\u0016\u00031!\bP\u001c'pO\u0006\u0003\b/\u001a8e\u0011\u001d\tyo\u0007C\u0001\u0003c\f!$\u00193e)btW*\u0019:lKJ\u001cHk\u001c\"s_.,'/U;fk\u0016$b\"a\u0018\u0002t\u0006U\u0018q B\u0005\u0005\u001b\u0011y\u0001\u0003\u0005\u0002*\u00065\b\u0019AAV\u0011!\t90!<A\u0002\u0005e\u0018A\u00039s_\u0012,8-\u001a:JIB\u0019q\"a?\n\u0007\u0005u\bC\u0001\u0003M_:<\u0007\u0002\u0003B\u0001\u0003[\u0004\rAa\u0001\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\ry!QA\u0005\u0004\u0005\u000f\u0001\"!B*i_J$\b\u0002\u0003B\u0006\u0003[\u0004\r!a1\u0002\rI,7/\u001e7u\u0011\u001d\ti,!<A\u0002qD\u0001B!\u0005\u0002n\u0002\u0007!1C\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB1!Q\u0003B\u000e\u0005?i!Aa\u0006\u000b\u0007\te\u00010A\u0005j[6,H/\u00192mK&!!Q\u0004B\f\u0005\r\u0019V\r\u001e\t\u0005\u0003\u000b\u0013\t#C\u0002\u0003$m\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0003(m!\tA!\u000b\u0002CI,Wn\u001c<f\u001b\u0006\u00148.\u001a:t\r>\u0014H\u000b\u001f8U_BL7\rU1si&$\u0018n\u001c8\u0015\t\u0005}#1\u0006\u0005\b\u0005[\u0011)\u00031\u0001}\u0003M!\bP\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\%e\u0011\u001d\u0011\td\u0007C\u0001\u0005g\tQC]3n_Z,W*\u0019:lKJ\u001chi\u001c:Uq:LE\r\u0006\u0003\u0002`\tU\u0002\u0002CAU\u0005_\u0001\r!a+\t\u000f\te2\u0004\"\u0001\u0003<\u0005Y2m\\7qY\u0016$XmU3oI6\u000b'o[3sg\u001a{'\u000f\u0016=o\u0013\u0012$B!a\u0018\u0003>!A\u0011\u0011\u0016B\u001c\u0001\u0004\tY\u000bC\u00031/\u0001\u0007\u0011\u0007\u0003\u0004-/\u0001\u0007!1\t\t\u0005\u0005\u000b\u0012I%\u0004\u0002\u0003H)\u0011AfW\u0005\u0005\u0005\u0017\u00129EA\u0004NKR\u0014\u0018nY:\t\u000ba:\u0002\u0019A\u001d\t\u000b);\u0002\u0019A&\t\u000b=;\u0002\u0019\u0001)\t\u000b];\u0002\u0019\u0001-")
public class TransactionMarkerChannelManager
extends InterBrokerSendThread
implements KafkaMetricsGroup {
    private final MetadataCache metadataCache;
    private final TransactionStateManager txnStateManager;
    private final DelayedOperationPurgatory<DelayedTxnMarker> txnMarkerPurgatory;
    private final ListenerName interBrokerListenerName;
    private final scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker;
    private final TxnMarkerQueue kafka$coordinator$transaction$TransactionMarkerChannelManager$$markersQueueForUnknownBroker;
    private final LinkedBlockingQueue<TxnLogAppend> kafka$coordinator$transaction$TransactionMarkerChannelManager$$txnLogAppendRetryQueue;

    public static TransactionMarkerChannelManager apply(KafkaConfig kafkaConfig, Metrics metrics, MetadataCache metadataCache, TransactionStateManager transactionStateManager, DelayedOperationPurgatory<DelayedTxnMarker> delayedOperationPurgatory, Time time) {
        return TransactionMarkerChannelManager$.MODULE$.apply(kafkaConfig, metrics, metadataCache, transactionStateManager, delayedOperationPurgatory, time);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    private ListenerName interBrokerListenerName() {
        return this.interBrokerListenerName;
    }

    private scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker() {
        return this.markersQueuePerBroker;
    }

    public TxnMarkerQueue kafka$coordinator$transaction$TransactionMarkerChannelManager$$markersQueueForUnknownBroker() {
        return this.kafka$coordinator$transaction$TransactionMarkerChannelManager$$markersQueueForUnknownBroker;
    }

    public LinkedBlockingQueue<TxnLogAppend> kafka$coordinator$transaction$TransactionMarkerChannelManager$$txnLogAppendRetryQueue() {
        return this.kafka$coordinator$transaction$TransactionMarkerChannelManager$$txnLogAppendRetryQueue;
    }

    @Override
    public Iterable<RequestAndCompletionHandler> generateRequests() {
        return this.drainQueuedTransactionMarkers();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.txnMarkerPurgatory.shutdown();
        this.markersQueuePerBroker().clear();
    }

    public Option<TxnMarkerQueue> queueForBroker(int brokerId) {
        return this.markersQueuePerBroker().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
    }

    public TxnMarkerQueue queueForUnknownBroker() {
        return this.kafka$coordinator$transaction$TransactionMarkerChannelManager$$markersQueueForUnknownBroker();
    }

    public void addMarkersForBroker(Node broker, int txnTopicPartition, TxnIdAndMarkerEntry txnIdAndMarker) {
        int brokerId = broker.id();
        TxnMarkerQueue brokerRequestQueue = CoreUtils$.MODULE$.atomicGetOrUpdate(this.markersQueuePerBroker(), BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> new TxnMarkerQueue(broker));
        brokerRequestQueue.destination_$eq(broker);
        brokerRequestQueue.addMarkers(txnTopicPartition, txnIdAndMarker);
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Added marker ", " for transactional id ", " to destination broker ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndMarker.txnMarkerEntry(), txnIdAndMarker.txnId(), BoxesRunTime.boxToInteger((int)brokerId)})));
    }

    public void retryLogAppends() {
        ArrayList txnLogAppendRetries = new ArrayList();
        this.kafka$coordinator$transaction$TransactionMarkerChannelManager$$txnLogAppendRetryQueue().drainTo(txnLogAppendRetries);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(txnLogAppendRetries).asScala()).foreach((Function1 & Serializable & scala.Serializable)txnLogAppend -> {
            TransactionMarkerChannelManager.$anonfun$retryLogAppends$1(this, txnLogAppend);
            return BoxedUnit.UNIT;
        });
    }

    public Iterable<RequestAndCompletionHandler> drainQueuedTransactionMarkers() {
        this.retryLogAppends();
        ArrayList txnIdAndMarkerEntries = new ArrayList();
        this.kafka$coordinator$transaction$TransactionMarkerChannelManager$$markersQueueForUnknownBroker().forEachTxnTopicPartition((Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> BoxesRunTime.boxToInteger((int)TransactionMarkerChannelManager.$anonfun$drainQueuedTransactionMarkers$1(txnIdAndMarkerEntries, BoxesRunTime.unboxToInt((Object)x0$2), x1$1)));
        ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(txnIdAndMarkerEntries).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$drainQueuedTransactionMarkers$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)txnIdAndMarker -> {
            TransactionMarkerChannelManager.$anonfun$drainQueuedTransactionMarkers$3(this, txnIdAndMarker);
            return BoxedUnit.UNIT;
        });
        return (Iterable)((TraversableLike)((TraversableLike)this.markersQueuePerBroker().values().map((Function1 & Serializable & scala.Serializable)brokerRequestQueue -> {
            ArrayList txnIdAndMarkerEntries = new ArrayList();
            brokerRequestQueue.forEachTxnTopicPartition((Function2 & Serializable & scala.Serializable)(x0$3, x1$2) -> BoxesRunTime.boxToInteger((int)TransactionMarkerChannelManager.$anonfun$drainQueuedTransactionMarkers$5(txnIdAndMarkerEntries, BoxesRunTime.unboxToInt((Object)x0$3), x1$2)));
            return new Tuple2((Object)brokerRequestQueue.destination(), txnIdAndMarkerEntries);
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$drainQueuedTransactionMarkers$6(x0$4)))).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Node node = (Node)tuple2._1();
            ArrayList entries = (ArrayList)tuple2._2();
            List markersToSend = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)entries).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.txnMarkerEntry(), Buffer$.MODULE$.canBuildFrom())).asJava();
            TransactionMarkerRequestCompletionHandler requestCompletionHandler = new TransactionMarkerRequestCompletionHandler(node.id(), $this.txnStateManager, this, entries);
            RequestAndCompletionHandler requestAndCompletionHandler = new RequestAndCompletionHandler(node, (AbstractRequest.Builder<? extends AbstractRequest>)new WriteTxnMarkersRequest.Builder(markersToSend), requestCompletionHandler);
            return requestAndCompletionHandler;
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public void addTxnMarkersToSend(String transactionalId, int coordinatorEpoch, TransactionResult txnResult, TransactionMetadata txnMetadata, TxnTransitMetadata newMetadata) {
        DelayedTxnMarker delayedTxnMarker = new DelayedTxnMarker(txnMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
            this.appendToLogCallback$1(error, transactionalId, coordinatorEpoch, txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        }, this.txnStateManager.stateReadLock());
        this.txnMarkerPurgatory.tryCompleteElseWatch(delayedTxnMarker, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{transactionalId}))));
        this.addTxnMarkersToBrokerQueue(transactionalId, txnMetadata.producerId(), txnMetadata.producerEpoch(), txnResult, coordinatorEpoch, (Set<TopicPartition>)txnMetadata.topicPartitions().toSet());
    }

    private void tryAppendToLog(TxnLogAppend txnLogAppend) {
        this.txnStateManager.appendTransactionToLog(txnLogAppend.transactionalId(), txnLogAppend.coordinatorEpoch(), txnLogAppend.newMetadata(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
            this.appendCallback$1(error, txnLogAppend);
            return BoxedUnit.UNIT;
        }, (Function1<Errors, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$tryAppendToLog$7(x$5)));
    }

    public void addTxnMarkersToBrokerQueue(String transactionalId, long producerId, short producerEpoch, TransactionResult result, int coordinatorEpoch, Set<TopicPartition> topicPartitions) {
        int txnTopicPartition = this.txnStateManager.partitionFor(transactionalId);
        scala.collection.immutable.Map partitionsByDestination = topicPartitions.groupBy((Function1 & Serializable & scala.Serializable)topicPartition -> $this.metadataCache.getPartitionLeaderEndpoint(topicPartition.topic(), topicPartition.partition(), this.interBrokerListenerName()));
        partitionsByDestination.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$addTxnMarkersToBrokerQueue$2(check$ifrefutable$2))).foreach(arg_0 -> TransactionMarkerChannelManager.$anonfun$addTxnMarkersToBrokerQueue$3(this, transactionalId, producerId, producerEpoch, result, coordinatorEpoch, txnTopicPartition, arg_0));
        this.wakeup();
    }

    public void removeMarkersForTxnTopicPartition(int txnTopicPartitionId) {
        this.kafka$coordinator$transaction$TransactionMarkerChannelManager$$markersQueueForUnknownBroker().removeMarkersForTxnTopicPartition(txnTopicPartitionId).foreach((Function1 & Serializable & scala.Serializable)queue -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$1(this, queue);
            return BoxedUnit.UNIT;
        });
        this.markersQueuePerBroker().foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$4(this, txnTopicPartitionId, x0$6);
            return BoxedUnit.UNIT;
        });
    }

    public void removeMarkersForTxnId(String transactionalId) {
        this.txnMarkerPurgatory.cancelForKey(transactionalId);
    }

    public void completeSendMarkersForTxnId(String transactionalId) {
        this.txnMarkerPurgatory.checkAndComplete(transactionalId);
    }

    public static final /* synthetic */ void $anonfun$retryLogAppends$1(TransactionMarkerChannelManager $this, TxnLogAppend txnLogAppend) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retry appending ", " transaction log"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnLogAppend})));
        $this.tryAppendToLog(txnLogAppend);
    }

    public static final /* synthetic */ int $anonfun$drainQueuedTransactionMarkers$1(List txnIdAndMarkerEntries$1, int x0$2, BlockingQueue x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BlockingQueue queue = (BlockingQueue)tuple2._2();
        int n = queue.drainTo(txnIdAndMarkerEntries$1);
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$drainQueuedTransactionMarkers$2(TxnIdAndMarkerEntry check$ifrefutable$1) {
        TxnIdAndMarkerEntry txnIdAndMarkerEntry = check$ifrefutable$1;
        boolean bl = txnIdAndMarkerEntry != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$drainQueuedTransactionMarkers$3(TransactionMarkerChannelManager $this, TxnIdAndMarkerEntry txnIdAndMarker) {
        String transactionalId = txnIdAndMarker.txnId();
        long producerId = txnIdAndMarker.txnMarkerEntry().producerId();
        short producerEpoch = txnIdAndMarker.txnMarkerEntry().producerEpoch();
        TransactionResult txnResult = txnIdAndMarker.txnMarkerEntry().transactionResult();
        int coordinatorEpoch = txnIdAndMarker.txnMarkerEntry().coordinatorEpoch();
        Set topicPartitions = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(txnIdAndMarker.txnMarkerEntry().partitions()).asScala()).toSet();
        $this.addTxnMarkersToBrokerQueue(transactionalId, producerId, producerEpoch, txnResult, coordinatorEpoch, (Set<TopicPartition>)topicPartitions);
    }

    public static final /* synthetic */ int $anonfun$drainQueuedTransactionMarkers$5(ArrayList txnIdAndMarkerEntries$2, int x0$3, BlockingQueue x1$2) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$3), (Object)x1$2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BlockingQueue queue = (BlockingQueue)tuple2._2();
        int n = queue.drainTo(txnIdAndMarkerEntries$2);
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$drainQueuedTransactionMarkers$6(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ArrayList entries = (ArrayList)tuple2._2();
        boolean bl = !entries.isEmpty();
        return bl;
    }

    public static final /* synthetic */ String $anonfun$addTxnMarkersToSend$1(String transactionalId$1, TransactionResult txnResult$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed sending transaction markers for ", " as ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, txnResult$1}));
    }

    public static final /* synthetic */ String $anonfun$addTxnMarkersToSend$2(String transactionalId$1, int coordinatorEpoch$1, TxnTransitMetadata newMetadata$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No longer the coordinator for ", " with coordinator epoch ", "; cancel appending ", " to transaction log"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, BoxesRunTime.boxToInteger((int)coordinatorEpoch$1), newMetadata$1}));
    }

    public static final /* synthetic */ String $anonfun$addTxnMarkersToSend$3(String transactionalId$1, int coordinatorEpoch$1, TxnTransitMetadata newMetadata$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading the transaction partition that contains ", " while my current coordinator epoch is ", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, BoxesRunTime.boxToInteger((int)coordinatorEpoch$1)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"so cancel appending ", " to transaction log since the loading process will continue the remaining work"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newMetadata$1}));
    }

    public static final /* synthetic */ String $anonfun$addTxnMarkersToSend$4(String transactionalId$1, int coordinatorEpoch$1, TransactionMetadata txnMetadata$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending ", "'s transaction markers for ", " with coordinator epoch ", " succeeded, trying to append complete transaction log now"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, txnMetadata$1, BoxesRunTime.boxToInteger((int)coordinatorEpoch$1)}));
    }

    public static final /* synthetic */ String $anonfun$addTxnMarkersToSend$5(int coordinatorEpoch$1, TransactionMetadata txnMetadata$1, TxnTransitMetadata newMetadata$1, CoordinatorEpochAndTxnMetadata epochAndMetadata$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cached metadata ", " has changed to ", " after completed sending the markers with coordinator "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMetadata$1, epochAndMetadata$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"epoch ", "; abort transiting the metadata to ", " as it may have been updated by another process"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)coordinatorEpoch$1), newMetadata$1}));
    }

    public static final /* synthetic */ String $anonfun$addTxnMarkersToSend$6(String errorMsg$2) {
        return errorMsg$2;
    }

    public static final /* synthetic */ String $anonfun$addTxnMarkersToSend$7(String errorMsg$3) {
        return errorMsg$3;
    }

    /*
     * Unable to fully structure code
     */
    private final void appendToLogCallback$1(Errors error, String transactionalId$1, int coordinatorEpoch$1, TransactionResult txnResult$1, TransactionMetadata txnMetadata$1, TxnTransitMetadata newMetadata$1) {
        block7: {
            block8: {
                block6: {
                    var9_7 = error;
                    if (!Errors.NONE.equals(var9_7)) ** GOTO lbl47
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addTxnMarkersToSend$1(java.lang.String org.apache.kafka.common.requests.TransactionResult ), ()Ljava/lang/String;)((String)transactionalId$1, (TransactionResult)txnResult$1));
                    var10_8 = false;
                    var11_9 = null;
                    var12_10 = false;
                    var13_11 = null;
                    var14_12 = this.txnStateManager.getTransactionState(transactionalId$1);
                    if (!(var14_12 instanceof Left)) break block6;
                    var10_8 = true;
                    var11_9 = (Left)var14_12;
                    var15_13 = (Errors)var11_9.value();
                    if (!Errors.NOT_COORDINATOR.equals(var15_13)) break block6;
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addTxnMarkersToSend$2(java.lang.String int kafka.coordinator.transaction.TxnTransitMetadata ), ()Ljava/lang/String;)((String)transactionalId$1, (int)coordinatorEpoch$1, (TxnTransitMetadata)newMetadata$1));
                    var8_14 = BoxedUnit.UNIT;
                    break block7;
                }
                if (!var10_8 || !Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(var16_17 = (Errors)var11_9.value())) break block8;
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addTxnMarkersToSend$3(java.lang.String int kafka.coordinator.transaction.TxnTransitMetadata ), ()Ljava/lang/String;)((String)transactionalId$1, (int)coordinatorEpoch$1, (TxnTransitMetadata)newMetadata$1));
                var8_15 = BoxedUnit.UNIT;
                break block7;
            }
            if (var10_8) {
                unexpectedError = (Errors)var11_9.value();
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unhandled error ", " when fetching current transaction state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unexpectedError})));
            }
            if (!(var14_12 instanceof Right)) ** GOTO lbl-1000
            var12_10 = true;
            var13_11 = (Right)var14_12;
            var18_19 = (Option)var13_11.value();
            if (var18_19 instanceof Some) {
                var19_20 = (Some)var18_19;
                epochAndMetadata = (CoordinatorEpochAndTxnMetadata)var19_20.value();
                if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$1) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addTxnMarkersToSend$4(java.lang.String int kafka.coordinator.transaction.TransactionMetadata ), ()Ljava/lang/String;)((String)transactionalId$1, (int)coordinatorEpoch$1, (TransactionMetadata)txnMetadata$1));
                    this.tryAppendToLog(new TxnLogAppend(transactionalId$1, coordinatorEpoch$1, txnMetadata$1, newMetadata$1));
                    v0 = BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addTxnMarkersToSend$5(int kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata ), ()Ljava/lang/String;)((int)coordinatorEpoch$1, (TransactionMetadata)txnMetadata$1, (TxnTransitMetadata)newMetadata$1, (CoordinatorEpochAndTxnMetadata)epochAndMetadata));
                    v0 = BoxedUnit.UNIT;
                }
                var8_16 = v0;
            } else lbl-1000:
            // 2 sources

            {
                if (var12_10 && None$.MODULE$.equals(var21_22 = (Option)var13_11.value())) {
                    errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The coordinator still owns the transaction partition for ", ", but there is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no metadata in the cache; this is not expected"})).s((Seq)Nil$.MODULE$);
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addTxnMarkersToSend$6(java.lang.String ), ()Ljava/lang/String;)((String)errorMsg));
                    throw new IllegalStateException(errorMsg);
                }
                throw new MatchError(var14_12);
lbl47:
                // 1 sources

                errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected error ", " before appending to txn log for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var9_7.exceptionName(), transactionalId$1}));
                this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addTxnMarkersToSend$7(java.lang.String ), ()Ljava/lang/String;)((String)errorMsg));
                throw new IllegalStateException(errorMsg);
            }
        }
        var7_24 = BoxedUnit.UNIT;
    }

    private final void appendCallback$1(Errors error, TxnLogAppend txnLogAppend$1) {
        Errors errors = error;
        if (Errors.NONE.equals(errors)) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed transaction for ", " with coordinator epoch ", ", final state after commit: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnLogAppend$1.transactionalId(), BoxesRunTime.boxToInteger((int)txnLogAppend$1.coordinatorEpoch()), txnLogAppend$1.txnMetadata().state()})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Errors.NOT_COORDINATOR.equals(errors)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No longer the coordinator for transactionalId: ", " while trying to append to transaction log, skip writing to transaction log"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnLogAppend$1.transactionalId()})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Errors.COORDINATOR_NOT_AVAILABLE.equals(errors)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not available to append ", ": possible causes include ", ", ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnLogAppend$1, Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.NOT_ENOUGH_REPLICAS})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " and ", "; retry appending"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND, Errors.REQUEST_TIMED_OUT})));
            this.kafka$coordinator$transaction$TransactionMarkerChannelManager$$txnLogAppendRetryQueue().add(txnLogAppend$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Coordinator is loading the partition ", " and hence cannot complete append of ", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.txnStateManager.partitionFor(txnLogAppend$1.transactionalId())), txnLogAppend$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"skip writing to transaction log as the loading process should complete it"})).s((Seq)Nil$.MODULE$));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (errors != null) {
                Errors errors2 = errors;
                String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected error ", " while appending to transaction log for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errors2.exceptionName(), txnLogAppend$1.transactionalId()}));
                this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                throw new IllegalStateException(errorMsg);
            }
            throw new MatchError((Object)errors);
        }
    }

    public static final /* synthetic */ boolean $anonfun$tryAppendToLog$7(Errors x$5) {
        Errors errors = x$5;
        Errors errors2 = Errors.COORDINATOR_NOT_AVAILABLE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$addTxnMarkersToBrokerQueue$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        if (tuple2 == null) return false;
        Option broker = (Option)tuple2._1();
        Set topicPartitions = (Set)tuple2._2();
        if (broker == null) return false;
        if (topicPartitions == null) return false;
        return true;
    }

    public static final /* synthetic */ String $anonfun$addTxnMarkersToBrokerQueue$4(String transactionalId$2, int coordinatorEpoch$2, Errors error$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered ", " trying to fetch transaction metadata for ", " with coordinator epoch ", "; cancel sending markers to its partition leaders"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error$1, transactionalId$2, BoxesRunTime.boxToInteger((int)coordinatorEpoch$2)}));
    }

    public static final /* synthetic */ String $anonfun$addTxnMarkersToBrokerQueue$5(int coordinatorEpoch$2, CoordinatorEpochAndTxnMetadata epochAndMetadata$2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cached metadata has changed to ", " (old coordinator epoch is ", ") since preparing to send markers; cancel sending markers to its partition leaders"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{epochAndMetadata$2, BoxesRunTime.boxToInteger((int)coordinatorEpoch$2)}));
    }

    public static final /* synthetic */ String $anonfun$addTxnMarkersToBrokerQueue$6(String transactionalId$2, Set x3$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find leader endpoint for partitions ", " while trying to send transaction markers for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x3$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", these partitions are likely deleted already and hence can be skipped"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$2}));
    }

    public static final /* synthetic */ void $anonfun$addTxnMarkersToBrokerQueue$7(TransactionMetadata txnMetadata$2, Set x3$1) {
        x3$1.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            txnMetadata$2.removePartition(topicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$addTxnMarkersToBrokerQueue$9(String errorMsg$4) {
        return errorMsg$4;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Object $anonfun$addTxnMarkersToBrokerQueue$3(TransactionMarkerChannelManager $this, String transactionalId$2, long producerId$1, short producerEpoch$1, TransactionResult result$1, int coordinatorEpoch$2, int txnTopicPartition$1, Tuple2 x$6) {
        block9: {
            block7: {
                block10: {
                    block12: {
                        block11: {
                            block8: {
                                var12_8 = x$6;
                                if (var12_8 == null) break block7;
                                broker = (Option)var12_8._1();
                                topicPartitions = (Set)var12_8._2();
                                if (broker == null) break block7;
                                var15_11 = broker;
                                if (topicPartitions == null) break block7;
                                var16_12 = topicPartitions;
                                var17_13 = var15_11;
                                if (!(var17_13 instanceof Some)) break block8;
                                var18_14 = (Some)var17_13;
                                brokerNode = (Node)var18_14.value();
                                marker = new WriteTxnMarkersRequest.TxnMarkerEntry(producerId$1, producerEpoch$1, coordinatorEpoch$2, result$1, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)var16_12.toList()).asJava());
                                txnIdAndMarker = new TxnIdAndMarkerEntry(transactionalId$2, marker);
                                v0 = brokerNode;
                                var22_18 = Node.noNode();
                                if (!(v0 != null ? v0.equals(var22_18) == false : var22_18 != null)) {
                                    $this.kafka$coordinator$transaction$TransactionMarkerChannelManager$$markersQueueForUnknownBroker().addMarkers(txnTopicPartition$1, txnIdAndMarker);
                                    v1 = BoxedUnit.UNIT;
                                } else {
                                    $this.addMarkersForBroker(brokerNode, txnTopicPartition$1, txnIdAndMarker);
                                    v1 = BoxedUnit.UNIT;
                                }
                                var10_19 = v1;
                                break block9;
                            }
                            if (!None$.MODULE$.equals(var17_13)) break block10;
                            var23_20 = false;
                            var24_21 = null;
                            var25_22 = $this.txnStateManager.getTransactionState(transactionalId$2);
                            if (!(var25_22 instanceof Left)) break block11;
                            var26_23 = (Left)var25_22;
                            error = (Errors)var26_23.value();
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addTxnMarkersToBrokerQueue$4(java.lang.String int org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$2, (int)coordinatorEpoch$2, (Errors)error));
                            var11_25 = $this.txnMarkerPurgatory.cancelForKey(transactionalId$2);
                            break block12;
                        }
                        if (!(var25_22 instanceof Right)) ** GOTO lbl-1000
                        var23_20 = true;
                        var24_21 = (Right)var25_22;
                        var28_26 = (Option)var24_21.value();
                        if (var28_26 instanceof Some) {
                            var29_27 = (Some)var28_26;
                            epochAndMetadata = (CoordinatorEpochAndTxnMetadata)var29_27.value();
                            if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$2) {
                                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addTxnMarkersToBrokerQueue$5(int kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata ), ()Ljava/lang/String;)((int)coordinatorEpoch$2, (CoordinatorEpochAndTxnMetadata)epochAndMetadata));
                                v2 /* !! */  = $this.txnMarkerPurgatory.cancelForKey(transactionalId$2);
                            } else {
                                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addTxnMarkersToBrokerQueue$6(java.lang.String scala.collection.immutable.Set ), ()Ljava/lang/String;)((String)transactionalId$2, (Set)var16_12));
                                txnMetadata = epochAndMetadata.transactionMetadata();
                                txnMetadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$addTxnMarkersToBrokerQueue$7(kafka.coordinator.transaction.TransactionMetadata scala.collection.immutable.Set ), ()V)((TransactionMetadata)txnMetadata, (Set)var16_12));
                                v2 /* !! */  = BoxesRunTime.boxToInteger((int)$this.txnMarkerPurgatory.checkAndComplete(transactionalId$2));
                            }
                            var11_25 = v2 /* !! */ ;
                        } else lbl-1000:
                        // 2 sources

                        {
                            if (var23_20 && None$.MODULE$.equals(var32_30 = (Option)var24_21.value())) {
                                errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The coordinator still owns the transaction partition for ", ", but there is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$2})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no metadata in the cache; this is not expected"})).s((Seq)Nil$.MODULE$);
                                $this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addTxnMarkersToBrokerQueue$9(java.lang.String ), ()Ljava/lang/String;)((String)errorMsg));
                                throw new IllegalStateException(errorMsg);
                            }
                            throw new MatchError(var25_22);
                        }
                    }
                    var10_19 = var11_25;
                    break block9;
                }
                throw new MatchError((Object)var17_13);
            }
            throw new MatchError((Object)var12_8);
        }
        var9_32 = var10_19;
        return var9_32;
    }

    public static final /* synthetic */ boolean $anonfun$removeMarkersForTxnTopicPartition$2(TxnIdAndMarkerEntry check$ifrefutable$3) {
        TxnIdAndMarkerEntry txnIdAndMarkerEntry = check$ifrefutable$3;
        boolean bl = txnIdAndMarkerEntry != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$1(TransactionMarkerChannelManager $this, BlockingQueue queue) {
        ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)queue).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$2(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            $this.removeMarkersForTxnId(entry.txnId());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$removeMarkersForTxnTopicPartition$6(TxnIdAndMarkerEntry check$ifrefutable$4) {
        TxnIdAndMarkerEntry txnIdAndMarkerEntry = check$ifrefutable$4;
        boolean bl = txnIdAndMarkerEntry != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$5(TransactionMarkerChannelManager $this, BlockingQueue queue) {
        ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)queue).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$6(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            $this.removeMarkersForTxnId(entry.txnId());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$4(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TxnMarkerQueue brokerQueue = (TxnMarkerQueue)tuple2._2();
        brokerQueue.removeMarkersForTxnTopicPartition(txnTopicPartitionId$1).foreach((Function1 & Serializable & scala.Serializable)queue -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$5($this, queue);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public TransactionMarkerChannelManager(KafkaConfig config, MetadataCache metadataCache, NetworkClient networkClient, TransactionStateManager txnStateManager, DelayedOperationPurgatory<DelayedTxnMarker> txnMarkerPurgatory, Time time) {
        this.metadataCache = metadataCache;
        this.txnStateManager = txnStateManager;
        this.txnMarkerPurgatory = txnMarkerPurgatory;
        super("TxnMarkerSenderThread-" + config.brokerId(), networkClient, time, InterBrokerSendThread$.MODULE$.$lessinit$greater$default$4());
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq("[Transaction Marker Channel Manager " + config.brokerId() + "]: ");
        this.interBrokerListenerName = config.interBrokerListenerName();
        this.markersQueuePerBroker = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.kafka$coordinator$transaction$TransactionMarkerChannelManager$$markersQueueForUnknownBroker = new TxnMarkerQueue(Node.noNode());
        this.kafka$coordinator$transaction$TransactionMarkerChannelManager$$txnLogAppendRetryQueue = new LinkedBlockingQueue();
        this.newGauge("UnknownDestinationQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ TransactionMarkerChannelManager $outer;

            public int value() {
                return this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManager$$markersQueueForUnknownBroker().totalNumMarkers();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("LogAppendRetryQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ TransactionMarkerChannelManager $outer;

            public int value() {
                return this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManager$$txnLogAppendRetryQueue().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

