/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import kafka.admin.AclCommand;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Alter$;
import kafka.security.auth.AlterConfigs$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Cluster$;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Describe$;
import kafka.security.auth.DescribeConfigs$;
import kafka.security.auth.Group$;
import kafka.security.auth.IdempotentWrite$;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.Topic$;
import kafka.security.auth.TransactionalId$;
import kafka.security.auth.Write$;
import kafka.server.KafkaConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Utils;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;

public final class AclCommand$ {
    public static AclCommand$ MODULE$;
    private final String Newline;
    private final scala.collection.immutable.Map<ResourceType, Set<Operation>> ResourceTypeToValidOperations;

    static {
        new AclCommand$();
    }

    public String Newline() {
        return this.Newline;
    }

    public scala.collection.immutable.Map<ResourceType, Set<Operation>> ResourceTypeToValidOperations() {
        return this.ResourceTypeToValidOperations;
    }

    public void main(String[] args) {
        AclCommand.AclCommandOptions opts = new AclCommand.AclCommandOptions(args);
        if (opts.options().has((OptionSpec)opts.helpOpt())) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Usage:");
        }
        opts.checkArgs();
        try {
            if (opts.options().has((OptionSpec)opts.addOpt())) {
                this.addAcl(opts);
            } else if (opts.options().has((OptionSpec)opts.removeOpt())) {
                this.removeAcl(opts);
            } else if (opts.options().has((OptionSpec)opts.listOpt())) {
                this.listAcl(opts);
            }
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing ACL command: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()})));
            Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)e));
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public void withAuthorizer(AclCommand.AclCommandOptions opts, Function1<Authorizer, BoxedUnit> f) {
        scala.collection.immutable.Map map;
        scala.collection.immutable.Map defaultProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkEnableSecureAclsProp()), (Object)BoxesRunTime.boxToBoolean((boolean)JaasUtils.isZkSecurityEnabled()))}));
        if (opts.options().has(opts.authorizerPropertiesOpt())) {
            Buffer authorizerProperties = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.authorizerPropertiesOpt())).asScala();
            map = defaultProps.$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)authorizerProperties, false)).asScala());
        } else {
            map = defaultProps;
        }
        scala.collection.immutable.Map authorizerProperties = map;
        String authorizerClass = (String)opts.options().valueOf(opts.authorizerOpt());
        Authorizer authZ = (Authorizer)CoreUtils$.MODULE$.createObject(authorizerClass, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[0]));
        try {
            authZ.configure((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)authorizerProperties).asJava());
            f.apply((Object)authZ);
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> authZ.close());
        }
    }

    private void addAcl(AclCommand.AclCommandOptions opts) {
        this.withAuthorizer(opts, (Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
            AclCommand$.$anonfun$addAcl$1(this, opts, authorizer);
            return BoxedUnit.UNIT;
        });
    }

    private void removeAcl(AclCommand.AclCommandOptions opts) {
        this.withAuthorizer(opts, (Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
            AclCommand$.$anonfun$removeAcl$1(this, opts, authorizer);
            return BoxedUnit.UNIT;
        });
    }

    private void listAcl(AclCommand.AclCommandOptions opts) {
        this.withAuthorizer(opts, (Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
            AclCommand$.$anonfun$listAcl$1(this, opts, authorizer);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Map<Resource, Set<Acl>> getResourceToAcls(AclCommand.AclCommandOptions opts) {
        ObjectRef resourceToAcls = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        if (!opts.options().has((OptionSpec)opts.producerOpt()) && !opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = ((scala.collection.immutable.Map)resourceToAcls.elem).$plus$plus(this.getCliResourceToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.producerOpt())) {
            resourceToAcls.elem = ((scala.collection.immutable.Map)resourceToAcls.elem).$plus$plus(this.getProducerResourceToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = ((scala.collection.immutable.Map)resourceToAcls.elem).$plus$plus((GenTraversableOnce)this.getConsumerResourceToAcls(opts).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Resource k = (Resource)tuple2._1();
                Set v = (Set)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((GenTraversableOnce)((scala.collection.immutable.Map)resourceToAcls$1.elem).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom()));
        }
        this.validateOperation(opts, (scala.collection.immutable.Map<Resource, Set<Acl>>)((scala.collection.immutable.Map)resourceToAcls.elem));
        return (scala.collection.immutable.Map)resourceToAcls.elem;
    }

    private scala.collection.immutable.Map<Resource, Set<Acl>> getProducerResourceToAcls(AclCommand.AclCommandOptions opts) {
        Set topics = (Set)this.getResource(opts, this.getResource$default$2()).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getProducerResourceToAcls$1(x$8)));
        Set transactionalIds = (Set)this.getResource(opts, this.getResource$default$2()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getProducerResourceToAcls$2(x$9)));
        boolean enableIdempotence = opts.options().has((OptionSpec)opts.idempotentOpt());
        Set<Acl> acls = this.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Write$.MODULE$, Describe$.MODULE$}))));
        return ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$10), (Object)acls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)transactionalIds.map((Function1 & Serializable & scala.Serializable)x$11 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$11), (Object)acls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Resource$.MODULE$.ClusterResource()), (Object)this.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Create$.MODULE$})))).$plus$plus((GenTraversableOnce)(enableIdempotence ? this.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{IdempotentWrite$.MODULE$})))) : Predef$.MODULE$.Set().empty()))));
    }

    private scala.collection.immutable.Map<Resource, Set<Acl>> getConsumerResourceToAcls(AclCommand.AclCommandOptions opts) {
        Set<Resource> resources = this.getResource(opts, this.getResource$default$2());
        Set topics = (Set)this.getResource(opts, this.getResource$default$2()).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getConsumerResourceToAcls$1(x$12)));
        Set groups = (Set)resources.filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getConsumerResourceToAcls$2(x$13)));
        Set<Acl> acls = this.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Describe$.MODULE$}))));
        return ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)x$14 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$14), (Object)acls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)groups.map((Function1 & Serializable & scala.Serializable)x$15 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$15), this.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$}))))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    private scala.collection.immutable.Map<Resource, Set<Acl>> getCliResourceToAcls(AclCommand.AclCommandOptions opts) {
        Set<Acl> acls = this.getAcl(opts);
        Set<Resource> resources = this.getResource(opts, this.getResource$default$2());
        return ((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x$16 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$16), (Object)acls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Set<Acl> getAcl(AclCommand.AclCommandOptions opts, Set<Operation> operations) {
        Set<KafkaPrincipal> allowedPrincipals = this.getPrincipals(opts, opts.allowPrincipalsOpt());
        Set<KafkaPrincipal> deniedPrincipals = this.getPrincipals(opts, opts.denyPrincipalsOpt());
        Set<String> allowedHosts = this.getHosts(opts, opts.allowHostsOpt(), opts.allowPrincipalsOpt());
        Set<String> deniedHosts = this.getHosts(opts, opts.denyHostsOpt(), opts.denyPrincipalsOpt());
        HashSet acls = new HashSet();
        Object object = allowedHosts.nonEmpty() && allowedPrincipals.nonEmpty() ? acls.$plus$plus$eq(this.getAcls(allowedPrincipals, Allow$.MODULE$, operations, allowedHosts)) : BoxedUnit.UNIT;
        Object object2 = deniedHosts.nonEmpty() && deniedPrincipals.nonEmpty() ? acls.$plus$plus$eq(this.getAcls(deniedPrincipals, Deny$.MODULE$, operations, deniedHosts)) : BoxedUnit.UNIT;
        return acls.toSet();
    }

    private Set<Acl> getAcl(AclCommand.AclCommandOptions opts) {
        Set operations = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.operationsOpt())).asScala()).map((Function1 & Serializable & scala.Serializable)operation -> Operation$.MODULE$.fromString(operation.trim()), Buffer$.MODULE$.canBuildFrom())).toSet();
        return this.getAcl(opts, (Set<Operation>)operations);
    }

    public Set<Acl> getAcls(Set<KafkaPrincipal> principals, PermissionType permissionType, Set<Operation> operations, Set<String> hosts) {
        return (Set)principals.flatMap((Function1 & Serializable & scala.Serializable)principal -> (Set)operations.flatMap((Function1 & Serializable & scala.Serializable)operation -> (Set)hosts.map((Function1 & Serializable & scala.Serializable)host -> new Acl((KafkaPrincipal)principal, permissionType, (String)host, (Operation)operation), Set$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom());
    }

    private Set<String> getHosts(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> hostOptionSpec, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(hostOptionSpec) ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(hostOptionSpec)).asScala()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.trim(), Buffer$.MODULE$.canBuildFrom())).toSet() : (opts.options().has(principalOptionSpec) ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Acl$.MODULE$.WildCardHost()})) : Predef$.MODULE$.Set().empty());
    }

    private Set<KafkaPrincipal> getPrincipals(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(principalOptionSpec) ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(principalOptionSpec)).asScala()).map((Function1 & Serializable & scala.Serializable)s -> KafkaPrincipal.fromString((String)s.trim()), Buffer$.MODULE$.canBuildFrom())).toSet() : Predef$.MODULE$.Set().empty();
    }

    private Set<Resource> getResource(AclCommand.AclCommandOptions opts, boolean dieIfNoResourceFound) {
        ObjectRef resources = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        if (opts.options().has(opts.topicOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.topicOpt())).asScala()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
                resources.elem = (Set)((Set)resources.elem).$plus((Object)new Resource(Topic$.MODULE$, topic.trim()));
                return BoxedUnit.UNIT;
            });
        }
        if (opts.options().has((OptionSpec)opts.clusterOpt()) || opts.options().has((OptionSpec)opts.idempotentOpt())) {
            resources.elem = (Set)((Set)resources.elem).$plus((Object)Resource$.MODULE$.ClusterResource());
        }
        if (opts.options().has(opts.groupOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.groupOpt())).asScala()).foreach((Function1 & Serializable & scala.Serializable)group -> {
                resources.elem = (Set)((Set)resources.elem).$plus((Object)new Resource(Group$.MODULE$, group.trim()));
                return BoxedUnit.UNIT;
            });
        }
        if (opts.options().has(opts.transactionalIdOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.transactionalIdOpt())).asScala()).foreach((Function1 & Serializable & scala.Serializable)transactionalId -> {
                resources.elem = (Set)((Set)resources.elem).$plus((Object)new Resource(TransactionalId$.MODULE$, transactionalId));
                return BoxedUnit.UNIT;
            });
        }
        if (((Set)resources.elem).isEmpty() && dieIfNoResourceFound) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "You must provide at least one resource: --topic <topic> or --cluster or --group <group>");
        }
        return (Set)resources.elem;
    }

    private boolean getResource$default$2() {
        return true;
    }

    private boolean confirmAction(AclCommand.AclCommandOptions opts, String msg) {
        if (opts.options().has((OptionSpec)opts.forceOpt())) {
            return true;
        }
        Predef$.MODULE$.println((Object)msg);
        return Console$.MODULE$.readLine().equalsIgnoreCase("y");
    }

    private void validateOperation(AclCommand.AclCommandOptions opts, scala.collection.immutable.Map<Resource, Set<Acl>> resourceToAcls) {
        resourceToAcls.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$validateOperation$1(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            AclCommand$.$anonfun$validateOperation$2(this, opts, x$19);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$addAcl$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addAcl$4(AclCommand$ $this, Authorizer authorizer$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Resource resource = (Resource)tuple2._1();
        Set acls = (Set)tuple2._2();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding ACLs for resource `", "`: ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource, $this.Newline(), ((TraversableOnce)acls.map((Function1 & Serializable & scala.Serializable)x$2 -> "\t" + x$2, Set$.MODULE$.canBuildFrom())).mkString($this.Newline()), $this.Newline()})));
        authorizer$1.addAcls((Set<Acl>)acls, resource);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$addAcl$1(AclCommand$ $this, AclCommand.AclCommandOptions opts$1, Authorizer authorizer) {
        scala.collection.immutable.Map<Resource, Set<Acl>> resourceToAcl = $this.getResourceToAcls(opts$1);
        if (resourceToAcl.values().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty()))) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts$1.parser(), "You must specify one of: --allow-principal, --deny-principal when trying to add ACLs.");
        }
        resourceToAcl.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$addAcl$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            AclCommand$.$anonfun$addAcl$4($this, authorizer, x$3);
            return BoxedUnit.UNIT;
        });
        $this.listAcl(opts$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeAcl$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$removeAcl$1(AclCommand$ $this, AclCommand.AclCommandOptions opts$2, Authorizer authorizer) {
        scala.collection.immutable.Map<Resource, Set<Acl>> resourceToAcl = $this.getResourceToAcls(opts$2);
        resourceToAcl.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$removeAcl$2(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            Resource resource;
            Tuple2 tuple2 = x$5;
            if (tuple2 != null) {
                resource = (Resource)tuple2._1();
            } else {
                throw new MatchError((Object)tuple2);
            }
            Set acls = (Set)tuple2._2();
            BoxedUnit boxedUnit = acls.isEmpty() ? ($this.confirmAction(opts$2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Are you sure you want to delete all ACLs for resource `", "`? (y/n)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource}))) ? BoxesRunTime.boxToBoolean((boolean)authorizer.removeAcls(resource)) : BoxedUnit.UNIT) : ($this.confirmAction(opts$2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Are you sure you want to remove ACLs: ", " ", " ", " from resource `", "`? (y/n)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.Newline(), ((TraversableOnce)acls.map((Function1 & Serializable & scala.Serializable)x$4 -> "\t" + x$4, Set$.MODULE$.canBuildFrom())).mkString($this.Newline()), $this.Newline(), resource}))) ? BoxesRunTime.boxToBoolean((boolean)authorizer.removeAcls((Set<Acl>)acls, resource)) : BoxedUnit.UNIT);
            return boxedUnit;
        });
        $this.listAcl(opts$2);
    }

    public static final /* synthetic */ boolean $anonfun$listAcl$3(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$listAcl$4(AclCommand$ $this, Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Resource resource = (Resource)tuple2._1();
        Set acls = (Set)tuple2._2();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Current ACLs for resource `", "`: ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource, $this.Newline(), ((TraversableOnce)acls.map((Function1 & Serializable & scala.Serializable)x$6 -> "\t" + x$6, Set$.MODULE$.canBuildFrom())).mkString($this.Newline()), $this.Newline()})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$listAcl$1(AclCommand$ $this, AclCommand.AclCommandOptions opts$3, Authorizer authorizer) {
        Set<Resource> resources = $this.getResource(opts$3, false);
        Iterable resourceToAcls = resources.isEmpty() ? authorizer.getAcls() : (Iterable)resources.map((Function1 & Serializable & scala.Serializable)resource -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resource), authorizer.getAcls((Resource)resource)), Set$.MODULE$.canBuildFrom());
        resourceToAcls.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$listAcl$3(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            AclCommand$.$anonfun$listAcl$4($this, x$7);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getProducerResourceToAcls$1(Resource x$8) {
        ResourceType resourceType = x$8.resourceType();
        Topic$ topic$ = Topic$.MODULE$;
        return !(resourceType != null ? !resourceType.equals(topic$) : topic$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$getProducerResourceToAcls$2(Resource x$9) {
        ResourceType resourceType = x$9.resourceType();
        TransactionalId$ transactionalId$ = TransactionalId$.MODULE$;
        return !(resourceType != null ? !resourceType.equals(transactionalId$) : transactionalId$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsumerResourceToAcls$1(Resource x$12) {
        ResourceType resourceType = x$12.resourceType();
        Topic$ topic$ = Topic$.MODULE$;
        return !(resourceType != null ? !resourceType.equals(topic$) : topic$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsumerResourceToAcls$2(Resource x$13) {
        ResourceType resourceType = x$13.resourceType();
        Group$ group$ = Group$.MODULE$;
        return !(resourceType != null ? !resourceType.equals(group$) : group$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateOperation$1(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$validateOperation$2(AclCommand$ $this, AclCommand.AclCommandOptions opts$5, Tuple2 x$19) {
        Tuple2 tuple2 = x$19;
        if (tuple2 != null) {
            Resource resource = (Resource)tuple2._1();
            Set acls = (Set)tuple2._2();
            Set validOps = (Set)$this.ResourceTypeToValidOperations().apply((Object)resource.resourceType());
            if (((TraversableOnce)((Subtractable)acls.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.operation(), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)validOps)).nonEmpty()) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts$5.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ResourceType ", " only supports operations ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource.resourceType(), validOps.mkString(",")})));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private AclCommand$() {
        MODULE$ = this;
        this.Newline = Properties$.MODULE$.lineSeparator();
        this.ResourceTypeToValidOperations = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Topic$.MODULE$), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Describe$.MODULE$, Delete$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Group$.MODULE$), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Describe$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Cluster$.MODULE$), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Create$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TransactionalId$.MODULE$), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$, Write$.MODULE$, All$.MODULE$})))}));
    }
}

