/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.AbstractMergedSortedCacheStoreIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;

class MergedSortedCacheWindowStoreKeyValueIterator<K, V>
extends AbstractMergedSortedCacheStoreIterator<Windowed<K>, Windowed<Bytes>, V, byte[]> {
    private final StateSerdes<K, V> serdes;
    private final long windowSize;
    private final SegmentedCacheFunction cacheFunction;

    MergedSortedCacheWindowStoreKeyValueIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> filteredCacheIterator, KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator, StateSerdes<K, V> serdes, long windowSize, SegmentedCacheFunction cacheFunction) {
        super(filteredCacheIterator, underlyingIterator);
        this.serdes = serdes;
        this.windowSize = windowSize;
        this.cacheFunction = cacheFunction;
    }

    @Override
    Windowed<K> deserializeStoreKey(Windowed<Bytes> key) {
        return new Windowed<K>(this.serdes.keyFrom(key.key().get()), key.window());
    }

    @Override
    KeyValue<Windowed<K>, V> deserializeStorePair(KeyValue<Windowed<Bytes>, byte[]> pair) {
        return KeyValue.pair(this.deserializeStoreKey((Windowed)pair.key), this.serdes.valueFrom((byte[])pair.value));
    }

    @Override
    Windowed<K> deserializeCacheKey(Bytes cacheKey) {
        byte[] binaryKey = this.cacheFunction.key(cacheKey).get();
        long timestamp = WindowStoreUtils.timestampFromBinaryKey(binaryKey);
        K key = WindowStoreUtils.keyFromBinaryKey(binaryKey, this.serdes);
        return new Windowed<K>(key, WindowStoreUtils.timeWindowForSize(timestamp, this.windowSize));
    }

    @Override
    V deserializeCacheValue(LRUCacheEntry cacheEntry) {
        return this.serdes.valueFrom(cacheEntry.value);
    }

    @Override
    int compare(Bytes cacheKey, Windowed<Bytes> storeKey) {
        Bytes storeKeyBytes = WindowStoreUtils.toBinaryKey(storeKey.key().get(), storeKey.window().start(), 0);
        return this.cacheFunction.compareSegmentedKeys(cacheKey, storeKeyBytes);
    }
}

