/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.RecordQueue;
import org.apache.kafka.streams.processor.internals.StampedRecord;

public class PartitionGroup {
    private final Map<TopicPartition, RecordQueue> partitionQueues;
    private final PriorityQueue<RecordQueue> queuesByTime;
    private int totalBuffered;

    PartitionGroup(Map<TopicPartition, RecordQueue> partitionQueues) {
        this.queuesByTime = new PriorityQueue<RecordQueue>(partitionQueues.size(), new Comparator<RecordQueue>(){

            @Override
            public int compare(RecordQueue queue1, RecordQueue queue2) {
                long time2;
                long time1 = queue1.timestamp();
                if (time1 < (time2 = queue2.timestamp())) {
                    return -1;
                }
                if (time1 > time2) {
                    return 1;
                }
                return 0;
            }
        });
        this.partitionQueues = partitionQueues;
        this.totalBuffered = 0;
    }

    StampedRecord nextRecord(RecordInfo info) {
        StampedRecord record = null;
        RecordQueue queue = this.queuesByTime.poll();
        if (queue != null) {
            record = queue.poll();
            if (!queue.isEmpty()) {
                this.queuesByTime.offer(queue);
            }
        }
        info.queue = queue;
        if (record != null) {
            --this.totalBuffered;
        }
        return record;
    }

    int addRawRecords(TopicPartition partition, Iterable<ConsumerRecord<byte[], byte[]>> rawRecords) {
        RecordQueue recordQueue = this.partitionQueues.get(partition);
        int oldSize = recordQueue.size();
        int newSize = recordQueue.addRawRecords(rawRecords);
        if (oldSize == 0 && newSize > 0) {
            this.queuesByTime.offer(recordQueue);
        }
        this.totalBuffered += newSize - oldSize;
        return newSize;
    }

    public Set<TopicPartition> partitions() {
        return Collections.unmodifiableSet(this.partitionQueues.keySet());
    }

    public long timestamp() {
        long timestamp = Long.MAX_VALUE;
        for (RecordQueue queue : this.partitionQueues.values()) {
            if (timestamp <= queue.timestamp()) continue;
            timestamp = queue.timestamp();
        }
        return timestamp;
    }

    int numBuffered(TopicPartition partition) {
        RecordQueue recordQueue = this.partitionQueues.get(partition);
        if (recordQueue == null) {
            throw new IllegalStateException("Record's partition does not belong to this partition-group.");
        }
        return recordQueue.size();
    }

    int numBuffered() {
        return this.totalBuffered;
    }

    public void close() {
        this.queuesByTime.clear();
        this.partitionQueues.clear();
    }

    public void clear() {
        this.queuesByTime.clear();
        for (RecordQueue queue : this.partitionQueues.values()) {
            queue.clear();
        }
    }

    public static class RecordInfo {
        RecordQueue queue;

        public ProcessorNode node() {
            return this.queue.source();
        }

        public TopicPartition partition() {
            return this.queue.partition();
        }

        RecordQueue queue() {
            return this.queue;
        }
    }
}

