/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.resource;

import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.Assert;
import org.junit.Test;

public class ResourceFilterTest {
    @Test
    public void shouldNotMatchIfDifferentResourceType() {
        Assert.assertFalse((boolean)new ResourceFilter(ResourceType.TOPIC, "Name").matches(new Resource(ResourceType.GROUP, "Name")));
    }

    @Test
    public void shouldNotMatchIfDifferentName() {
        Assert.assertFalse((boolean)new ResourceFilter(ResourceType.TOPIC, "Different").matches(new Resource(ResourceType.TOPIC, "Name")));
    }

    @Test
    public void shouldNotMatchIfDifferentNameCase() {
        Assert.assertFalse((boolean)new ResourceFilter(ResourceType.TOPIC, "NAME").matches(new Resource(ResourceType.TOPIC, "Name")));
    }

    @Test
    public void shouldMatchWhereResourceTypeIsAny() {
        Assert.assertTrue((boolean)new ResourceFilter(ResourceType.ANY, "Name").matches(new Resource(ResourceType.TOPIC, "Name")));
    }

    @Test
    public void shouldMatchWhereResourceNameIsAny() {
        Assert.assertTrue((boolean)new ResourceFilter(ResourceType.TOPIC, null).matches(new Resource(ResourceType.TOPIC, "Name")));
    }

    @Test
    public void shouldMatchIfExactMatch() {
        Assert.assertTrue((boolean)new ResourceFilter(ResourceType.TOPIC, "Name").matches(new Resource(ResourceType.TOPIC, "Name")));
    }

    @Test
    public void shouldMatchWildcardIfExactMatch() {
        Assert.assertTrue((boolean)new ResourceFilter(ResourceType.TOPIC, "*").matches(new Resource(ResourceType.TOPIC, "*")));
    }

    @Test
    public void shouldNotMatchWildcardAgainstOtherName() {
        Assert.assertFalse((boolean)new ResourceFilter(ResourceType.TOPIC, "Name").matches(new Resource(ResourceType.TOPIC, "*")));
    }

    @Test
    public void shouldNotMatchLiteralWildcardTheWayAround() {
        Assert.assertFalse((boolean)new ResourceFilter(ResourceType.TOPIC, "*").matches(new Resource(ResourceType.TOPIC, "Name")));
    }
}

