/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;

public abstract class RecordProcessor {
    protected JobConf jconf;
    protected Map<String, LogicalInput> inputs;
    protected Map<String, LogicalOutput> outputs;
    protected Map<String, OutputCollector> outMap;
    protected ProcessorContext processorContext;
    public static final Log l4j = LogFactory.getLog(RecordProcessor.class);
    protected boolean isLogInfoEnabled = false;
    protected boolean isLogTraceEnabled = false;
    protected MRTaskReporter reporter;
    protected PerfLogger perfLogger = PerfLogger.getPerfLogger();
    protected String CLASS_NAME = RecordProcessor.class.getName();

    void init(JobConf jconf, ProcessorContext processorContext, MRTaskReporter mrReporter, Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        this.jconf = jconf;
        this.reporter = mrReporter;
        this.inputs = inputs;
        this.outputs = outputs;
        this.processorContext = processorContext;
        this.isLogInfoEnabled = l4j.isInfoEnabled();
        this.isLogTraceEnabled = l4j.isTraceEnabled();
        try {
            if (l4j.isDebugEnabled()) {
                l4j.debug((Object)("conf classpath = " + Arrays.asList(((URLClassLoader)jconf.getClassLoader()).getURLs())));
                l4j.debug((Object)("thread classpath = " + Arrays.asList(((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs())));
            }
        }
        catch (Exception e) {
            l4j.info((Object)("cannot get classpath: " + e.getMessage()));
        }
    }

    abstract void run() throws Exception;

    abstract void close();

    protected void createOutputMap() {
        Preconditions.checkState(this.outMap == null, "Outputs should only be setup once");
        this.outMap = Maps.newHashMap();
        for (Map.Entry<String, LogicalOutput> entry : this.outputs.entrySet()) {
            TezProcessor.TezKVOutputCollector collector = new TezProcessor.TezKVOutputCollector(entry.getValue());
            this.outMap.put(entry.getKey(), collector);
        }
    }
}

