/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.PreemptionMessage;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerStatusPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NMTokenPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeReportPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PreemptionMessagePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.TokenPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AllocateResponsePBImpl
extends AllocateResponse {
    YarnServiceProtos.AllocateResponseProto proto = YarnServiceProtos.AllocateResponseProto.getDefaultInstance();
    YarnServiceProtos.AllocateResponseProto.Builder builder = null;
    boolean viaProto = false;
    Resource limit;
    private List<Container> allocatedContainers = null;
    private List<NMToken> nmTokens = null;
    private List<ContainerStatus> completedContainersStatuses = null;
    private List<Container> increasedContainers = null;
    private List<Container> decreasedContainers = null;
    private List<NodeReport> updatedNodes = null;
    private PreemptionMessage preempt;
    private Token amrmToken = null;
    private Priority appPriority = null;

    public AllocateResponsePBImpl() {
        this.builder = YarnServiceProtos.AllocateResponseProto.newBuilder();
    }

    public AllocateResponsePBImpl(YarnServiceProtos.AllocateResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnServiceProtos.AllocateResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((AllocateResponsePBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private synchronized void mergeLocalToBuilder() {
        Iterable<YarnProtos.ContainerProto> iterable;
        if (this.allocatedContainers != null) {
            this.builder.clearAllocatedContainers();
            iterable = this.getContainerProtoIterable(this.allocatedContainers);
            this.builder.addAllAllocatedContainers(iterable);
        }
        if (this.nmTokens != null) {
            this.builder.clearNmTokens();
            iterable = this.getTokenProtoIterable(this.nmTokens);
            this.builder.addAllNmTokens(iterable);
        }
        if (this.completedContainersStatuses != null) {
            this.builder.clearCompletedContainerStatuses();
            iterable = this.getContainerStatusProtoIterable(this.completedContainersStatuses);
            this.builder.addAllCompletedContainerStatuses(iterable);
        }
        if (this.updatedNodes != null) {
            this.builder.clearUpdatedNodes();
            iterable = this.getNodeReportProtoIterable(this.updatedNodes);
            this.builder.addAllUpdatedNodes(iterable);
        }
        if (this.limit != null) {
            this.builder.setLimit(this.convertToProtoFormat(this.limit));
        }
        if (this.preempt != null) {
            this.builder.setPreempt(this.convertToProtoFormat(this.preempt));
        }
        if (this.increasedContainers != null) {
            this.builder.clearIncreasedContainers();
            iterable = this.getContainerProtoIterable(this.increasedContainers);
            this.builder.addAllIncreasedContainers(iterable);
        }
        if (this.decreasedContainers != null) {
            this.builder.clearDecreasedContainers();
            iterable = this.getContainerProtoIterable(this.decreasedContainers);
            this.builder.addAllDecreasedContainers(iterable);
        }
        if (this.amrmToken != null) {
            this.builder.setAmRmToken(this.convertToProtoFormat(this.amrmToken));
        }
        if (this.appPriority != null) {
            this.builder.setApplicationPriority(this.convertToProtoFormat(this.appPriority));
        }
    }

    private synchronized void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.AllocateResponseProto.newBuilder((YarnServiceProtos.AllocateResponseProto)this.proto);
        }
        this.viaProto = false;
    }

    public synchronized AMCommand getAMCommand() {
        YarnServiceProtos.AllocateResponseProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasAMCommand()) {
            return null;
        }
        return ProtoUtils.convertFromProtoFormat(p.getAMCommand());
    }

    public synchronized void setAMCommand(AMCommand command) {
        this.maybeInitBuilder();
        if (command == null) {
            this.builder.clearAMCommand();
            return;
        }
        this.builder.setAMCommand(ProtoUtils.convertToProtoFormat(command));
    }

    public synchronized int getResponseId() {
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        return p.getResponseId();
    }

    public synchronized void setResponseId(int responseId) {
        this.maybeInitBuilder();
        this.builder.setResponseId(responseId);
    }

    public synchronized Resource getAvailableResources() {
        YarnServiceProtos.AllocateResponseProto p;
        if (this.limit != null) {
            return this.limit;
        }
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasLimit()) {
            return null;
        }
        this.limit = this.convertFromProtoFormat(p.getLimit());
        return this.limit;
    }

    public synchronized void setAvailableResources(Resource limit) {
        this.maybeInitBuilder();
        if (limit == null) {
            this.builder.clearLimit();
        }
        this.limit = limit;
    }

    public synchronized List<NodeReport> getUpdatedNodes() {
        this.initLocalNewNodeReportList();
        return this.updatedNodes;
    }

    public synchronized void setUpdatedNodes(List<NodeReport> updatedNodes) {
        if (updatedNodes == null) {
            this.updatedNodes.clear();
            return;
        }
        this.updatedNodes = new ArrayList<NodeReport>(updatedNodes.size());
        this.updatedNodes.addAll(updatedNodes);
    }

    public synchronized List<Container> getAllocatedContainers() {
        this.initLocalNewContainerList();
        return this.allocatedContainers;
    }

    public synchronized void setAllocatedContainers(List<Container> containers) {
        if (containers == null) {
            return;
        }
        this.initLocalNewContainerList();
        this.allocatedContainers.addAll(containers);
    }

    public synchronized List<Container> getIncreasedContainers() {
        this.initLocalIncreasedContainerList();
        return this.increasedContainers;
    }

    public synchronized void setIncreasedContainers(List<Container> containers) {
        if (containers == null) {
            return;
        }
        this.initLocalIncreasedContainerList();
        this.increasedContainers.addAll(containers);
    }

    public synchronized List<Container> getDecreasedContainers() {
        this.initLocalDecreasedContainerList();
        return this.decreasedContainers;
    }

    public synchronized void setDecreasedContainers(List<Container> containers) {
        if (containers == null) {
            return;
        }
        this.initLocalDecreasedContainerList();
        this.decreasedContainers.addAll(containers);
    }

    public synchronized List<ContainerStatus> getCompletedContainersStatuses() {
        this.initLocalFinishedContainerList();
        return this.completedContainersStatuses;
    }

    public synchronized void setCompletedContainersStatuses(List<ContainerStatus> containers) {
        if (containers == null) {
            return;
        }
        this.initLocalFinishedContainerList();
        this.completedContainersStatuses.addAll(containers);
    }

    public synchronized void setNMTokens(List<NMToken> nmTokens) {
        if (nmTokens == null || nmTokens.isEmpty()) {
            if (this.nmTokens != null) {
                this.nmTokens.clear();
            }
            this.builder.clearNmTokens();
            return;
        }
        this.initLocalNewNMTokenList();
        this.nmTokens.addAll(nmTokens);
    }

    public synchronized List<NMToken> getNMTokens() {
        this.initLocalNewNMTokenList();
        return this.nmTokens;
    }

    public synchronized int getNumClusterNodes() {
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        return p.getNumClusterNodes();
    }

    public synchronized void setNumClusterNodes(int numNodes) {
        this.maybeInitBuilder();
        this.builder.setNumClusterNodes(numNodes);
    }

    public synchronized PreemptionMessage getPreemptionMessage() {
        YarnServiceProtos.AllocateResponseProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.preempt != null) {
            return this.preempt;
        }
        if (!p.hasPreempt()) {
            return null;
        }
        this.preempt = this.convertFromProtoFormat(p.getPreempt());
        return this.preempt;
    }

    public synchronized void setPreemptionMessage(PreemptionMessage preempt) {
        this.maybeInitBuilder();
        if (null == preempt) {
            this.builder.clearPreempt();
        }
        this.preempt = preempt;
    }

    public synchronized Token getAMRMToken() {
        YarnServiceProtos.AllocateResponseProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.amrmToken != null) {
            return this.amrmToken;
        }
        if (!p.hasAmRmToken()) {
            return null;
        }
        this.amrmToken = this.convertFromProtoFormat(p.getAmRmToken());
        return this.amrmToken;
    }

    public synchronized void setAMRMToken(Token amRMToken) {
        this.maybeInitBuilder();
        if (amRMToken == null) {
            this.builder.clearAmRmToken();
        }
        this.amrmToken = amRMToken;
    }

    public synchronized String getCollectorAddr() {
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        return p.getCollectorAddr();
    }

    public synchronized void setCollectorAddr(String collectorAddr) {
        this.maybeInitBuilder();
        if (collectorAddr == null) {
            this.builder.clearCollectorAddr();
            return;
        }
        this.builder.setCollectorAddr(collectorAddr);
    }

    public synchronized Priority getApplicationPriority() {
        YarnServiceProtos.AllocateResponseProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.appPriority != null) {
            return this.appPriority;
        }
        if (!p.hasApplicationPriority()) {
            return null;
        }
        this.appPriority = this.convertFromProtoFormat(p.getApplicationPriority());
        return this.appPriority;
    }

    public synchronized void setApplicationPriority(Priority priority) {
        this.maybeInitBuilder();
        if (priority == null) {
            this.builder.clearApplicationPriority();
        }
        this.appPriority = priority;
    }

    private synchronized void initLocalIncreasedContainerList() {
        if (this.increasedContainers != null) {
            return;
        }
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getIncreasedContainersList();
        this.increasedContainers = new ArrayList<Container>();
        for (YarnProtos.ContainerProto c : list) {
            this.increasedContainers.add(this.convertFromProtoFormat(c));
        }
    }

    private synchronized void initLocalDecreasedContainerList() {
        if (this.decreasedContainers != null) {
            return;
        }
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getDecreasedContainersList();
        this.decreasedContainers = new ArrayList<Container>();
        for (YarnProtos.ContainerProto c : list) {
            this.decreasedContainers.add(this.convertFromProtoFormat(c));
        }
    }

    private synchronized void initLocalNewNodeReportList() {
        if (this.updatedNodes != null) {
            return;
        }
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getUpdatedNodesList();
        this.updatedNodes = new ArrayList<NodeReport>(list.size());
        for (YarnProtos.NodeReportProto n : list) {
            this.updatedNodes.add(this.convertFromProtoFormat(n));
        }
    }

    private synchronized void initLocalNewContainerList() {
        if (this.allocatedContainers != null) {
            return;
        }
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getAllocatedContainersList();
        this.allocatedContainers = new ArrayList<Container>();
        for (YarnProtos.ContainerProto c : list) {
            this.allocatedContainers.add(this.convertFromProtoFormat(c));
        }
    }

    private synchronized void initLocalNewNMTokenList() {
        if (this.nmTokens != null) {
            return;
        }
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getNmTokensList();
        this.nmTokens = new ArrayList<NMToken>();
        for (YarnServiceProtos.NMTokenProto t : list) {
            this.nmTokens.add(this.convertFromProtoFormat(t));
        }
    }

    private synchronized Iterable<YarnProtos.ContainerProto> getContainerProtoIterable(final List<Container> newContainersList) {
        this.maybeInitBuilder();
        return new Iterable<YarnProtos.ContainerProto>(){

            @Override
            public synchronized Iterator<YarnProtos.ContainerProto> iterator() {
                return new Iterator<YarnProtos.ContainerProto>(){
                    Iterator<Container> iter;
                    {
                        this.iter = newContainersList.iterator();
                    }

                    @Override
                    public synchronized boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public synchronized YarnProtos.ContainerProto next() {
                        return AllocateResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public synchronized void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private synchronized Iterable<YarnServiceProtos.NMTokenProto> getTokenProtoIterable(final List<NMToken> nmTokenList) {
        this.maybeInitBuilder();
        return new Iterable<YarnServiceProtos.NMTokenProto>(){

            @Override
            public synchronized Iterator<YarnServiceProtos.NMTokenProto> iterator() {
                return new Iterator<YarnServiceProtos.NMTokenProto>(){
                    Iterator<NMToken> iter;
                    {
                        this.iter = nmTokenList.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnServiceProtos.NMTokenProto next() {
                        return AllocateResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private synchronized Iterable<YarnProtos.ContainerStatusProto> getContainerStatusProtoIterable(final List<ContainerStatus> newContainersList) {
        this.maybeInitBuilder();
        return new Iterable<YarnProtos.ContainerStatusProto>(){

            @Override
            public synchronized Iterator<YarnProtos.ContainerStatusProto> iterator() {
                return new Iterator<YarnProtos.ContainerStatusProto>(){
                    Iterator<ContainerStatus> iter;
                    {
                        this.iter = newContainersList.iterator();
                    }

                    @Override
                    public synchronized boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public synchronized YarnProtos.ContainerStatusProto next() {
                        return AllocateResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public synchronized void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private synchronized Iterable<YarnProtos.NodeReportProto> getNodeReportProtoIterable(final List<NodeReport> newNodeReportsList) {
        this.maybeInitBuilder();
        return new Iterable<YarnProtos.NodeReportProto>(){

            @Override
            public synchronized Iterator<YarnProtos.NodeReportProto> iterator() {
                return new Iterator<YarnProtos.NodeReportProto>(){
                    Iterator<NodeReport> iter;
                    {
                        this.iter = newNodeReportsList.iterator();
                    }

                    @Override
                    public synchronized boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public synchronized YarnProtos.NodeReportProto next() {
                        return AllocateResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public synchronized void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private synchronized void initLocalFinishedContainerList() {
        if (this.completedContainersStatuses != null) {
            return;
        }
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getCompletedContainerStatusesList();
        this.completedContainersStatuses = new ArrayList<ContainerStatus>();
        for (YarnProtos.ContainerStatusProto c : list) {
            this.completedContainersStatuses.add(this.convertFromProtoFormat(c));
        }
    }

    private synchronized NodeReportPBImpl convertFromProtoFormat(YarnProtos.NodeReportProto p) {
        return new NodeReportPBImpl(p);
    }

    private synchronized YarnProtos.NodeReportProto convertToProtoFormat(NodeReport t) {
        return ((NodeReportPBImpl)t).getProto();
    }

    private synchronized ContainerPBImpl convertFromProtoFormat(YarnProtos.ContainerProto p) {
        return new ContainerPBImpl(p);
    }

    private synchronized YarnProtos.ContainerProto convertToProtoFormat(Container t) {
        return ((ContainerPBImpl)t).getProto();
    }

    private synchronized ContainerStatusPBImpl convertFromProtoFormat(YarnProtos.ContainerStatusProto p) {
        return new ContainerStatusPBImpl(p);
    }

    private synchronized YarnProtos.ContainerStatusProto convertToProtoFormat(ContainerStatus t) {
        return ((ContainerStatusPBImpl)t).getProto();
    }

    private synchronized ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private synchronized YarnProtos.ResourceProto convertToProtoFormat(Resource r) {
        return ((ResourcePBImpl)r).getProto();
    }

    private synchronized PreemptionMessagePBImpl convertFromProtoFormat(YarnProtos.PreemptionMessageProto p) {
        return new PreemptionMessagePBImpl(p);
    }

    private synchronized YarnProtos.PreemptionMessageProto convertToProtoFormat(PreemptionMessage r) {
        return ((PreemptionMessagePBImpl)r).getProto();
    }

    private synchronized YarnServiceProtos.NMTokenProto convertToProtoFormat(NMToken token) {
        return ((NMTokenPBImpl)token).getProto();
    }

    private synchronized NMToken convertFromProtoFormat(YarnServiceProtos.NMTokenProto proto) {
        return new NMTokenPBImpl(proto);
    }

    private TokenPBImpl convertFromProtoFormat(SecurityProtos.TokenProto p) {
        return new TokenPBImpl(p);
    }

    private SecurityProtos.TokenProto convertToProtoFormat(Token t) {
        return ((TokenPBImpl)t).getProto();
    }

    private PriorityPBImpl convertFromProtoFormat(YarnProtos.PriorityProto p) {
        return new PriorityPBImpl(p);
    }

    private YarnProtos.PriorityProto convertToProtoFormat(Priority t) {
        return ((PriorityPBImpl)t).getProto();
    }
}

