/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Shorts;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.crypto.CipherOption;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.inotify.Event;
import org.apache.hadoop.hdfs.inotify.EventBatch;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveStats;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolStats;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeLocalInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.proto.AclProtos;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocol.proto.EncryptionZonesProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.InotifyProtos;
import org.apache.hadoop.hdfs.protocol.proto.XAttrProtos;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.LimitInputStream;

public class PBHelperClient {
    private static final XAttr.NameSpace[] XATTR_NAMESPACE_VALUES = XAttr.NameSpace.values();
    private static final AclEntryType[] ACL_ENTRY_TYPE_VALUES = AclEntryType.values();
    private static final AclEntryScope[] ACL_ENTRY_SCOPE_VALUES = AclEntryScope.values();
    private static final FsAction[] FSACTION_VALUES = FsAction.values();

    private PBHelperClient() {
    }

    public static ByteString getByteString(byte[] bytes) {
        return bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes);
    }

    public static ShortCircuitShm.ShmId convert(DataTransferProtos.ShortCircuitShmIdProto shmId) {
        return new ShortCircuitShm.ShmId(shmId.getHi(), shmId.getLo());
    }

    public static DataChecksum.Type convert(HdfsProtos.ChecksumTypeProto type) {
        return DataChecksum.Type.valueOf((int)type.getNumber());
    }

    public static HdfsProtos.ChecksumTypeProto convert(DataChecksum.Type type) {
        return HdfsProtos.ChecksumTypeProto.valueOf(type.id);
    }

    public static HdfsProtos.ExtendedBlockProto convert(ExtendedBlock b) {
        if (b == null) {
            return null;
        }
        return HdfsProtos.ExtendedBlockProto.newBuilder().setPoolId(b.getBlockPoolId()).setBlockId(b.getBlockId()).setNumBytes(b.getNumBytes()).setGenerationStamp(b.getGenerationStamp()).build();
    }

    public static SecurityProtos.TokenProto convert(Token<?> tok) {
        return SecurityProtos.TokenProto.newBuilder().setIdentifier(PBHelperClient.getByteString(tok.getIdentifier())).setPassword(PBHelperClient.getByteString(tok.getPassword())).setKind(tok.getKind().toString()).setService(tok.getService().toString()).build();
    }

    public static DataTransferProtos.ShortCircuitShmIdProto convert(ShortCircuitShm.ShmId shmId) {
        return DataTransferProtos.ShortCircuitShmIdProto.newBuilder().setHi(shmId.getHi()).setLo(shmId.getLo()).build();
    }

    public static DataTransferProtos.ShortCircuitShmSlotProto convert(ShortCircuitShm.SlotId slotId) {
        return DataTransferProtos.ShortCircuitShmSlotProto.newBuilder().setShmId(PBHelperClient.convert(slotId.getShmId())).setSlotIdx(slotId.getSlotIdx()).build();
    }

    public static HdfsProtos.DatanodeIDProto convert(DatanodeID dn) {
        return HdfsProtos.DatanodeIDProto.newBuilder().setIpAddr(dn.getIpAddr()).setHostName(dn.getHostName()).setXferPort(dn.getXferPort()).setDatanodeUuid(dn.getDatanodeUuid() != null ? dn.getDatanodeUuid() : "").setInfoPort(dn.getInfoPort()).setInfoSecurePort(dn.getInfoSecurePort()).setIpcPort(dn.getIpcPort()).build();
    }

    public static HdfsProtos.DatanodeInfoProto.AdminState convert(DatanodeInfo.AdminStates inAs) {
        switch (inAs) {
            case NORMAL: {
                return HdfsProtos.DatanodeInfoProto.AdminState.NORMAL;
            }
            case DECOMMISSION_INPROGRESS: {
                return HdfsProtos.DatanodeInfoProto.AdminState.DECOMMISSION_INPROGRESS;
            }
            case DECOMMISSIONED: {
                return HdfsProtos.DatanodeInfoProto.AdminState.DECOMMISSIONED;
            }
            case ENTERING_MAINTENANCE: {
                return HdfsProtos.DatanodeInfoProto.AdminState.ENTERING_MAINTENANCE;
            }
            case IN_MAINTENANCE: {
                return HdfsProtos.DatanodeInfoProto.AdminState.IN_MAINTENANCE;
            }
        }
        return HdfsProtos.DatanodeInfoProto.AdminState.NORMAL;
    }

    public static HdfsProtos.DatanodeInfoProto convert(DatanodeInfo info) {
        HdfsProtos.DatanodeInfoProto.Builder builder = HdfsProtos.DatanodeInfoProto.newBuilder();
        if (info.getNetworkLocation() != null) {
            builder.setLocation(info.getNetworkLocation());
        }
        if (info.getUpgradeDomain() != null) {
            builder.setUpgradeDomain(info.getUpgradeDomain());
        }
        builder.setId(PBHelperClient.convert((DatanodeID)info)).setCapacity(info.getCapacity()).setDfsUsed(info.getDfsUsed()).setRemaining(info.getRemaining()).setBlockPoolUsed(info.getBlockPoolUsed()).setCacheCapacity(info.getCacheCapacity()).setCacheUsed(info.getCacheUsed()).setLastUpdate(info.getLastUpdate()).setLastUpdateMonotonic(info.getLastUpdateMonotonic()).setXceiverCount(info.getXceiverCount()).setAdminState(PBHelperClient.convert(info.getAdminState())).build();
        return builder.build();
    }

    public static List<? extends HdfsProtos.DatanodeInfoProto> convert(DatanodeInfo[] dnInfos) {
        return PBHelperClient.convert(dnInfos, 0);
    }

    public static List<? extends HdfsProtos.DatanodeInfoProto> convert(DatanodeInfo[] dnInfos, int startIdx) {
        if (dnInfos == null) {
            return null;
        }
        ArrayList protos = Lists.newArrayListWithCapacity((int)dnInfos.length);
        for (int i = startIdx; i < dnInfos.length; ++i) {
            protos.add(PBHelperClient.convert(dnInfos[i]));
        }
        return protos;
    }

    public static List<Boolean> convert(boolean[] targetPinnings, int idx) {
        ArrayList<Boolean> pinnings = new ArrayList<Boolean>();
        if (targetPinnings == null) {
            pinnings.add(Boolean.FALSE);
        } else {
            while (idx < targetPinnings.length) {
                pinnings.add(targetPinnings[idx]);
                ++idx;
            }
        }
        return pinnings;
    }

    public static ExtendedBlock convert(HdfsProtos.ExtendedBlockProto eb) {
        if (eb == null) {
            return null;
        }
        return new ExtendedBlock(eb.getPoolId(), eb.getBlockId(), eb.getNumBytes(), eb.getGenerationStamp());
    }

    public static DatanodeLocalInfo convert(HdfsProtos.DatanodeLocalInfoProto proto) {
        return new DatanodeLocalInfo(proto.getSoftwareVersion(), proto.getConfigVersion(), proto.getUptime());
    }

    public static HdfsProtos.DatanodeInfoProto convertDatanodeInfo(DatanodeInfo di) {
        if (di == null) {
            return null;
        }
        return PBHelperClient.convert(di);
    }

    public static HdfsProtos.StorageTypeProto convertStorageType(StorageType type) {
        switch (type) {
            case DISK: {
                return HdfsProtos.StorageTypeProto.DISK;
            }
            case SSD: {
                return HdfsProtos.StorageTypeProto.SSD;
            }
            case ARCHIVE: {
                return HdfsProtos.StorageTypeProto.ARCHIVE;
            }
            case RAM_DISK: {
                return HdfsProtos.StorageTypeProto.RAM_DISK;
            }
        }
        throw new IllegalStateException("BUG: StorageType not found, type=" + type);
    }

    public static StorageType convertStorageType(HdfsProtos.StorageTypeProto type) {
        switch (type) {
            case DISK: {
                return StorageType.DISK;
            }
            case SSD: {
                return StorageType.SSD;
            }
            case ARCHIVE: {
                return StorageType.ARCHIVE;
            }
            case RAM_DISK: {
                return StorageType.RAM_DISK;
            }
        }
        throw new IllegalStateException("BUG: StorageTypeProto not found, type=" + (Object)((Object)type));
    }

    public static List<HdfsProtos.StorageTypeProto> convertStorageTypes(StorageType[] types) {
        return PBHelperClient.convertStorageTypes(types, 0);
    }

    public static List<HdfsProtos.StorageTypeProto> convertStorageTypes(StorageType[] types, int startIdx) {
        if (types == null) {
            return null;
        }
        ArrayList<HdfsProtos.StorageTypeProto> protos = new ArrayList<HdfsProtos.StorageTypeProto>(types.length);
        for (int i = startIdx; i < types.length; ++i) {
            protos.add(PBHelperClient.convertStorageType(types[i]));
        }
        return protos;
    }

    public static InputStream vintPrefixed(InputStream input) throws IOException {
        int firstByte = input.read();
        if (firstByte == -1) {
            throw new EOFException("Unexpected EOF while trying to read response from server");
        }
        int size = CodedInputStream.readRawVarint32((int)firstByte, (InputStream)input);
        assert (size >= 0);
        return new LimitInputStream(input, (long)size);
    }

    public static CipherOption convert(HdfsProtos.CipherOptionProto proto) {
        if (proto != null) {
            CipherSuite suite = null;
            if (proto.getSuite() != null) {
                suite = PBHelperClient.convert(proto.getSuite());
            }
            byte[] inKey = null;
            if (proto.getInKey() != null) {
                inKey = proto.getInKey().toByteArray();
            }
            byte[] inIv = null;
            if (proto.getInIv() != null) {
                inIv = proto.getInIv().toByteArray();
            }
            byte[] outKey = null;
            if (proto.getOutKey() != null) {
                outKey = proto.getOutKey().toByteArray();
            }
            byte[] outIv = null;
            if (proto.getOutIv() != null) {
                outIv = proto.getOutIv().toByteArray();
            }
            return new CipherOption(suite, inKey, inIv, outKey, outIv);
        }
        return null;
    }

    public static CipherSuite convert(HdfsProtos.CipherSuiteProto proto) {
        switch (proto) {
            case AES_CTR_NOPADDING: {
                return CipherSuite.AES_CTR_NOPADDING;
            }
        }
        CipherSuite suite = CipherSuite.UNKNOWN;
        suite.setUnknownValue(proto.getNumber());
        return suite;
    }

    public static HdfsProtos.CipherOptionProto convert(CipherOption option) {
        if (option != null) {
            HdfsProtos.CipherOptionProto.Builder builder = HdfsProtos.CipherOptionProto.newBuilder();
            if (option.getCipherSuite() != null) {
                builder.setSuite(PBHelperClient.convert(option.getCipherSuite()));
            }
            if (option.getInKey() != null) {
                builder.setInKey(PBHelperClient.getByteString(option.getInKey()));
            }
            if (option.getInIv() != null) {
                builder.setInIv(PBHelperClient.getByteString(option.getInIv()));
            }
            if (option.getOutKey() != null) {
                builder.setOutKey(PBHelperClient.getByteString(option.getOutKey()));
            }
            if (option.getOutIv() != null) {
                builder.setOutIv(PBHelperClient.getByteString(option.getOutIv()));
            }
            return builder.build();
        }
        return null;
    }

    public static HdfsProtos.CipherSuiteProto convert(CipherSuite suite) {
        switch (suite) {
            case UNKNOWN: {
                return HdfsProtos.CipherSuiteProto.UNKNOWN;
            }
            case AES_CTR_NOPADDING: {
                return HdfsProtos.CipherSuiteProto.AES_CTR_NOPADDING;
            }
        }
        return null;
    }

    public static List<HdfsProtos.CipherOptionProto> convertCipherOptions(List<CipherOption> options) {
        if (options != null) {
            ArrayList protos = Lists.newArrayListWithCapacity((int)options.size());
            for (CipherOption option : options) {
                protos.add(PBHelperClient.convert(option));
            }
            return protos;
        }
        return null;
    }

    public static List<CipherOption> convertCipherOptionProtos(List<HdfsProtos.CipherOptionProto> protos) {
        if (protos != null) {
            ArrayList options = Lists.newArrayListWithCapacity((int)protos.size());
            for (HdfsProtos.CipherOptionProto proto : protos) {
                options.add(PBHelperClient.convert(proto));
            }
            return options;
        }
        return null;
    }

    public static LocatedBlock convertLocatedBlockProto(HdfsProtos.LocatedBlockProto proto) {
        LocatedBlock lb;
        String[] storageIDs;
        if (proto == null) {
            return null;
        }
        List<HdfsProtos.DatanodeInfoProto> locs = proto.getLocsList();
        DatanodeInfo[] targets = new DatanodeInfo[locs.size()];
        for (int i = 0; i < locs.size(); ++i) {
            targets[i] = PBHelperClient.convert(locs.get(i));
        }
        StorageType[] storageTypes = PBHelperClient.convertStorageTypes(proto.getStorageTypesList(), locs.size());
        int storageIDsCount = proto.getStorageIDsCount();
        if (storageIDsCount == 0) {
            storageIDs = null;
        } else {
            Preconditions.checkState((storageIDsCount == locs.size() ? 1 : 0) != 0);
            storageIDs = proto.getStorageIDsList().toArray(new String[storageIDsCount]);
        }
        byte[] indices = null;
        if (proto.hasBlockIndices()) {
            indices = proto.getBlockIndices().toByteArray();
        }
        ArrayList<DatanodeInfo> cachedLocs = new ArrayList<DatanodeInfo>(locs.size());
        List<Boolean> isCachedList = proto.getIsCachedList();
        for (int i = 0; i < isCachedList.size(); ++i) {
            if (!isCachedList.get(i).booleanValue()) continue;
            cachedLocs.add(targets[i]);
        }
        if (indices == null) {
            lb = new LocatedBlock(PBHelperClient.convert(proto.getB()), targets, storageIDs, storageTypes, proto.getOffset(), proto.getCorrupt(), cachedLocs.toArray(new DatanodeInfo[cachedLocs.size()]));
        } else {
            lb = new LocatedStripedBlock(PBHelperClient.convert(proto.getB()), targets, storageIDs, storageTypes, indices, proto.getOffset(), proto.getCorrupt(), cachedLocs.toArray(new DatanodeInfo[cachedLocs.size()]));
            List<SecurityProtos.TokenProto> tokenProtos = proto.getBlockTokensList();
            Token<BlockTokenIdentifier>[] blockTokens = PBHelperClient.convertTokens(tokenProtos);
            ((LocatedStripedBlock)lb).setBlockTokens(blockTokens);
        }
        lb.setBlockToken(PBHelperClient.convert(proto.getBlockToken()));
        return lb;
    }

    public static Token<BlockTokenIdentifier>[] convertTokens(List<SecurityProtos.TokenProto> tokenProtos) {
        Token[] blockTokens = new Token[tokenProtos.size()];
        for (int i = 0; i < blockTokens.length; ++i) {
            blockTokens[i] = PBHelperClient.convert(tokenProtos.get(i));
        }
        return blockTokens;
    }

    public static DatanodeInfo convert(HdfsProtos.DatanodeInfoProto di) {
        if (di == null) {
            return null;
        }
        return new DatanodeInfo(PBHelperClient.convert(di.getId()), di.hasLocation() ? di.getLocation() : null, di.getCapacity(), di.getDfsUsed(), di.getRemaining(), di.getBlockPoolUsed(), di.getCacheCapacity(), di.getCacheUsed(), di.getLastUpdate(), di.getLastUpdateMonotonic(), di.getXceiverCount(), PBHelperClient.convert(di.getAdminState()), di.hasUpgradeDomain() ? di.getUpgradeDomain() : null);
    }

    public static StorageType[] convertStorageTypes(List<HdfsProtos.StorageTypeProto> storageTypesList, int expectedSize) {
        Object[] storageTypes = new StorageType[expectedSize];
        if (storageTypesList.size() != expectedSize) {
            Preconditions.checkState((boolean)storageTypesList.isEmpty());
            Arrays.fill(storageTypes, StorageType.DEFAULT);
        } else {
            for (int i = 0; i < storageTypes.length; ++i) {
                storageTypes[i] = PBHelperClient.convertStorageType(storageTypesList.get(i));
            }
        }
        return storageTypes;
    }

    public static Token<BlockTokenIdentifier> convert(SecurityProtos.TokenProto blockToken) {
        return new Token(blockToken.getIdentifier().toByteArray(), blockToken.getPassword().toByteArray(), new Text(blockToken.getKind()), new Text(blockToken.getService()));
    }

    public static DatanodeID convert(HdfsProtos.DatanodeIDProto dn) {
        return new DatanodeID(dn.getIpAddr(), dn.getHostName(), dn.getDatanodeUuid(), dn.getXferPort(), dn.getInfoPort(), dn.hasInfoSecurePort() ? dn.getInfoSecurePort() : 0, dn.getIpcPort());
    }

    public static DatanodeInfo.AdminStates convert(HdfsProtos.DatanodeInfoProto.AdminState adminState) {
        switch (adminState) {
            case DECOMMISSION_INPROGRESS: {
                return DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS;
            }
            case DECOMMISSIONED: {
                return DatanodeInfo.AdminStates.DECOMMISSIONED;
            }
            case ENTERING_MAINTENANCE: {
                return DatanodeInfo.AdminStates.ENTERING_MAINTENANCE;
            }
            case IN_MAINTENANCE: {
                return DatanodeInfo.AdminStates.IN_MAINTENANCE;
            }
        }
        return DatanodeInfo.AdminStates.NORMAL;
    }

    public static LocatedBlocks convert(HdfsProtos.LocatedBlocksProto lb) {
        return new LocatedBlocks(lb.getFileLength(), lb.getUnderConstruction(), PBHelperClient.convertLocatedBlocks(lb.getBlocksList()), lb.hasLastBlock() ? PBHelperClient.convertLocatedBlockProto(lb.getLastBlock()) : null, lb.getIsLastBlockComplete(), lb.hasFileEncryptionInfo() ? PBHelperClient.convert(lb.getFileEncryptionInfo()) : null, lb.hasEcPolicy() ? PBHelperClient.convertErasureCodingPolicy(lb.getEcPolicy()) : null);
    }

    public static BlockStoragePolicy[] convertStoragePolicies(List<HdfsProtos.BlockStoragePolicyProto> policyProtos) {
        if (policyProtos == null || policyProtos.size() == 0) {
            return new BlockStoragePolicy[0];
        }
        BlockStoragePolicy[] policies = new BlockStoragePolicy[policyProtos.size()];
        int i = 0;
        for (HdfsProtos.BlockStoragePolicyProto proto : policyProtos) {
            policies[i++] = PBHelperClient.convert(proto);
        }
        return policies;
    }

    public static EventBatchList convert(ClientNamenodeProtocolProtos.GetEditsFromTxidResponseProto resp) throws IOException {
        InotifyProtos.EventsListProto list = resp.getEventsList();
        long firstTxid = list.getFirstTxid();
        long lastTxid = list.getLastTxid();
        ArrayList batches = Lists.newArrayList();
        if (list.getEventsList().size() > 0) {
            throw new IOException("Can't handle old inotify server response.");
        }
        for (InotifyProtos.EventBatchProto bp : list.getBatchList()) {
            long txid = bp.getTxid();
            if (txid != -1L && (txid < firstTxid || txid > lastTxid)) {
                throw new IOException("Error converting TxidResponseProto: got a transaction id " + txid + " that was outside the range of [" + firstTxid + ", " + lastTxid + "].");
            }
            ArrayList events = Lists.newArrayList();
            block10: for (InotifyProtos.EventProto p : bp.getEventsList()) {
                switch (p.getType()) {
                    case EVENT_CLOSE: {
                        InotifyProtos.CloseEventProto close = InotifyProtos.CloseEventProto.parseFrom(p.getContents());
                        events.add(new Event.CloseEvent(close.getPath(), close.getFileSize(), close.getTimestamp()));
                        continue block10;
                    }
                    case EVENT_CREATE: {
                        InotifyProtos.CreateEventProto create = InotifyProtos.CreateEventProto.parseFrom(p.getContents());
                        events.add(new Event.CreateEvent.Builder().iNodeType(PBHelperClient.createTypeConvert(create.getType())).path(create.getPath()).ctime(create.getCtime()).ownerName(create.getOwnerName()).groupName(create.getGroupName()).perms(PBHelperClient.convert(create.getPerms())).replication(create.getReplication()).symlinkTarget(create.getSymlinkTarget().isEmpty() ? null : create.getSymlinkTarget()).defaultBlockSize(create.getDefaultBlockSize()).overwrite(create.getOverwrite()).build());
                        continue block10;
                    }
                    case EVENT_METADATA: {
                        InotifyProtos.MetadataUpdateEventProto meta = InotifyProtos.MetadataUpdateEventProto.parseFrom(p.getContents());
                        events.add(new Event.MetadataUpdateEvent.Builder().path(meta.getPath()).metadataType(PBHelperClient.metadataUpdateTypeConvert(meta.getType())).mtime(meta.getMtime()).atime(meta.getAtime()).replication(meta.getReplication()).ownerName(meta.getOwnerName().isEmpty() ? null : meta.getOwnerName()).groupName(meta.getGroupName().isEmpty() ? null : meta.getGroupName()).perms(meta.hasPerms() ? PBHelperClient.convert(meta.getPerms()) : null).acls(meta.getAclsList().isEmpty() ? null : PBHelperClient.convertAclEntry(meta.getAclsList())).xAttrs(meta.getXAttrsList().isEmpty() ? null : PBHelperClient.convertXAttrs(meta.getXAttrsList())).xAttrsRemoved(meta.getXAttrsRemoved()).build());
                        continue block10;
                    }
                    case EVENT_RENAME: {
                        InotifyProtos.RenameEventProto rename = InotifyProtos.RenameEventProto.parseFrom(p.getContents());
                        events.add(new Event.RenameEvent.Builder().srcPath(rename.getSrcPath()).dstPath(rename.getDestPath()).timestamp(rename.getTimestamp()).build());
                        continue block10;
                    }
                    case EVENT_APPEND: {
                        InotifyProtos.AppendEventProto append = InotifyProtos.AppendEventProto.parseFrom(p.getContents());
                        events.add(new Event.AppendEvent.Builder().path(append.getPath()).newBlock(append.hasNewBlock() && append.getNewBlock()).build());
                        continue block10;
                    }
                    case EVENT_UNLINK: {
                        InotifyProtos.UnlinkEventProto unlink = InotifyProtos.UnlinkEventProto.parseFrom(p.getContents());
                        events.add(new Event.UnlinkEvent.Builder().path(unlink.getPath()).timestamp(unlink.getTimestamp()).build());
                        continue block10;
                    }
                    case EVENT_TRUNCATE: {
                        InotifyProtos.TruncateEventProto truncate = InotifyProtos.TruncateEventProto.parseFrom(p.getContents());
                        events.add(new Event.TruncateEvent(truncate.getPath(), truncate.getFileSize(), truncate.getTimestamp()));
                        continue block10;
                    }
                }
                throw new RuntimeException("Unexpected inotify event type: " + (Object)((Object)p.getType()));
            }
            batches.add(new EventBatch(txid, events.toArray(new Event[0])));
        }
        return new EventBatchList(batches, resp.getEventsList().getFirstTxid(), resp.getEventsList().getLastTxid(), resp.getEventsList().getSyncTxid());
    }

    public static HdfsProtos.LocatedBlockProto[] convertLocatedBlocks(LocatedBlock[] lb) {
        if (lb == null) {
            return null;
        }
        return PBHelperClient.convertLocatedBlocks2(Arrays.asList(lb)).toArray(new HdfsProtos.LocatedBlockProto[lb.length]);
    }

    public static LocatedBlock[] convertLocatedBlocks(HdfsProtos.LocatedBlockProto[] lb) {
        if (lb == null) {
            return null;
        }
        return PBHelperClient.convertLocatedBlocks(Arrays.asList(lb)).toArray(new LocatedBlock[lb.length]);
    }

    public static List<LocatedBlock> convertLocatedBlocks(List<HdfsProtos.LocatedBlockProto> lb) {
        if (lb == null) {
            return null;
        }
        int len = lb.size();
        ArrayList<LocatedBlock> result = new ArrayList<LocatedBlock>(len);
        for (HdfsProtos.LocatedBlockProto aLb : lb) {
            result.add(PBHelperClient.convertLocatedBlockProto(aLb));
        }
        return result;
    }

    public static List<HdfsProtos.LocatedBlockProto> convertLocatedBlocks2(List<LocatedBlock> lb) {
        if (lb == null) {
            return null;
        }
        int len = lb.size();
        ArrayList<HdfsProtos.LocatedBlockProto> result = new ArrayList<HdfsProtos.LocatedBlockProto>(len);
        for (LocatedBlock aLb : lb) {
            result.add(PBHelperClient.convertLocatedBlock(aLb));
        }
        return result;
    }

    public static HdfsProtos.LocatedBlockProto convertLocatedBlock(LocatedBlock b) {
        String[] storageIDs;
        if (b == null) {
            return null;
        }
        HdfsProtos.LocatedBlockProto.Builder builder = HdfsProtos.LocatedBlockProto.newBuilder();
        DatanodeInfo[] locs = b.getLocations();
        LinkedList cachedLocs = Lists.newLinkedList(Arrays.asList(b.getCachedLocations()));
        for (int i = 0; i < locs.length; ++i) {
            StorageType[] loc = locs[i];
            builder.addLocs(i, PBHelperClient.convert((DatanodeInfo)loc));
            int locIsCached = cachedLocs.contains(loc);
            builder.addIsCached(locIsCached != 0);
            if (locIsCached == 0) continue;
            cachedLocs.remove(loc);
        }
        Preconditions.checkArgument((cachedLocs.size() == 0 ? 1 : 0) != 0, (Object)"Found additional cached replica locations that are not in the set of storage-backed locations!");
        StorageType[] storageTypes = b.getStorageTypes();
        if (storageTypes != null) {
            for (StorageType storageType : storageTypes) {
                builder.addStorageTypes(PBHelperClient.convertStorageType(storageType));
            }
        }
        if ((storageIDs = b.getStorageIDs()) != null) {
            builder.addAllStorageIDs(Arrays.asList(storageIDs));
        }
        if (b instanceof LocatedStripedBlock) {
            LocatedStripedBlock sb = (LocatedStripedBlock)b;
            byte[] indices = sb.getBlockIndices();
            builder.setBlockIndices(PBHelperClient.getByteString(indices));
            Token<BlockTokenIdentifier>[] blockTokens = sb.getBlockTokens();
            builder.addAllBlockTokens(PBHelperClient.convert(blockTokens));
        }
        return builder.setB(PBHelperClient.convert(b.getBlock())).setBlockToken(PBHelperClient.convert(b.getBlockToken())).setCorrupt(b.isCorrupt()).setOffset(b.getStartOffset()).build();
    }

    public static List<SecurityProtos.TokenProto> convert(Token<BlockTokenIdentifier>[] blockTokens) {
        ArrayList<SecurityProtos.TokenProto> results = new ArrayList<SecurityProtos.TokenProto>(blockTokens.length);
        for (Token<BlockTokenIdentifier> bt : blockTokens) {
            results.add(PBHelperClient.convert(bt));
        }
        return results;
    }

    public static List<Integer> convertBlockIndices(byte[] blockIndices) {
        ArrayList<Integer> results = new ArrayList<Integer>(blockIndices.length);
        for (byte bt : blockIndices) {
            results.add(Integer.valueOf(bt));
        }
        return results;
    }

    public static byte[] convertBlockIndices(List<Integer> blockIndices) {
        byte[] blkIndices = new byte[blockIndices.size()];
        for (int i = 0; i < blockIndices.size(); ++i) {
            blkIndices[i] = (byte)blockIndices.get(i).intValue();
        }
        return blkIndices;
    }

    public static BlockStoragePolicy convert(HdfsProtos.BlockStoragePolicyProto proto) {
        List<HdfsProtos.StorageTypeProto> cList = proto.getCreationPolicy().getStorageTypesList();
        StorageType[] creationTypes = PBHelperClient.convertStorageTypes(cList, cList.size());
        List<HdfsProtos.StorageTypeProto> cfList = proto.hasCreationFallbackPolicy() ? proto.getCreationFallbackPolicy().getStorageTypesList() : null;
        StorageType[] creationFallbackTypes = cfList == null ? StorageType.EMPTY_ARRAY : PBHelperClient.convertStorageTypes(cfList, cfList.size());
        List<HdfsProtos.StorageTypeProto> rfList = proto.hasReplicationFallbackPolicy() ? proto.getReplicationFallbackPolicy().getStorageTypesList() : null;
        StorageType[] replicationFallbackTypes = rfList == null ? StorageType.EMPTY_ARRAY : PBHelperClient.convertStorageTypes(rfList, rfList.size());
        return new BlockStoragePolicy((byte)proto.getPolicyId(), proto.getName(), creationTypes, creationFallbackTypes, replicationFallbackTypes);
    }

    public static AclProtos.AclEntryProto.FsActionProto convert(FsAction v) {
        return AclProtos.AclEntryProto.FsActionProto.valueOf(v != null ? v.ordinal() : 0);
    }

    public static XAttrProtos.XAttrProto convertXAttrProto(XAttr a) {
        XAttrProtos.XAttrProto.Builder builder = XAttrProtos.XAttrProto.newBuilder();
        builder.setNamespace(PBHelperClient.convert(a.getNameSpace()));
        if (a.getName() != null) {
            builder.setName(a.getName());
        }
        if (a.getValue() != null) {
            builder.setValue(PBHelperClient.getByteString(a.getValue()));
        }
        return builder.build();
    }

    public static List<XAttr> convert(XAttrProtos.ListXAttrsResponseProto a) {
        List<XAttrProtos.XAttrProto> xAttrs = a.getXAttrsList();
        return PBHelperClient.convertXAttrs(xAttrs);
    }

    public static List<XAttr> convert(XAttrProtos.GetXAttrsResponseProto a) {
        List<XAttrProtos.XAttrProto> xAttrs = a.getXAttrsList();
        return PBHelperClient.convertXAttrs(xAttrs);
    }

    public static List<XAttr> convertXAttrs(List<XAttrProtos.XAttrProto> xAttrSpec) {
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)xAttrSpec.size());
        for (XAttrProtos.XAttrProto a : xAttrSpec) {
            XAttr.Builder builder = new XAttr.Builder();
            builder.setNameSpace(PBHelperClient.convert(a.getNamespace()));
            if (a.hasName()) {
                builder.setName(a.getName());
            }
            if (a.hasValue()) {
                builder.setValue(a.getValue().toByteArray());
            }
            xAttrs.add(builder.build());
        }
        return xAttrs;
    }

    static XAttrProtos.XAttrProto.XAttrNamespaceProto convert(XAttr.NameSpace v) {
        return XAttrProtos.XAttrProto.XAttrNamespaceProto.valueOf(v.ordinal());
    }

    static XAttr.NameSpace convert(XAttrProtos.XAttrProto.XAttrNamespaceProto v) {
        return (XAttr.NameSpace)PBHelperClient.castEnum((Enum)v, (Enum[])XATTR_NAMESPACE_VALUES);
    }

    static <T extends Enum<T>, U extends Enum<U>> U castEnum(T from, U[] to) {
        return to[from.ordinal()];
    }

    static InotifyProtos.MetadataUpdateType metadataUpdateTypeConvert(Event.MetadataUpdateEvent.MetadataType type) {
        switch (type) {
            case TIMES: {
                return InotifyProtos.MetadataUpdateType.META_TYPE_TIMES;
            }
            case REPLICATION: {
                return InotifyProtos.MetadataUpdateType.META_TYPE_REPLICATION;
            }
            case OWNER: {
                return InotifyProtos.MetadataUpdateType.META_TYPE_OWNER;
            }
            case PERMS: {
                return InotifyProtos.MetadataUpdateType.META_TYPE_PERMS;
            }
            case ACLS: {
                return InotifyProtos.MetadataUpdateType.META_TYPE_ACLS;
            }
            case XATTRS: {
                return InotifyProtos.MetadataUpdateType.META_TYPE_XATTRS;
            }
        }
        return null;
    }

    private static Event.MetadataUpdateEvent.MetadataType metadataUpdateTypeConvert(InotifyProtos.MetadataUpdateType type) {
        switch (type) {
            case META_TYPE_TIMES: {
                return Event.MetadataUpdateEvent.MetadataType.TIMES;
            }
            case META_TYPE_REPLICATION: {
                return Event.MetadataUpdateEvent.MetadataType.REPLICATION;
            }
            case META_TYPE_OWNER: {
                return Event.MetadataUpdateEvent.MetadataType.OWNER;
            }
            case META_TYPE_PERMS: {
                return Event.MetadataUpdateEvent.MetadataType.PERMS;
            }
            case META_TYPE_ACLS: {
                return Event.MetadataUpdateEvent.MetadataType.ACLS;
            }
            case META_TYPE_XATTRS: {
                return Event.MetadataUpdateEvent.MetadataType.XATTRS;
            }
        }
        return null;
    }

    static InotifyProtos.INodeType createTypeConvert(Event.CreateEvent.INodeType type) {
        switch (type) {
            case DIRECTORY: {
                return InotifyProtos.INodeType.I_TYPE_DIRECTORY;
            }
            case FILE: {
                return InotifyProtos.INodeType.I_TYPE_FILE;
            }
            case SYMLINK: {
                return InotifyProtos.INodeType.I_TYPE_SYMLINK;
            }
        }
        return null;
    }

    public static List<LocatedBlock> convertLocatedBlock(List<HdfsProtos.LocatedBlockProto> lb) {
        if (lb == null) {
            return null;
        }
        int len = lb.size();
        ArrayList<LocatedBlock> result = new ArrayList<LocatedBlock>(len);
        for (HdfsProtos.LocatedBlockProto aLb : lb) {
            result.add(PBHelperClient.convertLocatedBlockProto(aLb));
        }
        return result;
    }

    public static List<AclEntry> convertAclEntry(List<AclProtos.AclEntryProto> aclSpec) {
        ArrayList r = Lists.newArrayListWithCapacity((int)aclSpec.size());
        for (AclProtos.AclEntryProto e : aclSpec) {
            AclEntry.Builder builder = new AclEntry.Builder();
            builder.setType(PBHelperClient.convert(e.getType()));
            builder.setScope(PBHelperClient.convert(e.getScope()));
            builder.setPermission(PBHelperClient.convert(e.getPermissions()));
            if (e.hasName()) {
                builder.setName(e.getName());
            }
            r.add(builder.build());
        }
        return r;
    }

    static AclProtos.AclEntryProto.AclEntryScopeProto convert(AclEntryScope v) {
        return AclProtos.AclEntryProto.AclEntryScopeProto.valueOf(v.ordinal());
    }

    private static AclEntryScope convert(AclProtos.AclEntryProto.AclEntryScopeProto v) {
        return (AclEntryScope)PBHelperClient.castEnum((Enum)v, (Enum[])ACL_ENTRY_SCOPE_VALUES);
    }

    static AclProtos.AclEntryProto.AclEntryTypeProto convert(AclEntryType e) {
        return AclProtos.AclEntryProto.AclEntryTypeProto.valueOf(e.ordinal());
    }

    private static AclEntryType convert(AclProtos.AclEntryProto.AclEntryTypeProto v) {
        return (AclEntryType)PBHelperClient.castEnum((Enum)v, (Enum[])ACL_ENTRY_TYPE_VALUES);
    }

    public static FsAction convert(AclProtos.AclEntryProto.FsActionProto v) {
        return (FsAction)PBHelperClient.castEnum((Enum)v, (Enum[])FSACTION_VALUES);
    }

    public static FsPermission convert(HdfsProtos.FsPermissionProto p) {
        return new FsPermissionExtension((short)p.getPerm());
    }

    private static Event.CreateEvent.INodeType createTypeConvert(InotifyProtos.INodeType type) {
        switch (type) {
            case I_TYPE_DIRECTORY: {
                return Event.CreateEvent.INodeType.DIRECTORY;
            }
            case I_TYPE_FILE: {
                return Event.CreateEvent.INodeType.FILE;
            }
            case I_TYPE_SYMLINK: {
                return Event.CreateEvent.INodeType.SYMLINK;
            }
        }
        return null;
    }

    public static HdfsProtos.FileEncryptionInfoProto convert(FileEncryptionInfo info) {
        if (info == null) {
            return null;
        }
        return HdfsProtos.FileEncryptionInfoProto.newBuilder().setSuite(PBHelperClient.convert(info.getCipherSuite())).setCryptoProtocolVersion(PBHelperClient.convert(info.getCryptoProtocolVersion())).setKey(PBHelperClient.getByteString(info.getEncryptedDataEncryptionKey())).setIv(PBHelperClient.getByteString(info.getIV())).setEzKeyVersionName(info.getEzKeyVersionName()).setKeyName(info.getKeyName()).build();
    }

    public static HdfsProtos.CryptoProtocolVersionProto convert(CryptoProtocolVersion version) {
        switch (version) {
            case UNKNOWN: {
                return HdfsProtos.CryptoProtocolVersionProto.UNKNOWN_PROTOCOL_VERSION;
            }
            case ENCRYPTION_ZONES: {
                return HdfsProtos.CryptoProtocolVersionProto.ENCRYPTION_ZONES;
            }
        }
        return null;
    }

    public static FileEncryptionInfo convert(HdfsProtos.FileEncryptionInfoProto proto) {
        if (proto == null) {
            return null;
        }
        CipherSuite suite = PBHelperClient.convert(proto.getSuite());
        CryptoProtocolVersion version = PBHelperClient.convert(proto.getCryptoProtocolVersion());
        byte[] key = proto.getKey().toByteArray();
        byte[] iv = proto.getIv().toByteArray();
        String ezKeyVersionName = proto.getEzKeyVersionName();
        String keyName = proto.getKeyName();
        return new FileEncryptionInfo(suite, version, key, iv, keyName, ezKeyVersionName);
    }

    public static CryptoProtocolVersion convert(HdfsProtos.CryptoProtocolVersionProto proto) {
        switch (proto) {
            case ENCRYPTION_ZONES: {
                return CryptoProtocolVersion.ENCRYPTION_ZONES;
            }
        }
        CryptoProtocolVersion version = CryptoProtocolVersion.UNKNOWN;
        version.setUnknownValue(proto.getNumber());
        return version;
    }

    public static List<XAttrProtos.XAttrProto> convertXAttrProto(List<XAttr> xAttrSpec) {
        if (xAttrSpec == null) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)xAttrSpec.size());
        for (XAttr a : xAttrSpec) {
            XAttrProtos.XAttrProto.Builder builder = XAttrProtos.XAttrProto.newBuilder();
            builder.setNamespace(PBHelperClient.convert(a.getNameSpace()));
            if (a.getName() != null) {
                builder.setName(a.getName());
            }
            if (a.getValue() != null) {
                builder.setValue(PBHelperClient.getByteString(a.getValue()));
            }
            xAttrs.add(builder.build());
        }
        return xAttrs;
    }

    public static int convert(EnumSet<XAttrSetFlag> flag) {
        int value = 0;
        if (flag.contains(XAttrSetFlag.CREATE)) {
            value |= XAttrProtos.XAttrSetFlagProto.XATTR_CREATE.getNumber();
        }
        if (flag.contains(XAttrSetFlag.REPLACE)) {
            value |= XAttrProtos.XAttrSetFlagProto.XATTR_REPLACE.getNumber();
        }
        return value;
    }

    public static EncryptionZone convert(EncryptionZonesProtos.EncryptionZoneProto proto) {
        return new EncryptionZone(proto.getId(), proto.getPath(), PBHelperClient.convert(proto.getSuite()), PBHelperClient.convert(proto.getCryptoProtocolVersion()), proto.getKeyName());
    }

    public static AclStatus convert(AclProtos.GetAclStatusResponseProto e) {
        AclProtos.AclStatusProto r = e.getResult();
        AclStatus.Builder builder = new AclStatus.Builder();
        builder.owner(r.getOwner()).group(r.getGroup()).stickyBit(r.getSticky()).addEntries(PBHelperClient.convertAclEntry(r.getEntriesList()));
        if (r.hasPermission()) {
            builder.setPermission(PBHelperClient.convert(r.getPermission()));
        }
        return builder.build();
    }

    public static List<AclProtos.AclEntryProto> convertAclEntryProto(List<AclEntry> aclSpec) {
        ArrayList r = Lists.newArrayListWithCapacity((int)aclSpec.size());
        for (AclEntry e : aclSpec) {
            AclProtos.AclEntryProto.Builder builder = AclProtos.AclEntryProto.newBuilder();
            builder.setType(PBHelperClient.convert(e.getType()));
            builder.setScope(PBHelperClient.convert(e.getScope()));
            builder.setPermissions(PBHelperClient.convert(e.getPermission()));
            if (e.getName() != null) {
                builder.setName(e.getName());
            }
            r.add(builder.build());
        }
        return r;
    }

    public static CachePoolEntry convert(ClientNamenodeProtocolProtos.CachePoolEntryProto proto) {
        CachePoolInfo info = PBHelperClient.convert(proto.getInfo());
        CachePoolStats stats = PBHelperClient.convert(proto.getStats());
        return new CachePoolEntry(info, stats);
    }

    public static CachePoolInfo convert(ClientNamenodeProtocolProtos.CachePoolInfoProto proto) {
        String poolName = (String)Preconditions.checkNotNull((Object)proto.getPoolName());
        CachePoolInfo info = new CachePoolInfo(poolName);
        if (proto.hasOwnerName()) {
            info.setOwnerName(proto.getOwnerName());
        }
        if (proto.hasGroupName()) {
            info.setGroupName(proto.getGroupName());
        }
        if (proto.hasMode()) {
            info.setMode(new FsPermission((short)proto.getMode()));
        }
        if (proto.hasLimit()) {
            info.setLimit(proto.getLimit());
        }
        if (proto.hasDefaultReplication()) {
            info.setDefaultReplication(Shorts.checkedCast((long)proto.getDefaultReplication()));
        }
        if (proto.hasMaxRelativeExpiry()) {
            info.setMaxRelativeExpiryMs(proto.getMaxRelativeExpiry());
        }
        return info;
    }

    public static CachePoolStats convert(ClientNamenodeProtocolProtos.CachePoolStatsProto proto) {
        CachePoolStats.Builder builder = new CachePoolStats.Builder();
        builder.setBytesNeeded(proto.getBytesNeeded());
        builder.setBytesCached(proto.getBytesCached());
        builder.setBytesOverlimit(proto.getBytesOverlimit());
        builder.setFilesNeeded(proto.getFilesNeeded());
        builder.setFilesCached(proto.getFilesCached());
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CachePoolInfoProto convert(CachePoolInfo info) {
        ClientNamenodeProtocolProtos.CachePoolInfoProto.Builder builder = ClientNamenodeProtocolProtos.CachePoolInfoProto.newBuilder();
        builder.setPoolName(info.getPoolName());
        if (info.getOwnerName() != null) {
            builder.setOwnerName(info.getOwnerName());
        }
        if (info.getGroupName() != null) {
            builder.setGroupName(info.getGroupName());
        }
        if (info.getMode() != null) {
            builder.setMode(info.getMode().toShort());
        }
        if (info.getLimit() != null) {
            builder.setLimit(info.getLimit());
        }
        if (info.getDefaultReplication() != null) {
            builder.setDefaultReplication(info.getDefaultReplication().shortValue());
        }
        if (info.getMaxRelativeExpiryMs() != null) {
            builder.setMaxRelativeExpiry(info.getMaxRelativeExpiryMs());
        }
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveInfoProto convert(CacheDirectiveInfo info) {
        ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.Builder builder = ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.newBuilder();
        if (info.getId() != null) {
            builder.setId(info.getId());
        }
        if (info.getPath() != null) {
            builder.setPath(info.getPath().toUri().getPath());
        }
        if (info.getReplication() != null) {
            builder.setReplication(info.getReplication().shortValue());
        }
        if (info.getPool() != null) {
            builder.setPool(info.getPool());
        }
        if (info.getExpiration() != null) {
            builder.setExpiration(PBHelperClient.convert(info.getExpiration()));
        }
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto convert(CacheDirectiveInfo.Expiration expiration) {
        return ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto.newBuilder().setIsRelative(expiration.isRelative()).setMillis(expiration.getMillis()).build();
    }

    public static CacheDirectiveEntry convert(ClientNamenodeProtocolProtos.CacheDirectiveEntryProto proto) {
        CacheDirectiveInfo info = PBHelperClient.convert(proto.getInfo());
        CacheDirectiveStats stats = PBHelperClient.convert(proto.getStats());
        return new CacheDirectiveEntry(info, stats);
    }

    public static CacheDirectiveStats convert(ClientNamenodeProtocolProtos.CacheDirectiveStatsProto proto) {
        CacheDirectiveStats.Builder builder = new CacheDirectiveStats.Builder();
        builder.setBytesNeeded(proto.getBytesNeeded());
        builder.setBytesCached(proto.getBytesCached());
        builder.setFilesNeeded(proto.getFilesNeeded());
        builder.setFilesCached(proto.getFilesCached());
        builder.setHasExpired(proto.getHasExpired());
        return builder.build();
    }

    public static CacheDirectiveInfo convert(ClientNamenodeProtocolProtos.CacheDirectiveInfoProto proto) {
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder();
        if (proto.hasId()) {
            builder.setId(proto.getId());
        }
        if (proto.hasPath()) {
            builder.setPath(new Path(proto.getPath()));
        }
        if (proto.hasReplication()) {
            builder.setReplication(Shorts.checkedCast((long)proto.getReplication()));
        }
        if (proto.hasPool()) {
            builder.setPool(proto.getPool());
        }
        if (proto.hasExpiration()) {
            builder.setExpiration(PBHelperClient.convert(proto.getExpiration()));
        }
        return builder.build();
    }

    public static CacheDirectiveInfo.Expiration convert(ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto proto) {
        if (proto.getIsRelative()) {
            return CacheDirectiveInfo.Expiration.newRelative(proto.getMillis());
        }
        return CacheDirectiveInfo.Expiration.newAbsolute(proto.getMillis());
    }

    public static int convertCacheFlags(EnumSet<CacheFlag> flags) {
        int value = 0;
        if (flags.contains((Object)CacheFlag.FORCE)) {
            value |= ClientNamenodeProtocolProtos.CacheFlagProto.FORCE.getNumber();
        }
        return value;
    }

    public static SnapshotDiffReport convert(HdfsProtos.SnapshotDiffReportProto reportProto) {
        if (reportProto == null) {
            return null;
        }
        String snapshotDir = reportProto.getSnapshotRoot();
        String fromSnapshot = reportProto.getFromSnapshot();
        String toSnapshot = reportProto.getToSnapshot();
        List<HdfsProtos.SnapshotDiffReportEntryProto> list = reportProto.getDiffReportEntriesList();
        ArrayList<SnapshotDiffReport.DiffReportEntry> entries = new ArrayList<SnapshotDiffReport.DiffReportEntry>();
        for (HdfsProtos.SnapshotDiffReportEntryProto entryProto : list) {
            SnapshotDiffReport.DiffReportEntry entry = PBHelperClient.convert(entryProto);
            if (entry == null) continue;
            entries.add(entry);
        }
        return new SnapshotDiffReport(snapshotDir, fromSnapshot, toSnapshot, entries);
    }

    public static SnapshotDiffReport.DiffReportEntry convert(HdfsProtos.SnapshotDiffReportEntryProto entry) {
        if (entry == null) {
            return null;
        }
        SnapshotDiffReport.DiffType type = SnapshotDiffReport.DiffType.getTypeFromLabel(entry.getModificationLabel());
        return type == null ? null : new SnapshotDiffReport.DiffReportEntry(type, entry.getFullpath().toByteArray(), entry.hasTargetPath() ? entry.getTargetPath().toByteArray() : null);
    }

    public static SnapshottableDirectoryStatus[] convert(HdfsProtos.SnapshottableDirectoryListingProto sdlp) {
        if (sdlp == null) {
            return null;
        }
        List<HdfsProtos.SnapshottableDirectoryStatusProto> list = sdlp.getSnapshottableDirListingList();
        if (list.isEmpty()) {
            return new SnapshottableDirectoryStatus[0];
        }
        SnapshottableDirectoryStatus[] result = new SnapshottableDirectoryStatus[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = PBHelperClient.convert(list.get(i));
        }
        return result;
    }

    public static SnapshottableDirectoryStatus convert(HdfsProtos.SnapshottableDirectoryStatusProto sdirStatusProto) {
        if (sdirStatusProto == null) {
            return null;
        }
        HdfsProtos.HdfsFileStatusProto status = sdirStatusProto.getDirStatus();
        return new SnapshottableDirectoryStatus(status.getModificationTime(), status.getAccessTime(), PBHelperClient.convert(status.getPermission()), status.getOwner(), status.getGroup(), status.getPath().toByteArray(), status.getFileId(), status.getChildrenNum(), sdirStatusProto.getSnapshotNumber(), sdirStatusProto.getSnapshotQuota(), sdirStatusProto.getParentFullpath().toByteArray());
    }

    public static DataEncryptionKey convert(HdfsProtos.DataEncryptionKeyProto bet) {
        String encryptionAlgorithm = bet.getEncryptionAlgorithm();
        return new DataEncryptionKey(bet.getKeyId(), bet.getBlockPoolId(), bet.getNonce().toByteArray(), bet.getEncryptionKey().toByteArray(), bet.getExpiryDate(), encryptionAlgorithm.isEmpty() ? null : encryptionAlgorithm);
    }

    public static Token<DelegationTokenIdentifier> convertDelegationToken(SecurityProtos.TokenProto blockToken) {
        return new Token(blockToken.getIdentifier().toByteArray(), blockToken.getPassword().toByteArray(), new Text(blockToken.getKind()), new Text(blockToken.getService()));
    }

    public static HdfsProtos.DatanodeIDProto[] convert(DatanodeID[] did) {
        if (did == null) {
            return null;
        }
        int len = did.length;
        HdfsProtos.DatanodeIDProto[] result = new HdfsProtos.DatanodeIDProto[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelperClient.convert(did[i]);
        }
        return result;
    }

    public static HdfsProtos.FsPermissionProto convert(FsPermission p) {
        return HdfsProtos.FsPermissionProto.newBuilder().setPerm(p.toExtendedShort()).build();
    }

    public static HdfsFileStatus convert(HdfsProtos.HdfsFileStatusProto fs) {
        if (fs == null) {
            return null;
        }
        return new HdfsLocatedFileStatus(fs.getLength(), fs.getFileType().equals((Object)HdfsProtos.HdfsFileStatusProto.FileType.IS_DIR), fs.getBlockReplication(), fs.getBlocksize(), fs.getModificationTime(), fs.getAccessTime(), PBHelperClient.convert(fs.getPermission()), fs.getOwner(), fs.getGroup(), fs.getFileType().equals((Object)HdfsProtos.HdfsFileStatusProto.FileType.IS_SYMLINK) ? fs.getSymlink().toByteArray() : null, fs.getPath().toByteArray(), fs.hasFileId() ? fs.getFileId() : 0L, fs.hasLocations() ? PBHelperClient.convert(fs.getLocations()) : null, fs.hasChildrenNum() ? fs.getChildrenNum() : -1, fs.hasFileEncryptionInfo() ? PBHelperClient.convert(fs.getFileEncryptionInfo()) : null, fs.hasStoragePolicy() ? (byte)fs.getStoragePolicy() : (byte)0, fs.hasEcPolicy() ? PBHelperClient.convertErasureCodingPolicy(fs.getEcPolicy()) : null);
    }

    public static CorruptFileBlocks convert(HdfsProtos.CorruptFileBlocksProto c) {
        if (c == null) {
            return null;
        }
        List<String> fileList = c.getFilesList();
        return new CorruptFileBlocks(fileList.toArray(new String[fileList.size()]), c.getCookie());
    }

    public static ContentSummary convert(HdfsProtos.ContentSummaryProto cs) {
        if (cs == null) {
            return null;
        }
        ContentSummary.Builder builder = new ContentSummary.Builder();
        builder.length(cs.getLength()).fileCount(cs.getFileCount()).directoryCount(cs.getDirectoryCount()).snapshotLength(cs.getSnapshotLength()).snapshotFileCount(cs.getSnapshotFileCount()).snapshotDirectoryCount(cs.getSnapshotDirectoryCount()).snapshotSpaceConsumed(cs.getSnapshotSpaceConsumed()).quota(cs.getQuota()).spaceConsumed(cs.getSpaceConsumed()).spaceQuota(cs.getSpaceQuota());
        if (cs.hasTypeQuotaInfos()) {
            PBHelperClient.addStorageTypes(cs.getTypeQuotaInfos(), (QuotaUsage.Builder)builder);
        }
        return builder.build();
    }

    public static QuotaUsage convert(HdfsProtos.QuotaUsageProto qu) {
        if (qu == null) {
            return null;
        }
        QuotaUsage.Builder builder = new QuotaUsage.Builder();
        builder.fileAndDirectoryCount(qu.getFileAndDirectoryCount()).quota(qu.getQuota()).spaceConsumed(qu.getSpaceConsumed()).spaceQuota(qu.getSpaceQuota());
        if (qu.hasTypeQuotaInfos()) {
            PBHelperClient.addStorageTypes(qu.getTypeQuotaInfos(), builder);
        }
        return builder.build();
    }

    public static HdfsProtos.QuotaUsageProto convert(QuotaUsage qu) {
        if (qu == null) {
            return null;
        }
        HdfsProtos.QuotaUsageProto.Builder builder = HdfsProtos.QuotaUsageProto.newBuilder();
        builder.setFileAndDirectoryCount(qu.getFileAndDirectoryCount()).setQuota(qu.getQuota()).setSpaceConsumed(qu.getSpaceConsumed()).setSpaceQuota(qu.getSpaceQuota());
        if (qu.isTypeQuotaSet() || qu.isTypeConsumedAvailable()) {
            builder.setTypeQuotaInfos(PBHelperClient.getBuilder(qu));
        }
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.RollingUpgradeActionProto convert(HdfsConstants.RollingUpgradeAction a) {
        switch (a) {
            case QUERY: {
                return ClientNamenodeProtocolProtos.RollingUpgradeActionProto.QUERY;
            }
            case PREPARE: {
                return ClientNamenodeProtocolProtos.RollingUpgradeActionProto.START;
            }
            case FINALIZE: {
                return ClientNamenodeProtocolProtos.RollingUpgradeActionProto.FINALIZE;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)a));
    }

    public static RollingUpgradeInfo convert(ClientNamenodeProtocolProtos.RollingUpgradeInfoProto proto) {
        HdfsProtos.RollingUpgradeStatusProto status = proto.getStatus();
        return new RollingUpgradeInfo(status.getBlockPoolId(), proto.getCreatedRollbackImages(), proto.getStartTime(), proto.getFinalizeTime());
    }

    public static DatanodeStorageReport[] convertDatanodeStorageReports(List<ClientNamenodeProtocolProtos.DatanodeStorageReportProto> protos) {
        DatanodeStorageReport[] reports = new DatanodeStorageReport[protos.size()];
        for (int i = 0; i < reports.length; ++i) {
            reports[i] = PBHelperClient.convertDatanodeStorageReport(protos.get(i));
        }
        return reports;
    }

    public static DatanodeStorageReport convertDatanodeStorageReport(ClientNamenodeProtocolProtos.DatanodeStorageReportProto proto) {
        return new DatanodeStorageReport(PBHelperClient.convert(proto.getDatanodeInfo()), PBHelperClient.convertStorageReports(proto.getStorageReportsList()));
    }

    public static StorageReport[] convertStorageReports(List<HdfsProtos.StorageReportProto> list) {
        StorageReport[] report = new StorageReport[list.size()];
        for (int i = 0; i < report.length; ++i) {
            report[i] = PBHelperClient.convert(list.get(i));
        }
        return report;
    }

    public static StorageReport convert(HdfsProtos.StorageReportProto p) {
        return new StorageReport(p.hasStorage() ? PBHelperClient.convert(p.getStorage()) : new DatanodeStorage(p.getStorageUuid()), p.getFailed(), p.getCapacity(), p.getDfsUsed(), p.getRemaining(), p.getBlockPoolUsed());
    }

    public static DatanodeStorage convert(HdfsProtos.DatanodeStorageProto s) {
        return new DatanodeStorage(s.getStorageUuid(), PBHelperClient.convertState(s.getState()), PBHelperClient.convertStorageType(s.getStorageType()));
    }

    private static DatanodeStorage.State convertState(HdfsProtos.DatanodeStorageProto.StorageState state) {
        switch (state) {
            case READ_ONLY_SHARED: {
                return DatanodeStorage.State.READ_ONLY_SHARED;
            }
        }
        return DatanodeStorage.State.NORMAL;
    }

    public static ClientNamenodeProtocolProtos.SafeModeActionProto convert(HdfsConstants.SafeModeAction a) {
        switch (a) {
            case SAFEMODE_LEAVE: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_LEAVE;
            }
            case SAFEMODE_ENTER: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_ENTER;
            }
            case SAFEMODE_GET: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_GET;
            }
            case SAFEMODE_FORCE_EXIT: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_FORCE_EXIT;
            }
        }
        throw new IllegalArgumentException("Unexpected SafeModeAction :" + (Object)((Object)a));
    }

    public static DatanodeInfo[] convert(List<HdfsProtos.DatanodeInfoProto> list) {
        DatanodeInfo[] info = new DatanodeInfo[list.size()];
        for (int i = 0; i < info.length; ++i) {
            info[i] = PBHelperClient.convert(list.get(i));
        }
        return info;
    }

    public static long[] convert(ClientNamenodeProtocolProtos.GetFsStatsResponseProto res) {
        long[] result = new long[]{res.getCapacity(), res.getUsed(), res.getRemaining(), res.getUnderReplicated(), res.getCorruptBlocks(), res.getMissingBlocks(), res.getMissingReplOneBlocks(), res.hasBlocksInFuture() ? res.getBlocksInFuture() : 0L, res.getPendingDeletionBlocks()};
        return result;
    }

    public static ClientNamenodeProtocolProtos.DatanodeReportTypeProto convert(HdfsConstants.DatanodeReportType t) {
        switch (t) {
            case ALL: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.ALL;
            }
            case LIVE: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.LIVE;
            }
            case DEAD: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.DEAD;
            }
            case DECOMMISSIONING: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.DECOMMISSIONING;
            }
        }
        throw new IllegalArgumentException("Unexpected data type report:" + (Object)((Object)t));
    }

    public static DirectoryListing convert(HdfsProtos.DirectoryListingProto dl) {
        if (dl == null) {
            return null;
        }
        List<HdfsProtos.HdfsFileStatusProto> partList = dl.getPartialListingList();
        return new DirectoryListing(partList.isEmpty() ? new HdfsLocatedFileStatus[]{} : PBHelperClient.convert(partList.toArray(new HdfsProtos.HdfsFileStatusProto[partList.size()])), dl.getRemainingEntries());
    }

    public static HdfsFileStatus[] convert(HdfsProtos.HdfsFileStatusProto[] fs) {
        if (fs == null) {
            return null;
        }
        int len = fs.length;
        HdfsFileStatus[] result = new HdfsFileStatus[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelperClient.convert(fs[i]);
        }
        return result;
    }

    public static int convertCreateFlag(EnumSetWritable<CreateFlag> flag) {
        int value = 0;
        if (flag.contains((Object)CreateFlag.APPEND)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.APPEND.getNumber();
        }
        if (flag.contains((Object)CreateFlag.CREATE)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.CREATE.getNumber();
        }
        if (flag.contains((Object)CreateFlag.OVERWRITE)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.OVERWRITE.getNumber();
        }
        if (flag.contains((Object)CreateFlag.LAZY_PERSIST)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.LAZY_PERSIST.getNumber();
        }
        if (flag.contains((Object)CreateFlag.NEW_BLOCK)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.NEW_BLOCK.getNumber();
        }
        return value;
    }

    public static FsServerDefaults convert(HdfsProtos.FsServerDefaultsProto fs) {
        if (fs == null) {
            return null;
        }
        return new FsServerDefaults(fs.getBlockSize(), fs.getBytesPerChecksum(), fs.getWritePacketSize(), (short)fs.getReplication(), fs.getFileBufferSize(), fs.getEncryptDataTransfer(), fs.getTrashInterval(), PBHelperClient.convert(fs.getChecksumType()));
    }

    public static List<HdfsProtos.CryptoProtocolVersionProto> convert(CryptoProtocolVersion[] versions) {
        ArrayList protos = Lists.newArrayListWithCapacity((int)versions.length);
        for (CryptoProtocolVersion v : versions) {
            protos.add(PBHelperClient.convert(v));
        }
        return protos;
    }

    static List<HdfsProtos.StorageTypesProto> convert(StorageType[][] types) {
        ArrayList list = Lists.newArrayList();
        if (types != null) {
            for (StorageType[] ts : types) {
                HdfsProtos.StorageTypesProto.Builder builder = HdfsProtos.StorageTypesProto.newBuilder();
                builder.addAllStorageTypes(PBHelperClient.convertStorageTypes(ts));
                list.add(builder.build());
            }
        }
        return list;
    }

    public static HdfsProtos.BlockStoragePolicyProto convert(BlockStoragePolicy policy) {
        HdfsProtos.StorageTypesProto replicationFallbackProto;
        HdfsProtos.BlockStoragePolicyProto.Builder builder = HdfsProtos.BlockStoragePolicyProto.newBuilder().setPolicyId(policy.getId()).setName(policy.getName());
        HdfsProtos.StorageTypesProto creationProto = PBHelperClient.convert(policy.getStorageTypes());
        Preconditions.checkArgument((creationProto != null ? 1 : 0) != 0);
        builder.setCreationPolicy(creationProto);
        HdfsProtos.StorageTypesProto creationFallbackProto = PBHelperClient.convert(policy.getCreationFallbacks());
        if (creationFallbackProto != null) {
            builder.setCreationFallbackPolicy(creationFallbackProto);
        }
        if ((replicationFallbackProto = PBHelperClient.convert(policy.getReplicationFallbacks())) != null) {
            builder.setReplicationFallbackPolicy(replicationFallbackProto);
        }
        return builder.build();
    }

    public static HdfsProtos.StorageTypesProto convert(StorageType[] types) {
        if (types == null || types.length == 0) {
            return null;
        }
        List<HdfsProtos.StorageTypeProto> list = PBHelperClient.convertStorageTypes(types);
        return HdfsProtos.StorageTypesProto.newBuilder().addAllStorageTypes(list).build();
    }

    public static DatanodeID[] convert(HdfsProtos.DatanodeIDProto[] did) {
        if (did == null) {
            return null;
        }
        int len = did.length;
        DatanodeID[] result = new DatanodeID[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelperClient.convert(did[i]);
        }
        return result;
    }

    public static HdfsProtos.BlockProto convert(Block b) {
        return HdfsProtos.BlockProto.newBuilder().setBlockId(b.getBlockId()).setGenStamp(b.getGenerationStamp()).setNumBytes(b.getNumBytes()).build();
    }

    public static Block convert(HdfsProtos.BlockProto b) {
        return new Block(b.getBlockId(), b.getNumBytes(), b.getGenStamp());
    }

    public static DatanodeInfo[] convert(HdfsProtos.DatanodeInfoProto[] di) {
        if (di == null) {
            return null;
        }
        DatanodeInfo[] result = new DatanodeInfo[di.length];
        for (int i = 0; i < di.length; ++i) {
            result[i] = PBHelperClient.convert(di[i]);
        }
        return result;
    }

    public static ClientNamenodeProtocolProtos.DatanodeStorageReportProto convertDatanodeStorageReport(DatanodeStorageReport report) {
        return ClientNamenodeProtocolProtos.DatanodeStorageReportProto.newBuilder().setDatanodeInfo(PBHelperClient.convert(report.getDatanodeInfo())).addAllStorageReports(PBHelperClient.convertStorageReports(report.getStorageReports())).build();
    }

    public static List<ClientNamenodeProtocolProtos.DatanodeStorageReportProto> convertDatanodeStorageReports(DatanodeStorageReport[] reports) {
        ArrayList<ClientNamenodeProtocolProtos.DatanodeStorageReportProto> protos = new ArrayList<ClientNamenodeProtocolProtos.DatanodeStorageReportProto>(reports.length);
        for (DatanodeStorageReport report : reports) {
            protos.add(PBHelperClient.convertDatanodeStorageReport(report));
        }
        return protos;
    }

    public static LocatedBlock[] convertLocatedBlock(HdfsProtos.LocatedBlockProto[] lb) {
        if (lb == null) {
            return null;
        }
        return PBHelperClient.convertLocatedBlock(Arrays.asList(lb)).toArray(new LocatedBlock[lb.length]);
    }

    public static HdfsProtos.LocatedBlocksProto convert(LocatedBlocks lb) {
        if (lb == null) {
            return null;
        }
        HdfsProtos.LocatedBlocksProto.Builder builder = HdfsProtos.LocatedBlocksProto.newBuilder();
        if (lb.getLastLocatedBlock() != null) {
            builder.setLastBlock(PBHelperClient.convertLocatedBlock(lb.getLastLocatedBlock()));
        }
        if (lb.getFileEncryptionInfo() != null) {
            builder.setFileEncryptionInfo(PBHelperClient.convert(lb.getFileEncryptionInfo()));
        }
        if (lb.getErasureCodingPolicy() != null) {
            builder.setEcPolicy(PBHelperClient.convertErasureCodingPolicy(lb.getErasureCodingPolicy()));
        }
        return builder.setFileLength(lb.getFileLength()).setUnderConstruction(lb.isUnderConstruction()).addAllBlocks(PBHelperClient.convertLocatedBlocks2(lb.getLocatedBlocks())).setIsLastBlockComplete(lb.isLastBlockComplete()).build();
    }

    public static HdfsProtos.DataEncryptionKeyProto convert(DataEncryptionKey bet) {
        HdfsProtos.DataEncryptionKeyProto.Builder b = HdfsProtos.DataEncryptionKeyProto.newBuilder().setKeyId(bet.keyId).setBlockPoolId(bet.blockPoolId).setNonce(PBHelperClient.getByteString(bet.nonce)).setEncryptionKey(PBHelperClient.getByteString(bet.encryptionKey)).setExpiryDate(bet.expiryDate);
        if (bet.encryptionAlgorithm != null) {
            b.setEncryptionAlgorithm(bet.encryptionAlgorithm);
        }
        return b.build();
    }

    public static HdfsProtos.FsServerDefaultsProto convert(FsServerDefaults fs) {
        if (fs == null) {
            return null;
        }
        return HdfsProtos.FsServerDefaultsProto.newBuilder().setBlockSize(fs.getBlockSize()).setBytesPerChecksum(fs.getBytesPerChecksum()).setWritePacketSize(fs.getWritePacketSize()).setReplication(fs.getReplication()).setFileBufferSize(fs.getFileBufferSize()).setEncryptDataTransfer(fs.getEncryptDataTransfer()).setTrashInterval(fs.getTrashInterval()).setChecksumType(PBHelperClient.convert(fs.getChecksumType())).build();
    }

    public static EnumSetWritable<CreateFlag> convertCreateFlag(int flag) {
        EnumSet<CreateFlag> result = EnumSet.noneOf(CreateFlag.class);
        if ((flag & 4) == 4) {
            result.add(CreateFlag.APPEND);
        }
        if ((flag & 1) == 1) {
            result.add(CreateFlag.CREATE);
        }
        if ((flag & 2) == 2) {
            result.add(CreateFlag.OVERWRITE);
        }
        if ((flag & 0x10) == 16) {
            result.add(CreateFlag.LAZY_PERSIST);
        }
        if ((flag & 0x20) == 32) {
            result.add(CreateFlag.NEW_BLOCK);
        }
        return new EnumSetWritable(result, CreateFlag.class);
    }

    public static EnumSet<CacheFlag> convertCacheFlags(int flags) {
        EnumSet<CacheFlag> result = EnumSet.noneOf(CacheFlag.class);
        if ((flags & 1) == 1) {
            result.add(CacheFlag.FORCE);
        }
        return result;
    }

    public static HdfsProtos.HdfsFileStatusProto convert(HdfsFileStatus fs) {
        HdfsLocatedFileStatus lfs;
        LocatedBlocks locations;
        if (fs == null) {
            return null;
        }
        HdfsProtos.HdfsFileStatusProto.FileType fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_FILE;
        if (fs.isDir()) {
            fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_DIR;
        } else if (fs.isSymlink()) {
            fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_SYMLINK;
        }
        HdfsProtos.HdfsFileStatusProto.Builder builder = HdfsProtos.HdfsFileStatusProto.newBuilder().setLength(fs.getLen()).setFileType(fType).setBlockReplication(fs.getReplication()).setBlocksize(fs.getBlockSize()).setModificationTime(fs.getModificationTime()).setAccessTime(fs.getAccessTime()).setPermission(PBHelperClient.convert(fs.getPermission())).setOwner(fs.getOwner()).setGroup(fs.getGroup()).setFileId(fs.getFileId()).setChildrenNum(fs.getChildrenNum()).setPath(PBHelperClient.getByteString(fs.getLocalNameInBytes())).setStoragePolicy(fs.getStoragePolicy());
        if (fs.isSymlink()) {
            builder.setSymlink(PBHelperClient.getByteString(fs.getSymlinkInBytes()));
        }
        if (fs.getFileEncryptionInfo() != null) {
            builder.setFileEncryptionInfo(PBHelperClient.convert(fs.getFileEncryptionInfo()));
        }
        if (fs instanceof HdfsLocatedFileStatus && (locations = (lfs = (HdfsLocatedFileStatus)fs).getBlockLocations()) != null) {
            builder.setLocations(PBHelperClient.convert(locations));
        }
        if (fs.getErasureCodingPolicy() != null) {
            builder.setEcPolicy(PBHelperClient.convertErasureCodingPolicy(fs.getErasureCodingPolicy()));
        }
        return builder.build();
    }

    public static HdfsProtos.SnapshottableDirectoryStatusProto convert(SnapshottableDirectoryStatus status) {
        if (status == null) {
            return null;
        }
        int snapshotNumber = status.getSnapshotNumber();
        int snapshotQuota = status.getSnapshotQuota();
        byte[] parentFullPath = status.getParentFullPath();
        ByteString parentFullPathBytes = PBHelperClient.getByteString(parentFullPath == null ? DFSUtilClient.EMPTY_BYTES : parentFullPath);
        HdfsProtos.HdfsFileStatusProto fs = PBHelperClient.convert(status.getDirStatus());
        HdfsProtos.SnapshottableDirectoryStatusProto.Builder builder = HdfsProtos.SnapshottableDirectoryStatusProto.newBuilder().setSnapshotNumber(snapshotNumber).setSnapshotQuota(snapshotQuota).setParentFullpath(parentFullPathBytes).setDirStatus(fs);
        return builder.build();
    }

    public static HdfsProtos.HdfsFileStatusProto[] convert(HdfsFileStatus[] fs) {
        if (fs == null) {
            return null;
        }
        int len = fs.length;
        HdfsProtos.HdfsFileStatusProto[] result = new HdfsProtos.HdfsFileStatusProto[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelperClient.convert(fs[i]);
        }
        return result;
    }

    public static HdfsProtos.DirectoryListingProto convert(DirectoryListing d) {
        if (d == null) {
            return null;
        }
        return HdfsProtos.DirectoryListingProto.newBuilder().addAllPartialListing(Arrays.asList(PBHelperClient.convert(d.getPartialListing()))).setRemainingEntries(d.getRemainingEntries()).build();
    }

    public static ClientNamenodeProtocolProtos.GetFsStatsResponseProto convert(long[] fsStats) {
        ClientNamenodeProtocolProtos.GetFsStatsResponseProto.Builder result = ClientNamenodeProtocolProtos.GetFsStatsResponseProto.newBuilder();
        if (fsStats.length >= 1) {
            result.setCapacity(fsStats[0]);
        }
        if (fsStats.length >= 2) {
            result.setUsed(fsStats[1]);
        }
        if (fsStats.length >= 3) {
            result.setRemaining(fsStats[2]);
        }
        if (fsStats.length >= 4) {
            result.setUnderReplicated(fsStats[3]);
        }
        if (fsStats.length >= 5) {
            result.setCorruptBlocks(fsStats[4]);
        }
        if (fsStats.length >= 6) {
            result.setMissingBlocks(fsStats[5]);
        }
        if (fsStats.length >= 7) {
            result.setMissingReplOneBlocks(fsStats[6]);
        }
        if (fsStats.length >= 8) {
            result.setBlocksInFuture(fsStats[7]);
        }
        if (fsStats.length >= 9) {
            result.setPendingDeletionBlocks(fsStats[8]);
        }
        return result.build();
    }

    public static HdfsConstants.DatanodeReportType convert(ClientNamenodeProtocolProtos.DatanodeReportTypeProto t) {
        switch (t) {
            case ALL: {
                return HdfsConstants.DatanodeReportType.ALL;
            }
            case LIVE: {
                return HdfsConstants.DatanodeReportType.LIVE;
            }
            case DEAD: {
                return HdfsConstants.DatanodeReportType.DEAD;
            }
            case DECOMMISSIONING: {
                return HdfsConstants.DatanodeReportType.DECOMMISSIONING;
            }
        }
        throw new IllegalArgumentException("Unexpected data type report:" + (Object)((Object)t));
    }

    public static HdfsConstants.SafeModeAction convert(ClientNamenodeProtocolProtos.SafeModeActionProto a) {
        switch (a) {
            case SAFEMODE_LEAVE: {
                return HdfsConstants.SafeModeAction.SAFEMODE_LEAVE;
            }
            case SAFEMODE_ENTER: {
                return HdfsConstants.SafeModeAction.SAFEMODE_ENTER;
            }
            case SAFEMODE_GET: {
                return HdfsConstants.SafeModeAction.SAFEMODE_GET;
            }
            case SAFEMODE_FORCE_EXIT: {
                return HdfsConstants.SafeModeAction.SAFEMODE_FORCE_EXIT;
            }
        }
        throw new IllegalArgumentException("Unexpected SafeModeAction :" + (Object)((Object)a));
    }

    public static HdfsConstants.RollingUpgradeAction convert(ClientNamenodeProtocolProtos.RollingUpgradeActionProto a) {
        switch (a) {
            case QUERY: {
                return HdfsConstants.RollingUpgradeAction.QUERY;
            }
            case START: {
                return HdfsConstants.RollingUpgradeAction.PREPARE;
            }
            case FINALIZE: {
                return HdfsConstants.RollingUpgradeAction.FINALIZE;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)a));
    }

    public static HdfsProtos.RollingUpgradeStatusProto convertRollingUpgradeStatus(RollingUpgradeStatus status) {
        return HdfsProtos.RollingUpgradeStatusProto.newBuilder().setBlockPoolId(status.getBlockPoolId()).setFinalized(status.isFinalized()).build();
    }

    public static RollingUpgradeStatus convert(HdfsProtos.RollingUpgradeStatusProto proto) {
        return new RollingUpgradeStatus(proto.getBlockPoolId(), proto.getFinalized());
    }

    public static ClientNamenodeProtocolProtos.RollingUpgradeInfoProto convert(RollingUpgradeInfo info) {
        return ClientNamenodeProtocolProtos.RollingUpgradeInfoProto.newBuilder().setStatus(PBHelperClient.convertRollingUpgradeStatus(info)).setCreatedRollbackImages(info.createdRollbackImages()).setStartTime(info.getStartTime()).setFinalizeTime(info.getFinalizeTime()).build();
    }

    public static HdfsProtos.CorruptFileBlocksProto convert(CorruptFileBlocks c) {
        if (c == null) {
            return null;
        }
        return HdfsProtos.CorruptFileBlocksProto.newBuilder().addAllFiles(Arrays.asList(c.getFiles())).setCookie(c.getCookie()).build();
    }

    public static HdfsProtos.ContentSummaryProto convert(ContentSummary cs) {
        if (cs == null) {
            return null;
        }
        HdfsProtos.ContentSummaryProto.Builder builder = HdfsProtos.ContentSummaryProto.newBuilder();
        builder.setLength(cs.getLength()).setFileCount(cs.getFileCount()).setDirectoryCount(cs.getDirectoryCount()).setSnapshotLength(cs.getSnapshotLength()).setSnapshotFileCount(cs.getSnapshotFileCount()).setSnapshotDirectoryCount(cs.getSnapshotDirectoryCount()).setSnapshotSpaceConsumed(cs.getSnapshotSpaceConsumed()).setQuota(cs.getQuota()).setSpaceConsumed(cs.getSpaceConsumed()).setSpaceQuota(cs.getSpaceQuota());
        if (cs.isTypeQuotaSet() || cs.isTypeConsumedAvailable()) {
            builder.setTypeQuotaInfos(PBHelperClient.getBuilder((QuotaUsage)cs));
        }
        return builder.build();
    }

    private static void addStorageTypes(HdfsProtos.StorageTypeQuotaInfosProto typeQuotaInfos, QuotaUsage.Builder builder) {
        for (HdfsProtos.StorageTypeQuotaInfoProto info : typeQuotaInfos.getTypeQuotaInfoList()) {
            StorageType type = PBHelperClient.convertStorageType(info.getType());
            builder.typeConsumed(type, info.getConsumed());
            builder.typeQuota(type, info.getQuota());
        }
    }

    private static HdfsProtos.StorageTypeQuotaInfosProto.Builder getBuilder(QuotaUsage qu) {
        HdfsProtos.StorageTypeQuotaInfosProto.Builder isb = HdfsProtos.StorageTypeQuotaInfosProto.newBuilder();
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            HdfsProtos.StorageTypeQuotaInfoProto info = HdfsProtos.StorageTypeQuotaInfoProto.newBuilder().setType(PBHelperClient.convertStorageType(t)).setConsumed(qu.getTypeConsumed(t)).setQuota(qu.getTypeQuota(t)).build();
            isb.addTypeQuotaInfo(info);
        }
        return isb;
    }

    public static HdfsProtos.DatanodeStorageProto convert(DatanodeStorage s) {
        return HdfsProtos.DatanodeStorageProto.newBuilder().setState(PBHelperClient.convertState(s.getState())).setStorageType(PBHelperClient.convertStorageType(s.getStorageType())).setStorageUuid(s.getStorageID()).build();
    }

    private static HdfsProtos.DatanodeStorageProto.StorageState convertState(DatanodeStorage.State state) {
        switch (state) {
            case READ_ONLY_SHARED: {
                return HdfsProtos.DatanodeStorageProto.StorageState.READ_ONLY_SHARED;
            }
        }
        return HdfsProtos.DatanodeStorageProto.StorageState.NORMAL;
    }

    public static HdfsProtos.StorageReportProto convert(StorageReport r) {
        HdfsProtos.StorageReportProto.Builder builder = HdfsProtos.StorageReportProto.newBuilder().setBlockPoolUsed(r.getBlockPoolUsed()).setCapacity(r.getCapacity()).setDfsUsed(r.getDfsUsed()).setRemaining(r.getRemaining()).setStorageUuid(r.getStorage().getStorageID()).setStorage(PBHelperClient.convert(r.getStorage()));
        return builder.build();
    }

    public static List<HdfsProtos.StorageReportProto> convertStorageReports(StorageReport[] storages) {
        ArrayList<HdfsProtos.StorageReportProto> protos = new ArrayList<HdfsProtos.StorageReportProto>(storages.length);
        for (StorageReport storage : storages) {
            protos.add(PBHelperClient.convert(storage));
        }
        return protos;
    }

    public static HdfsProtos.SnapshottableDirectoryListingProto convert(SnapshottableDirectoryStatus[] status) {
        if (status == null) {
            return null;
        }
        HdfsProtos.SnapshottableDirectoryStatusProto[] protos = new HdfsProtos.SnapshottableDirectoryStatusProto[status.length];
        for (int i = 0; i < status.length; ++i) {
            protos[i] = PBHelperClient.convert(status[i]);
        }
        List<HdfsProtos.SnapshottableDirectoryStatusProto> protoList = Arrays.asList(protos);
        return HdfsProtos.SnapshottableDirectoryListingProto.newBuilder().addAllSnapshottableDirListing(protoList).build();
    }

    public static HdfsProtos.SnapshotDiffReportEntryProto convert(SnapshotDiffReport.DiffReportEntry entry) {
        if (entry == null) {
            return null;
        }
        ByteString sourcePath = PBHelperClient.getByteString(entry.getSourcePath() == null ? DFSUtilClient.EMPTY_BYTES : entry.getSourcePath());
        String modification = entry.getType().getLabel();
        HdfsProtos.SnapshotDiffReportEntryProto.Builder builder = HdfsProtos.SnapshotDiffReportEntryProto.newBuilder().setFullpath(sourcePath).setModificationLabel(modification);
        if (entry.getType() == SnapshotDiffReport.DiffType.RENAME) {
            ByteString targetPath = PBHelperClient.getByteString(entry.getTargetPath() == null ? DFSUtilClient.EMPTY_BYTES : entry.getTargetPath());
            builder.setTargetPath(targetPath);
        }
        return builder.build();
    }

    public static HdfsProtos.SnapshotDiffReportProto convert(SnapshotDiffReport report) {
        if (report == null) {
            return null;
        }
        List<SnapshotDiffReport.DiffReportEntry> entries = report.getDiffList();
        ArrayList<HdfsProtos.SnapshotDiffReportEntryProto> entryProtos = new ArrayList<HdfsProtos.SnapshotDiffReportEntryProto>();
        for (SnapshotDiffReport.DiffReportEntry entry : entries) {
            HdfsProtos.SnapshotDiffReportEntryProto entryProto = PBHelperClient.convert(entry);
            if (entryProto == null) continue;
            entryProtos.add(entryProto);
        }
        return HdfsProtos.SnapshotDiffReportProto.newBuilder().setSnapshotRoot(report.getSnapshotRoot()).setFromSnapshot(report.getFromSnapshot()).setToSnapshot(report.getLaterSnapshotName()).addAllDiffReportEntries(entryProtos).build();
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveStatsProto convert(CacheDirectiveStats stats) {
        ClientNamenodeProtocolProtos.CacheDirectiveStatsProto.Builder builder = ClientNamenodeProtocolProtos.CacheDirectiveStatsProto.newBuilder();
        builder.setBytesNeeded(stats.getBytesNeeded());
        builder.setBytesCached(stats.getBytesCached());
        builder.setFilesNeeded(stats.getFilesNeeded());
        builder.setFilesCached(stats.getFilesCached());
        builder.setHasExpired(stats.hasExpired());
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveEntryProto convert(CacheDirectiveEntry entry) {
        ClientNamenodeProtocolProtos.CacheDirectiveEntryProto.Builder builder = ClientNamenodeProtocolProtos.CacheDirectiveEntryProto.newBuilder();
        builder.setInfo(PBHelperClient.convert(entry.getInfo()));
        builder.setStats(PBHelperClient.convert(entry.getStats()));
        return builder.build();
    }

    public static boolean[] convertBooleanList(List<Boolean> targetPinningsList) {
        boolean[] targetPinnings = new boolean[targetPinningsList.size()];
        for (int i = 0; i < targetPinningsList.size(); ++i) {
            targetPinnings[i] = targetPinningsList.get(i);
        }
        return targetPinnings;
    }

    public static ClientNamenodeProtocolProtos.CachePoolStatsProto convert(CachePoolStats stats) {
        ClientNamenodeProtocolProtos.CachePoolStatsProto.Builder builder = ClientNamenodeProtocolProtos.CachePoolStatsProto.newBuilder();
        builder.setBytesNeeded(stats.getBytesNeeded());
        builder.setBytesCached(stats.getBytesCached());
        builder.setBytesOverlimit(stats.getBytesOverlimit());
        builder.setFilesNeeded(stats.getFilesNeeded());
        builder.setFilesCached(stats.getFilesCached());
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CachePoolEntryProto convert(CachePoolEntry entry) {
        ClientNamenodeProtocolProtos.CachePoolEntryProto.Builder builder = ClientNamenodeProtocolProtos.CachePoolEntryProto.newBuilder();
        builder.setInfo(PBHelperClient.convert(entry.getInfo()));
        builder.setStats(PBHelperClient.convert(entry.getStats()));
        return builder.build();
    }

    public static HdfsProtos.DatanodeLocalInfoProto convert(DatanodeLocalInfo info) {
        HdfsProtos.DatanodeLocalInfoProto.Builder builder = HdfsProtos.DatanodeLocalInfoProto.newBuilder();
        builder.setSoftwareVersion(info.getSoftwareVersion());
        builder.setConfigVersion(info.getConfigVersion());
        builder.setUptime(info.getUptime());
        return builder.build();
    }

    public static AclProtos.GetAclStatusResponseProto convert(AclStatus e) {
        AclProtos.AclStatusProto.Builder builder = AclProtos.AclStatusProto.newBuilder();
        builder.setOwner(e.getOwner()).setGroup(e.getGroup()).setSticky(e.isStickyBit()).addAllEntries(PBHelperClient.convertAclEntryProto(e.getEntries()));
        if (e.getPermission() != null) {
            builder.setPermission(PBHelperClient.convert(e.getPermission()));
        }
        AclProtos.AclStatusProto r = builder.build();
        return AclProtos.GetAclStatusResponseProto.newBuilder().setResult(r).build();
    }

    public static EnumSet<XAttrSetFlag> convert(int flag) {
        EnumSet<XAttrSetFlag> result = EnumSet.noneOf(XAttrSetFlag.class);
        if ((flag & 1) == 1) {
            result.add(XAttrSetFlag.CREATE);
        }
        if ((flag & 2) == 2) {
            result.add(XAttrSetFlag.REPLACE);
        }
        return result;
    }

    public static XAttr convertXAttr(XAttrProtos.XAttrProto a) {
        XAttr.Builder builder = new XAttr.Builder();
        builder.setNameSpace(PBHelperClient.convert(a.getNamespace()));
        if (a.hasName()) {
            builder.setName(a.getName());
        }
        if (a.hasValue()) {
            builder.setValue(a.getValue().toByteArray());
        }
        return builder.build();
    }

    public static XAttrProtos.GetXAttrsResponseProto convertXAttrsResponse(List<XAttr> xAttrs) {
        XAttrProtos.GetXAttrsResponseProto.Builder builder = XAttrProtos.GetXAttrsResponseProto.newBuilder();
        if (xAttrs != null) {
            builder.addAllXAttrs(PBHelperClient.convertXAttrProto(xAttrs));
        }
        return builder.build();
    }

    public static XAttrProtos.ListXAttrsResponseProto convertListXAttrsResponse(List<XAttr> names) {
        XAttrProtos.ListXAttrsResponseProto.Builder builder = XAttrProtos.ListXAttrsResponseProto.newBuilder();
        if (names != null) {
            builder.addAllXAttrs(PBHelperClient.convertXAttrProto(names));
        }
        return builder.build();
    }

    public static EncryptionZonesProtos.EncryptionZoneProto convert(EncryptionZone zone) {
        return EncryptionZonesProtos.EncryptionZoneProto.newBuilder().setId(zone.getId()).setPath(zone.getPath()).setSuite(PBHelperClient.convert(zone.getSuite())).setCryptoProtocolVersion(PBHelperClient.convert(zone.getVersion())).setKeyName(zone.getKeyName()).build();
    }

    public static ShortCircuitShm.SlotId convert(DataTransferProtos.ShortCircuitShmSlotProto slotId) {
        return new ShortCircuitShm.SlotId(PBHelperClient.convert(slotId.getShmId()), slotId.getSlotIdx());
    }

    public static ClientNamenodeProtocolProtos.GetEditsFromTxidResponseProto convertEditsResponse(EventBatchList el) {
        InotifyProtos.EventsListProto.Builder builder = InotifyProtos.EventsListProto.newBuilder();
        for (EventBatch b : el.getBatches()) {
            ArrayList events = Lists.newArrayList();
            block10: for (Event e : b.getEvents()) {
                switch (e.getEventType()) {
                    case CLOSE: {
                        Event.CloseEvent ce = (Event.CloseEvent)e;
                        events.add(InotifyProtos.EventProto.newBuilder().setType(InotifyProtos.EventType.EVENT_CLOSE).setContents(InotifyProtos.CloseEventProto.newBuilder().setPath(ce.getPath()).setFileSize(ce.getFileSize()).setTimestamp(ce.getTimestamp()).build().toByteString()).build());
                        continue block10;
                    }
                    case CREATE: {
                        Event.CreateEvent ce2 = (Event.CreateEvent)e;
                        events.add(InotifyProtos.EventProto.newBuilder().setType(InotifyProtos.EventType.EVENT_CREATE).setContents(InotifyProtos.CreateEventProto.newBuilder().setType(PBHelperClient.createTypeConvert(ce2.getiNodeType())).setPath(ce2.getPath()).setCtime(ce2.getCtime()).setOwnerName(ce2.getOwnerName()).setGroupName(ce2.getGroupName()).setPerms(PBHelperClient.convert(ce2.getPerms())).setReplication(ce2.getReplication()).setSymlinkTarget(ce2.getSymlinkTarget() == null ? "" : ce2.getSymlinkTarget()).setDefaultBlockSize(ce2.getDefaultBlockSize()).setOverwrite(ce2.getOverwrite()).build().toByteString()).build());
                        continue block10;
                    }
                    case METADATA: {
                        Event.MetadataUpdateEvent me = (Event.MetadataUpdateEvent)e;
                        InotifyProtos.MetadataUpdateEventProto.Builder metaB = InotifyProtos.MetadataUpdateEventProto.newBuilder().setPath(me.getPath()).setType(PBHelperClient.metadataUpdateTypeConvert(me.getMetadataType())).setMtime(me.getMtime()).setAtime(me.getAtime()).setReplication(me.getReplication()).setOwnerName(me.getOwnerName() == null ? "" : me.getOwnerName()).setGroupName(me.getGroupName() == null ? "" : me.getGroupName()).addAllAcls((Iterable<? extends AclProtos.AclEntryProto>)(me.getAcls() == null ? Lists.newArrayList() : PBHelperClient.convertAclEntryProto(me.getAcls()))).addAllXAttrs((Iterable<? extends XAttrProtos.XAttrProto>)(me.getxAttrs() == null ? Lists.newArrayList() : PBHelperClient.convertXAttrProto(me.getxAttrs()))).setXAttrsRemoved(me.isxAttrsRemoved());
                        if (me.getPerms() != null) {
                            metaB.setPerms(PBHelperClient.convert(me.getPerms()));
                        }
                        events.add(InotifyProtos.EventProto.newBuilder().setType(InotifyProtos.EventType.EVENT_METADATA).setContents(metaB.build().toByteString()).build());
                        continue block10;
                    }
                    case RENAME: {
                        Event.RenameEvent re = (Event.RenameEvent)e;
                        events.add(InotifyProtos.EventProto.newBuilder().setType(InotifyProtos.EventType.EVENT_RENAME).setContents(InotifyProtos.RenameEventProto.newBuilder().setSrcPath(re.getSrcPath()).setDestPath(re.getDstPath()).setTimestamp(re.getTimestamp()).build().toByteString()).build());
                        continue block10;
                    }
                    case APPEND: {
                        Event.AppendEvent re2 = (Event.AppendEvent)e;
                        events.add(InotifyProtos.EventProto.newBuilder().setType(InotifyProtos.EventType.EVENT_APPEND).setContents(InotifyProtos.AppendEventProto.newBuilder().setPath(re2.getPath()).setNewBlock(re2.toNewBlock()).build().toByteString()).build());
                        continue block10;
                    }
                    case UNLINK: {
                        Event.UnlinkEvent ue = (Event.UnlinkEvent)e;
                        events.add(InotifyProtos.EventProto.newBuilder().setType(InotifyProtos.EventType.EVENT_UNLINK).setContents(InotifyProtos.UnlinkEventProto.newBuilder().setPath(ue.getPath()).setTimestamp(ue.getTimestamp()).build().toByteString()).build());
                        continue block10;
                    }
                    case TRUNCATE: {
                        Event.TruncateEvent te = (Event.TruncateEvent)e;
                        events.add(InotifyProtos.EventProto.newBuilder().setType(InotifyProtos.EventType.EVENT_TRUNCATE).setContents(InotifyProtos.TruncateEventProto.newBuilder().setPath(te.getPath()).setFileSize(te.getFileSize()).setTimestamp(te.getTimestamp()).build().toByteString()).build());
                        continue block10;
                    }
                    default: {
                        throw new RuntimeException("Unexpected inotify event: " + e);
                    }
                }
            }
            builder.addBatch(InotifyProtos.EventBatchProto.newBuilder().setTxid(b.getTxid()).addAllEvents(events));
        }
        builder.setFirstTxid(el.getFirstTxid());
        builder.setLastTxid(el.getLastTxid());
        builder.setSyncTxid(el.getSyncTxid());
        return ClientNamenodeProtocolProtos.GetEditsFromTxidResponseProto.newBuilder().setEventsList(builder.build()).build();
    }

    public static CryptoProtocolVersion[] convertCryptoProtocolVersions(List<HdfsProtos.CryptoProtocolVersionProto> protos) {
        ArrayList versions = Lists.newArrayListWithCapacity((int)protos.size());
        for (HdfsProtos.CryptoProtocolVersionProto p : protos) {
            versions.add(PBHelperClient.convert(p));
        }
        return versions.toArray(new CryptoProtocolVersion[0]);
    }

    public static HdfsProtos.PerFileEncryptionInfoProto convertPerFileEncInfo(FileEncryptionInfo info) {
        if (info == null) {
            return null;
        }
        return HdfsProtos.PerFileEncryptionInfoProto.newBuilder().setKey(PBHelperClient.getByteString(info.getEncryptedDataEncryptionKey())).setIv(PBHelperClient.getByteString(info.getIV())).setEzKeyVersionName(info.getEzKeyVersionName()).build();
    }

    public static HdfsProtos.ZoneEncryptionInfoProto convert(CipherSuite suite, CryptoProtocolVersion version, String keyName) {
        if (suite == null || version == null || keyName == null) {
            return null;
        }
        return HdfsProtos.ZoneEncryptionInfoProto.newBuilder().setSuite(PBHelperClient.convert(suite)).setCryptoProtocolVersion(PBHelperClient.convert(version)).setKeyName(keyName).build();
    }

    public static FileEncryptionInfo convert(HdfsProtos.PerFileEncryptionInfoProto fileProto, CipherSuite suite, CryptoProtocolVersion version, String keyName) {
        if (fileProto == null || suite == null || version == null || keyName == null) {
            return null;
        }
        byte[] key = fileProto.getKey().toByteArray();
        byte[] iv = fileProto.getIv().toByteArray();
        String ezKeyVersionName = fileProto.getEzKeyVersionName();
        return new FileEncryptionInfo(suite, version, key, iv, keyName, ezKeyVersionName);
    }

    public static DatanodeInfo[] convert(HdfsProtos.DatanodeInfosProto datanodeInfosProto) {
        List<HdfsProtos.DatanodeInfoProto> proto = datanodeInfosProto.getDatanodesList();
        DatanodeInfo[] infos = new DatanodeInfo[proto.size()];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = PBHelperClient.convert(proto.get(i));
        }
        return infos;
    }

    static List<HdfsProtos.DatanodeInfosProto> convert(DatanodeInfo[][] targets) {
        HdfsProtos.DatanodeInfosProto[] ret = new HdfsProtos.DatanodeInfosProto[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            ret[i] = HdfsProtos.DatanodeInfosProto.newBuilder().addAllDatanodes(PBHelperClient.convert(targets[i])).build();
        }
        return Arrays.asList(ret);
    }

    public static ECSchema convertECSchema(HdfsProtos.ECSchemaProto schema) {
        List<HdfsProtos.ECSchemaOptionEntryProto> optionsList = schema.getOptionsList();
        HashMap<String, String> options = new HashMap<String, String>(optionsList.size());
        for (HdfsProtos.ECSchemaOptionEntryProto option : optionsList) {
            options.put(option.getKey(), option.getValue());
        }
        return new ECSchema(schema.getCodecName(), schema.getDataUnits(), schema.getParityUnits(), options);
    }

    public static HdfsProtos.ECSchemaProto convertECSchema(ECSchema schema) {
        HdfsProtos.ECSchemaProto.Builder builder = HdfsProtos.ECSchemaProto.newBuilder().setCodecName(schema.getCodecName()).setDataUnits(schema.getNumDataUnits()).setParityUnits(schema.getNumParityUnits());
        Set entrySet = schema.getExtraOptions().entrySet();
        for (Map.Entry entry : entrySet) {
            builder.addOptions(HdfsProtos.ECSchemaOptionEntryProto.newBuilder().setKey((String)entry.getKey()).setValue((String)entry.getValue()).build());
        }
        return builder.build();
    }

    public static ErasureCodingPolicy convertErasureCodingPolicy(HdfsProtos.ErasureCodingPolicyProto policy) {
        return new ErasureCodingPolicy(policy.getName(), PBHelperClient.convertECSchema(policy.getSchema()), policy.getCellSize(), (byte)policy.getId());
    }

    public static HdfsProtos.ErasureCodingPolicyProto convertErasureCodingPolicy(ErasureCodingPolicy policy) {
        HdfsProtos.ErasureCodingPolicyProto.Builder builder = HdfsProtos.ErasureCodingPolicyProto.newBuilder().setName(policy.getName()).setSchema(PBHelperClient.convertECSchema(policy.getSchema())).setCellSize(policy.getCellSize()).setId(policy.getId());
        return builder.build();
    }

    public static HdfsProtos.DatanodeInfosProto convertToProto(DatanodeInfo[] datanodeInfos) {
        HdfsProtos.DatanodeInfosProto.Builder builder = HdfsProtos.DatanodeInfosProto.newBuilder();
        for (DatanodeInfo datanodeInfo : datanodeInfos) {
            builder.addDatanodes(PBHelperClient.convert(datanodeInfo));
        }
        return builder.build();
    }

    public static EnumSet<AddBlockFlag> convertAddBlockFlags(List<ClientNamenodeProtocolProtos.AddBlockFlagProto> addBlockFlags) {
        EnumSet<AddBlockFlag> flags = EnumSet.noneOf(AddBlockFlag.class);
        for (ClientNamenodeProtocolProtos.AddBlockFlagProto af : addBlockFlags) {
            AddBlockFlag flag = AddBlockFlag.valueOf((short)af.getNumber());
            if (flag == null) continue;
            flags.add(flag);
        }
        return flags;
    }

    public static List<ClientNamenodeProtocolProtos.AddBlockFlagProto> convertAddBlockFlags(EnumSet<AddBlockFlag> flags) {
        ArrayList<ClientNamenodeProtocolProtos.AddBlockFlagProto> ret = new ArrayList<ClientNamenodeProtocolProtos.AddBlockFlagProto>();
        for (AddBlockFlag flag : flags) {
            ClientNamenodeProtocolProtos.AddBlockFlagProto abfp = ClientNamenodeProtocolProtos.AddBlockFlagProto.valueOf(flag.getMode());
            if (abfp == null) continue;
            ret.add(abfp);
        }
        return ret;
    }
}

