/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.scala;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.QueryableStateStream;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.functions.aggregation.SumAggregator;
import org.apache.flink.streaming.api.functions.co.ProcessJoinFunction;
import org.apache.flink.streaming.api.functions.query.QueryableAppendingStateOperator;
import org.apache.flink.streaming.api.functions.query.QueryableValueStateOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamGroupedReduce;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.WindowedStream;
import org.apache.flink.streaming.api.scala.function.StatefulFunction;
import org.apache.flink.streaming.api.scala.function.StatefulFunction$class;
import org.apache.flink.streaming.api.scala.package$;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Public
@ScalaSignature(bytes="\u0006\u0001\u0011ue\u0001B\u0001\u0003\u0001=\u00111bS3zK\u0012\u001cFO]3b[*\u00111\u0001B\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\u000b\u0019\t1!\u00199j\u0015\t9\u0001\"A\u0005tiJ,\u0017-\\5oO*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0007A9\"f\u0005\u0002\u0001#A\u0019!cE\u000b\u000e\u0003\tI!\u0001\u0006\u0002\u0003\u0015\u0011\u000bG/Y*ue\u0016\fW\u000e\u0005\u0002\u0017/1\u0001A!\u0002\r\u0001\u0005\u0004I\"!\u0001+\u0012\u0005iy\u0002CA\u000e\u001e\u001b\u0005a\"\"A\u0002\n\u0005ya\"a\u0002(pi\"Lgn\u001a\t\u00037\u0001J!!\t\u000f\u0003\u0007\u0005s\u0017\u0010\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003)Q\u0017M^1TiJ,\u0017-\u001c\t\u0005K!*\u0012&D\u0001'\u0015\t9C!\u0001\u0006eCR\f7\u000f\u001e:fC6L!!\u0001\u0014\u0011\u0005YQC!B\u0016\u0001\u0005\u0004I\"!A&\t\u000b5\u0002A\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\ty\u0003\u0007\u0005\u0003\u0013\u0001UI\u0003\"B\u0012-\u0001\u0004!\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0014AC4fi.+\u0017\u0010V=qKV\tA\u0007E\u00026w%j\u0011A\u000e\u0006\u0003oa\n\u0001\u0002^=qK&tgm\u001c\u0006\u0003si\naaY8n[>t'BA\u0003\t\u0013\tadGA\bUsB,\u0017J\u001c4pe6\fG/[8oQ\t\td\b\u0005\u0002@\u00056\t\u0001I\u0003\u0002B\u0011\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\r\u0003%\u0001C%oi\u0016\u0014h.\u00197\t\u000b\u0015\u0003A\u0011\t$\u0002\u000fA\u0014xnY3tgV\u0011qi\u0013\u000b\u0003\u0011B#\"!S'\u0011\u0007I\u0019\"\n\u0005\u0002\u0017\u0017\u0012)A\n\u0012b\u00013\t\t!\u000bC\u0004O\t\u0006\u0005\t9A(\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u00026w)CQ!\u0015#A\u0002I\u000bq\u0002\u001d:pG\u0016\u001c8OR;oGRLwN\u001c\t\u0005'Z+\"*D\u0001U\u0015\t)F!A\u0005gk:\u001cG/[8og&\u0011q\u000b\u0016\u0002\u0010!J|7-Z:t\rVt7\r^5p]\"\u0012A)\u0017\t\u0003\u007fiK!a\u0017!\u0003\u001dA+(\r\\5d\u000bZ|GN^5oO\"\"A)\u00181c!\tYb,\u0003\u0002`9\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0003\u0005\f1e^5mY\u0002\u0012W\r\t:f[>4X\r\u001a\u0011j]\u0002\n\u0007EZ;ukJ,\u0007E^3sg&|g.M\u0003$G*t7\u000e\u0005\u0002eO:\u00111$Z\u0005\u0003Mr\ta\u0001\u0015:fI\u00164\u0017B\u00015j\u0005\u0019\u0019FO]5oO*\u0011a\rH\u0005\u0003W2\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012$BA7\u001d\u0003)!W\r\u001d:fG\u0006$X\rZ\u0019\u0006G=\u0004\u0018/\u001c\b\u00037AL!!\u001c\u000f2\t\tZBD\u001d\u0002\u0006g\u000e\fG.\u0019\u0005\u0006\u000b\u0002!\t\u0001^\u000b\u0003kf$\"A^?\u0015\u0005]T\bc\u0001\n\u0014qB\u0011a#\u001f\u0003\u0006\u0019N\u0014\r!\u0007\u0005\bwN\f\t\u0011q\u0001}\u0003))g/\u001b3f]\u000e,GE\r\t\u0004kmB\b\"\u0002@t\u0001\u0004y\u0018\u0001F6fs\u0016$\u0007K]8dKN\u001ch)\u001e8di&|g\u000e\u0005\u0004T\u0003\u0003IS\u0003_\u0005\u0004\u0003\u0007!&\u0001F&fs\u0016$\u0007K]8dKN\u001ch)\u001e8di&|g\u000e\u000b\u0002t3\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0011\u0001D5oi\u0016\u0014h/\u00197K_&tW\u0003BA\u0007\u0005S!B!a\u0004\u0003.AA\u0011\u0011CA\n+\t\u001d\u0012&D\u0001\u0001\r\u0019\t)\u0002\u0001\u0001\u0002\u0018\ta\u0011J\u001c;feZ\fGNS8j]VA\u0011\u0011DA\u0016\u0003\u0007\n\td\u0005\u0003\u0002\u0014\u0005m\u0001cA\u000e\u0002\u001e%\u0019\u0011q\u0004\u000f\u0003\r\u0005s\u0017PU3g\u0011-\t\u0019#a\u0005\u0003\u0006\u0004%\t!!\n\u0002\u0013M$(/Z1n\u001f:,WCAA\u0014!\u0019\u0011\u0002!!\u000b\u00020A\u0019a#a\u000b\u0005\u000f\u00055\u00121\u0003b\u00013\t\u0019\u0011JT\u0019\u0011\u0007Y\t\t\u0004B\u0004\u00024\u0005M!\u0019A\r\u0003\u0007-+\u0015\fC\u0006\u00028\u0005M!\u0011!Q\u0001\n\u0005\u001d\u0012AC:ue\u0016\fWn\u00148fA!Y\u00111HA\n\u0005\u000b\u0007I\u0011AA\u001f\u0003%\u0019HO]3b[R;x.\u0006\u0002\u0002@A1!\u0003AA!\u0003_\u00012AFA\"\t\u001d\t)%a\u0005C\u0002e\u00111!\u0013(3\u0011-\tI%a\u0005\u0003\u0002\u0003\u0006I!a\u0010\u0002\u0015M$(/Z1n)^|\u0007\u0005C\u0004.\u0003'!\t!!\u0014\u0015\r\u0005=\u0013\u0011KA*!)\t\t\"a\u0005\u0002*\u0005\u0005\u0013q\u0006\u0005\t\u0003G\tY\u00051\u0001\u0002(!A\u00111HA&\u0001\u0004\ty\u0004\u0003\u0005\u0002X\u0005MA\u0011AA-\u0003\u001d\u0011W\r^<fK:$b!a\u0017\u0003\u0010\t\u0005\u0002CCA\t\u0003;\nI#!\u0011\u00020\u00191\u0011q\f\u0001\u0001\u0003C\u0012a\"\u00138uKJ4\u0018\r\u001c&pS:,G-\u0006\u0005\u0002d\u0005=\u00141QA:'\u0011\ti&a\u0007\t\u0017\u0005\u001d\u0014Q\fBC\u0002\u0013%\u0011\u0011N\u0001\fM&\u00148\u000f^*ue\u0016\fW.\u0006\u0002\u0002lA1!\u0003AA7\u0003c\u00022AFA8\t\u001d\ti#!\u0018C\u0002e\u00012AFA:\t\u001d\t\u0019$!\u0018C\u0002eA1\"a\u001e\u0002^\t\u0005\t\u0015!\u0003\u0002l\u0005aa-\u001b:tiN#(/Z1nA!Y\u00111PA/\u0005\u000b\u0007I\u0011BA?\u00031\u0019XmY8oIN#(/Z1n+\t\ty\b\u0005\u0004\u0013\u0001\u0005\u0005\u0015\u0011\u000f\t\u0004-\u0005\rEaBA#\u0003;\u0012\r!\u0007\u0005\f\u0003\u000f\u000biF!A!\u0002\u0013\ty(A\u0007tK\u000e|g\u000eZ*ue\u0016\fW\u000e\t\u0005\f\u0003\u0017\u000biF!b\u0001\n\u0013\ti)\u0001\u0006m_^,'OQ8v]\u0012,\"!a$\u0011\u0007m\t\t*C\u0002\u0002\u0014r\u0011A\u0001T8oO\"Y\u0011qSA/\u0005\u0003\u0005\u000b\u0011BAH\u0003-awn^3s\u0005>,h\u000e\u001a\u0011\t\u0017\u0005m\u0015Q\fBC\u0002\u0013%\u0011QR\u0001\u000bkB\u0004XM\u001d\"pk:$\u0007bCAP\u0003;\u0012\t\u0011)A\u0005\u0003\u001f\u000b1\"\u001e9qKJ\u0014u.\u001e8eA!9Q&!\u0018\u0005\u0002\u0005\rFCCAS\u0003O\u000bI+a+\u0002.BQ\u0011\u0011CA/\u0003[\n\t)!\u001d\t\u0011\u0005\u001d\u0014\u0011\u0015a\u0001\u0003WB\u0001\"a\u001f\u0002\"\u0002\u0007\u0011q\u0010\u0005\t\u0003\u0017\u000b\t\u000b1\u0001\u0002\u0010\"A\u00111TAQ\u0001\u0004\ty\t\u0003\u0006\u00022\u0006u\u0003\u0019!C\u0005\u0003g\u000b1\u0003\\8xKJ\u0014u.\u001e8e\u0013:\u001cG.^:jm\u0016,\"!!.\u0011\u0007m\t9,C\u0002\u0002:r\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002>\u0006u\u0003\u0019!C\u0005\u0003\u007f\u000bq\u0003\\8xKJ\u0014u.\u001e8e\u0013:\u001cG.^:jm\u0016|F%Z9\u0015\t\u0005\u0005\u0017q\u0019\t\u00047\u0005\r\u0017bAAc9\t!QK\\5u\u0011)\tI-a/\u0002\u0002\u0003\u0007\u0011QW\u0001\u0004q\u0012\n\u0004\"CAg\u0003;\u0002\u000b\u0015BA[\u0003Qawn^3s\u0005>,h\u000eZ%oG2,8/\u001b<fA!Q\u0011\u0011[A/\u0001\u0004%I!a-\u0002'U\u0004\b/\u001a:C_VtG-\u00138dYV\u001c\u0018N^3\t\u0015\u0005U\u0017Q\fa\u0001\n\u0013\t9.A\fvaB,'OQ8v]\u0012Len\u00197vg&4Xm\u0018\u0013fcR!\u0011\u0011YAm\u0011)\tI-a5\u0002\u0002\u0003\u0007\u0011Q\u0017\u0005\n\u0003;\fi\u0006)Q\u0005\u0003k\u000bA#\u001e9qKJ\u0014u.\u001e8e\u0013:\u001cG.^:jm\u0016\u0004\u0003\u0002CAq\u0003;\"\t!a9\u0002'1|w/\u001a:C_VtG-\u0012=dYV\u001c\u0018N^3\u0015\u0005\u0005\u0015\u0006fAAp3\"A\u0011\u0011^A/\t\u0003\t\u0019/A\nvaB,'OQ8v]\u0012,\u0005p\u00197vg&4X\rK\u0002\u0002hfCq!RA/\t\u0003\ty/\u0006\u0003\u0002r\u0006]H\u0003BAz\u0003w\u0004BAE\n\u0002vB\u0019a#a>\u0005\u000f\u0005e\u0018Q\u001eb\u00013\t\u0019q*\u0016+\t\u0011\u0005u\u0018Q\u001ea\u0001\u0003\u007f\f1\u0003\u001d:pG\u0016\u001c8OS8j]\u001a+hn\u0019;j_:\u0004\"B!\u0001\u0003\b\u00055\u0014\u0011QA{\u001b\t\u0011\u0019AC\u0002\u0003\u0006Q\u000b!aY8\n\t\t%!1\u0001\u0002\u0014!J|7-Z:t\u0015>LgNR;oGRLwN\u001c\u0015\u0004\u0003[L\u0006fAA/3\"A\u00111RA+\u0001\u0004\u0011\t\u0002\u0005\u0003\u0003\u0014\tuQB\u0001B\u000b\u0015\u0011\u00119B!\u0007\u0002\tQLW.\u001a\u0006\u0004\u00057!\u0011!C<j]\u0012|w/\u001b8h\u0013\u0011\u0011yB!\u0006\u0003\tQKW.\u001a\u0005\t\u00037\u000b)\u00061\u0001\u0003\u0012!\u001a\u0011QK-)\u0007\u0005M\u0011\fE\u0002\u0017\u0005S!qAa\u000b\u0002\b\t\u0007\u0011DA\u0003P)\"+%\u000b\u0003\u0005\u00030\u0005\u001d\u0001\u0019\u0001B\u0019\u0003-yG\u000f[3s'R\u0014X-Y7\u0011\u000bI\u0001!qE\u0015)\u0007\u0005\u001d\u0011\fC\u0004\u00038\u0001!\tA!\u000f\u0002\u0015QLW.Z,j]\u0012|w\u000f\u0006\u0003\u0003<\t5\u0003c\u0002\n\u0003>UI#\u0011I\u0005\u0004\u0005\u007f\u0011!AD,j]\u0012|w/\u001a3TiJ,\u0017-\u001c\t\u0005\u0005\u0007\u0012I%\u0004\u0002\u0003F)!!q\tB\r\u0003\u001d9\u0018N\u001c3poNLAAa\u0013\u0003F\tQA+[7f/&tGm\\<\t\u0011\t=#Q\u0007a\u0001\u0005#\tAa]5{K\"9!1\u000b\u0001\u0005\u0002\tU\u0013aC2pk:$x+\u001b8e_^$bAa\u0016\u0003`\t\u0005\u0004c\u0002\n\u0003>UI#\u0011\f\t\u0005\u0005\u0007\u0012Y&\u0003\u0003\u0003^\t\u0015#\u0001D$m_\n\fGnV5oI><\b\u0002\u0003B(\u0005#\u0002\r!a$\t\u0011\t\r$\u0011\u000ba\u0001\u0003\u001f\u000bQa\u001d7jI\u0016DqAa\u0015\u0001\t\u0003\u00119\u0007\u0006\u0003\u0003X\t%\u0004\u0002\u0003B(\u0005K\u0002\r!a$\t\u000f\t]\u0002\u0001\"\u0001\u0003nQ1!1\bB8\u0005cB\u0001Ba\u0014\u0003l\u0001\u0007!\u0011\u0003\u0005\t\u0005G\u0012Y\u00071\u0001\u0003\u0012!9!Q\u000f\u0001\u0005\u0002\t]\u0014AB<j]\u0012|w/\u0006\u0003\u0003z\t}D\u0003\u0002B>\u0005\u0017\u0003rA\u0005B\u001f+%\u0012i\bE\u0002\u0017\u0005\u007f\"\u0001B!!\u0003t\t\u0007!1\u0011\u0002\u0002/F\u0019!D!\"\u0011\t\t\r#qQ\u0005\u0005\u0005\u0013\u0013)E\u0001\u0004XS:$wn\u001e\u0005\t\u0005\u001b\u0013\u0019\b1\u0001\u0003\u0010\u0006A\u0011m]:jO:,'\u000f\r\u0003\u0003\u0012\n}\u0005\u0003\u0003BJ\u00053\u0013iJ! \u000e\u0005\tU%\u0002\u0002BL\u00053\t\u0011\"Y:tS\u001etWM]:\n\t\tm%Q\u0013\u0002\u000f/&tGm\\<BgNLwM\\3s!\r1\"q\u0014\u0003\r\u0005C\u0013Y)!A\u0001\u0002\u000b\u0005!1\u0015\u0002\u0004?\u0012\n\u0014CA\u000b Q\r\u0011\u0019(\u0017\u0005\b\u0005S\u0003A\u0011\u0001BV\u0003\u0019\u0011X\rZ;dKR\u0019\u0011C!,\t\u0011\t=&q\u0015a\u0001\u0005c\u000bqA]3ek\u000e,'\u000fE\u0003\u00034\n]V#\u0004\u0002\u00036*\u0011Q\u000bO\u0005\u0005\u0005s\u0013)L\u0001\bSK\u0012,8-\u001a$v]\u000e$\u0018n\u001c8\t\u000f\t%\u0006\u0001\"\u0001\u0003>R\u0019\u0011Ca0\t\u0011\t\u0005'1\u0018a\u0001\u0005\u0007\f1AZ;o!\u0019Y\"QY\u000b\u0016+%\u0019!q\u0019\u000f\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004b\u0002Bf\u0001\u0011\u0005!QZ\u0001\u0005M>dG-\u0006\u0003\u0003P\n]GC\u0002Bi\u0005?\u0014\u0019\u000f\u0006\u0003\u0003T\ne\u0007\u0003\u0002\n\u0014\u0005+\u00042A\u0006Bl\t\u0019a%\u0011\u001ab\u00013!Q!1\u001cBe\u0003\u0003\u0005\u001dA!8\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u00036w\tU\u0007\u0002\u0003Bq\u0005\u0013\u0004\rA!6\u0002\u0019%t\u0017\u000e^5bYZ\u000bG.^3\t\u0011\t\u0015(\u0011\u001aa\u0001\u0005O\faAZ8mI\u0016\u0014\bc\u0002BZ\u0005S,\"Q[\u0005\u0005\u0005W\u0014)L\u0001\u0007G_2$g)\u001e8di&|g\u000e\u000b\u0004\u0003Jv\u0003'q^\u0019\u0007G\rT'\u0011_62\r\rz\u0007Oa=nc\u0011\u00113\u0004\b:\t\u000f\t-\u0007\u0001\"\u0001\u0003xV!!\u0011`B\u0002)\u0011\u0011Ypa\u0004\u0015\t\tu81\u0002\u000b\u0005\u0005\u007f\u001c)\u0001\u0005\u0003\u0013'\r\u0005\u0001c\u0001\f\u0004\u0004\u00111AJ!>C\u0002eA!ba\u0002\u0003v\u0006\u0005\t9AB\u0005\u0003))g/\u001b3f]\u000e,G\u0005\u000e\t\u0005km\u001a\t\u0001\u0003\u0005\u0003B\nU\b\u0019AB\u0007!!Y\"QYB\u0001+\r\u0005\u0001\u0002\u0003Bq\u0005k\u0004\ra!\u0001)\r\tUX\fYB\nc\u0019\u00193M[B\u000bWF21e\u001c9\u0004\u00185\fDAI\u000e\u001de\"911\u0004\u0001\u0005\u0002\ru\u0011aA7bqR\u0019\u0011ca\b\t\u0011\r\u00052\u0011\u0004a\u0001\u0007G\t\u0001\u0002]8tSRLwN\u001c\t\u00047\r\u0015\u0012bAB\u00149\t\u0019\u0011J\u001c;\t\u000f\rm\u0001\u0001\"\u0001\u0004,Q\u0019\u0011c!\f\t\u000f\r=2\u0011\u0006a\u0001G\u0006)a-[3mI\"911\u0007\u0001\u0005\u0002\rU\u0012aA7j]R\u0019\u0011ca\u000e\t\u0011\r\u00052\u0011\u0007a\u0001\u0007GAqaa\r\u0001\t\u0003\u0019Y\u0004F\u0002\u0012\u0007{Aqaa\f\u0004:\u0001\u00071\rC\u0004\u0004B\u0001!\taa\u0011\u0002\u0007M,X\u000eF\u0002\u0012\u0007\u000bB\u0001b!\t\u0004@\u0001\u000711\u0005\u0005\b\u0007\u0003\u0002A\u0011AB%)\r\t21\n\u0005\b\u0007_\u00199\u00051\u0001d\u0011\u001d\u0019y\u0005\u0001C\u0001\u0007#\nQ!\\5o\u0005f$2!EB*\u0011!\u0019\tc!\u0014A\u0002\r\r\u0002bBB(\u0001\u0011\u00051q\u000b\u000b\u0004#\re\u0003bBB\u0018\u0007+\u0002\ra\u0019\u0005\b\u0007;\u0002A\u0011AB0\u0003\u0015i\u0017\r\u001f\"z)\r\t2\u0011\r\u0005\t\u0007C\u0019Y\u00061\u0001\u0004$!91Q\f\u0001\u0005\u0002\r\u0015DcA\t\u0004h!91qFB2\u0001\u0004\u0019\u0007bBB6\u0001\u0011%1QN\u0001\nC\u001e<'/Z4bi\u0016$R!EB8\u0007OC\u0001b!\u001d\u0004j\u0001\u000711O\u0001\u0010C\u001e<'/Z4bi&|g\u000eV=qKB!1QOBQ\u001d\u0011\u00199ha'\u000f\t\re4q\u0013\b\u0005\u0007w\u001a)J\u0004\u0003\u0004~\rMe\u0002BB@\u0007#sAa!!\u0004\u0010:!11QBG\u001d\u0011\u0019)ia#\u000e\u0005\r\u001d%bABE\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t)F!C\u0002\u0004\u001aR\u000b1\"Y4he\u0016<\u0017\r^5p]&!1QTBP\u0003M\tum\u001a:fO\u0006$\u0018n\u001c8Gk:\u001cG/[8o\u0015\r\u0019I\nV\u0005\u0005\u0007G\u001b)KA\bBO\u001e\u0014XmZ1uS>tG+\u001f9f\u0015\u0011\u0019ija(\t\u000f\r=2\u0011\u000ea\u0001G\"911\u000e\u0001\u0005\n\r-F#B\t\u0004.\u000e=\u0006\u0002CB9\u0007S\u0003\raa\u001d\t\u0011\r\u00052\u0011\u0016a\u0001\u0007GAqaa-\u0001\t\u0003\u0019),A\bgS2$XM],ji\"\u001cF/\u0019;f+\u0011\u00199la1\u0015\t\re6q\u0019\u000b\u0004#\rm\u0006BCB_\u0007c\u000b\t\u0011q\u0001\u0004@\u0006QQM^5eK:\u001cW\rJ\u001b\u0011\tUZ4\u0011\u0019\t\u0004-\r\rGaBBc\u0007c\u0013\r!\u0007\u0002\u0002'\"A!\u0011YBY\u0001\u0004\u0019I\r\u0005\u0005\u001c\u0005\u000b,21ZBi!\u0015Y2QZBa\u0013\r\u0019y\r\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fm\u0019\u0019.!.\u0004L&\u00191Q\u001b\u000f\u0003\rQ+\b\u000f\\33\u0011\u001d\u0019I\u000e\u0001C\u0001\u00077\fA\"\\1q/&$\bn\u0015;bi\u0016,ba!8\u0004f\u000eUH\u0003BBp\u0007o$ba!9\u0004h\u000e5\b\u0003\u0002\n\u0014\u0007G\u00042AFBs\t\u0019a5q\u001bb\u00013!Q1\u0011^Bl\u0003\u0003\u0005\u001daa;\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$c\u0007\u0005\u00036w\r\r\bBCBx\u0007/\f\t\u0011q\u0001\u0004r\u0006QQM^5eK:\u001cW\rJ\u001c\u0011\tUZ41\u001f\t\u0004-\rUHaBBc\u0007/\u0014\r!\u0007\u0005\t\u0005\u0003\u001c9\u000e1\u0001\u0004zBA1D!2\u0016\u0007w\u001ci\u0010E\u0003\u001c\u0007\u001b\u001c\u0019\u0010E\u0004\u001c\u0007'\u001c\u0019oa?\t\u000f\u0011\u0005\u0001\u0001\"\u0001\u0005\u0004\u0005\u0001b\r\\1u\u001b\u0006\u0004x+\u001b;i'R\fG/Z\u000b\u0007\t\u000b!i\u0001\"\b\u0015\t\u0011\u001dAq\u0004\u000b\u0007\t\u0013!y\u0001\"\u0006\u0011\tI\u0019B1\u0002\t\u0004-\u00115AA\u0002'\u0004\u0000\n\u0007\u0011\u0004\u0003\u0006\u0005\u0012\r}\u0018\u0011!a\u0002\t'\t!\"\u001a<jI\u0016t7-\u001a\u00139!\u0011)4\bb\u0003\t\u0015\u0011]1q`A\u0001\u0002\b!I\"\u0001\u0006fm&$WM\\2fIe\u0002B!N\u001e\u0005\u001cA\u0019a\u0003\"\b\u0005\u000f\r\u00157q b\u00013!A!\u0011YB\u0000\u0001\u0004!\t\u0003\u0005\u0005\u001c\u0005\u000b,B1\u0005C\u0013!\u0015Y2Q\u001aC\u000e!\u001dY21\u001bC\u0014\tG\u0001b\u0001\"\u000b\u00054\u0011-a\u0002\u0002C\u0016\t_qAa!\"\u0005.%\t1!C\u0002\u00052q\tq\u0001]1dW\u0006<W-\u0003\u0003\u00056\u0011]\"a\u0004+sCZ,'o]1cY\u0016|enY3\u000b\u0007\u0011EB\u0004C\u0004\u0005<\u0001!\t\u0001\"\u0010\u0002!\u0005\u001c\u0018+^3ss\u0006\u0014G.Z*uCR,G\u0003\u0002C \t\u000b\u0002R!\nC!SUI1\u0001b\u0011'\u0005Q\tV/\u001a:zC\ndWm\u0015;bi\u0016\u001cFO]3b[\"9Aq\tC\u001d\u0001\u0004\u0019\u0017AE9vKJL\u0018M\u00197f'R\fG/\u001a(b[\u0016D3\u0001\"\u000fZ\u0011\u001d!Y\u0004\u0001C\u0001\t\u001b\"b\u0001b\u0010\u0005P\u0011E\u0003b\u0002C$\t\u0017\u0002\ra\u0019\u0005\t\t'\"Y\u00051\u0001\u0005V\u0005y1\u000f^1uK\u0012+7o\u0019:jaR|'\u000fE\u0003\u0005X\u0011uS#\u0004\u0002\u0005Z)\u0019A1\f\u001d\u0002\u000bM$\u0018\r^3\n\t\u0011}C\u0011\f\u0002\u0015-\u0006dW/Z*uCR,G)Z:de&\u0004Ho\u001c:)\u0007\u0011-\u0013\fC\u0004\u0005<\u0001!\t\u0001\"\u001a\u0016\t\u0011\u001dDQ\u000e\u000b\u0007\tS\"\t\bb\u001d\u0011\r\u0015\"\t%\u000bC6!\r1BQ\u000e\u0003\b\t_\"\u0019G1\u0001\u001a\u0005\r\t5i\u0011\u0005\b\t\u000f\"\u0019\u00071\u0001d\u0011!!\u0019\u0006b\u0019A\u0002\u0011U\u0004c\u0002C,\to*B1N\u0005\u0005\ts\"IF\u0001\fG_2$\u0017N\\4Ti\u0006$X\rR3tGJL\u0007\u000f^8sQ\u0019!\u0019'\u00181\u0005~E21e\u00196\u0005\u0000-\fdaI8q\t\u0003k\u0017\u0007\u0002\u0012\u001c9ID3\u0001b\u0019Z\u0011\u001d!Y\u0004\u0001C\u0001\t\u000f#b\u0001b\u0010\u0005\n\u0012-\u0005b\u0002C$\t\u000b\u0003\ra\u0019\u0005\t\t'\")\t1\u0001\u0005\u000eB)Aq\u000bCH+%!A\u0011\u0013C-\u0005]\u0011V\rZ;dS:<7\u000b^1uK\u0012+7o\u0019:jaR|'\u000fK\u0002\u0005\u0006fC3\u0001\u0001CL!\ryD\u0011T\u0005\u0004\t7\u0003%A\u0002)vE2L7\r")
public class KeyedStream<T, K>
extends DataStream<T> {
    private final org.apache.flink.streaming.api.datastream.KeyedStream<T, K> javaStream;

    @Internal
    public TypeInformation<K> getKeyType() {
        return this.javaStream.getKeyType();
    }

    @Override
    @PublicEvolving
    public <R> DataStream<R> process(ProcessFunction<T, R> processFunction, TypeInformation<R> evidence$1) {
        if (processFunction == null) {
            throw new NullPointerException("ProcessFunction must not be null.");
        }
        return package$.MODULE$.asScalaStream(this.javaStream.process(processFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$1)));
    }

    @PublicEvolving
    public <R> DataStream<R> process(KeyedProcessFunction<K, T, R> keyedProcessFunction, TypeInformation<R> evidence$2) {
        if (keyedProcessFunction == null) {
            throw new NullPointerException("KeyedProcessFunction must not be null.");
        }
        return package$.MODULE$.asScalaStream(this.javaStream.process(keyedProcessFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$2)));
    }

    @PublicEvolving
    public <OTHER> IntervalJoin<T, OTHER, K> intervalJoin(KeyedStream<OTHER, K> otherStream) {
        return new IntervalJoin(this, this, otherStream);
    }

    public WindowedStream<T, K, TimeWindow> timeWindow(Time size) {
        return new WindowedStream(this.javaStream.timeWindow(size));
    }

    public WindowedStream<T, K, GlobalWindow> countWindow(long size, long slide) {
        return new WindowedStream(this.javaStream.countWindow(size, slide));
    }

    public WindowedStream<T, K, GlobalWindow> countWindow(long size) {
        return new WindowedStream(this.javaStream.countWindow(size));
    }

    public WindowedStream<T, K, TimeWindow> timeWindow(Time size, Time slide) {
        return new WindowedStream(this.javaStream.timeWindow(size, slide));
    }

    @PublicEvolving
    public <W extends Window> WindowedStream<T, K, W> window(WindowAssigner<? super T, W> assigner) {
        return new WindowedStream(new org.apache.flink.streaming.api.datastream.WindowedStream(this.javaStream, assigner));
    }

    public DataStream<T> reduce(ReduceFunction<T> reducer) {
        if (reducer == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        return package$.MODULE$.asScalaStream(this.javaStream.reduce(reducer));
    }

    public DataStream<T> reduce(Function2<T, T, T> fun) {
        if (fun == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        Function2<T, T, T> cleanFun = this.clean(fun);
        ReduceFunction reducer = new ReduceFunction<T>(this, cleanFun){
            private final Function2 cleanFun$1;

            public T reduce(T v1, T v2) {
                return (T)this.cleanFun$1.apply(v1, v2);
            }
            {
                this.cleanFun$1 = cleanFun$1;
            }
        };
        return this.reduce(reducer);
    }

    public <R> DataStream<R> fold(R initialValue, FoldFunction<T, R> folder, TypeInformation<R> evidence$3) {
        if (folder == null) {
            throw new NullPointerException("Fold function must not be null.");
        }
        TypeInformation outType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$3);
        return package$.MODULE$.asScalaStream(this.javaStream.fold(initialValue, folder).returns(outType));
    }

    public <R> DataStream<R> fold(R initialValue, Function2<R, T, R> fun, TypeInformation<R> evidence$4) {
        if (fun == null) {
            throw new NullPointerException("Fold function must not be null.");
        }
        Function2<R, T, R> cleanFun = this.clean(fun);
        FoldFunction folder = new FoldFunction<T, R>(this, cleanFun){
            private final Function2 cleanFun$2;

            public R fold(R acc, T v) {
                return (R)this.cleanFun$2.apply(acc, v);
            }
            {
                this.cleanFun$2 = cleanFun$2;
            }
        };
        return this.fold(initialValue, folder, evidence$4);
    }

    public DataStream<T> max(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MAX, position);
    }

    public DataStream<T> max(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MAX, field);
    }

    public DataStream<T> min(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MIN, position);
    }

    public DataStream<T> min(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MIN, field);
    }

    public DataStream<T> sum(int position) {
        return this.aggregate(AggregationFunction.AggregationType.SUM, position);
    }

    public DataStream<T> sum(String field) {
        return this.aggregate(AggregationFunction.AggregationType.SUM, field);
    }

    public DataStream<T> minBy(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MINBY, position);
    }

    public DataStream<T> minBy(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MINBY, field);
    }

    public DataStream<T> maxBy(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MAXBY, position);
    }

    public DataStream<T> maxBy(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MAXBY, field);
    }

    private DataStream<T> aggregate(AggregationFunction.AggregationType aggregationType, String field) {
        int position = package$.MODULE$.fieldNames2Indices(this.javaStream.getType(), (String[])((Object[])new String[]{field}))[0];
        return this.aggregate(aggregationType, position);
    }

    private DataStream<T> aggregate(AggregationFunction.AggregationType aggregationType, int position) {
        AggregationFunction.AggregationType aggregationType2 = aggregationType;
        Object object = AggregationFunction.AggregationType.SUM.equals(aggregationType2) ? new SumAggregator(position, this.javaStream.getType(), this.javaStream.getExecutionConfig()) : new ComparableAggregator(position, this.javaStream.getType(), aggregationType, true, this.javaStream.getExecutionConfig());
        SumAggregator reducer = object;
        StreamGroupedReduce invokable = new StreamGroupedReduce((ReduceFunction)reducer, this.getType().createSerializer(this.getExecutionConfig()));
        return new DataStream(this.javaStream.transform("aggregation", this.javaStream.getType(), (OneInputStreamOperator)invokable));
    }

    public <S> DataStream<T> filterWithState(Function2<T, Option<S>, Tuple2<Object, Option<S>>> fun, TypeInformation<S> evidence$5) {
        if (fun == null) {
            throw new NullPointerException("Filter function must not be null.");
        }
        Function2<T, Option<S>, Tuple2<Object, Option<S>>> cleanFun = this.clean(fun);
        TypeInformation stateTypeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$5);
        TypeSerializer serializer = stateTypeInfo.createSerializer(this.getExecutionConfig());
        StatefulFunction filterFun = new StatefulFunction<T, Object, S>(this, cleanFun, serializer){
            private final TypeSerializer<S> stateSerializer;
            private final Function2 cleanFun$3;
            private ValueState org$apache$flink$streaming$api$scala$function$StatefulFunction$$state;

            public ValueState org$apache$flink$streaming$api$scala$function$StatefulFunction$$state() {
                return this.org$apache$flink$streaming$api$scala$function$StatefulFunction$$state;
            }

            public void org$apache$flink$streaming$api$scala$function$StatefulFunction$$state_$eq(ValueState x$1) {
                this.org$apache$flink$streaming$api$scala$function$StatefulFunction$$state = x$1;
            }

            public Object applyWithState(Object in, Function2 fun) {
                return StatefulFunction$class.applyWithState(this, in, fun);
            }

            public void open(Configuration c) {
                StatefulFunction$class.open(this, c);
            }

            public TypeSerializer<S> stateSerializer() {
                return this.stateSerializer;
            }

            public boolean filter(T in) {
                return BoxesRunTime.unboxToBoolean((Object)this.applyWithState(in, this.cleanFun$3));
            }
            {
                void var3_3;
                this.cleanFun$3 = cleanFun$3;
                StatefulFunction$class.$init$(this);
                this.stateSerializer = var3_3;
            }
        };
        return this.filter(filterFun);
    }

    public <R, S> DataStream<R> mapWithState(Function2<T, Option<S>, Tuple2<R, Option<S>>> fun, TypeInformation<R> evidence$6, TypeInformation<S> evidence$7) {
        if (fun == null) {
            throw new NullPointerException("Map function must not be null.");
        }
        Function2<T, Option<S>, Tuple2<R, Option<S>>> cleanFun = this.clean(fun);
        TypeInformation stateTypeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$7);
        TypeSerializer serializer = stateTypeInfo.createSerializer(this.getExecutionConfig());
        StatefulFunction mapper = new StatefulFunction<T, R, S>(this, cleanFun, serializer){
            private final TypeSerializer<S> stateSerializer;
            private final Function2 cleanFun$4;
            private ValueState org$apache$flink$streaming$api$scala$function$StatefulFunction$$state;

            public ValueState org$apache$flink$streaming$api$scala$function$StatefulFunction$$state() {
                return this.org$apache$flink$streaming$api$scala$function$StatefulFunction$$state;
            }

            public void org$apache$flink$streaming$api$scala$function$StatefulFunction$$state_$eq(ValueState x$1) {
                this.org$apache$flink$streaming$api$scala$function$StatefulFunction$$state = x$1;
            }

            public R applyWithState(T in, Function2<T, Option<S>, Tuple2<R, Option<S>>> fun) {
                return (R)StatefulFunction$class.applyWithState(this, in, fun);
            }

            public void open(Configuration c) {
                StatefulFunction$class.open(this, c);
            }

            public TypeSerializer<S> stateSerializer() {
                return this.stateSerializer;
            }

            public R map(T in) {
                return this.applyWithState(in, (Function2<T, Option<S>, Tuple2<R, Option<S>>>)this.cleanFun$4);
            }
            {
                void var3_3;
                this.cleanFun$4 = cleanFun$4;
                StatefulFunction$class.$init$(this);
                this.stateSerializer = var3_3;
            }
        };
        return this.map(mapper, evidence$6);
    }

    public <R, S> DataStream<R> flatMapWithState(Function2<T, Option<S>, Tuple2<TraversableOnce<R>, Option<S>>> fun, TypeInformation<R> evidence$8, TypeInformation<S> evidence$9) {
        if (fun == null) {
            throw new NullPointerException("Flatmap function must not be null.");
        }
        Function2<T, Option<S>, Tuple2<TraversableOnce<R>, Option<S>>> cleanFun = this.clean(fun);
        TypeInformation stateTypeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$9);
        TypeSerializer serializer = stateTypeInfo.createSerializer(this.getExecutionConfig());
        StatefulFunction flatMapper = new StatefulFunction<T, TraversableOnce<R>, S>(this, cleanFun, serializer){
            private final TypeSerializer<S> stateSerializer;
            private final Function2 cleanFun$5;
            private ValueState org$apache$flink$streaming$api$scala$function$StatefulFunction$$state;

            public ValueState org$apache$flink$streaming$api$scala$function$StatefulFunction$$state() {
                return this.org$apache$flink$streaming$api$scala$function$StatefulFunction$$state;
            }

            public void org$apache$flink$streaming$api$scala$function$StatefulFunction$$state_$eq(ValueState x$1) {
                this.org$apache$flink$streaming$api$scala$function$StatefulFunction$$state = x$1;
            }

            public Object applyWithState(Object in, Function2 fun) {
                return StatefulFunction$class.applyWithState(this, in, fun);
            }

            public void open(Configuration c) {
                StatefulFunction$class.open(this, c);
            }

            public TypeSerializer<S> stateSerializer() {
                return this.stateSerializer;
            }

            public void flatMap(T in, Collector<R> out) {
                ((TraversableOnce)this.applyWithState(in, this.cleanFun$5)).foreach((Function1)new Serializable(this, out){
                    public static final long serialVersionUID = 0L;
                    private final Collector out$1;

                    public final void apply(R x$1) {
                        this.out$1.collect(x$1);
                    }
                    {
                        this.out$1 = out$1;
                    }
                });
            }
            {
                void var3_3;
                this.cleanFun$5 = cleanFun$5;
                StatefulFunction$class.$init$(this);
                this.stateSerializer = var3_3;
            }
        };
        return this.flatMap(flatMapper, evidence$8);
    }

    @PublicEvolving
    public QueryableStateStream<K, T> asQueryableState(String queryableStateName) {
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor(queryableStateName, this.dataType().createSerializer(this.executionConfig()));
        return this.asQueryableState(queryableStateName, stateDescriptor);
    }

    @PublicEvolving
    public QueryableStateStream<K, T> asQueryableState(String queryableStateName, ValueStateDescriptor<T> stateDescriptor) {
        this.transform(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Queryable state: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queryableStateName})), new QueryableValueStateOperator(queryableStateName, stateDescriptor), this.dataType());
        stateDescriptor.initializeSerializerUnlessSet(this.executionConfig());
        return new QueryableStateStream(queryableStateName, stateDescriptor, this.getKeyType().createSerializer(this.executionConfig()));
    }

    @PublicEvolving
    public <ACC> QueryableStateStream<K, ACC> asQueryableState(String queryableStateName, FoldingStateDescriptor<T, ACC> stateDescriptor) {
        this.transform(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Queryable state: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queryableStateName})), new QueryableAppendingStateOperator(queryableStateName, stateDescriptor), this.dataType());
        stateDescriptor.initializeSerializerUnlessSet(this.executionConfig());
        return new QueryableStateStream(queryableStateName, stateDescriptor, this.getKeyType().createSerializer(this.executionConfig()));
    }

    @PublicEvolving
    public QueryableStateStream<K, T> asQueryableState(String queryableStateName, ReducingStateDescriptor<T> stateDescriptor) {
        this.transform(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Queryable state: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queryableStateName})), new QueryableAppendingStateOperator(queryableStateName, stateDescriptor), this.dataType());
        stateDescriptor.initializeSerializerUnlessSet(this.executionConfig());
        return new QueryableStateStream(queryableStateName, stateDescriptor, this.getKeyType().createSerializer(this.executionConfig()));
    }

    public KeyedStream(org.apache.flink.streaming.api.datastream.KeyedStream<T, K> javaStream) {
        this.javaStream = javaStream;
        super(javaStream);
    }

    @PublicEvolving
    public class IntervalJoin<IN1, IN2, KEY> {
        private final KeyedStream<IN1, KEY> streamOne;
        private final KeyedStream<IN2, KEY> streamTwo;
        public final /* synthetic */ KeyedStream $outer;

        public KeyedStream<IN1, KEY> streamOne() {
            return this.streamOne;
        }

        public KeyedStream<IN2, KEY> streamTwo() {
            return this.streamTwo;
        }

        @PublicEvolving
        public IntervalJoined<IN1, IN2, KEY> between(Time lowerBound, Time upperBound) {
            long lowerMillis = lowerBound.toMilliseconds();
            long upperMillis = upperBound.toMilliseconds();
            return new IntervalJoined<IN1, IN2, KEY>(this.org$apache$flink$streaming$api$scala$KeyedStream$IntervalJoin$$$outer(), this.streamOne(), this.streamTwo(), lowerMillis, upperMillis);
        }

        public /* synthetic */ KeyedStream org$apache$flink$streaming$api$scala$KeyedStream$IntervalJoin$$$outer() {
            return this.$outer;
        }

        public IntervalJoin(KeyedStream<T, K> $outer, KeyedStream<IN1, KEY> streamOne, KeyedStream<IN2, KEY> streamTwo) {
            this.streamOne = streamOne;
            this.streamTwo = streamTwo;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    @PublicEvolving
    public class IntervalJoined<IN1, IN2, KEY> {
        private final KeyedStream<IN1, KEY> firstStream;
        private final KeyedStream<IN2, KEY> secondStream;
        private final long lowerBound;
        private final long upperBound;
        private boolean lowerBoundInclusive;
        private boolean upperBoundInclusive;
        public final /* synthetic */ KeyedStream $outer;

        private KeyedStream<IN1, KEY> firstStream() {
            return this.firstStream;
        }

        private KeyedStream<IN2, KEY> secondStream() {
            return this.secondStream;
        }

        private long lowerBound() {
            return this.lowerBound;
        }

        private long upperBound() {
            return this.upperBound;
        }

        private boolean lowerBoundInclusive() {
            return this.lowerBoundInclusive;
        }

        private void lowerBoundInclusive_$eq(boolean x$1) {
            this.lowerBoundInclusive = x$1;
        }

        private boolean upperBoundInclusive() {
            return this.upperBoundInclusive;
        }

        private void upperBoundInclusive_$eq(boolean x$1) {
            this.upperBoundInclusive = x$1;
        }

        @PublicEvolving
        public IntervalJoined<IN1, IN2, KEY> lowerBoundExclusive() {
            this.lowerBoundInclusive_$eq(false);
            return this;
        }

        @PublicEvolving
        public IntervalJoined<IN1, IN2, KEY> upperBoundExclusive() {
            this.upperBoundInclusive_$eq(false);
            return this;
        }

        @PublicEvolving
        public <OUT> DataStream<OUT> process(ProcessJoinFunction<IN1, IN2, OUT> processJoinFunction) {
            KeyedStream.IntervalJoined javaJoined = new KeyedStream.IntervalJoined((org.apache.flink.streaming.api.datastream.KeyedStream)this.firstStream().javaStream(), (org.apache.flink.streaming.api.datastream.KeyedStream)this.secondStream().javaStream(), this.lowerBound(), this.upperBound(), this.lowerBoundInclusive(), this.upperBoundInclusive());
            return package$.MODULE$.asScalaStream(javaJoined.process(processJoinFunction));
        }

        public /* synthetic */ KeyedStream org$apache$flink$streaming$api$scala$KeyedStream$IntervalJoined$$$outer() {
            return this.$outer;
        }

        public IntervalJoined(KeyedStream<T, K> $outer, KeyedStream<IN1, KEY> firstStream, KeyedStream<IN2, KEY> secondStream, long lowerBound, long upperBound) {
            this.firstStream = firstStream;
            this.secondStream = secondStream;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.lowerBoundInclusive = true;
            this.upperBoundInclusive = true;
        }
    }
}

