/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.security.HadoopSecurityContext;
import org.apache.flink.runtime.security.NoOpSecurityContext;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityContext;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.apache.flink.runtime.security.modules.SecurityModuleFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    private static SecurityContext installedContext = new NoOpSecurityContext();
    private static List<SecurityModule> installedModules = null;

    public static SecurityContext getInstalledContext() {
        return installedContext;
    }

    @VisibleForTesting
    static List<SecurityModule> getInstalledModules() {
        return installedModules;
    }

    public static void install(SecurityConfiguration config) throws Exception {
        ArrayList<SecurityModule> modules = new ArrayList<SecurityModule>();
        try {
            for (SecurityModuleFactory moduleFactory : config.getSecurityModuleFactories()) {
                SecurityModule module = moduleFactory.createModule(config);
                if (module == null) continue;
                module.install();
                modules.add(module);
            }
        }
        catch (Exception ex) {
            throw new Exception("unable to establish the security context", ex);
        }
        installedModules = modules;
        try {
            Class.forName("org.apache.hadoop.security.UserGroupInformation", false, SecurityUtils.class.getClassLoader());
            if (!(installedContext instanceof NoOpSecurityContext)) {
                LOG.warn("overriding previous security context");
            }
            UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
            installedContext = new HadoopSecurityContext(loginUser);
        }
        catch (ClassNotFoundException e) {
            LOG.info("Cannot install HadoopSecurityContext because Hadoop cannot be found in the Classpath.");
        }
        catch (LinkageError e) {
            LOG.error("Cannot install HadoopSecurityContext.", (Throwable)e);
        }
    }

    static void uninstall() {
        if (installedModules != null) {
            for (int i = installedModules.size() - 1; i >= 0; --i) {
                SecurityModule module = installedModules.get(i);
                try {
                    module.uninstall();
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    continue;
                }
                catch (SecurityModule.SecurityInstallException e) {
                    LOG.warn("unable to uninstall a security module", (Throwable)e);
                }
            }
            installedModules = null;
        }
        installedContext = new NoOpSecurityContext();
    }

    private SecurityUtils() {
    }
}

