/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.util.Preconditions;

public final class MainThreadValidatorUtil {
    private final RpcEndpoint endpoint;

    public MainThreadValidatorUtil(RpcEndpoint endpoint) {
        this.endpoint = (RpcEndpoint)Preconditions.checkNotNull((Object)endpoint);
    }

    public void enterMainThread() {
        assert (this.endpoint.currentMainThread.compareAndSet(null, Thread.currentThread())) : "The RpcEndpoint has concurrent access from " + this.endpoint.currentMainThread.get();
    }

    public void exitMainThread() {
        assert (this.endpoint.currentMainThread.compareAndSet(Thread.currentThread(), null)) : "The RpcEndpoint has concurrent access from " + this.endpoint.currentMainThread.get();
    }
}

