/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.rest.messages.MessageParameter;

public abstract class MessageQueryParameter<X>
extends MessageParameter<List<X>> {
    protected MessageQueryParameter(String key, MessageParameter.MessageParameterRequisiteness requisiteness) {
        super(key, requisiteness);
    }

    @Override
    public List<X> convertFromString(String values) {
        String[] splitValues = values.split(",");
        ArrayList<X> list = new ArrayList<X>();
        for (String value : splitValues) {
            list.add(this.convertValueFromString(value));
        }
        return list;
    }

    public abstract X convertValueFromString(String var1);

    @Override
    public String convertToString(List<X> values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (X value : values) {
            if (first) {
                sb.append(this.convertStringToValue(value));
                first = false;
                continue;
            }
            sb.append(",");
            sb.append(this.convertStringToValue(value));
        }
        return sb.toString();
    }

    public abstract String convertStringToValue(X var1);
}

