/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.LegacyRestHandler;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJsonRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class CurrentJobsOverviewHandler
extends AbstractJsonRequestHandler
implements LegacyRestHandler<DispatcherGateway, MultipleJobsDetails, EmptyMessageParameters> {
    private static final String ALL_JOBS_REST_PATH = "/joboverview";
    private static final String RUNNING_JOBS_REST_PATH = "/joboverview/running";
    private static final String COMPLETED_JOBS_REST_PATH = "/joboverview/completed";
    private final Time timeout;
    private final boolean includeRunningJobs;
    private final boolean includeFinishedJobs;

    public CurrentJobsOverviewHandler(Executor executor, Time timeout, boolean includeRunningJobs, boolean includeFinishedJobs) {
        super(executor);
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.includeRunningJobs = includeRunningJobs;
        this.includeFinishedJobs = includeFinishedJobs;
    }

    @Override
    public CompletableFuture<MultipleJobsDetails> handleRequest(HandlerRequest<EmptyRequestBody, EmptyMessageParameters> request, DispatcherGateway gateway) {
        return gateway.requestJobDetails(true, true, this.timeout);
    }

    @Override
    public String[] getPaths() {
        if (this.includeRunningJobs && this.includeFinishedJobs) {
            return new String[]{ALL_JOBS_REST_PATH};
        }
        if (this.includeRunningJobs) {
            return new String[]{RUNNING_JOBS_REST_PATH};
        }
        return new String[]{COMPLETED_JOBS_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleJsonRequest(Map<String, String> pathParams, Map<String, String> queryParams, JobManagerGateway jobManagerGateway) {
        if (jobManagerGateway != null) {
            CompletableFuture<MultipleJobsDetails> jobDetailsFuture = jobManagerGateway.requestJobDetails(this.includeRunningJobs, this.includeFinishedJobs, this.timeout);
            return jobDetailsFuture.thenApplyAsync(result -> {
                long now = System.currentTimeMillis();
                StringWriter writer = new StringWriter();
                try {
                    JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
                    JobDetails.JobDetailsSerializer jobDetailsSerializer = new JobDetails.JobDetailsSerializer();
                    gen.writeStartObject();
                    if (this.includeRunningJobs && this.includeFinishedJobs) {
                        gen.writeArrayFieldStart("running");
                        for (JobDetails detail : result.getRunning()) {
                            jobDetailsSerializer.serialize(detail, gen, null);
                        }
                        gen.writeEndArray();
                        gen.writeArrayFieldStart("finished");
                        for (JobDetails detail : result.getFinished()) {
                            jobDetailsSerializer.serialize(detail, gen, null);
                        }
                        gen.writeEndArray();
                    } else {
                        gen.writeArrayFieldStart("jobs");
                        for (JobDetails detail : this.includeRunningJobs ? result.getRunning() : result.getFinished()) {
                            jobDetailsSerializer.serialize(detail, gen, null);
                        }
                        gen.writeEndArray();
                    }
                    gen.writeEndObject();
                    gen.close();
                    return writer.toString();
                }
                catch (IOException e) {
                    throw new CompletionException(new FlinkException("Could not write current jobs overview json.", (Throwable)e));
                }
            }, this.executor);
        }
        return FutureUtils.completedExceptionally(new Exception("No connection to the leading JobManager."));
    }

    public static class CurrentJobsOverviewJsonArchivist
    implements JsonArchivist {
        @Override
        public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
            StringWriter writer = new StringWriter();
            try (JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);){
                gen.writeStartObject();
                gen.writeArrayFieldStart("running");
                gen.writeEndArray();
                gen.writeArrayFieldStart("finished");
                JobDetails.JobDetailsSerializer jobDetailsSerializer = new JobDetails.JobDetailsSerializer();
                jobDetailsSerializer.serialize(WebMonitorUtils.createDetailsForJob(graph), gen, null);
                gen.writeEndArray();
                gen.writeEndObject();
            }
            String json = writer.toString();
            String path = CurrentJobsOverviewHandler.ALL_JOBS_REST_PATH;
            return Collections.singleton(new ArchivedJson(path, json));
        }
    }
}

