/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.messages.webmonitor.ClusterOverview;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.LegacyRestHandler;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJsonRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.rest.handler.legacy.messages.ClusterOverviewWithVersion;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class ClusterOverviewHandler
extends AbstractJsonRequestHandler
implements LegacyRestHandler<DispatcherGateway, ClusterOverviewWithVersion, EmptyMessageParameters> {
    private static final String version = EnvironmentInformation.getVersion();
    private static final String commitID = EnvironmentInformation.getRevisionInformation().commitId;
    private final Time timeout;

    public ClusterOverviewHandler(Executor executor, Time timeout) {
        super(executor);
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
    }

    @Override
    public String[] getPaths() {
        return new String[]{"/overview"};
    }

    @Override
    public CompletableFuture<String> handleJsonRequest(Map<String, String> pathParams, Map<String, String> queryParams, JobManagerGateway jobManagerGateway) {
        try {
            if (jobManagerGateway != null) {
                CompletableFuture<ClusterOverview> overviewFuture = jobManagerGateway.requestClusterOverview(this.timeout);
                return overviewFuture.thenApplyAsync(overview -> {
                    StringWriter writer = new StringWriter();
                    try {
                        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
                        gen.writeStartObject();
                        gen.writeNumberField("taskmanagers", overview.getNumTaskManagersConnected());
                        gen.writeNumberField("slots-total", overview.getNumSlotsTotal());
                        gen.writeNumberField("slots-available", overview.getNumSlotsAvailable());
                        gen.writeNumberField("jobs-running", overview.getNumJobsRunningOrPending());
                        gen.writeNumberField("jobs-finished", overview.getNumJobsFinished());
                        gen.writeNumberField("jobs-cancelled", overview.getNumJobsCancelled());
                        gen.writeNumberField("jobs-failed", overview.getNumJobsFailed());
                        gen.writeStringField("flink-version", version);
                        if (!commitID.equals("<unknown>")) {
                            gen.writeStringField("flink-commit", commitID);
                        }
                        gen.writeEndObject();
                        gen.close();
                        return writer.toString();
                    }
                    catch (IOException exception) {
                        throw new CompletionException(new FlinkException("Could not write cluster overview.", (Throwable)exception));
                    }
                }, this.executor);
            }
            throw new Exception("No connection to the leading JobManager.");
        }
        catch (Exception e) {
            return FutureUtils.completedExceptionally(new FlinkException("Failed to fetch list of all running jobs: ", (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<ClusterOverviewWithVersion> handleRequest(HandlerRequest<EmptyRequestBody, EmptyMessageParameters> request, DispatcherGateway gateway) {
        CompletableFuture<ClusterOverview> overviewFuture = gateway.requestClusterOverview(this.timeout);
        return overviewFuture.thenApply(statusOverview -> ClusterOverviewWithVersion.fromStatusOverview(statusOverview, version, commitID));
    }
}

