/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.rpc.FencedRpcGateway;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public abstract class RetryingRegistration<F extends Serializable, G extends RpcGateway, S extends RegistrationResponse.Success> {
    private static final long INITIAL_REGISTRATION_TIMEOUT_MILLIS = 100L;
    private static final long MAX_REGISTRATION_TIMEOUT_MILLIS = 30000L;
    private static final long ERROR_REGISTRATION_DELAY_MILLIS = 10000L;
    private static final long REFUSED_REGISTRATION_DELAY_MILLIS = 30000L;
    private final Logger log;
    private final RpcService rpcService;
    private final String targetName;
    private final Class<G> targetType;
    private final String targetAddress;
    private final F fencingToken;
    private final CompletableFuture<Tuple2<G, S>> completionFuture;
    private final long initialRegistrationTimeout;
    private final long maxRegistrationTimeout;
    private final long delayOnError;
    private final long delayOnRefusedRegistration;
    private volatile boolean canceled;

    public RetryingRegistration(Logger log, RpcService rpcService, String targetName, Class<G> targetType, String targetAddress, F fencingToken) {
        this(log, rpcService, targetName, targetType, targetAddress, fencingToken, 100L, 30000L, 10000L, 30000L);
    }

    public RetryingRegistration(Logger log, RpcService rpcService, String targetName, Class<G> targetType, String targetAddress, F fencingToken, long initialRegistrationTimeout, long maxRegistrationTimeout, long delayOnError, long delayOnRefusedRegistration) {
        Preconditions.checkArgument((initialRegistrationTimeout > 0L ? 1 : 0) != 0, (Object)"initial registration timeout must be greater than zero");
        Preconditions.checkArgument((maxRegistrationTimeout > 0L ? 1 : 0) != 0, (Object)"maximum registration timeout must be greater than zero");
        Preconditions.checkArgument((delayOnError >= 0L ? 1 : 0) != 0, (Object)"delay on error must be non-negative");
        Preconditions.checkArgument((delayOnRefusedRegistration >= 0L ? 1 : 0) != 0, (Object)"delay on refused registration must be non-negative");
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
        this.rpcService = (RpcService)Preconditions.checkNotNull((Object)rpcService);
        this.targetName = (String)Preconditions.checkNotNull((Object)targetName);
        this.targetType = (Class)Preconditions.checkNotNull(targetType);
        this.targetAddress = (String)Preconditions.checkNotNull((Object)targetAddress);
        this.fencingToken = (Serializable)Preconditions.checkNotNull(fencingToken);
        this.initialRegistrationTimeout = initialRegistrationTimeout;
        this.maxRegistrationTimeout = maxRegistrationTimeout;
        this.delayOnError = delayOnError;
        this.delayOnRefusedRegistration = delayOnRefusedRegistration;
        this.completionFuture = new CompletableFuture();
    }

    public CompletableFuture<Tuple2<G, S>> getFuture() {
        return this.completionFuture;
    }

    public void cancel() {
        this.canceled = true;
        this.completionFuture.cancel(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected abstract CompletableFuture<RegistrationResponse> invokeRegistration(G var1, F var2, long var3) throws Exception;

    public void startRegistration() {
        if (this.canceled) {
            return;
        }
        try {
            CompletableFuture<Object> resourceManagerFuture = FencedRpcGateway.class.isAssignableFrom(this.targetType) ? this.rpcService.connect(this.targetAddress, this.fencingToken, this.targetType.asSubclass(FencedRpcGateway.class)) : this.rpcService.connect(this.targetAddress, this.targetType);
            CompletionStage resourceManagerAcceptFuture = resourceManagerFuture.thenAcceptAsync(result -> {
                this.log.info("Resolved {} address, beginning registration", (Object)this.targetName);
                this.register(result, 1, this.initialRegistrationTimeout);
            }, this.rpcService.getExecutor());
            ((CompletableFuture)resourceManagerAcceptFuture).whenCompleteAsync((v, failure) -> {
                if (failure != null && !this.canceled) {
                    this.log.warn("Could not resolve {} address {}, retrying in {} ms", new Object[]{this.targetName, this.targetAddress, this.delayOnError, failure});
                    this.startRegistrationLater(this.delayOnError);
                }
            }, this.rpcService.getExecutor());
        }
        catch (Throwable t) {
            this.completionFuture.completeExceptionally(t);
            this.cancel();
        }
    }

    private void register(G gateway, int attempt, long timeoutMillis) {
        if (this.canceled) {
            return;
        }
        try {
            this.log.info("Registration at {} attempt {} (timeout={}ms)", new Object[]{this.targetName, attempt, timeoutMillis});
            CompletableFuture<RegistrationResponse> registrationFuture = this.invokeRegistration(gateway, this.fencingToken, timeoutMillis);
            CompletionStage registrationAcceptFuture = registrationFuture.thenAcceptAsync(result -> {
                if (!this.isCanceled()) {
                    if (result instanceof RegistrationResponse.Success) {
                        RegistrationResponse.Success success = (RegistrationResponse.Success)result;
                        this.completionFuture.complete(Tuple2.of((Object)gateway, (Object)success));
                    } else {
                        if (result instanceof RegistrationResponse.Decline) {
                            RegistrationResponse.Decline decline = (RegistrationResponse.Decline)result;
                            this.log.info("Registration at {} was declined: {}", (Object)this.targetName, (Object)decline.getReason());
                        } else {
                            this.log.error("Received unknown response to registration attempt: {}", result);
                        }
                        this.log.info("Pausing and re-attempting registration in {} ms", (Object)this.delayOnRefusedRegistration);
                        this.registerLater(gateway, 1, this.initialRegistrationTimeout, this.delayOnRefusedRegistration);
                    }
                }
            }, this.rpcService.getExecutor());
            ((CompletableFuture)registrationAcceptFuture).whenCompleteAsync((v, failure) -> {
                if (failure != null && !this.isCanceled()) {
                    if (failure instanceof TimeoutException) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Registration at {} ({}) attempt {} timed out after {} ms", new Object[]{this.targetName, this.targetAddress, attempt, timeoutMillis});
                        }
                        long newTimeoutMillis = Math.min(2L * timeoutMillis, this.maxRegistrationTimeout);
                        this.register(gateway, attempt + 1, newTimeoutMillis);
                    } else {
                        this.log.error("Registration at {} failed due to an error", (Object)this.targetName, failure);
                        this.log.info("Pausing and re-attempting registration in {} ms", (Object)this.delayOnError);
                        this.registerLater(gateway, 1, this.initialRegistrationTimeout, this.delayOnError);
                    }
                }
            }, this.rpcService.getExecutor());
        }
        catch (Throwable t) {
            this.completionFuture.completeExceptionally(t);
            this.cancel();
        }
    }

    private void registerLater(G gateway, int attempt, long timeoutMillis, long delay) {
        this.rpcService.scheduleRunnable(new Runnable((RpcGateway)gateway, attempt, timeoutMillis){
            final /* synthetic */ RpcGateway val$gateway;
            final /* synthetic */ int val$attempt;
            final /* synthetic */ long val$timeoutMillis;
            {
                this.val$gateway = rpcGateway;
                this.val$attempt = n;
                this.val$timeoutMillis = l;
            }

            @Override
            public void run() {
                RetryingRegistration.this.register(this.val$gateway, this.val$attempt, this.val$timeoutMillis);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    private void startRegistrationLater(long delay) {
        this.rpcService.scheduleRunnable(this::startRegistration, delay, TimeUnit.MILLISECONDS);
    }
}

