/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.netty.PartitionRequestClient;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class RemoteInputChannel
extends InputChannel
implements BufferRecycler,
BufferListener {
    private final InputChannelID id = new InputChannelID();
    private final ConnectionID connectionId;
    private final ConnectionManager connectionManager;
    private final ArrayDeque<Buffer> receivedBuffers = new ArrayDeque();
    private final AtomicBoolean isReleased = new AtomicBoolean();
    private volatile PartitionRequestClient partitionRequestClient;
    private int expectedSequenceNumber = 0;
    private int initialCredit;
    private final ArrayDeque<Buffer> availableBuffers = new ArrayDeque();
    private final AtomicInteger unannouncedCredit = new AtomicInteger(0);
    private final AtomicInteger senderBacklog = new AtomicInteger(0);
    private final AtomicBoolean isWaitingForFloatingBuffers = new AtomicBoolean(false);

    public RemoteInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, ConnectionID connectionId, ConnectionManager connectionManager, TaskIOMetricGroup metrics) {
        this(inputGate, channelIndex, partitionId, connectionId, connectionManager, 0, 0, metrics);
    }

    public RemoteInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, ConnectionID connectionId, ConnectionManager connectionManager, int initialBackOff, int maxBackoff, TaskIOMetricGroup metrics) {
        super(inputGate, channelIndex, partitionId, initialBackOff, maxBackoff, metrics.getNumBytesInRemoteCounter());
        this.connectionId = (ConnectionID)Preconditions.checkNotNull((Object)connectionId);
        this.connectionManager = (ConnectionManager)Preconditions.checkNotNull((Object)connectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assignExclusiveSegments(List<MemorySegment> segments) {
        Preconditions.checkState((this.initialCredit == 0 ? 1 : 0) != 0, (Object)"Bug in input channel setup logic: exclusive buffers have already been set for this input channel.");
        Preconditions.checkNotNull(segments);
        Preconditions.checkArgument((segments.size() > 0 ? 1 : 0) != 0, (Object)"The number of exclusive buffers per channel should be larger than 0.");
        this.initialCredit = segments.size();
        ArrayDeque<Buffer> arrayDeque = this.availableBuffers;
        synchronized (arrayDeque) {
            for (MemorySegment segment : segments) {
                this.availableBuffers.add(new Buffer(segment, this));
            }
        }
    }

    @Override
    void requestSubpartition(int subpartitionIndex) throws IOException, InterruptedException {
        if (this.partitionRequestClient == null) {
            this.partitionRequestClient = this.connectionManager.createPartitionRequestClient(this.connectionId);
            this.partitionRequestClient.requestSubpartition(this.partitionId, subpartitionIndex, this, 0);
        }
    }

    void retriggerSubpartitionRequest(int subpartitionIndex) throws IOException, InterruptedException {
        Preconditions.checkState((this.partitionRequestClient != null ? 1 : 0) != 0, (Object)"Missing initial subpartition request.");
        if (this.increaseBackoff()) {
            this.partitionRequestClient.requestSubpartition(this.partitionId, subpartitionIndex, this, this.getCurrentBackoff());
        } else {
            this.failPartitionRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputChannel.BufferAndAvailability getNextBuffer() throws IOException {
        int remaining;
        Buffer next;
        Preconditions.checkState((!this.isReleased.get() ? 1 : 0) != 0, (Object)"Queried for a buffer after channel has been closed.");
        Preconditions.checkState((this.partitionRequestClient != null ? 1 : 0) != 0, (Object)"Queried for a buffer before requesting a queue.");
        this.checkError();
        ArrayDeque<Buffer> arrayDeque = this.receivedBuffers;
        synchronized (arrayDeque) {
            next = this.receivedBuffers.poll();
            remaining = this.receivedBuffers.size();
        }
        this.numBytesIn.inc((long)next.getSize());
        return new InputChannel.BufferAndAvailability(next, remaining > 0);
    }

    @Override
    void sendTaskEvent(TaskEvent event) throws IOException {
        Preconditions.checkState((!this.isReleased.get() ? 1 : 0) != 0, (Object)"Tried to send task event to producer after channel has been released.");
        Preconditions.checkState((this.partitionRequestClient != null ? 1 : 0) != 0, (Object)"Tried to send task event to producer before requesting a queue.");
        this.checkError();
        this.partitionRequestClient.sendTaskEvent(this.partitionId, event, this);
    }

    @Override
    boolean isReleased() {
        return this.isReleased.get();
    }

    @Override
    void notifySubpartitionConsumed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void releaseAllResources() throws IOException {
        if (this.isReleased.compareAndSet(false, true)) {
            Buffer buffer;
            ArrayList<MemorySegment> exclusiveRecyclingSegments = new ArrayList<MemorySegment>();
            ArrayDeque<Buffer> arrayDeque = this.receivedBuffers;
            synchronized (arrayDeque) {
                while ((buffer = this.receivedBuffers.poll()) != null) {
                    if (buffer.getRecycler() == this) {
                        exclusiveRecyclingSegments.add(buffer.getMemorySegment());
                        continue;
                    }
                    buffer.recycle();
                }
            }
            arrayDeque = this.availableBuffers;
            synchronized (arrayDeque) {
                while ((buffer = this.availableBuffers.poll()) != null) {
                    if (buffer.getRecycler() == this) {
                        exclusiveRecyclingSegments.add(buffer.getMemorySegment());
                        continue;
                    }
                    buffer.recycle();
                }
            }
            if (exclusiveRecyclingSegments.size() > 0) {
                this.inputGate.returnExclusiveSegments(exclusiveRecyclingSegments);
            }
            if (this.partitionRequestClient != null) {
                this.partitionRequestClient.close(this);
            } else {
                this.connectionManager.closeOpenChannelConnections(this.connectionId);
            }
        }
    }

    private void failPartitionRequest() {
        this.setError(new PartitionNotFoundException(this.partitionId));
    }

    public String toString() {
        return "RemoteInputChannel [" + this.partitionId + " at " + this.connectionId + "]";
    }

    void notifyCreditAvailable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(MemorySegment segment) {
        ArrayDeque<Buffer> arrayDeque = this.availableBuffers;
        synchronized (arrayDeque) {
            if (this.isReleased.get()) {
                try {
                    this.inputGate.returnExclusiveSegments(Arrays.asList(segment));
                    return;
                }
                catch (Throwable t) {
                    ExceptionUtils.rethrow((Throwable)t);
                }
            }
            this.availableBuffers.add(new Buffer(segment, this));
        }
        if (this.unannouncedCredit.getAndAdd(1) == 0) {
            this.notifyCreditAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAvailableBuffers() {
        ArrayDeque<Buffer> arrayDeque = this.availableBuffers;
        synchronized (arrayDeque) {
            return this.availableBuffers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notifyBufferAvailable(Buffer buffer) {
        Preconditions.checkState((boolean)this.isWaitingForFloatingBuffers.get(), (Object)"This channel should be waiting for floating buffers.");
        ArrayDeque<Buffer> arrayDeque = this.availableBuffers;
        synchronized (arrayDeque) {
            if (this.isReleased.get() || this.availableBuffers.size() >= this.senderBacklog.get()) {
                this.isWaitingForFloatingBuffers.set(false);
                buffer.recycle();
                return false;
            }
            this.availableBuffers.add(buffer);
            if (this.unannouncedCredit.getAndAdd(1) == 0) {
                this.notifyCreditAvailable();
            }
            if (this.availableBuffers.size() >= this.senderBacklog.get()) {
                this.isWaitingForFloatingBuffers.set(false);
                return false;
            }
            return true;
        }
    }

    @Override
    public void notifyBufferDestroyed() {
        if (!this.isWaitingForFloatingBuffers.compareAndSet(true, false)) {
            throw new IllegalStateException("This channel should be waiting for floating buffers currently.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfQueuedBuffers() {
        ArrayDeque<Buffer> arrayDeque = this.receivedBuffers;
        synchronized (arrayDeque) {
            return this.receivedBuffers.size();
        }
    }

    public int unsynchronizedGetNumberOfQueuedBuffers() {
        return Math.max(0, this.receivedBuffers.size());
    }

    public InputChannelID getInputChannelId() {
        return this.id;
    }

    public int getInitialCredit() {
        return this.initialCredit;
    }

    public BufferProvider getBufferProvider() throws IOException {
        if (this.isReleased.get()) {
            return null;
        }
        return this.inputGate.getBufferProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBuffer(Buffer buffer, int sequenceNumber) {
        boolean success = false;
        try {
            ArrayDeque<Buffer> arrayDeque = this.receivedBuffers;
            synchronized (arrayDeque) {
                if (!this.isReleased.get()) {
                    if (this.expectedSequenceNumber == sequenceNumber) {
                        int available = this.receivedBuffers.size();
                        this.receivedBuffers.add(buffer);
                        ++this.expectedSequenceNumber;
                        if (available == 0) {
                            this.notifyChannelNonEmpty();
                        }
                        success = true;
                    } else {
                        this.onError(new BufferReorderingException(this.expectedSequenceNumber, sequenceNumber));
                    }
                }
            }
        }
        finally {
            if (!success) {
                buffer.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEmptyBuffer(int sequenceNumber) {
        ArrayDeque<Buffer> arrayDeque = this.receivedBuffers;
        synchronized (arrayDeque) {
            if (!this.isReleased.get()) {
                if (this.expectedSequenceNumber == sequenceNumber) {
                    ++this.expectedSequenceNumber;
                } else {
                    this.onError(new BufferReorderingException(this.expectedSequenceNumber, sequenceNumber));
                }
            }
        }
    }

    public void onFailedPartitionRequest() {
        this.inputGate.triggerPartitionStateCheck(this.partitionId);
    }

    public void onError(Throwable cause) {
        this.setError(cause);
    }

    private static class BufferReorderingException
    extends IOException {
        private static final long serialVersionUID = -888282210356266816L;
        private final int expectedSequenceNumber;
        private final int actualSequenceNumber;

        BufferReorderingException(int expectedSequenceNumber, int actualSequenceNumber) {
            this.expectedSequenceNumber = expectedSequenceNumber;
            this.actualSequenceNumber = actualSequenceNumber;
        }

        @Override
        public String getMessage() {
            return String.format("Buffer re-ordering: expected buffer with sequence number %d, but received %d.", this.expectedSequenceNumber, this.actualSequenceNumber);
        }
    }
}

