/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.metrics;

import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.util.Preconditions;

public class UpTimeGauge
implements Gauge<Long> {
    public static final String METRIC_NAME = "uptime";
    private static final long NO_LONGER_RUNNING = -1L;
    private final ExecutionGraph eg;

    public UpTimeGauge(ExecutionGraph executionGraph) {
        this.eg = (ExecutionGraph)Preconditions.checkNotNull((Object)executionGraph);
    }

    public Long getValue() {
        JobStatus status = this.eg.getState();
        if (status == JobStatus.RUNNING) {
            long runningTimestamp = this.eg.getStatusTimestamp(JobStatus.RUNNING);
            return Math.max(System.currentTimeMillis() - runningTimestamp, 0L);
        }
        if (status.isTerminalState()) {
            return -1L;
        }
        return 0L;
    }
}

