/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.OnCompletionActions;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.runtime.jobmaster.JobManagerServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public abstract class JobClusterEntrypoint
extends ClusterEntrypoint {
    private ResourceManager<?> resourceManager;
    private JobManagerServices jobManagerServices;
    private JobManagerRunner jobManagerRunner;

    public JobClusterEntrypoint(Configuration configuration) {
        super(configuration);
    }

    @Override
    protected void startClusterComponents(Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, BlobServer blobServer, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry) throws Exception {
        this.resourceManager = this.createResourceManager(configuration, ResourceID.generate(), rpcService, highAvailabilityServices, heartbeatServices, metricRegistry, this);
        this.jobManagerServices = JobManagerServices.fromConfiguration(configuration, blobServer);
        this.jobManagerRunner = this.createJobManagerRunner(configuration, ResourceID.generate(), rpcService, highAvailabilityServices, this.jobManagerServices, heartbeatServices, metricRegistry, this);
        LOG.debug("Starting ResourceManager.");
        this.resourceManager.start();
        LOG.debug("Starting JobManager.");
        this.jobManagerRunner.start();
    }

    protected JobManagerRunner createJobManagerRunner(Configuration configuration, ResourceID resourceId, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, JobManagerServices jobManagerServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, FatalErrorHandler fatalErrorHandler) throws Exception {
        JobGraph jobGraph = this.retrieveJobGraph(configuration);
        return new JobManagerRunner(resourceId, jobGraph, configuration, rpcService, highAvailabilityServices, heartbeatServices, jobManagerServices, metricRegistry, new TerminatingOnCompleteActions(jobGraph.getJobID()), fatalErrorHandler);
    }

    @Override
    protected void stopClusterComponents(boolean cleanupHaData) throws Exception {
        Throwable exception = null;
        if (this.jobManagerRunner != null) {
            try {
                this.jobManagerRunner.shutdown();
            }
            catch (Throwable t) {
                exception = t;
            }
        }
        if (this.jobManagerServices != null) {
            try {
                this.jobManagerServices.shutdown();
            }
            catch (Throwable t) {
                exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
            }
        }
        if (this.resourceManager != null) {
            try {
                this.resourceManager.shutDown();
            }
            catch (Throwable t) {
                exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
            }
        }
        if (exception != null) {
            throw new FlinkException("Could not properly shut down the job cluster entry point.", exception);
        }
    }

    private void shutDownAndTerminate(boolean cleanupHaData) {
        try {
            this.shutDown(cleanupHaData);
        }
        catch (Throwable t) {
            LOG.error("Could not properly shut down cluster entrypoint.", t);
        }
        System.exit(0);
    }

    protected abstract ResourceManager<?> createResourceManager(Configuration var1, ResourceID var2, RpcService var3, HighAvailabilityServices var4, HeartbeatServices var5, MetricRegistry var6, FatalErrorHandler var7) throws Exception;

    protected abstract JobGraph retrieveJobGraph(Configuration var1) throws FlinkException;

    private final class TerminatingOnCompleteActions
    implements OnCompletionActions {
        private final JobID jobId;

        private TerminatingOnCompleteActions(JobID jobId) {
            this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        }

        @Override
        public void jobFinished(JobExecutionResult result) {
            ClusterEntrypoint.LOG.info("Job({}) finished.", (Object)this.jobId);
            JobClusterEntrypoint.this.shutDownAndTerminate(true);
        }

        @Override
        public void jobFailed(Throwable cause) {
            ClusterEntrypoint.LOG.info("Job({}) failed.", (Object)this.jobId, (Object)cause);
            JobClusterEntrypoint.this.shutDownAndTerminate(false);
        }

        @Override
        public void jobFinishedByOther() {
            ClusterEntrypoint.LOG.info("Job({}) was finished by another JobManager.", (Object)this.jobId);
            JobClusterEntrypoint.this.shutDownAndTerminate(false);
        }
    }
}

