/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.HadoopBlockLocation;
import org.apache.flink.runtime.fs.hdfs.HadoopDataInputStream;
import org.apache.flink.runtime.fs.hdfs.HadoopDataOutputStream;
import org.apache.flink.runtime.fs.hdfs.HadoopFileStatus;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;

public class HadoopFileSystem
extends org.apache.flink.core.fs.FileSystem {
    private final FileSystem fs;
    private FileSystemKind fsKind;

    public HadoopFileSystem(FileSystem hadoopFileSystem) {
        this.fs = (FileSystem)Preconditions.checkNotNull((Object)hadoopFileSystem, (String)"hadoopFileSystem");
    }

    public FileSystem getHadoopFileSystem() {
        return this.fs;
    }

    public Path getWorkingDirectory() {
        return new Path(this.fs.getWorkingDirectory().toUri());
    }

    public Path getHomeDirectory() {
        return new Path(this.fs.getHomeDirectory().toUri());
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus status = this.fs.getFileStatus(new org.apache.hadoop.fs.Path(f.toString()));
        return new HadoopFileStatus(status);
    }

    public org.apache.flink.core.fs.BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!(file instanceof HadoopFileStatus)) {
            throw new IOException("file is not an instance of DistributedFileStatus");
        }
        HadoopFileStatus f = (HadoopFileStatus)file;
        BlockLocation[] blkLocations = this.fs.getFileBlockLocations(f.getInternalFileStatus(), start, len);
        org.apache.flink.core.fs.BlockLocation[] distBlkLocations = new HadoopBlockLocation[blkLocations.length];
        for (int i = 0; i < distBlkLocations.length; ++i) {
            distBlkLocations[i] = new HadoopBlockLocation(blkLocations[i]);
        }
        return distBlkLocations;
    }

    public HadoopDataInputStream open(Path f, int bufferSize) throws IOException {
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path(f.toString());
        FSDataInputStream fdis = this.fs.open(path, bufferSize);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataInputStream open(Path f) throws IOException {
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path(f.toString());
        FSDataInputStream fdis = this.fs.open(path);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        FSDataOutputStream fdos = this.fs.create(new org.apache.hadoop.fs.Path(f.toString()), overwrite, bufferSize, replication, blockSize);
        return new HadoopDataOutputStream(fdos);
    }

    public HadoopDataOutputStream create(Path f, FileSystem.WriteMode overwrite) throws IOException {
        FSDataOutputStream fsDataOutputStream = this.fs.create(new org.apache.hadoop.fs.Path(f.toString()), overwrite == FileSystem.WriteMode.OVERWRITE);
        return new HadoopDataOutputStream(fsDataOutputStream);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.fs.delete(new org.apache.hadoop.fs.Path(f.toString()), recursive);
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus[] hadoopFiles = this.fs.listStatus(new org.apache.hadoop.fs.Path(f.toString()));
        FileStatus[] files = new FileStatus[hadoopFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new HadoopFileStatus(hadoopFiles[i]);
        }
        return files;
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.fs.mkdirs(new org.apache.hadoop.fs.Path(f.toString()));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.fs.rename(new org.apache.hadoop.fs.Path(src.toString()), new org.apache.hadoop.fs.Path(dst.toString()));
    }

    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    public boolean isDistributedFS() {
        return true;
    }

    public FileSystemKind getKind() {
        if (this.fsKind == null) {
            this.fsKind = HadoopFileSystem.getKindForScheme(this.fs.getUri().getScheme());
        }
        return this.fsKind;
    }

    static FileSystemKind getKindForScheme(String scheme) {
        if ((scheme = scheme.toLowerCase(Locale.US)).startsWith("s3") || scheme.startsWith("emr")) {
            return FileSystemKind.OBJECT_STORE;
        }
        if (scheme.startsWith("http") || scheme.startsWith("ftp")) {
            return FileSystemKind.OBJECT_STORE;
        }
        return FileSystemKind.FILE_SYSTEM;
    }
}

