/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import kr.weitao.common.util.AliCDNUrlAuth;
import kr.weitao.common.util.qrcode.BufferedImageLuminanceSource;
import org.apache.commons.codec.binary.Base64;

public class QRCodeUtil {
    private static final String CHARSET = "utf-8";
    private static final String FORMAT_NAME = "JPG";
    private static final int QRCODE_SIZE = 430;
    private static final int WIDTH = 120;
    private static final int HEIGHT = 120;

    public static BufferedImage createImage(String content, String imgPath, boolean needCompress) throws Exception {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 430, 430, hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        if (imgPath == null || "".equals(imgPath)) {
            return image;
        }
        try {
            QRCodeUtil.insertImage(image, imgPath, needCompress);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    private static void insertImage(BufferedImage source, String imgPath, boolean needCompress) throws Exception {
        Image src = ImageIO.read(new URL(imgPath).openStream());
        int width = ((Image)src).getWidth(null);
        int height = ((Image)src).getHeight(null);
        if (needCompress) {
            if (width > 120) {
                width = 120;
            }
            if (height > 120) {
                height = 120;
            }
            Image image = src.getScaledInstance(width, height, 4);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            src = image;
        }
        Graphics2D graph = source.createGraphics();
        int x = (430 - width) / 2;
        int y = (430 - height) / 2;
        graph.drawImage(src, x, y, width, height, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
    }

    public static InputStream encode(String content, String imgPath, boolean needCompress) throws Exception {
        BufferedImage image = QRCodeUtil.createImage(content, imgPath, needCompress);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, FORMAT_NAME, os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        return is;
    }

    public static void mkdirs(String destPath) {
        File file = new File(destPath);
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
    }

    public static void encode(String content, String imgPath) throws Exception {
        QRCodeUtil.encode(content, imgPath, false);
    }

    public static void encode(String content, String imgPath, OutputStream output, boolean needCompress) throws Exception {
        BufferedImage image = QRCodeUtil.createImage(content, imgPath, needCompress);
        ImageIO.write((RenderedImage)image, FORMAT_NAME, output);
    }

    public static void encode(String content, OutputStream output) throws Exception {
        QRCodeUtil.encode(content, null, output, false);
    }

    public static String decode(File file) throws Exception {
        BufferedImage image = ImageIO.read(file);
        if (image == null) {
            return null;
        }
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, CHARSET);
        Result result = new MultiFormatReader().decode(bitmap, hints);
        String resultStr = result.getText();
        return resultStr;
    }

    public static String decode(String path) throws Exception {
        return QRCodeUtil.decode(new File(path));
    }

    public static BufferedImage bigImgAddSmallImgAndText(InputStream bigImgIs, BufferedImage smallImg, double sx, double sy, double width, double height, int position) throws IOException {
        BufferedImage buffImg = ImageIO.read(bigImgIs);
        Graphics g = buffImg.getGraphics();
        double b_height = buffImg.getHeight();
        double b_width = buffImg.getWidth();
        if (position > 0 && position < 10) {
            double min_side;
            double d = min_side = b_height > b_width ? b_width : b_height;
            if (min_side * 0.238 < 100.0) {
                width = 100.0;
                height = 100.0;
            } else {
                width = min_side * 0.238;
                height = min_side * 0.238;
            }
            if (position == 1 || position == 4 || position == 7) {
                sx = b_width * 0.048;
            } else if (position == 2 || position == 5 || position == 8) {
                sx = (b_width - width) / 2.0;
            } else if (position == 3 || position == 6 || position == 9) {
                sx = b_width * 0.952 - width;
            }
            if (position == 1 || position == 2 || position == 3) {
                sy = b_height * 0.048;
            } else if (position == 4 || position == 5 || position == 6) {
                sy = (b_height - height) / 2.0;
            } else if (position == 7 || position == 8 || position == 9) {
                sy = b_height * 0.952 - height;
            }
        }
        System.out.println("sx:" + sx + " sy:" + sy);
        g.drawImage(smallImg, (int)sx, (int)sy, (int)width, (int)height, null);
        g.setColor(Color.WHITE);
        g.dispose();
        return buffImg;
    }

    public static InputStream getImageStream(BufferedImage bimage) {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
            ImageIO.write((RenderedImage)bimage, "png", imOut);
            is = new ByteArrayInputStream(bs.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return is;
    }

    public static void main(String[] args) throws Exception {
        String image_url = "material_imgs/5a41e339ca2d3c138289175d/wtkios1515401174.jpg";
        image_url = AliCDNUrlAuth.getAuthURLA("https://jlr-dev.oss-cn-shanghai.aliyuncs.com/" + image_url);
        String url = "https://mmbiz.qpic.cn/mmbiz_jpg/ib1okpmEEMfFS56RXVgLmibBN4mB6jo5dGydn3ia4YV5MYxVprS7KXRGypVRUMV4qAN1XP9OgVoQ5PvBKeeoWx6WQ/640";
        InputStream in = new URL(url).openStream();
        byte[] data = new byte[in.available()];
        in.read(data);
        in.close();
        System.out.println(Base64.encodeBase64((byte[])data));
    }
}

