/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XmlMapConverter {
    private static final String DEFAULT_XML_ROOT_NAME = "xml";
    private static final String DEFAULT_XML_ENCODING = "UTF-8";
    private static final OutputFormat DEFAULT_OUTPUT_FORMAT = new OutputFormat("  ", true);
    private static final String DEFAULT_LIST_NAME = "Value";

    public static String mapToXml(Map<String, Object> map, String rootName) throws Exception {
        return XmlMapConverter.mapToXml(map, rootName, DEFAULT_OUTPUT_FORMAT);
    }

    public static String mapToXml(Map<String, Object> map, String rootName, OutputFormat outputFormat) throws Exception {
        if (map == null) {
            throw new RuntimeException("[XmlMapConverter]can't convert null map into xml");
        }
        if (rootName == null || rootName.length() <= 0) {
            rootName = DEFAULT_XML_ROOT_NAME;
        }
        Element root = DocumentHelper.createElement((String)rootName);
        Document document = DocumentHelper.createDocument((Element)root);
        XmlMapConverter.convert(map, root, rootName);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, outputFormat);
        xmlWriter.write(document);
        xmlWriter.close();
        return stringWriter.toString();
    }

    private static void convert(Object obj, Element element, String elementName) {
        block10: {
            block9: {
                if (obj == null || element == null) {
                    return;
                }
                if (!(obj instanceof Map)) break block9;
                if (((Map)obj).size() <= 0) {
                    return;
                }
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    String name = String.valueOf(entry.getKey());
                    Object data = entry.getValue();
                    if (data instanceof Map) {
                        XmlMapConverter.convert(data, element.addElement(name), name);
                        continue;
                    }
                    if (data instanceof List) {
                        XmlMapConverter.convert(data, element, name);
                        continue;
                    }
                    Element subElement = element.addElement(name);
                    data = data == null ? "" : data;
                    subElement.addText(String.valueOf(data));
                }
                break block10;
            }
            if (!(obj instanceof List)) break block10;
            if (((List)obj).size() <= 0) {
                return;
            }
            for (Object data : (List)obj) {
                if (data instanceof Map) {
                    XmlMapConverter.convert(data, element.addElement(elementName), elementName);
                    continue;
                }
                if (data instanceof List) {
                    XmlMapConverter.convert(data, element.addElement(elementName), DEFAULT_LIST_NAME);
                    continue;
                }
                Element subElement = element.addElement(elementName);
                if (data == null) continue;
                subElement.addText(String.valueOf(data));
            }
        }
    }

    public static Map<String, Object> xmlToMap(String xml) throws Exception {
        if (xml == null || xml.length() <= 0) {
            throw new Exception("[XmlMapConverter]can't convert null xml into map");
        }
        Document document = DocumentHelper.parseText((String)xml);
        Element root = document.getRootElement();
        HashMap<String, Object> map = new HashMap<String, Object>();
        XmlMapConverter.convert(root, map);
        return map;
    }

    private static void convert(Element element, Map<String, Object> map) {
        if (element == null || map == null) {
            return;
        }
        List subElements = element.elements();
        if (subElements == null || subElements.size() <= 0) {
            return;
        }
        for (Object subElement : subElements) {
            if (!(subElement instanceof Element)) continue;
            String name = ((Element)subElement).getName();
            HashMap data = null;
            if (((Element)subElement).isTextOnly()) {
                data = ((Element)subElement).getData();
            } else {
                data = new HashMap();
                XmlMapConverter.convert((Element)subElement, data);
            }
            Object preData = map.remove(name);
            if (preData != null) {
                if (preData instanceof List) {
                    ((List)preData).add(data);
                    map.put(name, preData);
                    continue;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(preData);
                list.add(data);
                map.put(name, list);
                continue;
            }
            if (data == null) continue;
            map.put(name, data);
        }
    }

    public static void main(String[] args) throws Exception {
        String ss = "{\"nonce_str\":\"4b4f6f692547affd2c8fadb39fed603a\",\"sign\":\"144FF79B7391FE1BD0708470B7D8A2E3\",\"body\":\"\u88ab\u626b\u6d4b\u8bd5\",\"mch_id\":\"1900009001\",\"sub_mch_id\":\"11383918\",\"spbill_create_ip\":\"14.23.150.211\",\"version\":\"1.0\",\"auth_code\":\"130050378319653252\",\"device_info\":\"TEST01\",\"out_trade_no\":\"19000090011489146530\",\"goods_tag\":\"MEETING\",\"appid\":\"wxdace645e0bc2c424\",\"total_fee\":\"503\",\"attach\":\"test\",\"detail\":\"{\\\"cost_price\\\":1,\\\"receipt_id\\\":\\\"wx123\\\",\\\"goods_detail\\\":[{\\\"goods_id\\\":\\\"\u5546\u54c1\u7f16\u7801\\\",\\\"wxpay_goods_id\\\":\\\"1001\\\",\\\"goods_name\\\":\\\"iPhone6s 16G\\\",\\\"quantity\\\":1,\\\"price\\\":1},{\\\"goods_id\\\":\\\"\u5546\u54c1\u7f16\u7801\\\",\\\"wxpay_goods_id\\\":\\\"1002\\\",\\\"goods_name\\\":\\\"iPhone6s 32G\\\",\\\"quantity\\\":1,\\\"price\\\":1}]}\"}\n";
        JSONObject jsonObject = JSON.parseObject((String)ss);
        String detail = StringEscapeUtils.unescapeJava((String)("<![CDATA[" + jsonObject.getString("detail") + "]]>"));
        System.out.println(detail);
        jsonObject.put("detail", (Object)"detailValue");
        String sss = XmlMapConverter.mapToXml((Map<String, Object>)jsonObject, "");
        System.out.println(sss.replace("detailValue", detail));
        String s = "<xml>\n<appid>wxdace645e0bc2c424</appid>\n<attach>test</attach>\n<auth_code>130050378319653252</auth_code>\n<body>\u88ab\u626b\u6d4b\u8bd5</body>\n<detail><![CDATA[{\"cost_price\":1,\"receipt_id\":\"wx123\",\"goods_detail\":[{\"goods_id\":\"\u5546\u54c1\u7f16\u7801\",\"wxpay_goods_id\":\"1001\",\"goods_name\":\"iPhone6s 16G\",\"quantity\":1,\"price\":1},{\"goods_id\":\"\u5546\u54c1\u7f16\u7801\",\"wxpay_goods_id\":\"1002\",\"goods_name\":\"iPhone6s 32G\",\"quantity\":1,\"price\":1}]}]]></detail>\n<device_info>TEST01</device_info>\n<goods_tag>MEETING</goods_tag>\n<mch_id>1900009001</mch_id>\n<nonce_str>4b4f6f692547affd2c8fadb39fed603a</nonce_str>\n<out_trade_no>19000090011489146530</out_trade_no>\n<spbill_create_ip>14.23.150.211</spbill_create_ip>\n<sub_mch_id>11383918</sub_mch_id>\n<total_fee>503</total_fee>\n<version>1.0</version>\n<sign>144FF79B7391FE1BD0708470B7D8A2E3</sign>\n</xml>";
        System.out.println(JSON.toJSONString(XmlMapConverter.xmlToMap(s)));
    }

    static {
        DEFAULT_OUTPUT_FORMAT.setEncoding(DEFAULT_XML_ENCODING);
    }
}

