/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import kr.weitao.common.util.XMLTokener;

public class XML {
    public static final Character AMP = new Character('&');
    public static final Character APOS = new Character('\'');
    public static final Character BANG = new Character('!');
    public static final Character EQ = new Character('=');
    public static final Character GT = new Character('>');
    public static final Character LT = new Character('<');
    public static final Character QUEST = new Character('?');
    public static final Character QUOT = new Character('\"');
    public static final Character SLASH = new Character('/');

    public static String escape(String string) {
        StringBuffer sb = new StringBuffer();
        int len = string.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static boolean parse(XMLTokener x, JSONObject context, String name) {
        String s;
        JSONObject o = null;
        JSONArray ja = new JSONArray();
        Object t = x.nextToken();
        if (t == BANG) {
            char c = x.next();
            if (c == '-') {
                if (x.next() == '-') {
                    x.skipPast("-->");
                    return false;
                }
                x.back();
            } else if (c == '[') {
                t = x.nextToken();
                if (t.equals("CDATA") && x.next() == '[') {
                    String s2 = x.nextCDATA();
                    if (s2.length() > 0) {
                        context.put("content", (Object)s2);
                    }
                    return false;
                }
                return false;
            }
            int i = 1;
            do {
                if ((t = x.nextMeta()) == null) {
                    return false;
                }
                if (t == LT) {
                    ++i;
                    continue;
                }
                if (t != GT) continue;
                --i;
            } while (i > 0);
            return false;
        }
        if (t == QUEST) {
            x.skipPast("?>");
            return false;
        }
        if (t == SLASH) {
            t = x.nextToken();
            if (name == null) {
                return false;
            }
            if (!t.equals(name)) {
                return false;
            }
            return x.nextToken() == GT;
        }
        if (t instanceof Character) {
            return false;
        }
        String n = (String)t;
        t = null;
        o = new JSONObject();
        while (true) {
            if (t == null) {
                t = x.nextToken();
            }
            if (!(t instanceof String)) break;
            s = (String)t;
            t = x.nextToken();
            if (t == EQ) {
                t = x.nextToken();
                if (!(t instanceof String)) {
                    return false;
                }
                o.put(s, t);
                t = null;
                continue;
            }
            o.put(s, (Object)"");
        }
        if (t == SLASH) {
            if (x.nextToken() != GT) {
                return false;
            }
            context.put(n, (Object)o);
            return false;
        }
        if (t == GT) {
            while (true) {
                if ((t = x.nextContent()) == null) {
                    if (n != null) {
                        return false;
                    }
                    return false;
                }
                if (t instanceof String) {
                    s = (String)t;
                    if (s.length() <= 0) continue;
                    o.put("content", (Object)s);
                    continue;
                }
                if (t == LT && XML.parse(x, o, n)) break;
            }
            if (o.size() == 0) {
                context.put(n, (Object)"");
            } else if (o.size() == 1 && o.get((Object)"content") != null) {
                context.put(n, o.get((Object)"content"));
            } else if (context.containsKey((Object)n)) {
                ja.add((Object)o);
                context.put(n, (Object)ja);
            } else {
                context.put(n, (Object)o);
            }
            return false;
        }
        return false;
    }

    public static JSONObject toJSONObject(String string) {
        JSONObject o = new JSONObject();
        XMLTokener x = new XMLTokener(string);
        while (x.more()) {
            x.skipPast("<");
            XML.parse(x, o, null);
        }
        return o.getJSONObject("xml");
    }

    public static String toString(Object o) {
        return XML.toString(o, null);
    }

    public static String toString(Object o, String tagName) {
        StringBuffer b = new StringBuffer();
        if (o instanceof JSONObject) {
            if (tagName != null) {
                b.append('<');
                b.append(tagName);
                b.append('>');
            }
            JSONObject jo = (JSONObject)o;
            Iterator keys = jo.keySet().iterator();
            while (keys.hasNext()) {
                int i;
                int len;
                JSONArray ja;
                String k = keys.next().toString();
                Object v = jo.get((Object)k);
                String s = v instanceof String ? (String)v : null;
                if (k.equals("content")) {
                    if (v instanceof JSONArray) {
                        ja = (JSONArray)v;
                        len = ja.size();
                        for (i = 0; i < len; ++i) {
                            if (i > 0) {
                                b.append('\n');
                            }
                            b.append(XML.escape(ja.get(i).toString()));
                        }
                        continue;
                    }
                    b.append(XML.escape(v.toString()));
                    continue;
                }
                if (v instanceof JSONArray) {
                    ja = (JSONArray)v;
                    len = ja.size();
                    for (i = 0; i < len; ++i) {
                        b.append(XML.toString(ja.get(i), k));
                    }
                    continue;
                }
                if (v.equals("")) {
                    b.append('<');
                    b.append(k);
                    b.append("/>");
                    continue;
                }
                b.append(XML.toString(v, k));
            }
            if (tagName != null) {
                b.append("</");
                b.append(tagName);
                b.append('>');
            }
            return b.toString();
        }
        if (o instanceof JSONArray) {
            JSONArray ja = (JSONArray)o;
            int len = ja.size();
            for (int i = 0; i < len; ++i) {
                b.append(XML.toString(ja.get(i), tagName == null ? "array" : tagName));
            }
            return b.toString();
        }
        String s = o == null ? "null" : XML.escape(o.toString());
        return "<" + tagName + ">" + s + "</" + tagName + ">";
    }
}

