/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import kr.weitao.common.util.HttpResult;

public class WebConnection {
    private HttpURLConnection httpURLConnection = null;
    private static CookieManager cm = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebConnection() {
        if (cm != null) return;
        Class<CookieManager> clazz = CookieManager.class;
        synchronized (CookieManager.class) {
            cm = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(cm);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public HttpResult Request(String url, String method, Map<String, String> params, byte[] data) throws IOException {
        this.httpURLConnection = (HttpURLConnection)new URL(url).openConnection();
        this.httpURLConnection.setReadTimeout(60000);
        this.httpURLConnection.setConnectTimeout(60000);
        this.httpURLConnection.setRequestMethod(method);
        if (params != null) {
            for (String key : params.keySet()) {
                this.httpURLConnection.setRequestProperty(key, params.get(key));
            }
        }
        if (this.httpURLConnection.getRequestMethod() == "POST") {
            this.httpURLConnection.setDoOutput(true);
        }
        if (data != null && data.length > 0) {
            this.httpURLConnection.getOutputStream().write(data);
        }
        String page = WebConnection.GetPageContent(this.httpURLConnection);
        return new HttpResult(this.httpURLConnection.getResponseCode(), this.httpURLConnection.getResponseMessage(), page);
    }

    private static String GetPageContent(HttpURLConnection httpURLConnection) throws IOException {
        InputStream is = httpURLConnection.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int len = 0;
        while ((len = is.read(buff)) != -1) {
            byteArrayOutputStream.write(buff, 0, len);
        }
        String page = new String(byteArrayOutputStream.toByteArray());
        return page;
    }

    public List<HttpCookie> getCookies() {
        return cm.getCookieStore().getCookies();
    }
}

