/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSONObject;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.MultimediaInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class VideoUtil {
    public static JSONObject getVideoInfo(String url, String dir) {
        try {
            InputStream inputStream = new URL(url).openStream();
            byte[] getData = VideoUtil.readInputStream(inputStream);
            File source1 = new File(dir);
            if (!source1.exists() && !source1.isDirectory()) {
                source1.mkdirs();
            }
            File source = new File(dir + System.currentTimeMillis() + ".mp4");
            FileOutputStream fos = new FileOutputStream(source);
            fos.write(getData);
            if (fos != null) {
                fos.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            Encoder encoder = new Encoder();
            MultimediaInfo m = encoder.getInfo(source);
            JSONObject info = new JSONObject();
            info.put("time", (Object)m.getDuration());
            info.put("height", (Object)m.getVideo().getSize().getHeight());
            info.put("width", (Object)m.getVideo().getSize().getWidth());
            info.put("format", (Object)m.getFormat());
            return info;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }
}

