/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kr.weitao.common.util.HttpClient;
import kr.weitao.common.util.TimeUtils;
import okhttp3.Response;

public class TecentMapUtils {
    private static double EARTH_RADIUS = 6378.137;
    private static String TecentMap_AK = "AARBZ-SGZCP-GGLD3-V7VZI-3S5H6-H6B7R";
    private static String TecentMap_SK = "qo3WjnzPo3nPPvmoxnJsUjYJFjRgnCT";
    private static String TecentMap_Url = "https://apis.map.qq.com";

    public JSONObject GeoCoords(String coords) {
        HttpClient httpClient = new HttpClient();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("get_poi", "0");
        map.put("key", TecentMap_AK);
        map.put("location", coords);
        JSONObject object = null;
        try {
            String paramsStr = TecentMapUtils.toQueryString(map);
            String wholeStr = new String("/ws/geocoder/v1/?" + paramsStr);
            String sn = TecentMapUtils.MD5(wholeStr + TecentMap_SK);
            String url = TecentMap_Url + wholeStr + "&sn=" + sn;
            Response result = httpClient.get(url);
            String returns = result.body().string();
            object = JSONObject.parseObject((String)returns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    public JSONObject getCityList() {
        HttpClient httpClient = new HttpClient();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("key", TecentMap_AK);
        JSONObject object = null;
        try {
            String paramsStr = TecentMapUtils.toQueryString(map);
            String wholeStr = new String("/ws/district/v1/list?" + paramsStr);
            String sn = TecentMapUtils.MD5(wholeStr + TecentMap_SK);
            String url = TecentMap_Url + wholeStr + "&sn=" + sn;
            Response result = httpClient.get(url);
            String returns = result.body().string();
            object = JSONObject.parseObject((String)returns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    public static String toQueryString(Map<?, ?> data) throws UnsupportedEncodingException {
        StringBuffer queryString = new StringBuffer();
        for (Map.Entry<?, ?> pair : data.entrySet()) {
            queryString.append(pair.getKey() + "=");
            queryString.append(URLEncoder.encode((String)pair.getValue(), "UTF-8") + "&");
        }
        if (queryString.length() > 0) {
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }

    public static String MD5(String md5) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(md5.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String t1 = "2008-03-10 16:25:02";
        String t2 = "2008-03-10 16:25:32";
        Date d1 = null;
        Date d2 = null;
        try {
            d1 = TimeUtils.DATETIME_FORMAT_DATE.parse(t1);
            d2 = TimeUtils.DATETIME_FORMAT_DATE.parse(t2);
        }
        catch (Exception pe) {
            System.out.println(pe.getMessage());
        }
        long dd1 = d1.getTime();
        long dd2 = d2.getTime();
        double hours = (double)(dd2 - dd1) / 1000.0;
        System.out.println("\u65f6\u95f4\u5dee\u662f\uff1a" + hours + "\uff08\u79d2\uff09");
    }
}

