/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class SortUtils {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static JSONArray sortByNumberKey(JSONArray array, String sortKey, String order) {
        List<?> list = SortUtils.convert2List(array, JSONObject.class);
        if ("desc".equals(order)) {
            Collections.sort(list, (o1, o2) -> o2.getInteger(sortKey).compareTo(o1.getInteger(sortKey)));
        } else {
            Collections.sort(list, Comparator.comparing(o -> o.getInteger(sortKey)));
        }
        return SortUtils.convert2JSONArray(list);
    }

    public static JSONArray sortByInteger(JSONArray array, String order) {
        List<?> list = SortUtils.convert2List(array, Integer.class);
        if ("desc".equals(order)) {
            Collections.sort(list, (integer, anotherInteger) -> anotherInteger.compareTo((Integer)integer));
        } else {
            Collections.sort(list, Integer::compareTo);
        }
        return SortUtils.convert2JSONArray(list);
    }

    public static JSONArray sortByDouble(JSONArray array, String order) {
        List<?> list = SortUtils.convert2List(array, Double.class);
        if ("desc".equals(order)) {
            Collections.sort(list, (var1, var2) -> var2.compareTo((Double)var1));
        } else {
            Collections.sort(list, Double::compareTo);
        }
        return SortUtils.convert2JSONArray(list);
    }

    public static JSONArray sortByFormatedTime(JSONArray array, String sortKey, String order) {
        List<?> list = SortUtils.convert2List(array, JSONObject.class);
        if ("desc".equals(order)) {
            Collections.sort(list, (o1, o2) -> SortUtils.getTime(o2.getString(sortKey)).compareTo(SortUtils.getTime(o1.getString(sortKey))));
        } else {
            Collections.sort(list, Comparator.comparing(o -> SortUtils.getTime(o.getString(sortKey))));
        }
        return SortUtils.convert2JSONArray(list);
    }

    public static List<?> convert2List(JSONArray array, Class clazz) {
        return JSONObject.parseArray((String)array.toJSONString(), (Class)clazz);
    }

    public static JSONArray convert2JSONArray(List<?> list) {
        return JSONArray.parseArray((String)JSON.toJSONString(list));
    }

    public static Long getTime(String time) {
        try {
            Date parse = sdf.parse(time);
            return parse.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

