/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kr.weitao.common.util.MD5Util;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.XMLUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureUtil {
    private static final Logger log = LoggerFactory.getLogger(SignatureUtil.class);
    private String appId;
    private String appKey;
    private String appSecret;
    private String partnerKey;
    private String charset;

    public void setAppId(String id) {
        this.appId = id;
    }

    public void setAppKey(String key) {
        this.appKey = key;
    }

    public void setAppSecret(String secret) {
        this.appSecret = secret;
    }

    public void setPartnerKey(String partnerkey) {
        this.partnerKey = partnerkey;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        if (StringUtils.isNull(this.charset)) {
            return "UTF-8";
        }
        return this.charset;
    }

    public void init(String appid, String appkey, String appsecret, String partnerkey) {
        this.appId = appid;
        this.appKey = appkey;
        this.appSecret = appsecret;
        this.partnerKey = partnerkey;
    }

    public String doSignature(Map param, boolean isSort, boolean isFiltNull) {
        String signatureString = null;
        if (param == null || param.isEmpty()) {
            log.debug("signature is null");
            return signatureString;
        }
        Map signatureMap = null;
        signatureMap = isSort ? this.doSort(param, isFiltNull) : param;
        String signStr = this.createSignatureString(signatureMap, isFiltNull);
        log.debug("before md5 parmas is->" + signStr);
        System.out.println("before md5 parmas is->" + signStr);
        signatureString = DigestUtils.md5Hex((byte[])this.getContentBytes(signStr, this.getCharset()));
        if (StringUtils.isNotNull(signatureString)) {
            signatureString = signatureString.toUpperCase();
        }
        log.debug("after md5 params is->" + signatureString);
        System.out.println("after md5 params is->" + signatureString);
        return signatureString;
    }

    public String getSign(Map param, boolean isSort, boolean isFiltNull) {
        String signatureString = null;
        if (param == null || param.isEmpty()) {
            log.debug("signature is null");
            return signatureString;
        }
        Map signatureMap = null;
        signatureMap = isSort ? this.doSort(param, isFiltNull) : param;
        log.debug("--signatureMap---" + signatureMap);
        System.out.println("signatureMap->" + signatureMap);
        String signStr = this.getSignatureString(signatureMap, isFiltNull).replace("&", "").replace("=", "");
        log.debug("before md5 parmas is->" + signStr);
        System.out.println("before md5 parmas is->" + signStr);
        signatureString = MD5Util.getMD5Str32(signStr);
        log.debug("after md5 params is->" + signatureString);
        System.out.println("after md5 params is->" + signatureString);
        return signatureString;
    }

    public String createSignatureString(Map param, boolean isFiltNull) {
        StringBuffer sb = new StringBuffer();
        if (param == null || param.isEmpty()) {
            return sb.toString();
        }
        for (Object key : param.keySet()) {
            Object value = param.get(key);
            if (isFiltNull && (value == null || StringUtils.isNull(String.valueOf(value))) || "sign".equalsIgnoreCase(String.valueOf(key))) continue;
            if ("detail".equalsIgnoreCase(String.valueOf(key))) {
                value = StringEscapeUtils.unescapeJava((String)("<![CDATA[" + value + "]]>"));
            }
            sb.append(key + "=" + value + "&");
        }
        sb.append("key=" + this.partnerKey);
        return sb.toString();
    }

    public String getSignatureString(Map param, boolean isFiltNull) {
        log.info(String.valueOf(param));
        StringBuffer sb = new StringBuffer();
        if (param == null || param.isEmpty()) {
            return sb.toString();
        }
        for (Object key : param.keySet()) {
            Object value = param.get(key);
            if (isFiltNull && (value == null || StringUtils.isNull(String.valueOf(value)))) continue;
            sb.append(key + "=" + value + "&");
        }
        return sb.toString();
    }

    public Map doSort(Map<String, ?> param, boolean isFiltNull) {
        TreeMap sortMap = null;
        if (param == null || param.isEmpty()) {
            return sortMap;
        }
        sortMap = new TreeMap();
        for (String key : param.keySet()) {
            Object value = param.get(key);
            if (isFiltNull && (value == null || StringUtils.isNull(String.valueOf(value)))) continue;
            sortMap.put(key, value);
        }
        return sortMap;
    }

    public Map<String, String> doFiltNull(Map<String, String> param) {
        LinkedHashMap<String, String> filtMap = null;
        if (param == null || param.isEmpty()) {
            return filtMap;
        }
        String value = null;
        filtMap = new LinkedHashMap<String, String>();
        for (String key : param.keySet()) {
            value = param.get(key);
            if (StringUtils.isNull(value)) continue;
            filtMap.put(key, value);
        }
        return filtMap;
    }

    private byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset);
        }
    }

    public String genPackage(SortedMap<String, String> packageParams) throws UnsupportedEncodingException {
        String sign = this.createSign(packageParams);
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, String>> es = packageParams.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            sb.append(k + "=" + this.UrlEncode(v) + "&");
        }
        String packageValue = sb.append("sign=" + sign).toString();
        System.out.println("packageValue=" + packageValue);
        return packageValue;
    }

    public String createSign(SortedMap<String, String> packageParams) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, String>> es = packageParams.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (null == v || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(k + "=" + v + "&");
        }
        sb.append("key=" + this.partnerKey);
        System.out.println("md5 sb:" + sb);
        String sign = MD5Util.MD5Encode(sb.toString(), this.getCharset()).toUpperCase();
        return sign;
    }

    public boolean verifySignature(Map param, boolean isSort, boolean isFiltNull) {
        boolean isVerify = false;
        String signatureString = this.doSignature(param, isSort, isFiltNull);
        String sign = String.valueOf(param.get("sign"));
        isVerify = sign.equals(signatureString);
        return isVerify;
    }

    public boolean verifySignature(String xml, boolean isSort, boolean isFiltNull) {
        boolean isVerify = false;
        Map m = null;
        try {
            m = XMLUtil.doXMLParse(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        isVerify = this.verifySignature(m, isSort, isFiltNull);
        return isVerify;
    }

    public boolean verifySignature(JSONObject jo, boolean isSort, boolean isFiltNull) {
        boolean isVerify = false;
        Map m = this.jsonToMap(jo, isFiltNull);
        isVerify = this.verifySignature(m, isSort, isFiltNull);
        return isVerify;
    }

    public String UrlEncode(String src) throws UnsupportedEncodingException {
        return URLEncoder.encode(src, this.getCharset()).replace("+", "%20");
    }

    public JSONObject mapToJson(Map param, boolean isFiltNull) {
        JSONObject rjo = new JSONObject();
        Iterator iter = param.keySet().iterator();
        try {
            while (iter.hasNext()) {
                Object key = iter.next();
                Object value = param.get(key);
                if (isFiltNull && (value == null || value instanceof String && StringUtils.isNull(String.valueOf(value)))) continue;
                rjo.put(String.valueOf(key), param.get(key));
            }
        }
        catch (Exception e) {
            log.debug("map to json error->" + e.getLocalizedMessage());
        }
        return rjo;
    }

    public Map jsonToMap(JSONObject param, boolean isFiltNull) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (param == null) {
            return m;
        }
        for (String key : param.keySet()) {
            m.put(key, param.get((Object)key));
        }
        return m;
    }
}

