/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kr.weitao.common.util.StringUtils;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.util.CollectionUtils;

public class RequestUtil {
    private static final String START = "start";
    private static final String END = "end";

    public static String getUserId(HttpServletRequest request) {
        return request.getSession().getAttribute("user_id").toString();
    }

    public static BasicDBObject getQueryParam(JSONObject param) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"is_active", (Object)"Y");
        JSONArray filter = param.getJSONArray("filter");
        if (!CollectionUtils.isEmpty((Collection)filter)) {
            HashMap timeKeyMap = Maps.newHashMap();
            for (int i = 0; i < filter.size(); ++i) {
                boolean flag = false;
                JSONObject temp = filter.getJSONObject(i);
                String key = temp.getString("screen_key");
                String regex = temp.getString("regex");
                if ("is_active".equals(key) && "ALL".equals(temp.getString("screen_value"))) {
                    query.removeField("is_active");
                    continue;
                }
                if ("withdrawal_status".equals(key) && StringUtils.isNull(temp.getString("screen_value"))) {
                    temp.put("screen_value", (Object)new BasicDBObject("$ne", (Object)"3"));
                }
                if (StringUtils.isNull(temp.getString("screen_value"))) continue;
                if (temp.get((Object)"screen_value") instanceof JSONObject) {
                    JSONObject tempValue = temp.getJSONObject("screen_value");
                    if (StringUtils.isNull(tempValue.getString(START)) && StringUtils.isNull(tempValue.getString(END))) continue;
                    if (tempValue.containsKey((Object)START) && StringUtils.isNotNull(tempValue.get((Object)START))) {
                        if (!timeKeyMap.containsKey(key)) {
                            timeKeyMap.put(key, new BasicDBObject());
                        }
                        ((BasicDBObject)timeKeyMap.get(key)).put((Object)"$gte", tempValue.get((Object)START));
                        flag = true;
                    }
                    if (tempValue.containsKey((Object)END) && StringUtils.isNotNull(tempValue.get((Object)END))) {
                        if (!timeKeyMap.containsKey(key)) {
                            timeKeyMap.put(key, new BasicDBObject());
                        }
                        ((BasicDBObject)timeKeyMap.get(key)).put((Object)"$lte", tempValue.get((Object)END));
                        flag = true;
                    }
                }
                if (flag) {
                    query.put((Object)key, timeKeyMap.get(key));
                    continue;
                }
                if ("1".equals(regex)) {
                    query.put((Object)temp.getString("screen_key"), (Object)new BasicDBObject("$regex", (Object)temp.getString("screen_value")));
                    continue;
                }
                query.put((Object)temp.getString("screen_key"), temp.get((Object)"screen_value"));
            }
        }
        return query;
    }

    public static Integer getPageNum(JSONObject param) {
        return param.getInteger("page_num") == null ? 0 : param.getInteger("page_num");
    }

    public static Integer getPageSize(JSONObject param) {
        return param.getInteger("page_size") == null ? 10 : param.getInteger("page_size");
    }

    public static Criteria genCriteria(JSONObject param) {
        Criteria criteria = new Criteria();
        JSONArray filter = param.getJSONArray("filter");
        HashMap timeMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)filter)) {
            JSONObject temp;
            for (int i = 0; i < filter.size(); ++i) {
                temp = filter.getJSONObject(i);
                String key = temp.getString("screen_key");
                if (StringUtils.isNull(temp.getString("screen_value"))) continue;
                if (temp.get((Object)"screen_value") instanceof JSONObject) {
                    JSONObject tempValue = temp.getJSONObject("screen_value");
                    timeMap.put(key, tempValue);
                    continue;
                }
                if (i == 0) {
                    if ("1".equals(temp.getString("regex"))) {
                        criteria = Criteria.where((String)temp.getString("screen_key")).regex(temp.getString("screen_value"));
                        continue;
                    }
                    criteria = Criteria.where((String)temp.getString("screen_key")).is(temp.get((Object)"screen_value"));
                    continue;
                }
                criteria = "1".equals(temp.getString("regex")) ? criteria.and(temp.getString("screen_key")).regex(temp.getString("screen_value")) : criteria.and(temp.getString("screen_key")).is(temp.get((Object)"screen_value"));
            }
            if (!CollectionUtils.isEmpty((Map)timeMap)) {
                for (Map.Entry entry : timeMap.entrySet()) {
                    temp = (JSONObject)entry.getValue();
                    for (Map.Entry inner : temp.entrySet()) {
                        if (criteria.getCriteriaObject().containsField((String)entry.getKey())) {
                            if (START.equals(inner.getKey())) {
                                criteria = criteria.gte(inner.getValue());
                                continue;
                            }
                            criteria = criteria.lte(inner.getValue());
                            continue;
                        }
                        if (START.equals(inner.getKey())) {
                            criteria = criteria.and((String)entry.getKey()).gte(inner.getValue());
                            continue;
                        }
                        criteria = criteria.and((String)entry.getKey()).lte(inner.getValue());
                    }
                }
            }
        }
        return criteria;
    }

    private static boolean containsField(Criteria criteria, String fieldName) {
        return criteria.getCriteriaObject().containsField(fieldName);
    }
}

